/*
 * Decompiled with CFR 0.152.
 */
package macromedia.resource.jdbcmysql.spi;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import macromedia.mysqlutil.ddo;
import macromedia.resource.jdbcmysql.spi.JCAExceptions;
import macromedia.resource.jdbcmysql.spi.JCALogger;
import macromedia.resource.jdbcmysql.spi.JCAManagedConnection;

public class JCALocalTransaction
implements LocalTransaction {
    private static String footprint = "$Revision$";
    JCAManagedConnection managedConnection;
    Connection physConnection;
    boolean prevAutoCommitMode;
    protected JCALogger logger;
    JCAExceptions exceptions;

    public JCALocalTransaction(JCAManagedConnection jCAManagedConnection) {
        ddo.a("managedConnection must not be null", jCAManagedConnection != null);
        this.managedConnection = jCAManagedConnection;
        this.logger = jCAManagedConnection.getLogger();
        this.exceptions = jCAManagedConnection.getExceptions();
        try {
            this.physConnection = jCAManagedConnection.getPhysicalConnectionHandle();
        }
        catch (ResourceException resourceException) {
            this.physConnection = null;
        }
    }

    public void begin() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("LocalTransaction.begin()");
        }
        this.validatePhysicalConnection();
        try {
            this.prevAutoCommitMode = this.physConnection.getAutoCommit();
            this.physConnection.setAutoCommit(false);
            this.managedConnection.fireLocalTransactionStarted();
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 4);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("LocalTransaction.begin");
        }
    }

    public void commit() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("LocalTransaction.commit()");
        }
        this.validatePhysicalConnection();
        try {
            this.physConnection.commit();
            this.managedConnection.fireLocalTransactionCommitted();
            this.physConnection.setAutoCommit(this.prevAutoCommitMode);
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 4);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("LocalTransaction.commit");
        }
    }

    public void rollback() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("LocalTransaction.rollback()");
        }
        this.validatePhysicalConnection();
        try {
            this.physConnection.rollback();
            this.managedConnection.fireLocalTransactionRolledBack();
            this.physConnection.setAutoCommit(this.prevAutoCommitMode);
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 4);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("LocalTransaction.rollback");
        }
    }

    private final void validatePhysicalConnection() throws ResourceException {
        if (this.physConnection == null) {
            ResourceException resourceException = this.exceptions.getException(4304, 4);
            this.managedConnection.fireConnectionErrorOccurred(resourceException);
            throw resourceException;
        }
    }
}

