/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ssp;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import macromedia.sequelink.net.NetInputStream;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SlXid;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;

public class SspInputStreamOnDataInputStream
extends SspInputStream {
    private DataInputStream dis;
    private NetInputStream nis;
    private char[] charBuf = new char[80];
    private boolean newByte;
    private int buf;
    private UtilTransliterator transliterator;
    private static byte[] sl = new byte[]{83, 101, 113, 117, 101, 76, 105, 110, 107};

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public void setInputStream(NetInputStream netInputStream) {
        this.nis = netInputStream;
        this.dis = new DataInputStream(netInputStream);
    }

    public int readSSPInt8() throws IOException {
        int n2 = this.nis.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return n2;
    }

    public int readSSPInt16() throws IOException {
        return this.dis.readShort();
    }

    public int readSSPFullInt32() throws IOException {
        return this.dis.readInt();
    }

    public int readSSPInt32() throws IOException {
        int n2 = this.nis.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        if (n2 != 128) {
            return (byte)n2;
        }
        return this.dis.readInt();
    }

    public int readSSPUInt32() throws IOException {
        int n2 = this.nis.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        if (n2 != 255) {
            return n2;
        }
        return this.dis.readInt();
    }

    public int readSSPIndicator() throws IOException {
        return this.readSSPInt32();
    }

    public int readSSPEnum() throws IOException {
        return this.readSSPInt32();
    }

    public int readSSPErr() throws IOException {
        return this.readSSPFullInt32();
    }

    public int readSSPRefNum() throws IOException {
        return this.readSSPUInt32();
    }

    public int readSSPRowCount(boolean bl2) throws IOException {
        int n2 = bl2 ? this.readSSPInt32() : this.readSSPFullInt32();
        return n2 == -1 ? 0 : n2;
    }

    public String readSSPString() throws IOException, UtilException {
        byte[] byArray;
        int n2 = this.readSSPUInt32();
        byte[] byArray2 = n2 > (byArray = this.transliterator.getBytesCache()).length ? new byte[n2] : byArray;
        int n3 = this.nis.read(byArray2, 0, n2);
        return this.transliterator.decode(byArray2, 0, n3);
    }

    public String readSSPString(int n2) throws IOException, UtilException {
        byte[] byArray;
        int n3 = this.readSSPUInt32();
        byte[] byArray2 = n3 > (byArray = this.transliterator.getBytesCache()).length ? new byte[n3] : byArray;
        int n4 = this.nis.read(byArray2, 0, n3);
        return this.transliterator.decode(byArray2, 0, n4, n2);
    }

    private byte readNibble() throws IOException {
        if (this.newByte) {
            this.buf = this.nis.read();
            if (this.buf == -1) {
                throw new EOFException();
            }
        }
        int n2 = this.buf;
        if (this.newByte) {
            n2 >>= 4;
        }
        this.newByte = !this.newByte;
        return (byte)(n2 &= 0xF);
    }

    public BigDecimal readSSPBcdType(int n2) throws IOException {
        int n3;
        int n4;
        this.newByte = true;
        int n5 = this.nis.read();
        if (n5 == -1) {
            throw new EOFException();
        }
        int n6 = this.nis.read();
        if (n6 == -1) {
            throw new EOFException();
        }
        n6 = (byte)(n6 & 0xFF);
        int n7 = n5 + 1;
        int n8 = 0;
        if (n2 >= 0) {
            n7 += n2 - n6;
            n8 = n2;
        } else if (n6 <= 0) {
            n7 -= n6;
        } else {
            n8 = n6;
        }
        if (n7 > this.charBuf.length) {
            this.charBuf = new char[n7];
        }
        if ((n5 & 1) == 0 && this.readNibble() != 0) {
            throw new IOException();
        }
        int n9 = n5 + 1;
        for (n4 = 1; n4 < n9; ++n4) {
            this.charBuf[n4] = (char)(this.readNibble() + 48);
        }
        while (n4 < n7) {
            this.charBuf[n4] = 48;
            ++n4;
        }
        byte by2 = this.readNibble();
        if (by2 == 13) {
            this.charBuf[0] = 45;
            n3 = 0;
            if (n7 < n5 + 1) {
                n7 = n5 + 1;
            }
        } else {
            if (--n7 < n5) {
                n7 = n5;
            }
            n3 = 1;
        }
        String string = new String(this.charBuf, n3, n7);
        return new BigDecimal(new BigInteger(string), n8);
    }

    public byte[] readSSPBinaryType() throws IOException {
        int n2 = this.dis.readInt();
        byte[] byArray = new byte[n2];
        this.nis.read(byArray);
        return byArray;
    }

    public byte[] readSSPBinaryType(int n2) throws IOException {
        int n3 = this.dis.readInt();
        if (n2 < n3) {
            n2 = n3;
        }
        byte[] byArray = new byte[n2];
        this.nis.read(byArray, 0, n3);
        while (n3 < n2) {
            byArray[n3++] = 0;
        }
        return byArray;
    }

    public double readSSPFloatType() throws IOException {
        return this.dis.readDouble();
    }

    public float readSSPRealType() throws IOException {
        return this.dis.readFloat();
    }

    public SlXid readXid() throws IOException {
        int n2 = this.readSSPFullInt32();
        byte[] byArray = new byte[this.readSSPInt32()];
        byte[] byArray2 = new byte[this.readSSPInt32()];
        this.nis.read(byArray);
        this.nis.read(byArray2);
        return new SlXid(n2, byArray, byArray2);
    }

    public void readSequeLink() throws IOException, SQLException {
        int n2 = sl.length;
        byte[] byArray = new byte[n2];
        int n3 = this.nis.read(byArray);
        if (n3 != n2) {
            throw Message.Gen.getSqlException(7427);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == sl[i2]) continue;
            throw Message.Gen.getSqlException(7427);
        }
    }

    public String readSSPASCIIString() throws IOException {
        int n2 = this.readSSPFullInt32();
        if (n2 > this.charBuf.length) {
            this.charBuf = new char[n2];
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.charBuf[i2] = (char)(this.dis.readByte() & 0xFF);
        }
        return new String(this.charBuf, 0, n2);
    }

    public void skipBytes(int n2) throws IOException, SQLException {
        if (this.dis.skipBytes(n2) != n2) {
            throw Message.Gen.getSqlException(7428);
        }
    }

    public int readSSPLongVarBinary(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.readSSPFullInt32();
        this.nis.read(byArray, n2, n4);
        return n4;
    }

    public int readSSPLongVarChar(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.readSSPUInt32();
        this.nis.read(byArray, n2, n4);
        return n4;
    }
}

