/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbcx.db2;

import javax.transaction.xa.Xid;
import macromedia.jdbcx.db2.base.r;

public class DB2Xid
extends r {
    private static String footprint = "$Revision$";
    private byte[] data;
    public byte[] formatted;
    public int formattedLen;
    private static final int XidDATASIZE = 128;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;

    public DB2Xid() {
        super(-1, null, null);
        this.data = new byte[128];
    }

    public DB2Xid(int n2, byte[] byArray, byte[] byArray2) {
        super(n2, byArray, byArray2);
        this.data = new byte[128];
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
        System.arraycopy(byArray2, 0, this.data, byArray.length, byArray2.length);
        this.formatted = this.getFormatted();
        this.formattedLen = this.formatted.length;
    }

    public DB2Xid(Xid xid) {
        super(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        if (xid instanceof DB2Xid) {
            this.data = ((DB2Xid)xid).getData();
        } else {
            this.data = new byte[128];
            System.arraycopy(this.gtrid, 0, this.data, 0, this.gtrid.length);
            System.arraycopy(this.bqual, 0, this.data, this.gtrid.length, this.bqual.length);
        }
        this.formatted = this.getFormatted();
        this.formattedLen = this.formatted.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getFormatted() {
        int n2 = this.gtrid.length + this.bqual.length;
        int n3 = this.gtrid.length;
        int n4 = this.bqual.length;
        byte[] byArray = new byte[12 + n2];
        byArray[0] = (byte)(this.formatId >>> 24 & 0xFF);
        byArray[1] = (byte)(this.formatId >>> 16 & 0xFF);
        byArray[2] = (byte)(this.formatId >>> 8 & 0xFF);
        byArray[3] = (byte)(this.formatId >>> 0 & 0xFF);
        byArray[4] = (byte)(n3 >>> 24 & 0xFF);
        byArray[5] = (byte)(n3 >>> 16 & 0xFF);
        byArray[6] = (byte)(n3 >>> 8 & 0xFF);
        byArray[7] = (byte)(n3 >>> 0 & 0xFF);
        byArray[8] = (byte)(n4 >>> 24 & 0xFF);
        byArray[9] = (byte)(n4 >>> 16 & 0xFF);
        byArray[10] = (byte)(n4 >>> 8 & 0xFF);
        byArray[11] = (byte)(n4 >>> 0 & 0xFF);
        System.arraycopy(this.data, 0, byArray, 12, n2);
        return byArray;
    }
}

