/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.org.json;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.db2.externals.org.json.ParserConfiguration;
import macromedia.jdbc.db2.externals.org.json.XMLXsiTypeConverter;

public class XMLParserConfiguration
extends ParserConfiguration {
    public static final XMLParserConfiguration ORIGINAL = new XMLParserConfiguration();
    public static final XMLParserConfiguration KEEP_STRINGS = new XMLParserConfiguration().withKeepStrings(true);
    private String cDataTagName;
    private boolean convertNilAttributeToNull;
    private Map<String, XMLXsiTypeConverter<?>> xsiTypeMap;
    private Set<String> forceList;

    public XMLParserConfiguration() {
        this.cDataTagName = "content";
        this.convertNilAttributeToNull = false;
        this.xsiTypeMap = Collections.emptyMap();
        this.forceList = Collections.emptySet();
    }

    @Deprecated
    public XMLParserConfiguration(boolean bl2) {
        this(bl2, "content", false);
    }

    @Deprecated
    public XMLParserConfiguration(String string) {
        this(false, string, false);
    }

    @Deprecated
    public XMLParserConfiguration(boolean bl2, String string) {
        super(bl2, 512);
        this.cDataTagName = string;
        this.convertNilAttributeToNull = false;
    }

    @Deprecated
    public XMLParserConfiguration(boolean bl2, String string, boolean bl3) {
        super(bl2, 512);
        this.cDataTagName = string;
        this.convertNilAttributeToNull = bl3;
    }

    private XMLParserConfiguration(boolean bl2, String string, boolean bl3, Map<String, XMLXsiTypeConverter<?>> map, Set<String> set, int n2) {
        super(bl2, n2);
        this.cDataTagName = string;
        this.convertNilAttributeToNull = bl3;
        this.xsiTypeMap = Collections.unmodifiableMap(map);
        this.forceList = Collections.unmodifiableSet(set);
    }

    @Override
    protected XMLParserConfiguration clone() {
        return new XMLParserConfiguration(this.keepStrings, this.cDataTagName, this.convertNilAttributeToNull, this.xsiTypeMap, this.forceList, this.maxNestingDepth);
    }

    public XMLParserConfiguration withKeepStrings(boolean bl2) {
        return (XMLParserConfiguration)super.withKeepStrings(bl2);
    }

    public String getcDataTagName() {
        return this.cDataTagName;
    }

    public XMLParserConfiguration withcDataTagName(String string) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        xMLParserConfiguration.cDataTagName = string;
        return xMLParserConfiguration;
    }

    public boolean isConvertNilAttributeToNull() {
        return this.convertNilAttributeToNull;
    }

    public XMLParserConfiguration withConvertNilAttributeToNull(boolean bl2) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        xMLParserConfiguration.convertNilAttributeToNull = bl2;
        return xMLParserConfiguration;
    }

    public Map<String, XMLXsiTypeConverter<?>> getXsiTypeMap() {
        return this.xsiTypeMap;
    }

    public XMLParserConfiguration withXsiTypeMap(Map<String, XMLXsiTypeConverter<?>> map) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        HashMap hashMap = new HashMap(map);
        xMLParserConfiguration.xsiTypeMap = Collections.unmodifiableMap(hashMap);
        return xMLParserConfiguration;
    }

    public Set<String> getForceList() {
        return this.forceList;
    }

    public XMLParserConfiguration withForceList(Set<String> set) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        HashSet<String> hashSet = new HashSet<String>(set);
        xMLParserConfiguration.forceList = Collections.unmodifiableSet(hashSet);
        return xMLParserConfiguration;
    }

    public XMLParserConfiguration withMaxNestingDepth(int n2) {
        return (XMLParserConfiguration)super.withMaxNestingDepth(n2);
    }
}

