/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.util.Date;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.DateRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.GregorianCalendar;

class EasterRule
implements DateRule {
    private int daysAfterEaster;
    private GregorianCalendar calendar = new GregorianCalendar();

    public EasterRule(int n2, boolean bl2) {
        this.daysAfterEaster = n2;
        if (bl2) {
            this.calendar.setGregorianChange(new Date(Long.MAX_VALUE));
        }
    }

    @Override
    public Date firstAfter(Date date) {
        return this.doFirstBetween(date, null);
    }

    @Override
    public Date firstBetween(Date date, Date date2) {
        return this.doFirstBetween(date, date2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOn(Date date) {
        GregorianCalendar gregorianCalendar = this.calendar;
        synchronized (gregorianCalendar) {
            this.calendar.setTime(date);
            int n2 = this.calendar.get(6);
            this.calendar.setTime(this.computeInYear(this.calendar.getTime(), this.calendar));
            return this.calendar.get(6) == n2;
        }
    }

    @Override
    public boolean isBetween(Date date, Date date2) {
        return this.firstBetween(date, date2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date doFirstBetween(Date date, Date date2) {
        GregorianCalendar gregorianCalendar = this.calendar;
        synchronized (gregorianCalendar) {
            Date date3 = this.computeInYear(date, this.calendar);
            if (date3.before(date)) {
                this.calendar.setTime(date);
                this.calendar.get(1);
                this.calendar.add(1, 1);
                date3 = this.computeInYear(this.calendar.getTime(), this.calendar);
            }
            if (date2 != null && !date3.before(date2)) {
                return null;
            }
            return date3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date computeInYear(Date date, GregorianCalendar gregorianCalendar) {
        if (gregorianCalendar == null) {
            gregorianCalendar = this.calendar;
        }
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        synchronized (gregorianCalendar2) {
            int n2;
            int n3;
            gregorianCalendar.setTime(date);
            int n4 = gregorianCalendar.get(1);
            int n5 = n4 % 19;
            int n6 = 0;
            int n7 = 0;
            if (gregorianCalendar.getTime().after(gregorianCalendar.getGregorianChange())) {
                n3 = n4 / 100;
                n2 = (n3 - n3 / 4 - (8 * n3 + 13) / 25 + 19 * n5 + 15) % 30;
                n6 = n2 - n2 / 28 * (1 - n2 / 28 * (29 / (n2 + 1)) * ((21 - n5) / 11));
                n7 = (n4 + n4 / 4 + n6 + 2 - n3 + n3 / 4) % 7;
            } else {
                n6 = (19 * n5 + 15) % 30;
                n7 = (n4 + n4 / 4 + n6) % 7;
            }
            n3 = n6 - n7;
            n2 = 3 + (n3 + 40) / 44;
            int n8 = n3 + 28 - 31 * (n2 / 4);
            gregorianCalendar.clear();
            gregorianCalendar.set(0, 1);
            gregorianCalendar.set(1, n4);
            gregorianCalendar.set(2, n2 - 1);
            gregorianCalendar.set(5, n8);
            gregorianCalendar.getTime();
            gregorianCalendar.add(5, this.daysAfterEaster);
            return gregorianCalendar.getTime();
        }
    }
}

