/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.nio.CharBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.StringTrieBuilder;

public final class CharsTrieBuilder
extends StringTrieBuilder {
    private final char[] intUnits = new char[3];
    private char[] chars;
    private int charsLength;

    public CharsTrieBuilder add(CharSequence charSequence, int n2) {
        this.addImpl(charSequence, n2);
        return this;
    }

    public CharsTrie build(StringTrieBuilder.Option option) {
        return new CharsTrie(this.buildCharSequence(option), 0);
    }

    public CharSequence buildCharSequence(StringTrieBuilder.Option option) {
        this.buildChars(option);
        return CharBuffer.wrap(this.chars, this.chars.length - this.charsLength, this.charsLength);
    }

    private void buildChars(StringTrieBuilder.Option option) {
        if (this.chars == null) {
            this.chars = new char[1024];
        }
        this.buildImpl(option);
    }

    public CharsTrieBuilder clear() {
        this.clearImpl();
        this.chars = null;
        this.charsLength = 0;
        return this;
    }

    @Override
    @Deprecated
    protected boolean matchNodesCanHaveValues() {
        return true;
    }

    @Override
    @Deprecated
    protected int getMaxBranchLinearSubNodeLength() {
        return 5;
    }

    @Override
    @Deprecated
    protected int getMinLinearMatch() {
        return 48;
    }

    @Override
    @Deprecated
    protected int getMaxLinearMatchLength() {
        return 16;
    }

    private void ensureCapacity(int n2) {
        if (n2 > this.chars.length) {
            int n3 = this.chars.length;
            while ((n3 *= 2) <= n2) {
            }
            char[] cArray = new char[n3];
            System.arraycopy(this.chars, this.chars.length - this.charsLength, cArray, cArray.length - this.charsLength, this.charsLength);
            this.chars = cArray;
        }
    }

    @Override
    @Deprecated
    protected int write(int n2) {
        int n3 = this.charsLength + 1;
        this.ensureCapacity(n3);
        this.charsLength = n3;
        this.chars[this.chars.length - this.charsLength] = (char)n2;
        return this.charsLength;
    }

    @Override
    @Deprecated
    protected int write(int n2, int n3) {
        int n4 = this.charsLength + n3;
        this.ensureCapacity(n4);
        this.charsLength = n4;
        int n5 = this.chars.length - this.charsLength;
        while (n3 > 0) {
            this.chars[n5++] = this.strings.charAt(n2++);
            --n3;
        }
        return this.charsLength;
    }

    private int write(char[] cArray, int n2) {
        int n3 = this.charsLength + n2;
        this.ensureCapacity(n3);
        this.charsLength = n3;
        System.arraycopy(cArray, 0, this.chars, this.chars.length - this.charsLength, n2);
        return this.charsLength;
    }

    @Override
    @Deprecated
    protected int writeValueAndFinal(int n2, boolean bl2) {
        int n3;
        if (0 <= n2 && n2 <= 16383) {
            return this.write(n2 | (bl2 ? 32768 : 0));
        }
        if (n2 < 0 || n2 > 0x3FFEFFFF) {
            this.intUnits[0] = Short.MAX_VALUE;
            this.intUnits[1] = (char)(n2 >> 16);
            this.intUnits[2] = (char)n2;
            n3 = 3;
        } else {
            this.intUnits[0] = (char)(16384 + (n2 >> 16));
            this.intUnits[1] = (char)n2;
            n3 = 2;
        }
        this.intUnits[0] = (char)(this.intUnits[0] | (bl2 ? 32768 : 0));
        return this.write(this.intUnits, n3);
    }

    @Override
    @Deprecated
    protected int writeValueAndType(boolean bl2, int n2, int n3) {
        int n4;
        if (!bl2) {
            return this.write(n3);
        }
        if (n2 < 0 || n2 > 0xFDFFFF) {
            this.intUnits[0] = 32704;
            this.intUnits[1] = (char)(n2 >> 16);
            this.intUnits[2] = (char)n2;
            n4 = 3;
        } else if (n2 <= 255) {
            this.intUnits[0] = (char)(n2 + 1 << 6);
            n4 = 1;
        } else {
            this.intUnits[0] = (char)(16448 + (n2 >> 10 & 0x7FC0));
            this.intUnits[1] = (char)n2;
            n4 = 2;
        }
        this.intUnits[0] = (char)(this.intUnits[0] | (char)n3);
        return this.write(this.intUnits, n4);
    }

    @Override
    @Deprecated
    protected int writeDeltaTo(int n2) {
        int n3;
        int n4 = this.charsLength - n2;
        assert (n4 >= 0);
        if (n4 <= 64511) {
            return this.write(n4);
        }
        if (n4 <= 0x3FEFFFF) {
            this.intUnits[0] = (char)(64512 + (n4 >> 16));
            n3 = 1;
        } else {
            this.intUnits[0] = 65535;
            this.intUnits[1] = (char)(n4 >> 16);
            n3 = 2;
        }
        this.intUnits[n3++] = (char)n4;
        return this.write(this.intUnits, n3);
    }
}

