/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public final class CharsTrie
implements Cloneable,
Iterable<Entry> {
    private static BytesTrie.Result[] valueResults_ = new BytesTrie.Result[]{BytesTrie.Result.INTERMEDIATE_VALUE, BytesTrie.Result.FINAL_VALUE};
    static final int kMaxBranchLinearSubNodeLength = 5;
    static final int kMinLinearMatch = 48;
    static final int kMaxLinearMatchLength = 16;
    static final int kMinValueLead = 64;
    static final int kNodeTypeMask = 63;
    static final int kValueIsFinal = 32768;
    static final int kMaxOneUnitValue = 16383;
    static final int kMinTwoUnitValueLead = 16384;
    static final int kThreeUnitValueLead = Short.MAX_VALUE;
    static final int kMaxTwoUnitValue = 0x3FFEFFFF;
    static final int kMaxOneUnitNodeValue = 255;
    static final int kMinTwoUnitNodeValueLead = 16448;
    static final int kThreeUnitNodeValueLead = 32704;
    static final int kMaxTwoUnitNodeValue = 0xFDFFFF;
    static final int kMaxOneUnitDelta = 64511;
    static final int kMinTwoUnitDeltaLead = 64512;
    static final int kThreeUnitDeltaLead = 65535;
    static final int kMaxTwoUnitDelta = 0x3FEFFFF;
    private CharSequence chars_;
    private int root_;
    private int pos_;
    private int remainingMatchLength_;

    public CharsTrie(CharSequence charSequence, int n2) {
        this.chars_ = charSequence;
        this.pos_ = this.root_ = n2;
        this.remainingMatchLength_ = -1;
    }

    public CharsTrie(CharsTrie charsTrie) {
        this.chars_ = charsTrie.chars_;
        this.root_ = charsTrie.root_;
        this.pos_ = charsTrie.pos_;
        this.remainingMatchLength_ = charsTrie.remainingMatchLength_;
    }

    public CharsTrie clone() throws CloneNotSupportedException {
        return (CharsTrie)super.clone();
    }

    public CharsTrie reset() {
        this.pos_ = this.root_;
        this.remainingMatchLength_ = -1;
        return this;
    }

    public long getState64() {
        return (long)this.remainingMatchLength_ << 32 | (long)this.pos_;
    }

    public CharsTrie resetToState64(long l2) {
        this.remainingMatchLength_ = (int)(l2 >> 32);
        this.pos_ = (int)l2;
        return this;
    }

    public CharsTrie saveState(State state) {
        state.chars = this.chars_;
        state.root = this.root_;
        state.pos = this.pos_;
        state.remainingMatchLength = this.remainingMatchLength_;
        return this;
    }

    public CharsTrie resetToState(State state) {
        if (this.chars_ != state.chars || this.chars_ == null || this.root_ != state.root) {
            throw new IllegalArgumentException("incompatible trie state");
        }
        this.pos_ = state.pos;
        this.remainingMatchLength_ = state.remainingMatchLength;
        return this;
    }

    public BytesTrie.Result current() {
        char c2;
        int n2 = this.pos_;
        if (n2 < 0) {
            return BytesTrie.Result.NO_MATCH;
        }
        return this.remainingMatchLength_ < 0 && (c2 = this.chars_.charAt(n2)) >= '@' ? valueResults_[c2 >> 15] : BytesTrie.Result.NO_VALUE;
    }

    public BytesTrie.Result first(int n2) {
        this.remainingMatchLength_ = -1;
        return this.nextImpl(this.root_, n2);
    }

    public BytesTrie.Result firstForCodePoint(int n2) {
        return n2 <= 65535 ? this.first(n2) : (this.first(UTF16.getLeadSurrogate(n2)).hasNext() ? this.next(UTF16.getTrailSurrogate(n2)) : BytesTrie.Result.NO_MATCH);
    }

    public BytesTrie.Result next(int n2) {
        int n3 = this.pos_;
        if (n3 < 0) {
            return BytesTrie.Result.NO_MATCH;
        }
        int n4 = this.remainingMatchLength_;
        if (n4 >= 0) {
            if (n2 == this.chars_.charAt(n3++)) {
                char c2;
                this.remainingMatchLength_ = --n4;
                this.pos_ = n3;
                return n4 < 0 && (c2 = this.chars_.charAt(n3)) >= '@' ? valueResults_[c2 >> 15] : BytesTrie.Result.NO_VALUE;
            }
            this.stop();
            return BytesTrie.Result.NO_MATCH;
        }
        return this.nextImpl(n3, n2);
    }

    public BytesTrie.Result nextForCodePoint(int n2) {
        return n2 <= 65535 ? this.next(n2) : (this.next(UTF16.getLeadSurrogate(n2)).hasNext() ? this.next(UTF16.getTrailSurrogate(n2)) : BytesTrie.Result.NO_MATCH);
    }

    public BytesTrie.Result next(CharSequence charSequence, int n2, int n3) {
        if (n2 >= n3) {
            return this.current();
        }
        int n4 = this.pos_;
        if (n4 < 0) {
            return BytesTrie.Result.NO_MATCH;
        }
        int n5 = this.remainingMatchLength_;
        block0: while (true) {
            int n6;
            if (n2 == n3) {
                this.remainingMatchLength_ = n5;
                this.pos_ = n4;
                return n5 < 0 && (n6 = this.chars_.charAt(n4)) >= 64 ? valueResults_[n6 >> 15] : BytesTrie.Result.NO_VALUE;
            }
            char c2 = charSequence.charAt(n2++);
            if (n5 >= 0) {
                if (c2 != this.chars_.charAt(n4)) {
                    this.stop();
                    return BytesTrie.Result.NO_MATCH;
                }
                ++n4;
                --n5;
                continue;
            }
            this.remainingMatchLength_ = n5;
            n6 = this.chars_.charAt(n4++);
            while (true) {
                if (n6 < 48) {
                    BytesTrie.Result result = this.branchNext(n4, n6, c2);
                    if (result == BytesTrie.Result.NO_MATCH) {
                        return BytesTrie.Result.NO_MATCH;
                    }
                    if (n2 == n3) {
                        return result;
                    }
                    if (result == BytesTrie.Result.FINAL_VALUE) {
                        this.stop();
                        return BytesTrie.Result.NO_MATCH;
                    }
                    c2 = charSequence.charAt(n2++);
                    n4 = this.pos_;
                    n6 = this.chars_.charAt(n4++);
                    continue;
                }
                if (n6 < 64) {
                    n5 = n6 - 48;
                    if (c2 != this.chars_.charAt(n4)) {
                        this.stop();
                        return BytesTrie.Result.NO_MATCH;
                    }
                    ++n4;
                    --n5;
                    continue block0;
                }
                if ((n6 & 0x8000) != 0) {
                    this.stop();
                    return BytesTrie.Result.NO_MATCH;
                }
                n4 = CharsTrie.skipNodeValue(n4, n6);
                n6 &= 0x3F;
            }
            break;
        }
    }

    public int getValue() {
        int n2 = this.pos_;
        char c2 = this.chars_.charAt(n2++);
        assert (c2 >= '@');
        return (c2 & 0x8000) != 0 ? CharsTrie.readValue(this.chars_, n2, c2 & Short.MAX_VALUE) : CharsTrie.readNodeValue(this.chars_, n2, c2);
    }

    public long getUniqueValue() {
        int n2 = this.pos_;
        if (n2 < 0) {
            return 0L;
        }
        long l2 = CharsTrie.findUniqueValue(this.chars_, n2 + this.remainingMatchLength_ + 1, 0L);
        return l2 << 31 >> 31;
    }

    public int getNextChars(Appendable appendable) {
        int n2;
        int n3 = this.pos_;
        if (n3 < 0) {
            return 0;
        }
        if (this.remainingMatchLength_ >= 0) {
            CharsTrie.append(appendable, this.chars_.charAt(n3));
            return 1;
        }
        if ((n2 = this.chars_.charAt(n3++)) >= 64) {
            if ((n2 & 0x8000) != 0) {
                return 0;
            }
            n3 = CharsTrie.skipNodeValue(n3, n2);
            n2 &= 0x3F;
        }
        if (n2 < 48) {
            if (n2 == 0) {
                n2 = this.chars_.charAt(n3++);
            }
            CharsTrie.getNextBranchChars(this.chars_, n3, ++n2, appendable);
            return n2;
        }
        CharsTrie.append(appendable, this.chars_.charAt(n3));
        return 1;
    }

    public Iterator iterator() {
        return new Iterator(this.chars_, this.pos_, this.remainingMatchLength_, 0);
    }

    public Iterator iterator(int n2) {
        return new Iterator(this.chars_, this.pos_, this.remainingMatchLength_, n2);
    }

    public static Iterator iterator(CharSequence charSequence, int n2, int n3) {
        return new Iterator(charSequence, n2, -1, n3);
    }

    private void stop() {
        this.pos_ = -1;
    }

    private static int readValue(CharSequence charSequence, int n2, int n3) {
        int n4 = n3 < 16384 ? n3 : (n3 < Short.MAX_VALUE ? n3 - 16384 << 16 | charSequence.charAt(n2) : charSequence.charAt(n2) << 16 | charSequence.charAt(n2 + 1));
        return n4;
    }

    private static int skipValue(int n2, int n3) {
        if (n3 >= 16384) {
            n2 = n3 < Short.MAX_VALUE ? ++n2 : (n2 += 2);
        }
        return n2;
    }

    private static int skipValue(CharSequence charSequence, int n2) {
        char c2 = charSequence.charAt(n2++);
        return CharsTrie.skipValue(n2, c2 & Short.MAX_VALUE);
    }

    private static int readNodeValue(CharSequence charSequence, int n2, int n3) {
        assert (64 <= n3 && n3 < 32768);
        int n4 = n3 < 16448 ? (n3 >> 6) - 1 : (n3 < 32704 ? (n3 & 0x7FC0) - 16448 << 10 | charSequence.charAt(n2) : charSequence.charAt(n2) << 16 | charSequence.charAt(n2 + 1));
        return n4;
    }

    private static int skipNodeValue(int n2, int n3) {
        assert (64 <= n3 && n3 < 32768);
        if (n3 >= 16448) {
            n2 = n3 < 32704 ? ++n2 : (n2 += 2);
        }
        return n2;
    }

    private static int jumpByDelta(CharSequence charSequence, int n2) {
        int n3;
        if ((n3 = charSequence.charAt(n2++)) >= 64512) {
            if (n3 == 65535) {
                n3 = charSequence.charAt(n2) << 16 | charSequence.charAt(n2 + 1);
                n2 += 2;
            } else {
                n3 = n3 - 64512 << 16 | charSequence.charAt(n2++);
            }
        }
        return n2 + n3;
    }

    private static int skipDelta(CharSequence charSequence, int n2) {
        char c2;
        if ((c2 = charSequence.charAt(n2++)) >= '\ufc00') {
            n2 = c2 == '\uffff' ? (n2 += 2) : ++n2;
        }
        return n2;
    }

    private BytesTrie.Result branchNext(int n2, int n3, int n4) {
        if (n3 == 0) {
            n3 = this.chars_.charAt(n2++);
        }
        ++n3;
        while (n3 > 5) {
            if (n4 < this.chars_.charAt(n2++)) {
                n3 >>= 1;
                n2 = CharsTrie.jumpByDelta(this.chars_, n2);
                continue;
            }
            n3 -= n3 >> 1;
            n2 = CharsTrie.skipDelta(this.chars_, n2);
        }
        do {
            if (n4 == this.chars_.charAt(n2++)) {
                BytesTrie.Result result;
                int n5 = this.chars_.charAt(n2);
                if ((n5 & 0x8000) != 0) {
                    result = BytesTrie.Result.FINAL_VALUE;
                } else {
                    int n6;
                    ++n2;
                    if (n5 < 16384) {
                        n6 = n5;
                    } else if (n5 < Short.MAX_VALUE) {
                        n6 = n5 - 16384 << 16 | this.chars_.charAt(n2++);
                    } else {
                        n6 = this.chars_.charAt(n2) << 16 | this.chars_.charAt(n2 + 1);
                        n2 += 2;
                    }
                    n5 = this.chars_.charAt(n2 += n6);
                    result = n5 >= 64 ? valueResults_[n5 >> 15] : BytesTrie.Result.NO_VALUE;
                }
                this.pos_ = n2;
                return result;
            }
            n2 = CharsTrie.skipValue(this.chars_, n2);
        } while (--n3 > 1);
        if (n4 == this.chars_.charAt(n2++)) {
            this.pos_ = n2;
            char c2 = this.chars_.charAt(n2);
            return c2 >= '@' ? valueResults_[c2 >> 15] : BytesTrie.Result.NO_VALUE;
        }
        this.stop();
        return BytesTrie.Result.NO_MATCH;
    }

    /*
     * Enabled aggressive block sorting
     */
    private BytesTrie.Result nextImpl(int n2, int n3) {
        int n4 = this.chars_.charAt(n2++);
        while (true) {
            if (n4 < 48) {
                return this.branchNext(n2, n4, n3);
            }
            if (n4 < 64) {
                BytesTrie.Result result;
                int n5 = n4 - 48;
                if (n3 != this.chars_.charAt(n2++)) break;
                this.remainingMatchLength_ = --n5;
                this.pos_ = n2;
                if (n5 < 0) {
                    char c2 = this.chars_.charAt(n2);
                    n4 = c2;
                    if (c2 >= '@') {
                        result = valueResults_[n4 >> 15];
                        return result;
                    }
                }
                result = BytesTrie.Result.NO_VALUE;
                return result;
            }
            if ((n4 & 0x8000) != 0) break;
            n2 = CharsTrie.skipNodeValue(n2, n4);
            n4 &= 0x3F;
        }
        this.stop();
        return BytesTrie.Result.NO_MATCH;
    }

    private static long findUniqueValueFromBranch(CharSequence charSequence, int n2, int n3, long l2) {
        while (n3 > 5) {
            if ((l2 = CharsTrie.findUniqueValueFromBranch(charSequence, CharsTrie.jumpByDelta(charSequence, ++n2), n3 >> 1, l2)) == 0L) {
                return 0L;
            }
            n3 -= n3 >> 1;
            n2 = CharsTrie.skipDelta(charSequence, n2);
        }
        do {
            int n4 = ++n2;
            int n5 = charSequence.charAt(n4);
            boolean bl2 = (n5 & 0x8000) != 0;
            int n6 = CharsTrie.readValue(charSequence, ++n2, n5 &= Short.MAX_VALUE);
            n2 = CharsTrie.skipValue(n2, n5);
            if (bl2) {
                if (l2 != 0L) {
                    if (n6 == (int)(l2 >> 1)) continue;
                    return 0L;
                }
                l2 = (long)n6 << 1 | 1L;
                continue;
            }
            if ((l2 = CharsTrie.findUniqueValue(charSequence, n2 + n6, l2)) != 0L) continue;
            return 0L;
        } while (--n3 > 1);
        return (long)(n2 + 1) << 33 | l2 & 0x1FFFFFFFFL;
    }

    private static long findUniqueValue(CharSequence charSequence, int n2, long l2) {
        int n3 = charSequence.charAt(n2++);
        while (true) {
            if (n3 < 48) {
                if (n3 == 0) {
                    n3 = charSequence.charAt(n2++);
                }
                if ((l2 = CharsTrie.findUniqueValueFromBranch(charSequence, n2, n3 + '\u0001', l2)) == 0L) {
                    return 0L;
                }
                n2 = (int)(l2 >>> 33);
                n3 = charSequence.charAt(n2++);
                continue;
            }
            if (n3 < 64) {
                n2 += n3 - 48 + 1;
                n3 = charSequence.charAt(n2++);
                continue;
            }
            boolean bl2 = (n3 & 0x8000) != 0;
            int n4 = bl2 ? CharsTrie.readValue(charSequence, n2, n3 & Short.MAX_VALUE) : CharsTrie.readNodeValue(charSequence, n2, n3);
            if (l2 != 0L) {
                if (n4 != (int)(l2 >> 1)) {
                    return 0L;
                }
            } else {
                l2 = (long)n4 << 1 | 1L;
            }
            if (bl2) {
                return l2;
            }
            n2 = CharsTrie.skipNodeValue(n2, n3);
            n3 &= 0x3F;
        }
    }

    private static void getNextBranchChars(CharSequence charSequence, int n2, int n3, Appendable appendable) {
        while (n3 > 5) {
            CharsTrie.getNextBranchChars(charSequence, CharsTrie.jumpByDelta(charSequence, ++n2), n3 >> 1, appendable);
            n3 -= n3 >> 1;
            n2 = CharsTrie.skipDelta(charSequence, n2);
        }
        do {
            CharsTrie.append(appendable, charSequence.charAt(n2++));
            n2 = CharsTrie.skipValue(charSequence, n2);
        } while (--n3 > 1);
        CharsTrie.append(appendable, charSequence.charAt(n2));
    }

    private static void append(Appendable appendable, int n2) {
        try {
            appendable.append((char)n2);
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    public static final class Iterator
    implements java.util.Iterator<Entry> {
        private CharSequence chars_;
        private int pos_;
        private int initialPos_;
        private int remainingMatchLength_;
        private int initialRemainingMatchLength_;
        private boolean skipValue_;
        private StringBuilder str_ = new StringBuilder();
        private int maxLength_;
        private Entry entry_ = new Entry();
        private ArrayList<Long> stack_ = new ArrayList();

        private Iterator(CharSequence charSequence, int n2, int n3, int n4) {
            this.chars_ = charSequence;
            this.pos_ = this.initialPos_ = n2;
            this.remainingMatchLength_ = this.initialRemainingMatchLength_ = n3;
            this.maxLength_ = n4;
            int n5 = this.remainingMatchLength_;
            if (n5 >= 0) {
                if (this.maxLength_ > 0 && ++n5 > this.maxLength_) {
                    n5 = this.maxLength_;
                }
                this.str_.append(this.chars_, this.pos_, this.pos_ + n5);
                this.pos_ += n5;
                this.remainingMatchLength_ -= n5;
            }
        }

        public Iterator reset() {
            this.pos_ = this.initialPos_;
            this.remainingMatchLength_ = this.initialRemainingMatchLength_;
            this.skipValue_ = false;
            int n2 = this.remainingMatchLength_ + 1;
            if (this.maxLength_ > 0 && n2 > this.maxLength_) {
                n2 = this.maxLength_;
            }
            this.str_.setLength(n2);
            this.pos_ += n2;
            this.remainingMatchLength_ -= n2;
            this.stack_.clear();
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.pos_ >= 0 || !this.stack_.isEmpty();
        }

        @Override
        public Entry next() {
            int n2 = this.pos_;
            if (n2 < 0) {
                if (this.stack_.isEmpty()) {
                    throw new NoSuchElementException();
                }
                long l2 = this.stack_.remove(this.stack_.size() - 1);
                int n3 = (int)l2;
                n2 = (int)(l2 >> 32);
                this.str_.setLength(n3 & 0xFFFF);
                if ((n3 >>>= 16) > 1) {
                    if ((n2 = this.branchNext(n2, n3)) < 0) {
                        return this.entry_;
                    }
                } else {
                    this.str_.append(this.chars_.charAt(n2++));
                }
            }
            if (this.remainingMatchLength_ >= 0) {
                return this.truncateAndStop();
            }
            while (true) {
                int n4;
                int n5;
                if ((n5 = this.chars_.charAt(n2++)) >= 64) {
                    if (this.skipValue_) {
                        n2 = CharsTrie.skipNodeValue(n2, n5);
                        n5 &= 0x3F;
                        this.skipValue_ = false;
                    } else {
                        n4 = (n5 & 0x8000) != 0 ? 1 : 0;
                        this.entry_.value = n4 != 0 ? CharsTrie.readValue(this.chars_, n2, n5 & Short.MAX_VALUE) : CharsTrie.readNodeValue(this.chars_, n2, n5);
                        if (n4 != 0 || this.maxLength_ > 0 && this.str_.length() == this.maxLength_) {
                            this.pos_ = -1;
                        } else {
                            this.pos_ = n2 - 1;
                            this.skipValue_ = true;
                        }
                        this.entry_.chars = this.str_;
                        return this.entry_;
                    }
                }
                if (this.maxLength_ > 0 && this.str_.length() == this.maxLength_) {
                    return this.truncateAndStop();
                }
                if (n5 < 48) {
                    if (n5 == 0) {
                        n5 = this.chars_.charAt(n2++);
                    }
                    if ((n2 = this.branchNext(n2, n5 + 1)) >= 0) continue;
                    return this.entry_;
                }
                n4 = n5 - 48 + 1;
                if (this.maxLength_ > 0 && this.str_.length() + n4 > this.maxLength_) {
                    this.str_.append(this.chars_, n2, n2 + this.maxLength_ - this.str_.length());
                    return this.truncateAndStop();
                }
                this.str_.append(this.chars_, n2, n2 + n4);
                n2 += n4;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Entry truncateAndStop() {
            this.pos_ = -1;
            this.entry_.chars = this.str_;
            this.entry_.value = -1;
            return this.entry_;
        }

        private int branchNext(int n2, int n3) {
            int n4;
            while (n3 > 5) {
                this.stack_.add((long)CharsTrie.skipDelta(this.chars_, ++n2) << 32 | (long)(n3 - (n3 >> 1) << 16) | (long)this.str_.length());
                n3 >>= 1;
                n2 = CharsTrie.jumpByDelta(this.chars_, n2);
            }
            char c2 = this.chars_.charAt(n2++);
            boolean bl2 = ((n4 = this.chars_.charAt(n2++)) & 0x8000) != 0;
            int n5 = CharsTrie.readValue(this.chars_, n2, n4 &= Short.MAX_VALUE);
            n2 = CharsTrie.skipValue(n2, n4);
            this.stack_.add((long)n2 << 32 | (long)(n3 - 1 << 16) | (long)this.str_.length());
            this.str_.append(c2);
            if (bl2) {
                this.pos_ = -1;
                this.entry_.chars = this.str_;
                this.entry_.value = n5;
                return -1;
            }
            return n2 + n5;
        }
    }

    public static final class Entry {
        public CharSequence chars;
        public int value;

        private Entry() {
        }
    }

    public static final class State {
        private CharSequence chars;
        private int root;
        private int pos;
        private int remainingMatchLength;
    }
}

