/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeFilter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class UnicodeNameTransliterator
extends Transliterator {
    static final String _ID = "Any-Name";
    static final String OPEN_DELIM = "\\N{";
    static final char CLOSE_DELIM = '}';
    static final int OPEN_DELIM_LEN = 3;

    static void register() {
        Transliterator.registerFactory(_ID, new Transliterator.Factory(){

            @Override
            public Transliterator getInstance(String string) {
                return new UnicodeNameTransliterator(null);
            }
        });
    }

    public UnicodeNameTransliterator(UnicodeFilter unicodeFilter) {
        super(_ID, unicodeFilter);
    }

    @Override
    protected void handleTransliterate(Replaceable replaceable, Transliterator.Position position, boolean bl2) {
        int n2 = position.start;
        int n3 = position.limit;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OPEN_DELIM);
        while (n2 < n3) {
            int n4 = replaceable.char32At(n2);
            String string = UCharacter.getExtendedName(n4);
            if (string != null) {
                stringBuilder.setLength(3);
                stringBuilder.append(string).append('}');
                int n5 = UTF16.getCharCount(n4);
                replaceable.replace(n2, n2 + n5, stringBuilder.toString());
                int n6 = stringBuilder.length();
                n2 += n6;
                n3 += n6 - n5;
                continue;
            }
            ++n2;
        }
        position.contextLimit += n3 - position.limit;
        position.limit = n3;
        position.start = n2;
    }

    @Override
    public void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        UnicodeSet unicodeSet4 = this.getFilterAsUnicodeSet(unicodeSet);
        if (unicodeSet4.size() > 0) {
            unicodeSet2.addAll(unicodeSet4);
            unicodeSet3.addAll(48, 57).addAll(65, 90).add(45).add(32).addAll(OPEN_DELIM).add(125).addAll(97, 122).add(60).add(62).add(40).add(41);
        }
    }
}

