/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.text.SCSU;

public final class UnicodeCompressor
implements SCSU {
    private static boolean[] sSingleTagTable = new boolean[]{false, true, true, true, true, true, true, true, true, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static boolean[] sUnicodeTagTable = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private int fCurrentWindow = 0;
    private int[] fOffsets = new int[8];
    private int fMode = 0;
    private int[] fIndexCount = new int[256];
    private int[] fTimeStamps = new int[8];
    private int fTimeStamp = 0;

    public UnicodeCompressor() {
        this.reset();
    }

    public static byte[] compress(String string) {
        return UnicodeCompressor.compress(string.toCharArray(), 0, string.length());
    }

    public static byte[] compress(char[] cArray, int n2, int n3) {
        UnicodeCompressor unicodeCompressor = new UnicodeCompressor();
        int n4 = Math.max(4, 3 * (n3 - n2) + 1);
        byte[] byArray = new byte[n4];
        int n5 = unicodeCompressor.compress(cArray, n2, n3, null, byArray, 0, n4);
        byte[] byArray2 = new byte[n5];
        System.arraycopy(byArray, 0, byArray2, 0, n5);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int compress(char[] cArray, int n2, int n3, int[] nArray, byte[] byArray, int n4, int n5) {
        int n6 = n4;
        int n7 = n2;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (byArray.length < 4 || n5 - n4 < 4) {
            throw new IllegalArgumentException("byteBuffer.length < 4");
        }
        block4: while (n7 < n3 && n6 < n5) {
            block47: {
                block48: {
                    switch (this.fMode) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break block48;
                        }
                    }
                    while (n7 < n3 && n6 < n5) {
                        n8 = cArray[n7++];
                        n10 = n7 < n3 ? cArray[n7] : -1;
                        if (n8 < 128) {
                            n14 = n8 & 0xFF;
                            if (sSingleTagTable[n14]) {
                                if (n6 + 1 >= n5) {
                                    --n7;
                                    break block4;
                                }
                                byArray[n6++] = 1;
                            }
                            byArray[n6++] = (byte)n14;
                            continue;
                        }
                        if (this.inDynamicWindow(n8, this.fCurrentWindow)) {
                            byArray[n6++] = (byte)(n8 - this.fOffsets[this.fCurrentWindow] + 128);
                            continue;
                        }
                        if (!UnicodeCompressor.isCompressible(n8)) {
                            if (n10 != -1 && UnicodeCompressor.isCompressible(n10)) {
                                if (n6 + 2 >= n5) {
                                    --n7;
                                    break block4;
                                }
                                byArray[n6++] = 14;
                                byArray[n6++] = (byte)(n8 >>> 8);
                                byArray[n6++] = (byte)(n8 & 0xFF);
                                continue;
                            }
                            if (n6 + 3 >= n5) {
                                --n7;
                                break block4;
                            }
                            byArray[n6++] = 15;
                            n13 = n8 >>> 8;
                            n14 = n8 & 0xFF;
                            if (sUnicodeTagTable[n13]) {
                                byArray[n6++] = -16;
                            }
                            byArray[n6++] = (byte)n13;
                            byArray[n6++] = (byte)n14;
                            this.fMode = 1;
                            break block47;
                        } else {
                            n12 = this.findDynamicWindow(n8);
                            if (n12 != -1) {
                                n11 = n7 + 1 < n3 ? cArray[n7 + 1] : -1;
                                if (this.inDynamicWindow(n10, n12) && this.inDynamicWindow(n11, n12)) {
                                    if (n6 + 1 >= n5) {
                                        --n7;
                                        break block4;
                                    }
                                    byArray[n6++] = (byte)(16 + n12);
                                    byArray[n6++] = (byte)(n8 - this.fOffsets[n12] + 128);
                                    this.fTimeStamps[n12] = ++this.fTimeStamp;
                                    this.fCurrentWindow = n12;
                                    continue;
                                }
                                if (n6 + 1 >= n5) {
                                    --n7;
                                    break block4;
                                }
                                byArray[n6++] = (byte)(1 + n12);
                                byArray[n6++] = (byte)(n8 - this.fOffsets[n12] + 128);
                                continue;
                            }
                            n12 = UnicodeCompressor.findStaticWindow(n8);
                            if (n12 != -1 && !UnicodeCompressor.inStaticWindow(n10, n12)) {
                                if (n6 + 1 >= n5) {
                                    --n7;
                                    break block4;
                                }
                                byArray[n6++] = (byte)(1 + n12);
                                byArray[n6++] = (byte)(n8 - sOffsets[n12]);
                                continue;
                            }
                            int n15 = n9 = UnicodeCompressor.makeIndex(n8);
                            this.fIndexCount[n15] = this.fIndexCount[n15] + 1;
                            n11 = n7 + 1 < n3 ? cArray[n7 + 1] : -1;
                            if (this.fIndexCount[n9] > 1 || n9 == UnicodeCompressor.makeIndex(n10) && n9 == UnicodeCompressor.makeIndex(n11)) {
                                if (n6 + 2 >= n5) {
                                    --n7;
                                    break block4;
                                }
                                n12 = this.getLRDefinedWindow();
                                byArray[n6++] = (byte)(24 + n12);
                                byArray[n6++] = (byte)n9;
                                byArray[n6++] = (byte)(n8 - sOffsetTable[n9] + 128);
                                this.fOffsets[n12] = sOffsetTable[n9];
                                this.fCurrentWindow = n12;
                                this.fTimeStamps[n12] = ++this.fTimeStamp;
                                continue;
                            }
                            if (n6 + 3 >= n5) {
                                --n7;
                                break block4;
                            }
                            byArray[n6++] = 15;
                            n13 = n8 >>> 8;
                            n14 = n8 & 0xFF;
                            if (sUnicodeTagTable[n13]) {
                                byArray[n6++] = -16;
                            }
                            byArray[n6++] = (byte)n13;
                            byArray[n6++] = (byte)n14;
                            this.fMode = 1;
                        }
                        break block47;
                    }
                    break block47;
                }
                while (n7 < n3 && n6 < n5) {
                    n8 = cArray[n7++];
                    n10 = n7 < n3 ? cArray[n7] : -1;
                    if (!UnicodeCompressor.isCompressible(n8) || n10 != -1 && !UnicodeCompressor.isCompressible(n10)) {
                        if (n6 + 2 >= n5) {
                            --n7;
                            break block4;
                        }
                        n13 = n8 >>> 8;
                        n14 = n8 & 0xFF;
                        if (sUnicodeTagTable[n13]) {
                            byArray[n6++] = -16;
                        }
                        byArray[n6++] = (byte)n13;
                        byArray[n6++] = (byte)n14;
                        continue;
                    }
                    if (n8 < 128) {
                        n14 = n8 & 0xFF;
                        if (n10 != -1 && n10 < 128 && !sSingleTagTable[n14]) {
                            if (n6 + 1 >= n5) {
                                --n7;
                                break block4;
                            }
                            n12 = this.fCurrentWindow;
                            byArray[n6++] = (byte)(224 + n12);
                            byArray[n6++] = (byte)n14;
                            this.fTimeStamps[n12] = ++this.fTimeStamp;
                            this.fMode = 0;
                            break;
                        } else {
                            if (n6 + 1 >= n5) {
                                --n7;
                                break block4;
                            }
                            byArray[n6++] = 0;
                            byArray[n6++] = (byte)n14;
                            continue;
                        }
                    }
                    n12 = this.findDynamicWindow(n8);
                    if (n12 != -1) {
                        if (this.inDynamicWindow(n10, n12)) {
                            if (n6 + 1 >= n5) {
                                --n7;
                                break block4;
                            }
                            byArray[n6++] = (byte)(224 + n12);
                            byArray[n6++] = (byte)(n8 - this.fOffsets[n12] + 128);
                            this.fTimeStamps[n12] = ++this.fTimeStamp;
                            this.fCurrentWindow = n12;
                            this.fMode = 0;
                            break;
                        } else {
                            if (n6 + 2 >= n5) {
                                --n7;
                                break block4;
                            }
                            n13 = n8 >>> 8;
                            n14 = n8 & 0xFF;
                            if (sUnicodeTagTable[n13]) {
                                byArray[n6++] = -16;
                            }
                            byArray[n6++] = (byte)n13;
                            byArray[n6++] = (byte)n14;
                            continue;
                        }
                    }
                    int n16 = n9 = UnicodeCompressor.makeIndex(n8);
                    this.fIndexCount[n16] = this.fIndexCount[n16] + 1;
                    n11 = n7 + 1 < n3 ? cArray[n7 + 1] : -1;
                    if (this.fIndexCount[n9] > 1 || n9 == UnicodeCompressor.makeIndex(n10) && n9 == UnicodeCompressor.makeIndex(n11)) {
                        if (n6 + 2 >= n5) {
                            --n7;
                            break block4;
                        }
                        n12 = this.getLRDefinedWindow();
                        byArray[n6++] = (byte)(232 + n12);
                        byArray[n6++] = (byte)n9;
                        byArray[n6++] = (byte)(n8 - sOffsetTable[n9] + 128);
                        this.fOffsets[n12] = sOffsetTable[n9];
                        this.fCurrentWindow = n12;
                        this.fTimeStamps[n12] = ++this.fTimeStamp;
                        this.fMode = 0;
                        break;
                    }
                    if (n6 + 2 >= n5) {
                        --n7;
                        break block4;
                    }
                    n13 = n8 >>> 8;
                    n14 = n8 & 0xFF;
                    if (sUnicodeTagTable[n13]) {
                        byArray[n6++] = -16;
                    }
                    byArray[n6++] = (byte)n13;
                    byArray[n6++] = (byte)n14;
                }
            }
        }
        if (nArray != null) {
            nArray[0] = n7 - n2;
        }
        return n6 - n4;
    }

    public void reset() {
        int n2;
        this.fOffsets[0] = 128;
        this.fOffsets[1] = 192;
        this.fOffsets[2] = 1024;
        this.fOffsets[3] = 1536;
        this.fOffsets[4] = 2304;
        this.fOffsets[5] = 12352;
        this.fOffsets[6] = 12448;
        this.fOffsets[7] = 65280;
        for (n2 = 0; n2 < 8; ++n2) {
            this.fTimeStamps[n2] = 0;
        }
        for (n2 = 0; n2 <= 255; ++n2) {
            this.fIndexCount[n2] = 0;
        }
        this.fTimeStamp = 0;
        this.fCurrentWindow = 0;
        this.fMode = 0;
    }

    private static int makeIndex(int n2) {
        if (n2 >= 192 && n2 < 320) {
            return 249;
        }
        if (n2 >= 592 && n2 < 720) {
            return 250;
        }
        if (n2 >= 880 && n2 < 1008) {
            return 251;
        }
        if (n2 >= 1328 && n2 < 1424) {
            return 252;
        }
        if (n2 >= 12352 && n2 < 12448) {
            return 253;
        }
        if (n2 >= 12448 && n2 < 12576) {
            return 254;
        }
        if (n2 >= 65376 && n2 < 65439) {
            return 255;
        }
        if (n2 >= 128 && n2 < 13312) {
            return n2 / 128 & 0xFF;
        }
        if (n2 >= 57344 && n2 <= 65535) {
            return (n2 - 44032) / 128 & 0xFF;
        }
        return 0;
    }

    private boolean inDynamicWindow(int n2, int n3) {
        return n2 >= this.fOffsets[n3] && n2 < this.fOffsets[n3] + 128;
    }

    private static boolean inStaticWindow(int n2, int n3) {
        return n2 >= sOffsets[n3] && n2 < sOffsets[n3] + 128;
    }

    private static boolean isCompressible(int n2) {
        return n2 < 13312 || n2 >= 57344;
    }

    private int findDynamicWindow(int n2) {
        for (int i2 = 7; i2 >= 0; --i2) {
            if (!this.inDynamicWindow(n2, i2)) continue;
            int n3 = i2;
            this.fTimeStamps[n3] = this.fTimeStamps[n3] + 1;
            return i2;
        }
        return -1;
    }

    private static int findStaticWindow(int n2) {
        for (int i2 = 7; i2 >= 0; --i2) {
            if (!UnicodeCompressor.inStaticWindow(n2, i2)) continue;
            return i2;
        }
        return -1;
    }

    private int getLRDefinedWindow() {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (int i2 = 7; i2 >= 0; --i2) {
            if (this.fTimeStamps[i2] >= n2) continue;
            n2 = this.fTimeStamps[i2];
            n3 = i2;
        }
        return n3;
    }
}

