/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.AnyTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CaseFoldTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CompoundTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.EscapeTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.LowercaseTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NameUnicodeTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NormalizationTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NullTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RemoveTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ReplaceableString;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringTransform;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TitlecaseTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TransliteratorIDParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TransliteratorParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TransliteratorRegistry;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnescapeTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeFilter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeNameTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UppercaseTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CaseInsensitiveString;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public abstract class Transliterator
implements StringTransform {
    public static final int FORWARD = 0;
    public static final int REVERSE = 1;
    private String ID;
    private UnicodeSet filter;
    private int maximumContextLength = 0;
    private static TransliteratorRegistry registry = new TransliteratorRegistry();
    private static Map<CaseInsensitiveString, String> displayNameCache = Collections.synchronizedMap(new HashMap());
    private static final String RB_DISPLAY_NAME_PREFIX = "%Translit%%";
    private static final String RB_SCRIPT_DISPLAY_NAME_PREFIX = "%Translit%";
    private static final String RB_DISPLAY_NAME_PATTERN = "TransliteratorNamePattern";
    static final char ID_DELIM = ';';
    static final char ID_SEP = '-';
    static final char VARIANT_SEP = '/';
    static final boolean DEBUG = false;
    private static final String ROOT = "root";
    private static final String RB_RULE_BASED_IDS = "RuleBasedTransliteratorIDs";

    protected Transliterator(String string, UnicodeFilter unicodeFilter) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.ID = string;
        this.setFilter(unicodeFilter);
    }

    public final int transliterate(Replaceable replaceable, int n2, int n3) {
        if (n2 < 0 || n3 < n2 || replaceable.length() < n3) {
            return -1;
        }
        Position position = new Position(n2, n3, n2);
        this.filteredTransliterate(replaceable, position, false, true);
        return position.limit;
    }

    public final void transliterate(Replaceable replaceable) {
        this.transliterate(replaceable, 0, replaceable.length());
    }

    public final String transliterate(String string) {
        ReplaceableString replaceableString = new ReplaceableString(string);
        this.transliterate(replaceableString);
        return replaceableString.toString();
    }

    public final void transliterate(Replaceable replaceable, Position position, String string) {
        position.validate(replaceable.length());
        if (string != null) {
            replaceable.replace(position.limit, position.limit, string);
            position.limit += string.length();
            position.contextLimit += string.length();
        }
        if (position.limit > 0 && UTF16.isLeadSurrogate(replaceable.charAt(position.limit - 1))) {
            return;
        }
        this.filteredTransliterate(replaceable, position, true, true);
    }

    public final void transliterate(Replaceable replaceable, Position position, int n2) {
        this.transliterate(replaceable, position, UTF16.valueOf(n2));
    }

    public final void transliterate(Replaceable replaceable, Position position) {
        this.transliterate(replaceable, position, null);
    }

    public final void finishTransliteration(Replaceable replaceable, Position position) {
        position.validate(replaceable.length());
        this.filteredTransliterate(replaceable, position, false, true);
    }

    protected abstract void handleTransliterate(Replaceable var1, Position var2, boolean var3);

    private void filteredTransliterate(Replaceable replaceable, Position position, boolean bl2, boolean bl3) {
        int n2;
        if (this.filter == null && !bl3) {
            this.handleTransliterate(replaceable, position, bl2);
            return;
        }
        int n3 = position.limit;
        Object var6_6 = null;
        do {
            int n4;
            int n5;
            if (this.filter != null) {
                while (position.start < n3 && !this.filter.contains(n2 = replaceable.char32At(position.start))) {
                    position.start += UTF16.getCharCount(n2);
                }
                position.limit = position.start;
                while (position.limit < n3 && this.filter.contains(n2 = replaceable.char32At(position.limit))) {
                    position.limit += UTF16.getCharCount(n2);
                }
            }
            if (position.start == position.limit) break;
            int n6 = n2 = position.limit < n3 ? 0 : bl2;
            if (bl3 && n2 != 0) {
                int n7;
                n5 = position.start;
                int n8 = position.limit;
                int n9 = n8 - n5;
                int n10 = replaceable.length();
                replaceable.copy(n5, n8, n10);
                int n11 = n5;
                int n12 = n10;
                int n13 = position.start;
                int n14 = 0;
                int n15 = 0;
                while ((n13 += (n7 = UTF16.getCharCount(replaceable.char32At(n13)))) <= n8) {
                    n14 += n7;
                    position.limit = n13;
                    this.handleTransliterate(replaceable, position, true);
                    n4 = position.limit - n13;
                    if (position.start != position.limit) {
                        int n16 = n12 + n4 - (position.limit - n11);
                        replaceable.replace(n11, position.limit, "");
                        replaceable.copy(n16, n16 + n14, n11);
                        position.start = n11;
                        position.limit = n13;
                        position.contextLimit -= n4;
                        continue;
                    }
                    n11 = n13 = position.start;
                    n12 += n4 + n14;
                    n14 = 0;
                    n8 += n4;
                    n15 += n4;
                }
                n3 += n15;
                replaceable.replace(n10 += n15, n10 + n9, "");
                position.start = n11;
                continue;
            }
            n5 = position.limit;
            this.handleTransliterate(replaceable, position, n2 != 0);
            n4 = position.limit - n5;
            if (n2 == 0 && position.start != position.limit) {
                throw new RuntimeException("ERROR: Incomplete non-incremental transliteration by " + this.getID());
            }
            n3 += n4;
        } while (this.filter != null && n2 == 0);
        position.limit = n3;
    }

    public void filteredTransliterate(Replaceable replaceable, Position position, boolean bl2) {
        this.filteredTransliterate(replaceable, position, bl2, false);
    }

    public final int getMaximumContextLength() {
        return this.maximumContextLength;
    }

    protected void setMaximumContextLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid context length " + n2);
        }
        this.maximumContextLength = n2;
    }

    public final String getID() {
        return this.ID;
    }

    protected final void setID(String string) {
        this.ID = string;
    }

    public static final String getDisplayName(String string) {
        return Transliterator.getDisplayName(string, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public static String getDisplayName(String string, Locale locale) {
        return Transliterator.getDisplayName(string, ULocale.forLocale(locale));
    }

    public static String getDisplayName(String string, ULocale uLocale) {
        String string2;
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/translit", uLocale);
        String[] stringArray = TransliteratorIDParser.IDtoSTV(string);
        if (stringArray == null) {
            return "";
        }
        String string3 = stringArray[0] + '-' + stringArray[1];
        if (stringArray[2] != null && stringArray[2].length() > 0) {
            string3 = string3 + '/' + stringArray[2];
        }
        if ((string2 = displayNameCache.get(new CaseInsensitiveString(string3))) != null) {
            return string2;
        }
        try {
            return iCUResourceBundle.getString(RB_DISPLAY_NAME_PREFIX + string3);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                MessageFormat messageFormat = new MessageFormat(iCUResourceBundle.getString(RB_DISPLAY_NAME_PATTERN));
                Object[] objectArray = new Object[]{2, stringArray[0], stringArray[1]};
                for (int i2 = 1; i2 <= 2; ++i2) {
                    try {
                        objectArray[i2] = iCUResourceBundle.getString(RB_SCRIPT_DISPLAY_NAME_PREFIX + (String)objectArray[i2]);
                        continue;
                    }
                    catch (MissingResourceException missingResourceException2) {
                        // empty catch block
                    }
                }
                return stringArray[2].length() > 0 ? messageFormat.format(objectArray) + '/' + stringArray[2] : messageFormat.format(objectArray);
            }
            catch (MissingResourceException missingResourceException3) {
                throw new RuntimeException();
            }
        }
    }

    public final UnicodeFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UnicodeFilter unicodeFilter) {
        if (unicodeFilter == null) {
            this.filter = null;
        } else {
            try {
                this.filter = new UnicodeSet((UnicodeSet)unicodeFilter).freeze();
            }
            catch (Exception exception) {
                this.filter = new UnicodeSet();
                unicodeFilter.addMatchSetTo(this.filter);
                this.filter.freeze();
            }
        }
    }

    public static final Transliterator getInstance(String string) {
        return Transliterator.getInstance(string, 0);
    }

    public static Transliterator getInstance(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<TransliteratorIDParser.SingleID> arrayList = new ArrayList<TransliteratorIDParser.SingleID>();
        UnicodeSet[] unicodeSetArray = new UnicodeSet[1];
        if (!TransliteratorIDParser.parseCompoundID(string, n2, stringBuffer, arrayList, unicodeSetArray)) {
            throw new IllegalArgumentException("Invalid ID " + string);
        }
        List<Transliterator> list = TransliteratorIDParser.instantiateList(arrayList);
        Transliterator transliterator = null;
        transliterator = arrayList.size() > 1 || stringBuffer.indexOf(";") >= 0 ? new CompoundTransliterator(list) : list.get(0);
        transliterator.setID(stringBuffer.toString());
        if (unicodeSetArray[0] != null) {
            transliterator.setFilter(unicodeSetArray[0]);
        }
        return transliterator;
    }

    static Transliterator getBasicInstance(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Transliterator transliterator = registry.get(string, stringBuffer);
        if (stringBuffer.length() != 0) {
            transliterator = Transliterator.getInstance(stringBuffer.toString(), 0);
        }
        if (transliterator != null && string2 != null) {
            transliterator.setID(string2);
        }
        return transliterator;
    }

    public static final Transliterator createFromRules(String string, String string2, int n2) {
        Transliterator transliterator = null;
        TransliteratorParser transliteratorParser = new TransliteratorParser();
        transliteratorParser.parse(string2, n2);
        if (transliteratorParser.idBlockVector.size() == 0 && transliteratorParser.dataVector.size() == 0) {
            transliterator = new NullTransliterator();
        } else if (transliteratorParser.idBlockVector.size() == 0 && transliteratorParser.dataVector.size() == 1) {
            transliterator = new RuleBasedTransliterator(string, transliteratorParser.dataVector.get(0), transliteratorParser.compoundFilter);
        } else if (transliteratorParser.idBlockVector.size() == 1 && transliteratorParser.dataVector.size() == 0) {
            transliterator = transliteratorParser.compoundFilter != null ? Transliterator.getInstance(transliteratorParser.compoundFilter.toPattern(false) + ";" + transliteratorParser.idBlockVector.get(0)) : Transliterator.getInstance(transliteratorParser.idBlockVector.get(0));
            if (transliterator != null) {
                transliterator.setID(string);
            }
        } else {
            ArrayList<Transliterator> arrayList = new ArrayList<Transliterator>();
            int n3 = 1;
            int n4 = Math.max(transliteratorParser.idBlockVector.size(), transliteratorParser.dataVector.size());
            for (int i2 = 0; i2 < n4; ++i2) {
                Transliterator transliterator2;
                Object object;
                if (i2 < transliteratorParser.idBlockVector.size() && ((String)(object = transliteratorParser.idBlockVector.get(i2))).length() > 0 && !((transliterator2 = Transliterator.getInstance((String)object)) instanceof NullTransliterator)) {
                    arrayList.add(Transliterator.getInstance((String)object));
                }
                if (i2 >= transliteratorParser.dataVector.size()) continue;
                object = transliteratorParser.dataVector.get(i2);
                arrayList.add(new RuleBasedTransliterator("%Pass" + n3++, (RuleBasedTransliterator.Data)object, null));
            }
            transliterator = new CompoundTransliterator(arrayList, n3 - 1);
            transliterator.setID(string);
            if (transliteratorParser.compoundFilter != null) {
                transliterator.setFilter(transliteratorParser.compoundFilter);
            }
        }
        return transliterator;
    }

    public String toRules(boolean bl2) {
        return this.baseToRules(bl2);
    }

    protected final String baseToRules(boolean bl2) {
        if (bl2) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getID();
            for (int i2 = 0; i2 < string.length(); i2 += UTF16.getCharCount(n2)) {
                n2 = UTF16.charAt(string, i2);
                if (Utility.escapeUnprintable(stringBuffer, n2)) continue;
                UTF16.append(stringBuffer, n2);
            }
            stringBuffer.insert(0, "::");
            stringBuffer.append(';');
            return stringBuffer.toString();
        }
        return "::" + this.getID() + ';';
    }

    public Transliterator[] getElements() {
        Transliterator[] transliteratorArray;
        if (this instanceof CompoundTransliterator) {
            CompoundTransliterator compoundTransliterator = (CompoundTransliterator)this;
            transliteratorArray = new Transliterator[compoundTransliterator.getCount()];
            for (int i2 = 0; i2 < transliteratorArray.length; ++i2) {
                transliteratorArray[i2] = compoundTransliterator.getTransliterator(i2);
            }
        } else {
            transliteratorArray = new Transliterator[]{this};
        }
        return transliteratorArray;
    }

    public final UnicodeSet getSourceSet() {
        UnicodeSet unicodeSet = new UnicodeSet();
        this.addSourceTargetSet(this.getFilterAsUnicodeSet(UnicodeSet.ALL_CODE_POINTS), unicodeSet, new UnicodeSet());
        return unicodeSet;
    }

    protected UnicodeSet handleGetSourceSet() {
        return new UnicodeSet();
    }

    public UnicodeSet getTargetSet() {
        UnicodeSet unicodeSet = new UnicodeSet();
        this.addSourceTargetSet(this.getFilterAsUnicodeSet(UnicodeSet.ALL_CODE_POINTS), new UnicodeSet(), unicodeSet);
        return unicodeSet;
    }

    @Deprecated
    public void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        UnicodeSet unicodeSet4 = this.getFilterAsUnicodeSet(unicodeSet);
        UnicodeSet unicodeSet5 = new UnicodeSet(this.handleGetSourceSet()).retainAll(unicodeSet4);
        unicodeSet2.addAll(unicodeSet5);
        for (String string : unicodeSet5) {
            String string2;
            if (string.equals(string2 = this.transliterate(string))) continue;
            unicodeSet3.addAll(string2);
        }
    }

    @Deprecated
    public UnicodeSet getFilterAsUnicodeSet(UnicodeSet unicodeSet) {
        UnicodeSet unicodeSet2;
        if (this.filter == null) {
            return unicodeSet;
        }
        UnicodeSet unicodeSet3 = new UnicodeSet(unicodeSet);
        try {
            unicodeSet2 = this.filter;
        }
        catch (ClassCastException classCastException) {
            unicodeSet2 = new UnicodeSet();
            this.filter.addMatchSetTo(unicodeSet2);
        }
        return unicodeSet3.retainAll(unicodeSet2).freeze();
    }

    public final Transliterator getInverse() {
        return Transliterator.getInstance(this.ID, 1);
    }

    public static void registerClass(String string, Class<? extends Transliterator> clazz, String string2) {
        registry.put(string, clazz, true);
        if (string2 != null) {
            displayNameCache.put(new CaseInsensitiveString(string), string2);
        }
    }

    public static void registerFactory(String string, Factory factory) {
        registry.put(string, factory, true);
    }

    public static void registerInstance(Transliterator transliterator) {
        registry.put(transliterator.getID(), transliterator, true);
    }

    static void registerInstance(Transliterator transliterator, boolean bl2) {
        registry.put(transliterator.getID(), transliterator, bl2);
    }

    public static void registerAlias(String string, String string2) {
        registry.put(string, string2, true);
    }

    static void registerSpecialInverse(String string, String string2, boolean bl2) {
        TransliteratorIDParser.registerSpecialInverse(string, string2, bl2);
    }

    public static void unregister(String string) {
        displayNameCache.remove(new CaseInsensitiveString(string));
        registry.remove(string);
    }

    public static final Enumeration<String> getAvailableIDs() {
        return registry.getAvailableIDs();
    }

    public static final Enumeration<String> getAvailableSources() {
        return registry.getAvailableSources();
    }

    public static final Enumeration<String> getAvailableTargets(String string) {
        return registry.getAvailableTargets(string);
    }

    public static final Enumeration<String> getAvailableVariants(String string, String string2) {
        return registry.getAvailableVariants(string, string2);
    }

    @Deprecated
    public static void registerAny() {
        AnyTransliterator.register();
    }

    @Override
    public String transform(String string) {
        return this.transliterate(string);
    }

    static {
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/translit", ROOT);
        UResourceBundle uResourceBundle2 = uResourceBundle.get(RB_RULE_BASED_IDS);
        int n2 = uResourceBundle2.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            UResourceBundle uResourceBundle3 = uResourceBundle2.get(i2);
            String string2 = uResourceBundle3.getKey();
            if (string2.indexOf("-t-") >= 0) continue;
            UResourceBundle uResourceBundle4 = uResourceBundle3.get(0);
            String string3 = uResourceBundle4.getKey();
            if (string3.equals("file") || string3.equals("internal")) {
                int n3;
                string = uResourceBundle4.getString("resource");
                String string4 = uResourceBundle4.getString("direction");
                switch (string4.charAt(0)) {
                    case 'F': {
                        n3 = 0;
                        break;
                    }
                    case 'R': {
                        n3 = 1;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Can't parse direction: " + string4);
                    }
                }
                registry.put(string2, string, n3, !string3.equals("internal"));
                continue;
            }
            if (string3.equals("alias")) {
                string = uResourceBundle4.getString();
                registry.put(string2, string, true);
                continue;
            }
            throw new RuntimeException("Unknown type: " + string3);
        }
        Transliterator.registerSpecialInverse("Null", "Null", false);
        Transliterator.registerClass("Any-Null", NullTransliterator.class, null);
        RemoveTransliterator.register();
        EscapeTransliterator.register();
        UnescapeTransliterator.register();
        LowercaseTransliterator.register();
        UppercaseTransliterator.register();
        TitlecaseTransliterator.register();
        CaseFoldTransliterator.register();
        UnicodeNameTransliterator.register();
        NameUnicodeTransliterator.register();
        NormalizationTransliterator.register();
        BreakTransliterator.register();
        AnyTransliterator.register();
    }

    public static interface Factory {
        public Transliterator getInstance(String var1);
    }

    public static class Position {
        public int contextStart;
        public int contextLimit;
        public int start;
        public int limit;

        public Position() {
            this(0, 0, 0, 0);
        }

        public Position(int n2, int n3, int n4) {
            this(n2, n3, n4, n3);
        }

        public Position(int n2, int n3, int n4, int n5) {
            this.contextStart = n2;
            this.contextLimit = n3;
            this.start = n4;
            this.limit = n5;
        }

        public Position(Position position) {
            this.set(position);
        }

        public void set(Position position) {
            this.contextStart = position.contextStart;
            this.contextLimit = position.contextLimit;
            this.start = position.start;
            this.limit = position.limit;
        }

        public boolean equals(Object object) {
            if (object instanceof Position) {
                Position position = (Position)object;
                return this.contextStart == position.contextStart && this.contextLimit == position.contextLimit && this.start == position.start && this.limit == position.limit;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.contextStart, this.contextLimit, this.start, this.limit);
        }

        public String toString() {
            return "[cs=" + this.contextStart + ", s=" + this.start + ", l=" + this.limit + ", cl=" + this.contextLimit + "]";
        }

        public final void validate(int n2) {
            if (this.contextStart < 0 || this.start < this.contextStart || this.limit < this.start || this.contextLimit < this.limit || n2 < this.contextLimit) {
                throw new IllegalArgumentException("Invalid Position {cs=" + this.contextStart + ", s=" + this.start + ", l=" + this.limit + ", cl=" + this.contextLimit + "}, len=" + n2);
            }
        }
    }
}

