/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CharTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringPrepDataReader;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UBiDiProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringPrepParseException;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.VersionInfo;

public final class StringPrep {
    public static final int DEFAULT = 0;
    public static final int ALLOW_UNASSIGNED = 1;
    public static final int RFC3491_NAMEPREP = 0;
    public static final int RFC3530_NFS4_CS_PREP = 1;
    public static final int RFC3530_NFS4_CS_PREP_CI = 2;
    public static final int RFC3530_NFS4_CIS_PREP = 3;
    public static final int RFC3530_NFS4_MIXED_PREP_PREFIX = 4;
    public static final int RFC3530_NFS4_MIXED_PREP_SUFFIX = 5;
    public static final int RFC3722_ISCSI = 6;
    public static final int RFC3920_NODEPREP = 7;
    public static final int RFC3920_RESOURCEPREP = 8;
    public static final int RFC4011_MIB = 9;
    public static final int RFC4013_SASLPREP = 10;
    public static final int RFC4505_TRACE = 11;
    public static final int RFC4518_LDAP = 12;
    public static final int RFC4518_LDAP_CI = 13;
    private static final int MAX_PROFILE = 13;
    private static final String[] PROFILE_NAMES = new String[]{"rfc3491", "rfc3530cs", "rfc3530csci", "rfc3491", "rfc3530mixp", "rfc3491", "rfc3722", "rfc3920node", "rfc3920res", "rfc4011", "rfc4013", "rfc4505", "rfc4518", "rfc4518ci"};
    private static final WeakReference<StringPrep>[] CACHE = new WeakReference[14];
    private static final int UNASSIGNED = 0;
    private static final int MAP = 1;
    private static final int PROHIBITED = 2;
    private static final int DELETE = 3;
    private static final int TYPE_LIMIT = 4;
    private static final int NORMALIZATION_ON = 1;
    private static final int CHECK_BIDI_ON = 2;
    private static final int TYPE_THRESHOLD = 65520;
    private static final int MAX_INDEX_VALUE = 16319;
    private static final int INDEX_MAPPING_DATA_SIZE = 1;
    private static final int NORM_CORRECTNS_LAST_UNI_VERSION = 2;
    private static final int ONE_UCHAR_MAPPING_INDEX_START = 3;
    private static final int TWO_UCHARS_MAPPING_INDEX_START = 4;
    private static final int THREE_UCHARS_MAPPING_INDEX_START = 5;
    private static final int FOUR_UCHARS_MAPPING_INDEX_START = 6;
    private static final int OPTIONS = 7;
    private static final int INDEX_TOP = 16;
    private CharTrie sprepTrie;
    private int[] indexes;
    private char[] mappingData;
    private VersionInfo sprepUniVer;
    private VersionInfo normCorrVer;
    private boolean doNFKC;
    private boolean checkBiDi;
    private UBiDiProps bdp;

    private char getCodePointValue(int n2) {
        return this.sprepTrie.getCodePointValue(n2);
    }

    private static VersionInfo getVersionInfo(int n2) {
        int n3 = n2 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 >> 16 & 0xFF;
        int n6 = n2 >> 24 & 0xFF;
        return VersionInfo.getInstance(n6, n5, n4, n3);
    }

    private static VersionInfo getVersionInfo(byte[] byArray) {
        if (byArray.length != 4) {
            return null;
        }
        return VersionInfo.getInstance(byArray[0], byArray[1], byArray[2], byArray[3]);
    }

    public StringPrep(InputStream inputStream) throws IOException {
        this(ICUBinary.getByteBufferFromInputStreamAndCloseStream(inputStream));
    }

    private StringPrep(ByteBuffer byteBuffer) throws IOException {
        StringPrepDataReader stringPrepDataReader = new StringPrepDataReader(byteBuffer);
        this.indexes = stringPrepDataReader.readIndexes(16);
        this.sprepTrie = new CharTrie(byteBuffer, null);
        this.mappingData = stringPrepDataReader.read(this.indexes[1] / 2);
        this.doNFKC = (this.indexes[7] & 1) > 0;
        this.checkBiDi = (this.indexes[7] & 2) > 0;
        this.sprepUniVer = StringPrep.getVersionInfo(stringPrepDataReader.getUnicodeVersion());
        this.normCorrVer = StringPrep.getVersionInfo(this.indexes[2]);
        VersionInfo versionInfo = UCharacter.getUnicodeVersion();
        if (versionInfo.compareTo(this.sprepUniVer) < 0 && versionInfo.compareTo(this.normCorrVer) < 0 && (this.indexes[7] & 1) > 0) {
            throw new IOException("Normalization Correction version not supported");
        }
        if (this.checkBiDi) {
            this.bdp = UBiDiProps.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringPrep getInstance(int n2) {
        if (n2 < 0 || n2 > 13) {
            throw new IllegalArgumentException("Bad profile type");
        }
        StringPrep stringPrep = null;
        WeakReference<StringPrep>[] weakReferenceArray = CACHE;
        synchronized (CACHE) {
            WeakReference<StringPrep> weakReference = CACHE[n2];
            if (weakReference != null) {
                stringPrep = (StringPrep)weakReference.get();
            }
            if (stringPrep == null) {
                ByteBuffer byteBuffer = ICUBinary.getRequiredData(PROFILE_NAMES[n2] + ".spp");
                if (byteBuffer != null) {
                    try {
                        stringPrep = new StringPrep(byteBuffer);
                    }
                    catch (IOException iOException) {
                        throw new ICUUncheckedIOException(iOException);
                    }
                }
                if (stringPrep != null) {
                    StringPrep.CACHE[n2] = new WeakReference<StringPrep>(stringPrep);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return stringPrep;
        }
    }

    private static final void getValues(char c2, Values values) {
        values.reset();
        if (c2 == '\u0000') {
            values.type = 4;
        } else if (c2 >= '\ufff0') {
            values.type = c2 - 65520;
        } else {
            values.type = 1;
            if ((c2 & 2) > 0) {
                values.isIndex = true;
                values.value = c2 >> 2;
            } else {
                values.isIndex = false;
                values.value = c2 << 16 >> 16;
                values.value >>= 2;
            }
            if (c2 >> 2 == 16319) {
                values.type = 3;
                values.isIndex = false;
                values.value = 0;
            }
        }
    }

    private StringBuffer map(UCharacterIterator uCharacterIterator, int n2) throws StringPrepParseException {
        boolean bl2;
        Values values = new Values();
        char c2 = '\u0000';
        int n3 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = bl2 = (n2 & 1) > 0;
        while ((n3 = uCharacterIterator.nextCodePoint()) != -1) {
            c2 = this.getCodePointValue(n3);
            StringPrep.getValues(c2, values);
            if (values.type == 0 && !bl2) {
                throw new StringPrepParseException("An unassigned code point was found in the input", 3, uCharacterIterator.getText(), uCharacterIterator.getIndex());
            }
            if (values.type == 1) {
                if (values.isIndex) {
                    int n4 = values.value;
                    int n5 = n4 >= this.indexes[3] && n4 < this.indexes[4] ? 1 : (n4 >= this.indexes[4] && n4 < this.indexes[5] ? 2 : (n4 >= this.indexes[5] && n4 < this.indexes[6] ? 3 : this.mappingData[n4++]));
                    stringBuffer.append(this.mappingData, n4, n5);
                    continue;
                }
                n3 -= values.value;
            } else if (values.type == 3) continue;
            UTF16.append(stringBuffer, n3);
        }
        return stringBuffer;
    }

    private StringBuffer normalize(StringBuffer stringBuffer) {
        return new StringBuffer(Normalizer.normalize(stringBuffer.toString(), Normalizer.NFKC, 32));
    }

    public StringBuffer prepare(UCharacterIterator uCharacterIterator, int n2) throws StringPrepParseException {
        int n3;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = this.map(uCharacterIterator, n2);
        if (this.doNFKC) {
            stringBuffer2 = this.normalize(stringBuffer);
        }
        UCharacterIterator uCharacterIterator2 = UCharacterIterator.getInstance(stringBuffer2);
        Values values = new Values();
        int n4 = 23;
        int n5 = 23;
        int n6 = -1;
        int n7 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        while ((n3 = uCharacterIterator2.nextCodePoint()) != -1) {
            char c2 = this.getCodePointValue(n3);
            StringPrep.getValues(c2, values);
            if (values.type == 2) {
                throw new StringPrepParseException("A prohibited code point was found in the input", 2, uCharacterIterator2.getText(), values.value);
            }
            if (!this.checkBiDi) continue;
            n4 = this.bdp.getClass(n3);
            if (n5 == 23) {
                n5 = n4;
            }
            if (n4 == 0) {
                bl3 = true;
                n7 = uCharacterIterator2.getIndex() - 1;
            }
            if (n4 != 1 && n4 != 13) continue;
            bl2 = true;
            n6 = uCharacterIterator2.getIndex() - 1;
        }
        if (this.checkBiDi) {
            if (bl3 && bl2) {
                throw new StringPrepParseException("The input does not conform to the rules for BiDi code points.", 4, uCharacterIterator2.getText(), n6 > n7 ? n6 : n7);
            }
            if (bl2 && (n5 != 1 && n5 != 13 || n4 != 1 && n4 != 13)) {
                throw new StringPrepParseException("The input does not conform to the rules for BiDi code points.", 4, uCharacterIterator2.getText(), n6 > n7 ? n6 : n7);
            }
        }
        return stringBuffer2;
    }

    public String prepare(String string, int n2) throws StringPrepParseException {
        StringBuffer stringBuffer = this.prepare(UCharacterIterator.getInstance(string), n2);
        return stringBuffer.toString();
    }

    private static final class Values {
        boolean isIndex;
        int value;
        int type;

        private Values() {
        }

        public void reset() {
            this.isIndex = false;
            this.value = 0;
            this.type = -1;
        }
    }
}

