/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeReplacer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class StringMatcher
implements UnicodeMatcher,
UnicodeReplacer {
    private String pattern;
    private int matchStart;
    private int matchLimit;
    private int segmentNumber;
    private final RuleBasedTransliterator.Data data;

    public StringMatcher(String string, int n2, RuleBasedTransliterator.Data data) {
        this.data = data;
        this.pattern = string;
        this.matchLimit = -1;
        this.matchStart = -1;
        this.segmentNumber = n2;
    }

    public StringMatcher(String string, int n2, int n3, int n4, RuleBasedTransliterator.Data data) {
        this(string.substring(n2, n3), n4, data);
    }

    @Override
    public int matches(Replaceable replaceable, int[] nArray, int n2, boolean bl2) {
        int[] nArray2 = new int[]{nArray[0]};
        if (n2 < nArray2[0]) {
            for (int i2 = this.pattern.length() - 1; i2 >= 0; --i2) {
                char c2 = this.pattern.charAt(i2);
                UnicodeMatcher unicodeMatcher = this.data.lookupMatcher(c2);
                if (unicodeMatcher == null) {
                    if (nArray2[0] > n2 && c2 == replaceable.charAt(nArray2[0])) {
                        nArray2[0] = nArray2[0] - 1;
                        continue;
                    }
                    return 0;
                }
                int n3 = unicodeMatcher.matches(replaceable, nArray2, n2, bl2);
                if (n3 == 2) continue;
                return n3;
            }
            if (this.matchStart < 0) {
                this.matchStart = nArray2[0] + 1;
                this.matchLimit = nArray[0] + 1;
            }
        } else {
            for (int i3 = 0; i3 < this.pattern.length(); ++i3) {
                if (bl2 && nArray2[0] == n2) {
                    return 1;
                }
                char c3 = this.pattern.charAt(i3);
                UnicodeMatcher unicodeMatcher = this.data.lookupMatcher(c3);
                if (unicodeMatcher == null) {
                    if (nArray2[0] < n2 && c3 == replaceable.charAt(nArray2[0])) {
                        nArray2[0] = nArray2[0] + 1;
                        continue;
                    }
                    return 0;
                }
                int n4 = unicodeMatcher.matches(replaceable, nArray2, n2, bl2);
                if (n4 == 2) continue;
                return n4;
            }
            this.matchStart = nArray[0];
            this.matchLimit = nArray2[0];
        }
        nArray[0] = nArray2[0];
        return 2;
    }

    @Override
    public String toPattern(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.segmentNumber > 0) {
            stringBuffer.append('(');
        }
        for (int i2 = 0; i2 < this.pattern.length(); ++i2) {
            char c2 = this.pattern.charAt(i2);
            UnicodeMatcher unicodeMatcher = this.data.lookupMatcher(c2);
            if (unicodeMatcher == null) {
                Utility.appendToRule(stringBuffer, c2, false, bl2, stringBuffer2);
                continue;
            }
            Utility.appendToRule(stringBuffer, unicodeMatcher.toPattern(bl2), true, bl2, stringBuffer2);
        }
        if (this.segmentNumber > 0) {
            stringBuffer.append(')');
        }
        Utility.appendToRule(stringBuffer, -1, true, bl2, stringBuffer2);
        return stringBuffer.toString();
    }

    @Override
    public boolean matchesIndexValue(int n2) {
        if (this.pattern.length() == 0) {
            return true;
        }
        int n3 = UTF16.charAt(this.pattern, 0);
        UnicodeMatcher unicodeMatcher = this.data.lookupMatcher(n3);
        return unicodeMatcher == null ? (n3 & 0xFF) == n2 : unicodeMatcher.matchesIndexValue(n2);
    }

    @Override
    public void addMatchSetTo(UnicodeSet unicodeSet) {
        int n2;
        for (int i2 = 0; i2 < this.pattern.length(); i2 += UTF16.getCharCount(n2)) {
            n2 = UTF16.charAt(this.pattern, i2);
            UnicodeMatcher unicodeMatcher = this.data.lookupMatcher(n2);
            if (unicodeMatcher == null) {
                unicodeSet.add(n2);
                continue;
            }
            unicodeMatcher.addMatchSetTo(unicodeSet);
        }
    }

    @Override
    public int replace(Replaceable replaceable, int n2, int n3, int[] nArray) {
        int n4 = 0;
        int n5 = n3;
        if (this.matchStart >= 0 && this.matchStart != this.matchLimit) {
            replaceable.copy(this.matchStart, this.matchLimit, n5);
            n4 = this.matchLimit - this.matchStart;
        }
        replaceable.replace(n2, n3, "");
        return n4;
    }

    @Override
    public String toReplacerPattern(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("$");
        Utility.appendNumber(stringBuffer, this.segmentNumber, 10, 1);
        return stringBuffer.toString();
    }

    public void resetMatch() {
        this.matchLimit = -1;
        this.matchStart = -1;
    }

    @Override
    public void addReplacementSetTo(UnicodeSet unicodeSet) {
    }
}

