/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.MessagePattern;

public class SelectFormat
extends Format {
    private static final long serialVersionUID = 2993154333257524984L;
    private String pattern = null;
    private transient MessagePattern msgPattern;

    public SelectFormat(String string) {
        this.applyPattern(string);
    }

    private void reset() {
        this.pattern = null;
        if (this.msgPattern != null) {
            this.msgPattern.clear();
        }
    }

    public void applyPattern(String string) {
        this.pattern = string;
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern();
        }
        try {
            this.msgPattern.parseSelectStyle(string);
        }
        catch (RuntimeException runtimeException) {
            this.reset();
            throw runtimeException;
        }
    }

    public String toPattern() {
        return this.pattern;
    }

    static int findSubMessage(MessagePattern messagePattern, int n2, String string) {
        MessagePattern.Part part;
        MessagePattern.Part.Type type;
        int n3 = messagePattern.countParts();
        int n4 = 0;
        while ((type = (part = messagePattern.getPart(n2++)).getType()) != MessagePattern.Part.Type.ARG_LIMIT) {
            assert (type == MessagePattern.Part.Type.ARG_SELECTOR);
            if (messagePattern.partSubstringMatches(part, string)) {
                return n2;
            }
            if (n4 == 0 && messagePattern.partSubstringMatches(part, "other")) {
                n4 = n2;
            }
            n2 = messagePattern.getLimitPartIndex(n2);
            if (++n2 < n3) continue;
        }
        return n4;
    }

    public final String format(String string) {
        if (!PatternProps.isIdentifier(string)) {
            throw new IllegalArgumentException("Invalid formatting argument.");
        }
        if (this.msgPattern == null || this.msgPattern.countParts() == 0) {
            throw new IllegalStateException("Invalid format error.");
        }
        int n2 = SelectFormat.findSubMessage(this.msgPattern, 0, string);
        if (!this.msgPattern.jdkAposMode()) {
            int n3 = this.msgPattern.getLimitPartIndex(n2);
            return this.msgPattern.getPatternString().substring(this.msgPattern.getPart(n2).getLimit(), this.msgPattern.getPatternIndex(n3));
        }
        StringBuilder stringBuilder = null;
        int n4 = this.msgPattern.getPart(n2).getLimit();
        int n5 = n2;
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(++n5);
            MessagePattern.Part.Type type = part.getType();
            int n6 = part.getIndex();
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                if (stringBuilder == null) {
                    return this.pattern.substring(n4, n6);
                }
                return stringBuilder.append(this.pattern, n4, n6).toString();
            }
            if (type == MessagePattern.Part.Type.SKIP_SYNTAX) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(this.pattern, n4, n6);
                n4 = part.getLimit();
                continue;
            }
            if (type != MessagePattern.Part.Type.ARG_START) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(this.pattern, n4, n6);
            n4 = n6;
            n5 = this.msgPattern.getLimitPartIndex(n5);
            n6 = this.msgPattern.getPart(n5).getLimit();
            MessagePattern.appendReducedApostrophes(this.pattern, n4, n6, stringBuilder);
            n4 = n6;
        }
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("'" + object + "' is not a String");
        }
        stringBuffer.append(this.format((String)object));
        return stringBuffer;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SelectFormat selectFormat = (SelectFormat)object;
        return this.msgPattern == null ? selectFormat.msgPattern == null : this.msgPattern.equals(selectFormat.msgPattern);
    }

    public int hashCode() {
        if (this.pattern != null) {
            return this.pattern.hashCode();
        }
        return 0;
    }

    public String toString() {
        return "pattern='" + this.pattern + "'";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.pattern != null) {
            this.applyPattern(this.pattern);
        }
    }
}

