/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.FieldPosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SimpleFormatter;

class QuantityFormatter {
    private final SimpleFormatter[] templates = new SimpleFormatter[StandardPlural.COUNT];

    public void addIfAbsent(CharSequence charSequence, String string) {
        int n2 = StandardPlural.indexFromString(charSequence);
        if (this.templates[n2] != null) {
            return;
        }
        this.templates[n2] = SimpleFormatter.compileMinMaxArguments(string, 0, 1);
    }

    public boolean isValid() {
        return this.templates[StandardPlural.OTHER_INDEX] != null;
    }

    public String format(double d2, NumberFormat numberFormat, PluralRules pluralRules) {
        String string = numberFormat.format(d2);
        StandardPlural standardPlural = QuantityFormatter.selectPlural(d2, numberFormat, pluralRules);
        SimpleFormatter simpleFormatter = this.templates[standardPlural.ordinal()];
        if (simpleFormatter == null) {
            simpleFormatter = this.templates[StandardPlural.OTHER_INDEX];
            assert (simpleFormatter != null);
        }
        return simpleFormatter.format(string);
    }

    public SimpleFormatter getByVariant(CharSequence charSequence) {
        assert (this.isValid());
        int n2 = StandardPlural.indexOrOtherIndexFromString(charSequence);
        SimpleFormatter simpleFormatter = this.templates[n2];
        return simpleFormatter == null && n2 != StandardPlural.OTHER_INDEX ? this.templates[StandardPlural.OTHER_INDEX] : simpleFormatter;
    }

    public static StandardPlural selectPlural(double d2, NumberFormat numberFormat, PluralRules pluralRules) {
        String string = numberFormat instanceof DecimalFormat ? pluralRules.select(((DecimalFormat)numberFormat).getFixedDecimal(d2)) : pluralRules.select(d2);
        return StandardPlural.orOtherFromString(string);
    }

    public static StringBuilder format(String string, CharSequence charSequence, StringBuilder stringBuilder, FieldPosition fieldPosition) {
        int[] nArray = new int[1];
        SimpleFormatterImpl.formatAndAppend(string, stringBuilder, nArray, charSequence);
        if (fieldPosition.getBeginIndex() != 0 || fieldPosition.getEndIndex() != 0) {
            if (nArray[0] >= 0) {
                fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + nArray[0]);
                fieldPosition.setEndIndex(fieldPosition.getEndIndex() + nArray[0]);
            } else {
                fieldPosition.setBeginIndex(0);
                fieldPosition.setEndIndex(0);
            }
        }
        return stringBuilder;
    }
}

