/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICULocaleService;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUService;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

class NumberFormatServiceShim
extends NumberFormat.NumberFormatShim {
    private static ICULocaleService service = new NFService();

    NumberFormatServiceShim() {
    }

    @Override
    Locale[] getAvailableLocales() {
        if (service.isDefault()) {
            return ICUResourceBundle.getAvailableLocales();
        }
        return service.getAvailableLocales();
    }

    @Override
    ULocale[] getAvailableULocales() {
        if (service.isDefault()) {
            return ICUResourceBundle.getAvailableULocales();
        }
        return service.getAvailableULocales();
    }

    @Override
    Object registerFactory(NumberFormat.NumberFormatFactory numberFormatFactory) {
        return service.registerFactory(new NFFactory(numberFormatFactory));
    }

    @Override
    boolean unregister(Object object) {
        return service.unregisterFactory((ICUService.Factory)object);
    }

    @Override
    NumberFormat createInstance(ULocale uLocale, int n2) {
        ULocale[] uLocaleArray = new ULocale[1];
        NumberFormat numberFormat = (NumberFormat)service.get(uLocale, n2, uLocaleArray);
        if (numberFormat == null) {
            throw new MissingResourceException("Unable to construct NumberFormat", "", "");
        }
        numberFormat = (NumberFormat)numberFormat.clone();
        if (n2 == 1 || n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8 || n2 == 9) {
            numberFormat.setCurrency(Currency.getInstance(uLocale));
        }
        ULocale uLocale2 = uLocaleArray[0];
        numberFormat.setLocale(uLocale2, uLocale2);
        return numberFormat;
    }

    private static class NFService
    extends ICULocaleService {
        NFService() {
            super("NumberFormat");
            class RBNumberFormatFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                RBNumberFormatFactory() {
                }

                @Override
                protected Object handleCreate(ULocale uLocale, int n2, ICUService iCUService) {
                    return NumberFormat.createInstance(uLocale, n2);
                }
            }
            this.registerFactory(new RBNumberFormatFactory());
            this.markDefault();
        }
    }

    private static final class NFFactory
    extends ICULocaleService.LocaleKeyFactory {
        private NumberFormat.NumberFormatFactory delegate;

        NFFactory(NumberFormat.NumberFormatFactory numberFormatFactory) {
            super(numberFormatFactory.visible());
            this.delegate = numberFormatFactory;
        }

        @Override
        public Object create(ICUService.Key key, ICUService iCUService) {
            if (!this.handlesKey(key) || !(key instanceof ICULocaleService.LocaleKey)) {
                return null;
            }
            ICULocaleService.LocaleKey localeKey = (ICULocaleService.LocaleKey)key;
            Object object = this.delegate.createFormat(localeKey.canonicalLocale(), localeKey.kind());
            if (object == null) {
                object = iCUService.getKey(key, null, this);
            }
            return object;
        }

        @Override
        protected Set<String> getSupportedIDs() {
            return this.delegate.getSupportedLocaleNames();
        }
    }
}

