/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.nio.CharBuffer;
import java.text.CharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Norm2AllModes;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCaseProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.FilteredNormalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;

public final class Normalizer
implements Cloneable {
    private UCharacterIterator text;
    private Normalizer2 norm2;
    private Mode mode;
    private int options;
    private int currentIndex;
    private int nextIndex;
    private StringBuilder buffer;
    private int bufferPos;
    @Deprecated
    public static final int UNICODE_3_2 = 32;
    @Deprecated
    public static final int DONE = -1;
    @Deprecated
    public static final Mode NONE = new NONEMode();
    @Deprecated
    public static final Mode NFD = new NFDMode();
    @Deprecated
    public static final Mode NFKD = new NFKDMode();
    @Deprecated
    public static final Mode NFC;
    @Deprecated
    public static final Mode DEFAULT;
    @Deprecated
    public static final Mode NFKC;
    @Deprecated
    public static final Mode FCD;
    @Deprecated
    public static final Mode NO_OP;
    @Deprecated
    public static final Mode COMPOSE;
    @Deprecated
    public static final Mode COMPOSE_COMPAT;
    @Deprecated
    public static final Mode DECOMP;
    @Deprecated
    public static final Mode DECOMP_COMPAT;
    @Deprecated
    public static final int IGNORE_HANGUL = 1;
    public static final QuickCheckResult NO;
    public static final QuickCheckResult YES;
    public static final QuickCheckResult MAYBE;
    public static final int FOLD_CASE_DEFAULT = 0;
    public static final int INPUT_IS_FCD = 131072;
    public static final int COMPARE_IGNORE_CASE = 65536;
    public static final int COMPARE_CODE_POINT_ORDER = 32768;
    public static final int FOLD_CASE_EXCLUDE_SPECIAL_I = 1;
    @Deprecated
    public static final int COMPARE_NORM_OPTIONS_SHIFT = 20;
    private static final int COMPARE_EQUIV = 524288;

    @Deprecated
    public Normalizer(String string, Mode mode, int n2) {
        this.text = UCharacterIterator.getInstance(string);
        this.mode = mode;
        this.options = n2;
        this.norm2 = mode.getNormalizer2(n2);
        this.buffer = new StringBuilder();
    }

    @Deprecated
    public Normalizer(CharacterIterator characterIterator, Mode mode, int n2) {
        this.text = UCharacterIterator.getInstance((CharacterIterator)characterIterator.clone());
        this.mode = mode;
        this.options = n2;
        this.norm2 = mode.getNormalizer2(n2);
        this.buffer = new StringBuilder();
    }

    @Deprecated
    public Normalizer(UCharacterIterator uCharacterIterator, Mode mode, int n2) {
        try {
            this.text = (UCharacterIterator)uCharacterIterator.clone();
            this.mode = mode;
            this.options = n2;
            this.norm2 = mode.getNormalizer2(n2);
            this.buffer = new StringBuilder();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException(cloneNotSupportedException);
        }
    }

    @Deprecated
    public Object clone() {
        try {
            Normalizer normalizer = (Normalizer)super.clone();
            normalizer.text = (UCharacterIterator)this.text.clone();
            normalizer.mode = this.mode;
            normalizer.options = this.options;
            normalizer.norm2 = this.norm2;
            normalizer.buffer = new StringBuilder(this.buffer);
            normalizer.bufferPos = this.bufferPos;
            normalizer.currentIndex = this.currentIndex;
            normalizer.nextIndex = this.nextIndex;
            return normalizer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException(cloneNotSupportedException);
        }
    }

    private static final Normalizer2 getComposeNormalizer2(boolean bl2, int n2) {
        return (bl2 ? NFKC : NFC).getNormalizer2(n2);
    }

    private static final Normalizer2 getDecomposeNormalizer2(boolean bl2, int n2) {
        return (bl2 ? NFKD : NFD).getNormalizer2(n2);
    }

    @Deprecated
    public static String compose(String string, boolean bl2) {
        return Normalizer.compose(string, bl2, 0);
    }

    @Deprecated
    public static String compose(String string, boolean bl2, int n2) {
        return Normalizer.getComposeNormalizer2(bl2, n2).normalize(string);
    }

    @Deprecated
    public static int compose(char[] cArray, char[] cArray2, boolean bl2, int n2) {
        return Normalizer.compose(cArray, 0, cArray.length, cArray2, 0, cArray2.length, bl2, n2);
    }

    @Deprecated
    public static int compose(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, boolean bl2, int n6) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3 - n2);
        CharsAppendable charsAppendable = new CharsAppendable(cArray2, n4, n5);
        Normalizer.getComposeNormalizer2(bl2, n6).normalize((CharSequence)charBuffer, charsAppendable);
        return charsAppendable.length();
    }

    @Deprecated
    public static String decompose(String string, boolean bl2) {
        return Normalizer.decompose(string, bl2, 0);
    }

    @Deprecated
    public static String decompose(String string, boolean bl2, int n2) {
        return Normalizer.getDecomposeNormalizer2(bl2, n2).normalize(string);
    }

    @Deprecated
    public static int decompose(char[] cArray, char[] cArray2, boolean bl2, int n2) {
        return Normalizer.decompose(cArray, 0, cArray.length, cArray2, 0, cArray2.length, bl2, n2);
    }

    @Deprecated
    public static int decompose(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, boolean bl2, int n6) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3 - n2);
        CharsAppendable charsAppendable = new CharsAppendable(cArray2, n4, n5);
        Normalizer.getDecomposeNormalizer2(bl2, n6).normalize((CharSequence)charBuffer, charsAppendable);
        return charsAppendable.length();
    }

    @Deprecated
    public static String normalize(String string, Mode mode, int n2) {
        return mode.getNormalizer2(n2).normalize(string);
    }

    @Deprecated
    public static String normalize(String string, Mode mode) {
        return Normalizer.normalize(string, mode, 0);
    }

    @Deprecated
    public static int normalize(char[] cArray, char[] cArray2, Mode mode, int n2) {
        return Normalizer.normalize(cArray, 0, cArray.length, cArray2, 0, cArray2.length, mode, n2);
    }

    @Deprecated
    public static int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, Mode mode, int n6) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3 - n2);
        CharsAppendable charsAppendable = new CharsAppendable(cArray2, n4, n5);
        mode.getNormalizer2(n6).normalize((CharSequence)charBuffer, charsAppendable);
        return charsAppendable.length();
    }

    @Deprecated
    public static String normalize(int n2, Mode mode, int n3) {
        if (mode == NFD && n3 == 0) {
            String string = Normalizer2.getNFCInstance().getDecomposition(n2);
            if (string == null) {
                string = UTF16.valueOf(n2);
            }
            return string;
        }
        return Normalizer.normalize(UTF16.valueOf(n2), mode, n3);
    }

    @Deprecated
    public static String normalize(int n2, Mode mode) {
        return Normalizer.normalize(n2, mode, 0);
    }

    @Deprecated
    public static QuickCheckResult quickCheck(String string, Mode mode) {
        return Normalizer.quickCheck(string, mode, 0);
    }

    @Deprecated
    public static QuickCheckResult quickCheck(String string, Mode mode, int n2) {
        return mode.getNormalizer2(n2).quickCheck(string);
    }

    @Deprecated
    public static QuickCheckResult quickCheck(char[] cArray, Mode mode, int n2) {
        return Normalizer.quickCheck(cArray, 0, cArray.length, mode, n2);
    }

    @Deprecated
    public static QuickCheckResult quickCheck(char[] cArray, int n2, int n3, Mode mode, int n4) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3 - n2);
        return mode.getNormalizer2(n4).quickCheck(charBuffer);
    }

    @Deprecated
    public static boolean isNormalized(char[] cArray, int n2, int n3, Mode mode, int n4) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3 - n2);
        return mode.getNormalizer2(n4).isNormalized(charBuffer);
    }

    @Deprecated
    public static boolean isNormalized(String string, Mode mode, int n2) {
        return mode.getNormalizer2(n2).isNormalized(string);
    }

    @Deprecated
    public static boolean isNormalized(int n2, Mode mode, int n3) {
        return Normalizer.isNormalized(UTF16.valueOf(n2), mode, n3);
    }

    public static int compare(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
        if (cArray == null || n2 < 0 || n3 < 0 || cArray2 == null || n4 < 0 || n5 < 0 || n3 < n2 || n5 < n4) {
            throw new IllegalArgumentException();
        }
        return Normalizer.internalCompare(CharBuffer.wrap(cArray, n2, n3 - n2), CharBuffer.wrap(cArray2, n4, n5 - n4), n6);
    }

    public static int compare(String string, String string2, int n2) {
        return Normalizer.internalCompare(string, string2, n2);
    }

    public static int compare(char[] cArray, char[] cArray2, int n2) {
        return Normalizer.internalCompare(CharBuffer.wrap(cArray), CharBuffer.wrap(cArray2), n2);
    }

    public static int compare(int n2, int n3, int n4) {
        return Normalizer.internalCompare(UTF16.valueOf(n2), UTF16.valueOf(n3), n4 | 0x20000);
    }

    public static int compare(int n2, String string, int n3) {
        return Normalizer.internalCompare(UTF16.valueOf(n2), string, n3);
    }

    @Deprecated
    public static int concatenate(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, char[] cArray3, int n6, int n7, Mode mode, int n8) {
        if (cArray3 == null) {
            throw new IllegalArgumentException();
        }
        if (cArray2 == cArray3 && n4 < n7 && n6 < n5) {
            throw new IllegalArgumentException("overlapping right and dst ranges");
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2 + n5 - n4 + 16);
        stringBuilder.append(cArray, n2, n3 - n2);
        CharBuffer charBuffer = CharBuffer.wrap(cArray2, n4, n5 - n4);
        mode.getNormalizer2(n8).append(stringBuilder, charBuffer);
        int n9 = stringBuilder.length();
        if (n9 <= n7 - n6) {
            stringBuilder.getChars(0, n9, cArray3, n6);
            return n9;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n9));
    }

    @Deprecated
    public static String concatenate(char[] cArray, char[] cArray2, Mode mode, int n2) {
        StringBuilder stringBuilder = new StringBuilder(cArray.length + cArray2.length + 16).append(cArray);
        return mode.getNormalizer2(n2).append(stringBuilder, CharBuffer.wrap(cArray2)).toString();
    }

    @Deprecated
    public static String concatenate(String string, String string2, Mode mode, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 16).append(string);
        return mode.getNormalizer2(n2).append(stringBuilder, string2).toString();
    }

    @Deprecated
    public static int getFC_NFKC_Closure(int n2, char[] cArray) {
        String string = Normalizer.getFC_NFKC_Closure(n2);
        int n3 = string.length();
        if (n3 != 0 && cArray != null && n3 <= cArray.length) {
            string.getChars(0, n3, cArray, 0);
        }
        return n3;
    }

    @Deprecated
    public static String getFC_NFKC_Closure(int n2) {
        Object object;
        Normalizer2 normalizer2 = NFKCModeImpl.INSTANCE.normalizer2;
        UCaseProps uCaseProps = UCaseProps.INSTANCE;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = uCaseProps.toFullFolding(n2, stringBuilder, 0);
        if (n3 < 0) {
            object = ((Norm2AllModes.Normalizer2WithImpl)normalizer2).impl;
            if (((Normalizer2Impl)object).getCompQuickCheck(((Normalizer2Impl)object).getNorm16(n2)) != 0) {
                return "";
            }
            stringBuilder.appendCodePoint(n2);
        } else if (n3 > 31) {
            stringBuilder.appendCodePoint(n3);
        }
        object = normalizer2.normalize(stringBuilder);
        String string = normalizer2.normalize(UCharacter.foldCase((String)object, 0));
        if (((String)object).equals(string)) {
            return "";
        }
        return string;
    }

    @Deprecated
    public int current() {
        if (this.bufferPos < this.buffer.length() || this.nextNormalize()) {
            return this.buffer.codePointAt(this.bufferPos);
        }
        return -1;
    }

    @Deprecated
    public int next() {
        if (this.bufferPos < this.buffer.length() || this.nextNormalize()) {
            int n2 = this.buffer.codePointAt(this.bufferPos);
            this.bufferPos += Character.charCount(n2);
            return n2;
        }
        return -1;
    }

    @Deprecated
    public int previous() {
        if (this.bufferPos > 0 || this.previousNormalize()) {
            int n2 = this.buffer.codePointBefore(this.bufferPos);
            this.bufferPos -= Character.charCount(n2);
            return n2;
        }
        return -1;
    }

    @Deprecated
    public void reset() {
        this.text.setToStart();
        this.nextIndex = 0;
        this.currentIndex = 0;
        this.clearBuffer();
    }

    @Deprecated
    public void setIndexOnly(int n2) {
        this.text.setIndex(n2);
        this.currentIndex = this.nextIndex = n2;
        this.clearBuffer();
    }

    @Deprecated
    public int setIndex(int n2) {
        this.setIndexOnly(n2);
        return this.current();
    }

    @Deprecated
    public int getBeginIndex() {
        return 0;
    }

    @Deprecated
    public int getEndIndex() {
        return this.endIndex();
    }

    @Deprecated
    public int first() {
        this.reset();
        return this.next();
    }

    @Deprecated
    public int last() {
        this.text.setToLimit();
        this.currentIndex = this.nextIndex = this.text.getIndex();
        this.clearBuffer();
        return this.previous();
    }

    @Deprecated
    public int getIndex() {
        if (this.bufferPos < this.buffer.length()) {
            return this.currentIndex;
        }
        return this.nextIndex;
    }

    @Deprecated
    public int startIndex() {
        return 0;
    }

    @Deprecated
    public int endIndex() {
        return this.text.getLength();
    }

    @Deprecated
    public void setMode(Mode mode) {
        this.mode = mode;
        this.norm2 = this.mode.getNormalizer2(this.options);
    }

    @Deprecated
    public Mode getMode() {
        return this.mode;
    }

    @Deprecated
    public void setOption(int n2, boolean bl2) {
        this.options = bl2 ? (this.options |= n2) : (this.options &= ~n2);
        this.norm2 = this.mode.getNormalizer2(this.options);
    }

    @Deprecated
    public int getOption(int n2) {
        if ((this.options & n2) != 0) {
            return 1;
        }
        return 0;
    }

    @Deprecated
    public int getText(char[] cArray) {
        return this.text.getText(cArray);
    }

    @Deprecated
    public int getLength() {
        return this.text.getLength();
    }

    @Deprecated
    public String getText() {
        return this.text.getText();
    }

    @Deprecated
    public void setText(StringBuffer stringBuffer) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(stringBuffer);
        if (uCharacterIterator == null) {
            throw new IllegalStateException("Could not create a new UCharacterIterator");
        }
        this.text = uCharacterIterator;
        this.reset();
    }

    @Deprecated
    public void setText(char[] cArray) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(cArray);
        if (uCharacterIterator == null) {
            throw new IllegalStateException("Could not create a new UCharacterIterator");
        }
        this.text = uCharacterIterator;
        this.reset();
    }

    @Deprecated
    public void setText(String string) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(string);
        if (uCharacterIterator == null) {
            throw new IllegalStateException("Could not create a new UCharacterIterator");
        }
        this.text = uCharacterIterator;
        this.reset();
    }

    @Deprecated
    public void setText(CharacterIterator characterIterator) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance(characterIterator);
        if (uCharacterIterator == null) {
            throw new IllegalStateException("Could not create a new UCharacterIterator");
        }
        this.text = uCharacterIterator;
        this.reset();
    }

    @Deprecated
    public void setText(UCharacterIterator uCharacterIterator) {
        try {
            UCharacterIterator uCharacterIterator2 = (UCharacterIterator)uCharacterIterator.clone();
            if (uCharacterIterator2 == null) {
                throw new IllegalStateException("Could not create a new UCharacterIterator");
            }
            this.text = uCharacterIterator2;
            this.reset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException("Could not clone the UCharacterIterator", cloneNotSupportedException);
        }
    }

    private void clearBuffer() {
        this.buffer.setLength(0);
        this.bufferPos = 0;
    }

    private boolean nextNormalize() {
        this.clearBuffer();
        this.currentIndex = this.nextIndex;
        this.text.setIndex(this.nextIndex);
        int n2 = this.text.nextCodePoint();
        if (n2 < 0) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder().appendCodePoint(n2);
        while ((n2 = this.text.nextCodePoint()) >= 0) {
            if (this.norm2.hasBoundaryBefore(n2)) {
                this.text.moveCodePointIndex(-1);
                break;
            }
            stringBuilder.appendCodePoint(n2);
        }
        this.nextIndex = this.text.getIndex();
        this.norm2.normalize((CharSequence)stringBuilder, this.buffer);
        return this.buffer.length() != 0;
    }

    private boolean previousNormalize() {
        int n2;
        this.clearBuffer();
        this.nextIndex = this.currentIndex;
        this.text.setIndex(this.currentIndex);
        StringBuilder stringBuilder = new StringBuilder();
        while ((n2 = this.text.previousCodePoint()) >= 0) {
            if (n2 <= 65535) {
                stringBuilder.insert(0, (char)n2);
            } else {
                stringBuilder.insert(0, Character.toChars(n2));
            }
            if (!this.norm2.hasBoundaryBefore(n2)) continue;
        }
        this.currentIndex = this.text.getIndex();
        this.norm2.normalize((CharSequence)stringBuilder, this.buffer);
        this.bufferPos = this.buffer.length();
        return this.buffer.length() != 0;
    }

    private static int internalCompare(CharSequence charSequence, CharSequence charSequence2, int n2) {
        int n3 = n2 >>> 20;
        if (((n2 |= 0x80000) & 0x20000) == 0 || (n2 & 1) != 0) {
            StringBuilder stringBuilder;
            Normalizer2 normalizer2 = (n2 & 1) != 0 ? NFD.getNormalizer2(n3) : FCD.getNormalizer2(n3);
            int n4 = normalizer2.spanQuickCheckYes(charSequence);
            int n5 = normalizer2.spanQuickCheckYes(charSequence2);
            if (n4 < charSequence.length()) {
                stringBuilder = new StringBuilder(charSequence.length() + 16).append(charSequence, 0, n4);
                charSequence = normalizer2.normalizeSecondAndAppend(stringBuilder, charSequence.subSequence(n4, charSequence.length()));
            }
            if (n5 < charSequence2.length()) {
                stringBuilder = new StringBuilder(charSequence2.length() + 16).append(charSequence2, 0, n5);
                charSequence2 = normalizer2.normalizeSecondAndAppend(stringBuilder, charSequence2.subSequence(n5, charSequence2.length()));
            }
        }
        return Normalizer.cmpEquivFold(charSequence, charSequence2, n2);
    }

    private static final CmpEquivLevel[] createCmpEquivLevelStack() {
        return new CmpEquivLevel[]{new CmpEquivLevel(), new CmpEquivLevel()};
    }

    static int cmpEquivFold(CharSequence charSequence, CharSequence charSequence2, int n2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        UCaseProps uCaseProps;
        CmpEquivLevel[] cmpEquivLevelArray = null;
        CmpEquivLevel[] cmpEquivLevelArray2 = null;
        Normalizer2Impl normalizer2Impl = (n2 & 0x80000) != 0 ? Norm2AllModes.getNFCInstance().impl : null;
        if ((n2 & 0x10000) != 0) {
            uCaseProps = UCaseProps.INSTANCE;
            stringBuilder2 = new StringBuilder();
            stringBuilder = new StringBuilder();
        } else {
            uCaseProps = null;
            stringBuilder = null;
            stringBuilder2 = null;
        }
        int n3 = 0;
        int n4 = charSequence.length();
        int n5 = 0;
        int n6 = charSequence2.length();
        int n7 = 0;
        int n8 = 0;
        int n9 = -1;
        int n10 = -1;
        while (true) {
            String string;
            String string2;
            int n11;
            char c2;
            if (n10 < 0) {
                while (true) {
                    if (n3 == n4) {
                        if (n8 == 0) {
                            n10 = -1;
                            break;
                        }
                    } else {
                        n10 = charSequence.charAt(n3++);
                        break;
                    }
                    while ((charSequence = cmpEquivLevelArray[--n8].cs) == null) {
                    }
                    n3 = cmpEquivLevelArray[n8].s;
                    n4 = charSequence.length();
                }
            }
            if (n9 < 0) {
                while (true) {
                    if (n5 == n6) {
                        if (n7 == 0) {
                            n9 = -1;
                            break;
                        }
                    } else {
                        n9 = charSequence2.charAt(n5++);
                        break;
                    }
                    while ((charSequence2 = cmpEquivLevelArray2[--n7].cs) == null) {
                    }
                    n5 = cmpEquivLevelArray2[n7].s;
                    n6 = charSequence2.length();
                }
            }
            if (n10 == n9) {
                if (n10 < 0) {
                    return 0;
                }
                n9 = -1;
                n10 = -1;
                continue;
            }
            if (n10 < 0) {
                return -1;
            }
            if (n9 < 0) {
                return 1;
            }
            int n12 = n10;
            if (UTF16.isSurrogate(n10)) {
                if (Normalizer2Impl.UTF16Plus.isSurrogateLead(n10)) {
                    if (n3 != n4 && Character.isLowSurrogate(c2 = charSequence.charAt(n3))) {
                        n12 = Character.toCodePoint((char)n10, c2);
                    }
                } else if (0 <= n3 - 2 && Character.isHighSurrogate(c2 = charSequence.charAt(n3 - 2))) {
                    n12 = Character.toCodePoint(c2, (char)n10);
                }
            }
            int n13 = n9;
            if (UTF16.isSurrogate(n9)) {
                if (Normalizer2Impl.UTF16Plus.isSurrogateLead(n9)) {
                    if (n5 != n6 && Character.isLowSurrogate(c2 = charSequence2.charAt(n5))) {
                        n13 = Character.toCodePoint((char)n9, c2);
                    }
                } else if (0 <= n5 - 2 && Character.isHighSurrogate(c2 = charSequence2.charAt(n5 - 2))) {
                    n13 = Character.toCodePoint(c2, (char)n9);
                }
            }
            if (n8 == 0 && (n2 & 0x10000) != 0 && (n11 = uCaseProps.toFullFolding(n12, stringBuilder2, n2)) >= 0) {
                if (UTF16.isSurrogate(n10)) {
                    if (Normalizer2Impl.UTF16Plus.isSurrogateLead(n10)) {
                        ++n3;
                    } else {
                        n9 = charSequence2.charAt(--n5 - 1);
                    }
                }
                if (cmpEquivLevelArray == null) {
                    cmpEquivLevelArray = Normalizer.createCmpEquivLevelStack();
                }
                cmpEquivLevelArray[0].cs = charSequence;
                cmpEquivLevelArray[0].s = n3;
                ++n8;
                if (n11 <= 31) {
                    stringBuilder2.delete(0, stringBuilder2.length() - n11);
                } else {
                    stringBuilder2.setLength(0);
                    stringBuilder2.appendCodePoint(n11);
                }
                charSequence = stringBuilder2;
                n3 = 0;
                n4 = stringBuilder2.length();
                n10 = -1;
                continue;
            }
            if (n7 == 0 && (n2 & 0x10000) != 0 && (n11 = uCaseProps.toFullFolding(n13, stringBuilder, n2)) >= 0) {
                if (UTF16.isSurrogate(n9)) {
                    if (Normalizer2Impl.UTF16Plus.isSurrogateLead(n9)) {
                        ++n5;
                    } else {
                        n10 = charSequence.charAt(--n3 - 1);
                    }
                }
                if (cmpEquivLevelArray2 == null) {
                    cmpEquivLevelArray2 = Normalizer.createCmpEquivLevelStack();
                }
                cmpEquivLevelArray2[0].cs = charSequence2;
                cmpEquivLevelArray2[0].s = n5;
                ++n7;
                if (n11 <= 31) {
                    stringBuilder.delete(0, stringBuilder.length() - n11);
                } else {
                    stringBuilder.setLength(0);
                    stringBuilder.appendCodePoint(n11);
                }
                charSequence2 = stringBuilder;
                n5 = 0;
                n6 = stringBuilder.length();
                n9 = -1;
                continue;
            }
            if (n8 < 2 && (n2 & 0x80000) != 0 && (string2 = normalizer2Impl.getDecomposition(n12)) != null) {
                if (UTF16.isSurrogate(n10)) {
                    if (Normalizer2Impl.UTF16Plus.isSurrogateLead(n10)) {
                        ++n3;
                    } else {
                        n9 = charSequence2.charAt(--n5 - 1);
                    }
                }
                if (cmpEquivLevelArray == null) {
                    cmpEquivLevelArray = Normalizer.createCmpEquivLevelStack();
                }
                cmpEquivLevelArray[n8].cs = charSequence;
                cmpEquivLevelArray[n8].s = n3;
                if (++n8 < 2) {
                    cmpEquivLevelArray[n8++].cs = null;
                }
                charSequence = string2;
                n3 = 0;
                n4 = string2.length();
                n10 = -1;
                continue;
            }
            if (n7 >= 2 || (n2 & 0x80000) == 0 || (string = normalizer2Impl.getDecomposition(n13)) == null) break;
            if (UTF16.isSurrogate(n9)) {
                if (Normalizer2Impl.UTF16Plus.isSurrogateLead(n9)) {
                    ++n5;
                } else {
                    n10 = charSequence.charAt(--n3 - 1);
                }
            }
            if (cmpEquivLevelArray2 == null) {
                cmpEquivLevelArray2 = Normalizer.createCmpEquivLevelStack();
            }
            cmpEquivLevelArray2[n7].cs = charSequence2;
            cmpEquivLevelArray2[n7].s = n5;
            if (++n7 < 2) {
                cmpEquivLevelArray2[n7++].cs = null;
            }
            charSequence2 = string;
            n5 = 0;
            n6 = string.length();
            n9 = -1;
        }
        if (n10 >= 55296 && n9 >= 55296 && (n2 & 0x8000) != 0) {
            if (!(n10 <= 56319 && n3 != n4 && Character.isLowSurrogate(charSequence.charAt(n3)) || Character.isLowSurrogate((char)n10) && 0 != n3 - 1 && Character.isHighSurrogate(charSequence.charAt(n3 - 2)))) {
                n10 -= 10240;
            }
            if (!(n9 <= 56319 && n5 != n6 && Character.isLowSurrogate(charSequence2.charAt(n5)) || Character.isLowSurrogate((char)n9) && 0 != n5 - 1 && Character.isHighSurrogate(charSequence2.charAt(n5 - 2)))) {
                n9 -= 10240;
            }
        }
        return n10 - n9;
    }

    static {
        DEFAULT = NFC = new NFCMode();
        NFKC = new NFKCMode();
        FCD = new FCDMode();
        NO_OP = NONE;
        COMPOSE = NFC;
        COMPOSE_COMPAT = NFKC;
        DECOMP = NFD;
        DECOMP_COMPAT = NFKD;
        NO = new QuickCheckResult(0);
        YES = new QuickCheckResult(1);
        MAYBE = new QuickCheckResult(2);
    }

    private static final class CharsAppendable
    implements Appendable {
        private final char[] chars;
        private final int start;
        private final int limit;
        private int offset;

        public CharsAppendable(char[] cArray, int n2, int n3) {
            this.chars = cArray;
            this.start = this.offset = n2;
            this.limit = n3;
        }

        public int length() {
            int n2 = this.offset - this.start;
            if (this.offset <= this.limit) {
                return n2;
            }
            throw new IndexOutOfBoundsException(Integer.toString(n2));
        }

        @Override
        public Appendable append(char c2) {
            if (this.offset < this.limit) {
                this.chars[this.offset] = c2;
            }
            ++this.offset;
            return this;
        }

        @Override
        public Appendable append(CharSequence charSequence) {
            return this.append(charSequence, 0, charSequence.length());
        }

        @Override
        public Appendable append(CharSequence charSequence, int n2, int n3) {
            int n4 = n3 - n2;
            if (n4 <= this.limit - this.offset) {
                while (n2 < n3) {
                    this.chars[this.offset++] = charSequence.charAt(n2++);
                }
            } else {
                this.offset += n4;
            }
            return this;
        }
    }

    private static final class CmpEquivLevel {
        CharSequence cs;
        int s;

        private CmpEquivLevel() {
        }
    }

    public static final class QuickCheckResult {
        private QuickCheckResult(int n2) {
        }
    }

    private static final class FCDMode
    extends Mode {
        private FCDMode() {
        }

        @Override
        protected Normalizer2 getNormalizer2(int n2) {
            return (n2 & 0x20) != 0 ? FCD32ModeImpl.INSTANCE.normalizer2 : FCDModeImpl.INSTANCE.normalizer2;
        }
    }

    private static final class NFKCMode
    extends Mode {
        private NFKCMode() {
        }

        @Override
        protected Normalizer2 getNormalizer2(int n2) {
            return (n2 & 0x20) != 0 ? NFKC32ModeImpl.INSTANCE.normalizer2 : NFKCModeImpl.INSTANCE.normalizer2;
        }
    }

    private static final class NFCMode
    extends Mode {
        private NFCMode() {
        }

        @Override
        protected Normalizer2 getNormalizer2(int n2) {
            return (n2 & 0x20) != 0 ? NFC32ModeImpl.INSTANCE.normalizer2 : NFCModeImpl.INSTANCE.normalizer2;
        }
    }

    private static final class NFKDMode
    extends Mode {
        private NFKDMode() {
        }

        @Override
        protected Normalizer2 getNormalizer2(int n2) {
            return (n2 & 0x20) != 0 ? NFKD32ModeImpl.INSTANCE.normalizer2 : NFKDModeImpl.INSTANCE.normalizer2;
        }
    }

    private static final class NFDMode
    extends Mode {
        private NFDMode() {
        }

        @Override
        protected Normalizer2 getNormalizer2(int n2) {
            return (n2 & 0x20) != 0 ? NFD32ModeImpl.INSTANCE.normalizer2 : NFDModeImpl.INSTANCE.normalizer2;
        }
    }

    private static final class NONEMode
    extends Mode {
        private NONEMode() {
        }

        @Override
        protected Normalizer2 getNormalizer2(int n2) {
            return Norm2AllModes.NOOP_NORMALIZER2;
        }
    }

    @Deprecated
    public static abstract class Mode {
        @Deprecated
        protected Mode() {
        }

        @Deprecated
        protected abstract Normalizer2 getNormalizer2(int var1);
    }

    private static final class FCD32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Norm2AllModes.getFCDNormalizer2(), Unicode32.access$100()));

        private FCD32ModeImpl() {
        }
    }

    private static final class NFKC32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Normalizer2.getNFKCInstance(), Unicode32.access$100()));

        private NFKC32ModeImpl() {
        }
    }

    private static final class NFC32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Normalizer2.getNFCInstance(), Unicode32.access$100()));

        private NFC32ModeImpl() {
        }
    }

    private static final class NFKD32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Normalizer2.getNFKDInstance(), Unicode32.access$100()));

        private NFKD32ModeImpl() {
        }
    }

    private static final class NFD32ModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(new FilteredNormalizer2(Normalizer2.getNFDInstance(), Unicode32.access$100()));

        private NFD32ModeImpl() {
        }
    }

    private static final class Unicode32 {
        private static final UnicodeSet INSTANCE = new UnicodeSet("[:age=3.2:]").freeze();

        private Unicode32() {
        }

        static /* synthetic */ UnicodeSet access$100() {
            return INSTANCE;
        }
    }

    private static final class FCDModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Norm2AllModes.getFCDNormalizer2());

        private FCDModeImpl() {
        }
    }

    private static final class NFKCModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Normalizer2.getNFKCInstance());

        private NFKCModeImpl() {
        }
    }

    private static final class NFCModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Normalizer2.getNFCInstance());

        private NFCModeImpl() {
        }
    }

    private static final class NFKDModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Normalizer2.getNFKDInstance());

        private NFKDModeImpl() {
        }
    }

    private static final class NFDModeImpl {
        private static final ModeImpl INSTANCE = new ModeImpl(Normalizer2.getNFDInstance());

        private NFDModeImpl() {
        }
    }

    private static final class ModeImpl {
        private final Normalizer2 normalizer2;

        private ModeImpl(Normalizer2 normalizer2) {
            this.normalizer2 = normalizer2;
        }
    }
}

