/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.ParsePosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.AbsoluteValueSubstitution;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.FractionalPartSubstitution;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.IntegralPartSubstitution;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ModulusSubstitution;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.MultiplierSubstitution;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRuleSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumeratorSubstitution;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedNumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SameValueSubstitution;

abstract class NFSubstitution {
    final int pos;
    final NFRuleSet ruleSet;
    final DecimalFormat numberFormat;
    private static final long MAX_INT64_IN_DOUBLE = 0x1FFFFFFFFFFFFFL;

    public static NFSubstitution makeSubstitution(int n2, NFRule nFRule, NFRule nFRule2, NFRuleSet nFRuleSet, RuleBasedNumberFormat ruleBasedNumberFormat, String string) {
        if (string.length() == 0) {
            return null;
        }
        switch (string.charAt(0)) {
            case '<': {
                if (nFRule.getBaseValue() == -1L) {
                    throw new IllegalArgumentException("<< not allowed in negative-number rule");
                }
                if (nFRule.getBaseValue() == -2L || nFRule.getBaseValue() == -3L || nFRule.getBaseValue() == -4L) {
                    return new IntegralPartSubstitution(n2, nFRuleSet, string);
                }
                if (nFRuleSet.isFractionSet()) {
                    return new NumeratorSubstitution(n2, nFRule.getBaseValue(), ruleBasedNumberFormat.getDefaultRuleSet(), string);
                }
                return new MultiplierSubstitution(n2, nFRule, nFRuleSet, string);
            }
            case '>': {
                if (nFRule.getBaseValue() == -1L) {
                    return new AbsoluteValueSubstitution(n2, nFRuleSet, string);
                }
                if (nFRule.getBaseValue() == -2L || nFRule.getBaseValue() == -3L || nFRule.getBaseValue() == -4L) {
                    return new FractionalPartSubstitution(n2, nFRuleSet, string);
                }
                if (nFRuleSet.isFractionSet()) {
                    throw new IllegalArgumentException(">> not allowed in fraction rule set");
                }
                return new ModulusSubstitution(n2, nFRule, nFRule2, nFRuleSet, string);
            }
            case '=': {
                return new SameValueSubstitution(n2, nFRuleSet, string);
            }
        }
        throw new IllegalArgumentException("Illegal substitution character");
    }

    NFSubstitution(int n2, NFRuleSet nFRuleSet, String string) {
        this.pos = n2;
        int n3 = string.length();
        if (n3 >= 2 && string.charAt(0) == string.charAt(n3 - 1)) {
            string = string.substring(1, n3 - 1);
        } else if (n3 != 0) {
            throw new IllegalArgumentException("Illegal substitution syntax");
        }
        if (string.length() == 0) {
            this.ruleSet = nFRuleSet;
            this.numberFormat = null;
        } else if (string.charAt(0) == '%') {
            this.ruleSet = nFRuleSet.owner.findRuleSet(string);
            this.numberFormat = null;
        } else if (string.charAt(0) == '#' || string.charAt(0) == '0') {
            this.ruleSet = null;
            this.numberFormat = (DecimalFormat)nFRuleSet.owner.getDecimalFormat().clone();
            this.numberFormat.applyPattern(string);
        } else if (string.charAt(0) == '>') {
            this.ruleSet = nFRuleSet;
            this.numberFormat = null;
        } else {
            throw new IllegalArgumentException("Illegal substitution syntax");
        }
    }

    public void setDivisor(int n2, short s2) {
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() == object.getClass()) {
            NFSubstitution nFSubstitution = (NFSubstitution)object;
            return this.pos == nFSubstitution.pos && (this.ruleSet != null || nFSubstitution.ruleSet == null) && (this.numberFormat == null ? nFSubstitution.numberFormat == null : this.numberFormat.equals(nFSubstitution.numberFormat));
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        if (this.ruleSet != null) {
            return this.tokenChar() + this.ruleSet.getName() + this.tokenChar();
        }
        return this.tokenChar() + this.numberFormat.toPattern() + this.tokenChar();
    }

    public void doSubstitution(long l2, StringBuilder stringBuilder, int n2, int n3) {
        if (this.ruleSet != null) {
            long l3 = this.transformNumber(l2);
            this.ruleSet.format(l3, stringBuilder, n2 + this.pos, n3);
        } else if (l2 <= 0x1FFFFFFFFFFFFFL) {
            stringBuilder.insert(n2 + this.pos, this.numberFormat.format(this.transformNumber((double)l2)));
        } else {
            long l4 = this.transformNumber(l2);
            stringBuilder.insert(n2 + this.pos, this.numberFormat.format(l4));
        }
    }

    public void doSubstitution(double d2, StringBuilder stringBuilder, int n2, int n3) {
        double d3 = this.transformNumber(d2);
        if (Double.isInfinite(d3)) {
            NFRule nFRule = this.ruleSet.findRule(Double.POSITIVE_INFINITY);
            nFRule.doFormat(d3, stringBuilder, n2 + this.pos, n3);
            return;
        }
        if (d3 == Math.floor(d3) && this.ruleSet != null) {
            this.ruleSet.format((long)d3, stringBuilder, n2 + this.pos, n3);
        } else if (this.ruleSet != null) {
            this.ruleSet.format(d3, stringBuilder, n2 + this.pos, n3);
        } else {
            stringBuilder.insert(n2 + this.pos, this.numberFormat.format(d3));
        }
    }

    public abstract long transformNumber(long var1);

    public abstract double transformNumber(double var1);

    public Number doParse(String string, ParsePosition parsePosition, double d2, double d3, boolean bl2, int n2) {
        Number number;
        d3 = this.calcUpperBound(d3);
        if (this.ruleSet != null) {
            number = this.ruleSet.parse(string, parsePosition, d3, n2);
            if (bl2 && !this.ruleSet.isFractionSet() && parsePosition.getIndex() == 0) {
                number = this.ruleSet.owner.getDecimalFormat().parse(string, parsePosition);
            }
        } else {
            number = this.numberFormat.parse(string, parsePosition);
        }
        if (parsePosition.getIndex() != 0) {
            double d4 = number.doubleValue();
            if ((d4 = this.composeRuleValue(d4, d2)) == (double)((long)d4)) {
                return (long)d4;
            }
            return d4;
        }
        return number;
    }

    public abstract double composeRuleValue(double var1, double var3);

    public abstract double calcUpperBound(double var1);

    public final int getPos() {
        return this.pos;
    }

    abstract char tokenChar();

    public boolean isModulusSubstitution() {
        return false;
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        if (this.numberFormat != null) {
            this.numberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }
}

