/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ModulusSubstitution;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRuleSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFSubstitution;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RbnfLenientScanner;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedNumberFormat;

final class NFRule {
    static final int NEGATIVE_NUMBER_RULE = -1;
    static final int IMPROPER_FRACTION_RULE = -2;
    static final int PROPER_FRACTION_RULE = -3;
    static final int DEFAULT_RULE = -4;
    static final int INFINITY_RULE = -5;
    static final int NAN_RULE = -6;
    static final Long ZERO = 0L;
    private long baseValue;
    private int radix = 10;
    private short exponent = 0;
    private char decimalPoint = '\u0000';
    private String ruleText = null;
    private PluralFormat rulePatternFormat = null;
    private NFSubstitution sub1 = null;
    private NFSubstitution sub2 = null;
    final RuleBasedNumberFormat formatter;
    private static final String[] RULE_PREFIXES = new String[]{"<<", "<%", "<#", "<0", ">>", ">%", ">#", ">0", "=%", "=#", "=0"};

    public static void makeRules(String string, NFRuleSet nFRuleSet, NFRule nFRule, RuleBasedNumberFormat ruleBasedNumberFormat, List<NFRule> list) {
        int n2;
        NFRule nFRule2 = new NFRule(ruleBasedNumberFormat, string);
        string = nFRule2.ruleText;
        int n3 = string.indexOf(91);
        int n4 = n2 = n3 < 0 ? -1 : string.indexOf(93);
        if (n2 < 0 || n3 > n2 || nFRule2.baseValue == -3L || nFRule2.baseValue == -1L || nFRule2.baseValue == -5L || nFRule2.baseValue == -6L) {
            nFRule2.extractSubstitutions(nFRuleSet, string, nFRule);
        } else {
            NFRule nFRule3 = null;
            StringBuilder stringBuilder = new StringBuilder();
            if (nFRule2.baseValue > 0L && nFRule2.baseValue % NFRule.power(nFRule2.radix, nFRule2.exponent) == 0L || nFRule2.baseValue == -2L || nFRule2.baseValue == -4L) {
                nFRule3 = new NFRule(ruleBasedNumberFormat, null);
                if (nFRule2.baseValue >= 0L) {
                    nFRule3.baseValue = nFRule2.baseValue++;
                    if (!nFRuleSet.isFractionSet()) {
                        // empty if block
                    }
                } else if (nFRule2.baseValue == -2L) {
                    nFRule3.baseValue = -3L;
                } else if (nFRule2.baseValue == -4L) {
                    nFRule3.baseValue = nFRule2.baseValue;
                    nFRule2.baseValue = -2L;
                }
                nFRule3.radix = nFRule2.radix;
                nFRule3.exponent = nFRule2.exponent;
                stringBuilder.append(string.substring(0, n3));
                if (n2 + 1 < string.length()) {
                    stringBuilder.append(string.substring(n2 + 1));
                }
                nFRule3.extractSubstitutions(nFRuleSet, stringBuilder.toString(), nFRule);
            }
            stringBuilder.setLength(0);
            stringBuilder.append(string.substring(0, n3));
            stringBuilder.append(string.substring(n3 + 1, n2));
            if (n2 + 1 < string.length()) {
                stringBuilder.append(string.substring(n2 + 1));
            }
            nFRule2.extractSubstitutions(nFRuleSet, stringBuilder.toString(), nFRule);
            if (nFRule3 != null) {
                if (nFRule3.baseValue >= 0L) {
                    list.add(nFRule3);
                } else {
                    nFRuleSet.setNonNumericalRule(nFRule3);
                }
            }
        }
        if (nFRule2.baseValue >= 0L) {
            list.add(nFRule2);
        } else {
            nFRuleSet.setNonNumericalRule(nFRule2);
        }
    }

    public NFRule(RuleBasedNumberFormat ruleBasedNumberFormat, String string) {
        this.formatter = ruleBasedNumberFormat;
        this.ruleText = string == null ? null : this.parseRuleDescriptor(string);
    }

    private String parseRuleDescriptor(String string) {
        int n2 = string.indexOf(":");
        if (n2 != -1) {
            String string2 = string.substring(0, n2);
            ++n2;
            while (n2 < string.length() && PatternProps.isWhiteSpace(string.charAt(n2))) {
                ++n2;
            }
            string = string.substring(n2);
            int n3 = string2.length();
            char c2 = string2.charAt(0);
            char c3 = string2.charAt(n3 - 1);
            if (c2 >= '0' && c2 <= '9' && c3 != 'x') {
                long l2 = 0L;
                char c4 = '\u0000';
                for (n2 = 0; n2 < n3; ++n2) {
                    c4 = string2.charAt(n2);
                    if (c4 >= '0' && c4 <= '9') {
                        l2 = l2 * 10L + (long)(c4 - 48);
                        continue;
                    }
                    if (c4 == '/' || c4 == '>') break;
                    if (PatternProps.isWhiteSpace(c4) || c4 == ',' || c4 == '.') continue;
                    throw new IllegalArgumentException("Illegal character " + c4 + " in rule descriptor");
                }
                this.setBaseValue(l2);
                if (c4 == '/') {
                    l2 = 0L;
                    ++n2;
                    while (n2 < n3) {
                        c4 = string2.charAt(n2);
                        if (c4 >= '0' && c4 <= '9') {
                            l2 = l2 * 10L + (long)(c4 - 48);
                        } else {
                            if (c4 == '>') break;
                            if (!PatternProps.isWhiteSpace(c4) && c4 != ',' && c4 != '.') {
                                throw new IllegalArgumentException("Illegal character " + c4 + " in rule descriptor");
                            }
                        }
                        ++n2;
                    }
                    this.radix = (int)l2;
                    if (this.radix == 0) {
                        throw new IllegalArgumentException("Rule can't have radix of 0");
                    }
                    this.exponent = this.expectedExponent();
                }
                if (c4 == '>') {
                    while (n2 < n3) {
                        c4 = string2.charAt(n2);
                        if (c4 != '>' || this.exponent <= 0) {
                            throw new IllegalArgumentException("Illegal character in rule descriptor");
                        }
                        this.exponent = (short)(this.exponent - 1);
                        ++n2;
                    }
                }
            } else if (string2.equals("-x")) {
                this.setBaseValue(-1L);
            } else if (n3 == 3) {
                if (c2 == '0' && c3 == 'x') {
                    this.setBaseValue(-3L);
                    this.decimalPoint = string2.charAt(1);
                } else if (c2 == 'x' && c3 == 'x') {
                    this.setBaseValue(-2L);
                    this.decimalPoint = string2.charAt(1);
                } else if (c2 == 'x' && c3 == '0') {
                    this.setBaseValue(-4L);
                    this.decimalPoint = string2.charAt(1);
                } else if (string2.equals("NaN")) {
                    this.setBaseValue(-6L);
                } else if (string2.equals("Inf")) {
                    this.setBaseValue(-5L);
                }
            }
        }
        if (string.length() > 0 && string.charAt(0) == '\'') {
            string = string.substring(1);
        }
        return string;
    }

    private void extractSubstitutions(NFRuleSet nFRuleSet, String string, NFRule nFRule) {
        int n2;
        this.ruleText = string;
        this.sub1 = this.extractSubstitution(nFRuleSet, nFRule);
        this.sub2 = this.sub1 == null ? null : this.extractSubstitution(nFRuleSet, nFRule);
        string = this.ruleText;
        int n3 = string.indexOf("$(");
        int n4 = n2 = n3 >= 0 ? string.indexOf(")$", n3) : -1;
        if (n2 >= 0) {
            PluralRules.PluralType pluralType;
            int n5 = string.indexOf(44, n3);
            if (n5 < 0) {
                throw new IllegalArgumentException("Rule \"" + string + "\" does not have a defined type");
            }
            String string2 = this.ruleText.substring(n3 + 2, n5);
            if ("cardinal".equals(string2)) {
                pluralType = PluralRules.PluralType.CARDINAL;
            } else if ("ordinal".equals(string2)) {
                pluralType = PluralRules.PluralType.ORDINAL;
            } else {
                throw new IllegalArgumentException(string2 + " is an unknown type");
            }
            this.rulePatternFormat = this.formatter.createPluralFormat(pluralType, string.substring(n5 + 1, n2));
        }
    }

    private NFSubstitution extractSubstitution(NFRuleSet nFRuleSet, NFRule nFRule) {
        int n2;
        int n3 = NFRule.indexOfAnyRulePrefix(this.ruleText);
        if (n3 == -1) {
            return null;
        }
        if (this.ruleText.startsWith(">>>", n3)) {
            n2 = n3 + 2;
        } else {
            char c2 = this.ruleText.charAt(n3);
            n2 = this.ruleText.indexOf(c2, n3 + 1);
            if (c2 == '<' && n2 != -1 && n2 < this.ruleText.length() - 1 && this.ruleText.charAt(n2 + 1) == c2) {
                ++n2;
            }
        }
        if (n2 == -1) {
            return null;
        }
        NFSubstitution nFSubstitution = NFSubstitution.makeSubstitution(n3, this, nFRule, nFRuleSet, this.formatter, this.ruleText.substring(n3, n2 + 1));
        this.ruleText = this.ruleText.substring(0, n3) + this.ruleText.substring(n2 + 1);
        return nFSubstitution;
    }

    final void setBaseValue(long l2) {
        this.baseValue = l2;
        this.radix = 10;
        if (this.baseValue >= 1L) {
            this.exponent = this.expectedExponent();
            if (this.sub1 != null) {
                this.sub1.setDivisor(this.radix, this.exponent);
            }
            if (this.sub2 != null) {
                this.sub2.setDivisor(this.radix, this.exponent);
            }
        } else {
            this.exponent = 0;
        }
    }

    private short expectedExponent() {
        if (this.radix == 0 || this.baseValue < 1L) {
            return 0;
        }
        short s2 = (short)(Math.log(this.baseValue) / Math.log(this.radix));
        if (NFRule.power(this.radix, (short)(s2 + 1)) <= this.baseValue) {
            return (short)(s2 + 1);
        }
        return s2;
    }

    private static int indexOfAnyRulePrefix(String string) {
        int n2 = -1;
        if (string.length() > 0) {
            for (String string2 : RULE_PREFIXES) {
                int n3 = string.indexOf(string2);
                if (n3 == -1 || n2 != -1 && n3 >= n2) continue;
                n2 = n3;
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object instanceof NFRule) {
            NFRule nFRule = (NFRule)object;
            return this.baseValue == nFRule.baseValue && this.radix == nFRule.radix && this.exponent == nFRule.exponent && this.ruleText.equals(nFRule.ruleText) && Objects.equals(this.sub1, nFRule.sub1) && Objects.equals(this.sub2, nFRule.sub2);
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.baseValue == -1L) {
            stringBuilder.append("-x: ");
        } else if (this.baseValue == -2L) {
            stringBuilder.append('x').append(this.decimalPoint == '\u0000' ? (char)'.' : (char)this.decimalPoint).append("x: ");
        } else if (this.baseValue == -3L) {
            stringBuilder.append('0').append(this.decimalPoint == '\u0000' ? (char)'.' : (char)this.decimalPoint).append("x: ");
        } else if (this.baseValue == -4L) {
            stringBuilder.append('x').append(this.decimalPoint == '\u0000' ? (char)'.' : (char)this.decimalPoint).append("0: ");
        } else if (this.baseValue == -5L) {
            stringBuilder.append("Inf: ");
        } else if (this.baseValue == -6L) {
            stringBuilder.append("NaN: ");
        } else {
            stringBuilder.append(String.valueOf(this.baseValue));
            if (this.radix != 10) {
                stringBuilder.append('/').append(this.radix);
            }
            int n2 = this.expectedExponent() - this.exponent;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append('>');
            }
            stringBuilder.append(": ");
        }
        if (this.ruleText.startsWith(" ") && (this.sub1 == null || this.sub1.getPos() != 0)) {
            stringBuilder.append('\'');
        }
        StringBuilder stringBuilder2 = new StringBuilder(this.ruleText);
        if (this.sub2 != null) {
            stringBuilder2.insert(this.sub2.getPos(), this.sub2.toString());
        }
        if (this.sub1 != null) {
            stringBuilder2.insert(this.sub1.getPos(), this.sub1.toString());
        }
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    public final char getDecimalPoint() {
        return this.decimalPoint;
    }

    public final long getBaseValue() {
        return this.baseValue;
    }

    public long getDivisor() {
        return NFRule.power(this.radix, this.exponent);
    }

    boolean hasModulusSubstitution() {
        return this.sub1 instanceof ModulusSubstitution || this.sub2 instanceof ModulusSubstitution;
    }

    public void doFormat(long l2, StringBuilder stringBuilder, int n2, int n3) {
        int n4 = this.ruleText.length();
        int n5 = 0;
        if (this.rulePatternFormat == null) {
            stringBuilder.insert(n2, this.ruleText);
        } else {
            n4 = this.ruleText.indexOf("$(");
            int n6 = this.ruleText.indexOf(")$", n4);
            int n7 = stringBuilder.length();
            if (n6 < this.ruleText.length() - 1) {
                stringBuilder.insert(n2, this.ruleText.substring(n6 + 2));
            }
            stringBuilder.insert(n2, this.rulePatternFormat.format(l2 / NFRule.power(this.radix, this.exponent)));
            if (n4 > 0) {
                stringBuilder.insert(n2, this.ruleText.substring(0, n4));
            }
            n5 = this.ruleText.length() - (stringBuilder.length() - n7);
        }
        if (this.sub2 != null) {
            this.sub2.doSubstitution(l2, stringBuilder, n2 - (this.sub2.getPos() > n4 ? n5 : 0), n3);
        }
        if (this.sub1 != null) {
            this.sub1.doSubstitution(l2, stringBuilder, n2 - (this.sub1.getPos() > n4 ? n5 : 0), n3);
        }
    }

    public void doFormat(double d2, StringBuilder stringBuilder, int n2, int n3) {
        int n4 = this.ruleText.length();
        int n5 = 0;
        if (this.rulePatternFormat == null) {
            stringBuilder.insert(n2, this.ruleText);
        } else {
            double d3;
            n4 = this.ruleText.indexOf("$(");
            int n6 = this.ruleText.indexOf(")$", n4);
            int n7 = stringBuilder.length();
            if (n6 < this.ruleText.length() - 1) {
                stringBuilder.insert(n2, this.ruleText.substring(n6 + 2));
            }
            d3 = 0.0 <= (d3 = d2) && d3 < 1.0 ? (double)Math.round(d3 * (double)NFRule.power(this.radix, this.exponent)) : (d3 /= (double)NFRule.power(this.radix, this.exponent));
            stringBuilder.insert(n2, this.rulePatternFormat.format((long)d3));
            if (n4 > 0) {
                stringBuilder.insert(n2, this.ruleText.substring(0, n4));
            }
            n5 = this.ruleText.length() - (stringBuilder.length() - n7);
        }
        if (this.sub2 != null) {
            this.sub2.doSubstitution(d2, stringBuilder, n2 - (this.sub2.getPos() > n4 ? n5 : 0), n3);
        }
        if (this.sub1 != null) {
            this.sub1.doSubstitution(d2, stringBuilder, n2 - (this.sub1.getPos() > n4 ? n5 : 0), n3);
        }
    }

    static long power(long l2, short s2) {
        if (s2 < 0) {
            throw new IllegalArgumentException("Exponent can not be negative");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Base can not be negative");
        }
        long l3 = 1L;
        while (s2 > 0) {
            if ((s2 & 1) == 1) {
                l3 *= l2;
            }
            l2 *= l2;
            s2 = (short)(s2 >> 1);
        }
        return l3;
    }

    public boolean shouldRollBack(long l2) {
        if (!(this.sub1 != null && this.sub1.isModulusSubstitution() || this.sub2 != null && this.sub2.isModulusSubstitution())) {
            return false;
        }
        long l3 = NFRule.power(this.radix, this.exponent);
        return l2 % l3 == 0L && this.baseValue % l3 != 0L;
    }

    public Number doParse(String string, ParsePosition parsePosition, boolean bl2, double d2, int n2) {
        ParsePosition parsePosition2 = new ParsePosition(0);
        int n3 = this.sub1 != null ? this.sub1.getPos() : this.ruleText.length();
        int n4 = this.sub2 != null ? this.sub2.getPos() : this.ruleText.length();
        String string2 = this.stripPrefix(string, this.ruleText.substring(0, n3), parsePosition2);
        int n5 = string.length() - string2.length();
        if (parsePosition2.getIndex() == 0 && n3 != 0) {
            return ZERO;
        }
        if (this.baseValue == -5L) {
            parsePosition.setIndex(parsePosition2.getIndex());
            return Double.POSITIVE_INFINITY;
        }
        if (this.baseValue == -6L) {
            parsePosition.setIndex(parsePosition2.getIndex());
            return Double.NaN;
        }
        int n6 = 0;
        double d3 = 0.0;
        int n7 = 0;
        double d4 = Math.max(0L, this.baseValue);
        do {
            parsePosition2.setIndex(0);
            double d5 = this.matchToDelimiter(string2, n7, d4, this.ruleText.substring(n3, n4), this.rulePatternFormat, parsePosition2, this.sub1, d2, n2).doubleValue();
            if (parsePosition2.getIndex() == 0 && this.sub1 != null) continue;
            n7 = parsePosition2.getIndex();
            String string3 = string2.substring(parsePosition2.getIndex());
            ParsePosition parsePosition3 = new ParsePosition(0);
            d5 = this.matchToDelimiter(string3, 0, d5, this.ruleText.substring(n4), this.rulePatternFormat, parsePosition3, this.sub2, d2, n2).doubleValue();
            if (parsePosition3.getIndex() == 0 && this.sub2 != null || n5 + parsePosition2.getIndex() + parsePosition3.getIndex() <= n6) continue;
            n6 = n5 + parsePosition2.getIndex() + parsePosition3.getIndex();
            d3 = d5;
        } while (n3 != n4 && parsePosition2.getIndex() > 0 && parsePosition2.getIndex() < string2.length() && parsePosition2.getIndex() != n7);
        parsePosition.setIndex(n6);
        if (bl2 && n6 > 0 && this.sub1 == null) {
            d3 = 1.0 / d3;
        }
        if (d3 == (double)((long)d3)) {
            return (long)d3;
        }
        return d3;
    }

    private String stripPrefix(String string, String string2, ParsePosition parsePosition) {
        if (string2.length() == 0) {
            return string;
        }
        int n2 = this.prefixLength(string, string2);
        if (n2 != 0) {
            parsePosition.setIndex(parsePosition.getIndex() + n2);
            return string.substring(n2);
        }
        return string;
    }

    private Number matchToDelimiter(String string, int n2, double d2, String string2, PluralFormat pluralFormat, ParsePosition parsePosition, NFSubstitution nFSubstitution, double d3, int n3) {
        if (!this.allIgnorable(string2)) {
            ParsePosition parsePosition2 = new ParsePosition(0);
            int[] nArray = this.findText(string, string2, pluralFormat, n2);
            int n4 = nArray[0];
            int n5 = nArray[1];
            while (n4 >= 0) {
                String string3 = string.substring(0, n4);
                if (string3.length() > 0) {
                    Number number = nFSubstitution.doParse(string3, parsePosition2, d2, d3, this.formatter.lenientParseEnabled(), n3);
                    if (parsePosition2.getIndex() == n4) {
                        parsePosition.setIndex(n4 + n5);
                        return number;
                    }
                }
                parsePosition2.setIndex(0);
                nArray = this.findText(string, string2, pluralFormat, n4 + n5);
                n4 = nArray[0];
                n5 = nArray[1];
            }
            parsePosition.setIndex(0);
            return ZERO;
        }
        if (nFSubstitution == null) {
            return d2;
        }
        ParsePosition parsePosition3 = new ParsePosition(0);
        Number number = ZERO;
        Number number2 = nFSubstitution.doParse(string, parsePosition3, d2, d3, this.formatter.lenientParseEnabled(), n3);
        if (parsePosition3.getIndex() != 0) {
            parsePosition.setIndex(parsePosition3.getIndex());
            if (number2 != null) {
                number = number2;
            }
        }
        return number;
    }

    private int prefixLength(String string, String string2) {
        if (string2.length() == 0) {
            return 0;
        }
        RbnfLenientScanner rbnfLenientScanner = this.formatter.getLenientScanner();
        if (rbnfLenientScanner != null) {
            if (string.startsWith(string2)) {
                return string2.length();
            }
            return rbnfLenientScanner.prefixLength(string, string2);
        }
        if (string.startsWith(string2)) {
            return string2.length();
        }
        return 0;
    }

    private int[] findText(String string, String string2, PluralFormat pluralFormat, int n2) {
        RbnfLenientScanner rbnfLenientScanner = this.formatter.getLenientScanner();
        if (pluralFormat != null) {
            FieldPosition fieldPosition = new FieldPosition(0);
            fieldPosition.setBeginIndex(n2);
            pluralFormat.parseType(string, rbnfLenientScanner, fieldPosition);
            int n3 = fieldPosition.getBeginIndex();
            if (n3 >= 0) {
                int n4 = this.ruleText.indexOf("$(");
                int n5 = this.ruleText.indexOf(")$", n4) + 2;
                int n6 = fieldPosition.getEndIndex() - n3;
                String string3 = this.ruleText.substring(0, n4);
                String string4 = this.ruleText.substring(n5);
                if (string.regionMatches(n3 - string3.length(), string3, 0, string3.length()) && string.regionMatches(n3 + n6, string4, 0, string4.length())) {
                    return new int[]{n3 - string3.length(), n6 + string3.length() + string4.length()};
                }
            }
            return new int[]{-1, 0};
        }
        if (rbnfLenientScanner != null) {
            int[] nArray = new int[]{string.indexOf(string2, n2), string2.length()};
            if (nArray[0] >= 0) {
                return nArray;
            }
            return rbnfLenientScanner.findText(string, string2, n2);
        }
        return new int[]{string.indexOf(string2, n2), string2.length()};
    }

    private boolean allIgnorable(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        RbnfLenientScanner rbnfLenientScanner = this.formatter.getLenientScanner();
        return rbnfLenientScanner != null && rbnfLenientScanner.allIgnorable(string);
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        if (this.sub1 != null) {
            this.sub1.setDecimalFormatSymbols(decimalFormatSymbols);
        }
        if (this.sub2 != null) {
            this.sub2.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }
}

