/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.ArrayList;
import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUConfig;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Freezable;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;

public final class MessagePattern
implements Freezable<MessagePattern>,
Cloneable {
    public static final int ARG_NAME_NOT_NUMBER = -1;
    public static final int ARG_NAME_NOT_VALID = -2;
    public static final double NO_NUMERIC_VALUE = -1.23456789E8;
    private static final int MAX_PREFIX_LENGTH = 24;
    private ApostropheMode aposMode;
    private String msg;
    private ArrayList<Part> parts = new ArrayList();
    private ArrayList<Double> numericValues;
    private boolean hasArgNames;
    private boolean hasArgNumbers;
    private boolean needsAutoQuoting;
    private volatile boolean frozen;
    private static final ApostropheMode defaultAposMode = ApostropheMode.valueOf(ICUConfig.get("macromedia.jdbc.db2.externals.com.ibm.icu.text.MessagePattern.ApostropheMode", "DOUBLE_OPTIONAL"));
    private static final ArgType[] argTypes = ArgType.values();

    public MessagePattern() {
        this.aposMode = defaultAposMode;
    }

    public MessagePattern(ApostropheMode apostropheMode) {
        this.aposMode = apostropheMode;
    }

    public MessagePattern(String string) {
        this.aposMode = defaultAposMode;
        this.parse(string);
    }

    public MessagePattern parse(String string) {
        this.preParse(string);
        this.parseMessage(0, 0, 0, ArgType.NONE);
        this.postParse();
        return this;
    }

    public MessagePattern parseChoiceStyle(String string) {
        this.preParse(string);
        this.parseChoiceStyle(0, 0);
        this.postParse();
        return this;
    }

    public MessagePattern parsePluralStyle(String string) {
        this.preParse(string);
        this.parsePluralOrSelectStyle(ArgType.PLURAL, 0, 0);
        this.postParse();
        return this;
    }

    public MessagePattern parseSelectStyle(String string) {
        this.preParse(string);
        this.parsePluralOrSelectStyle(ArgType.SELECT, 0, 0);
        this.postParse();
        return this;
    }

    public void clear() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to clear() a frozen MessagePattern instance.");
        }
        this.msg = null;
        this.hasArgNumbers = false;
        this.hasArgNames = false;
        this.needsAutoQuoting = false;
        this.parts.clear();
        if (this.numericValues != null) {
            this.numericValues.clear();
        }
    }

    public void clearPatternAndSetApostropheMode(ApostropheMode apostropheMode) {
        this.clear();
        this.aposMode = apostropheMode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MessagePattern messagePattern = (MessagePattern)object;
        return this.aposMode.equals((Object)messagePattern.aposMode) && (this.msg == null ? messagePattern.msg == null : this.msg.equals(messagePattern.msg)) && this.parts.equals(messagePattern.parts);
    }

    public int hashCode() {
        return (this.aposMode.hashCode() * 37 + (this.msg != null ? this.msg.hashCode() : 0)) * 37 + this.parts.hashCode();
    }

    public ApostropheMode getApostropheMode() {
        return this.aposMode;
    }

    boolean jdkAposMode() {
        return this.aposMode == ApostropheMode.DOUBLE_REQUIRED;
    }

    public String getPatternString() {
        return this.msg;
    }

    public boolean hasNamedArguments() {
        return this.hasArgNames;
    }

    public boolean hasNumberedArguments() {
        return this.hasArgNumbers;
    }

    public String toString() {
        return this.msg;
    }

    public static int validateArgumentName(String string) {
        if (!PatternProps.isIdentifier(string)) {
            return -2;
        }
        return MessagePattern.parseArgNumber(string, 0, string.length());
    }

    public String autoQuoteApostropheDeep() {
        int n2;
        if (!this.needsAutoQuoting) {
            return this.msg;
        }
        StringBuilder stringBuilder = null;
        int n3 = n2 = this.countParts();
        while (n3 > 0) {
            Part part;
            if ((part = this.getPart(--n3)).getType() != Part.Type.INSERT_CHAR) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(this.msg.length() + 10).append(this.msg);
            }
            stringBuilder.insert(part.index, (char)part.value);
        }
        if (stringBuilder == null) {
            return this.msg;
        }
        return stringBuilder.toString();
    }

    public int countParts() {
        return this.parts.size();
    }

    public Part getPart(int n2) {
        return this.parts.get(n2);
    }

    public Part.Type getPartType(int n2) {
        return this.parts.get(n2).type;
    }

    public int getPatternIndex(int n2) {
        return this.parts.get(n2).index;
    }

    public String getSubstring(Part part) {
        int n2 = part.index;
        return this.msg.substring(n2, n2 + part.length);
    }

    public boolean partSubstringMatches(Part part, String string) {
        return part.length == string.length() && this.msg.regionMatches(part.index, string, 0, part.length);
    }

    public double getNumericValue(Part part) {
        Part.Type type = part.type;
        if (type == Part.Type.ARG_INT) {
            return part.value;
        }
        if (type == Part.Type.ARG_DOUBLE) {
            return this.numericValues.get(part.value);
        }
        return -1.23456789E8;
    }

    public double getPluralOffset(int n2) {
        Part part = this.parts.get(n2);
        if (part.type.hasNumericValue()) {
            return this.getNumericValue(part);
        }
        return 0.0;
    }

    public int getLimitPartIndex(int n2) {
        int n3 = this.parts.get(n2).limitPartIndex;
        if (n3 < n2) {
            return n2;
        }
        return n3;
    }

    public Object clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    @Override
    public MessagePattern cloneAsThawed() {
        MessagePattern messagePattern;
        try {
            messagePattern = (MessagePattern)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException(cloneNotSupportedException);
        }
        messagePattern.parts = (ArrayList)this.parts.clone();
        if (this.numericValues != null) {
            messagePattern.numericValues = (ArrayList)this.numericValues.clone();
        }
        messagePattern.frozen = false;
        return messagePattern;
    }

    @Override
    public MessagePattern freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    private void preParse(String string) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to parse(" + MessagePattern.prefix(string) + ") on frozen MessagePattern instance.");
        }
        this.msg = string;
        this.hasArgNumbers = false;
        this.hasArgNames = false;
        this.needsAutoQuoting = false;
        this.parts.clear();
        if (this.numericValues != null) {
            this.numericValues.clear();
        }
    }

    private void postParse() {
    }

    private int parseMessage(int n2, int n3, int n4, ArgType argType) {
        if (n4 > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = this.parts.size();
        this.addPart(Part.Type.MSG_START, n2, n3, n4);
        n2 += n3;
        block0: while (n2 < this.msg.length()) {
            char c2;
            if ((c2 = this.msg.charAt(n2++)) == '\'') {
                if (n2 == this.msg.length()) {
                    this.addPart(Part.Type.INSERT_CHAR, n2, 0, 39);
                    this.needsAutoQuoting = true;
                    continue;
                }
                c2 = this.msg.charAt(n2);
                if (c2 == '\'') {
                    this.addPart(Part.Type.SKIP_SYNTAX, n2++, 1, 0);
                    continue;
                }
                if (this.aposMode == ApostropheMode.DOUBLE_REQUIRED || c2 == '{' || c2 == '}' || argType == ArgType.CHOICE && c2 == '|' || argType.hasPluralStyle() && c2 == '#') {
                    this.addPart(Part.Type.SKIP_SYNTAX, n2 - 1, 1, 0);
                    while ((n2 = this.msg.indexOf(39, n2 + 1)) >= 0) {
                        if (n2 + 1 < this.msg.length() && this.msg.charAt(n2 + 1) == '\'') {
                            this.addPart(Part.Type.SKIP_SYNTAX, ++n2, 1, 0);
                            continue;
                        }
                        this.addPart(Part.Type.SKIP_SYNTAX, n2++, 1, 0);
                        continue block0;
                    }
                    n2 = this.msg.length();
                    this.addPart(Part.Type.INSERT_CHAR, n2, 0, 39);
                    this.needsAutoQuoting = true;
                    continue;
                }
                this.addPart(Part.Type.INSERT_CHAR, n2, 0, 39);
                this.needsAutoQuoting = true;
                continue;
            }
            if (argType.hasPluralStyle() && c2 == '#') {
                this.addPart(Part.Type.REPLACE_NUMBER, n2 - 1, 1, 0);
                continue;
            }
            if (c2 == '{') {
                n2 = this.parseArg(n2 - 1, 1, n4);
                continue;
            }
            if ((n4 <= 0 || c2 != '}') && (argType != ArgType.CHOICE || c2 != '|')) continue;
            int n6 = argType == ArgType.CHOICE && c2 == '}' ? 0 : 1;
            this.addLimitPart(n5, Part.Type.MSG_LIMIT, n2 - 1, n6, n4);
            if (argType == ArgType.CHOICE) {
                return n2 - 1;
            }
            return n2;
        }
        if (n4 > 0 && !this.inTopLevelChoiceMessage(n4, argType)) {
            throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
        }
        this.addLimitPart(n5, Part.Type.MSG_LIMIT, n2, 0, n4);
        return n2;
    }

    private int parseArg(int n2, int n3, int n4) {
        ArgType argType;
        int n5;
        block28: {
            int n6;
            int n7;
            int n8;
            int n9;
            block30: {
                block29: {
                    n5 = this.parts.size();
                    argType = ArgType.NONE;
                    this.addPart(Part.Type.ARG_START, n2, n3, argType.ordinal());
                    n9 = n2 = this.skipWhiteSpace(n2 + n3);
                    if (n2 == this.msg.length()) {
                        throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
                    }
                    int n10 = this.parseArgNumber(n9, n2 = this.skipIdentifier(n2));
                    if (n10 >= 0) {
                        n8 = n2 - n9;
                        if (n8 > 65535 || n10 > Short.MAX_VALUE) {
                            throw new IndexOutOfBoundsException("Argument number too large: " + this.prefix(n9));
                        }
                        this.hasArgNumbers = true;
                        this.addPart(Part.Type.ARG_NUMBER, n9, n8, n10);
                    } else if (n10 == -1) {
                        n8 = n2 - n9;
                        if (n8 > 65535) {
                            throw new IndexOutOfBoundsException("Argument name too long: " + this.prefix(n9));
                        }
                        this.hasArgNames = true;
                        this.addPart(Part.Type.ARG_NAME, n9, n8, 0);
                    } else {
                        throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(n9));
                    }
                    n2 = this.skipWhiteSpace(n2);
                    if (n2 == this.msg.length()) {
                        throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
                    }
                    n8 = this.msg.charAt(n2);
                    if (n8 == 125) break block28;
                    if (n8 != 44) {
                        throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(n9));
                    }
                    n7 = n2 = this.skipWhiteSpace(n2 + 1);
                    while (n2 < this.msg.length() && MessagePattern.isArgTypeChar(this.msg.charAt(n2))) {
                        ++n2;
                    }
                    n6 = n2 - n7;
                    if ((n2 = this.skipWhiteSpace(n2)) == this.msg.length()) {
                        throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
                    }
                    if (n6 == 0) break block29;
                    char c2 = this.msg.charAt(n2);
                    n8 = c2;
                    if (c2 == ',' || n8 == 125) break block30;
                }
                throw new IllegalArgumentException("Bad argument syntax: " + this.prefix(n9));
            }
            if (n6 > 65535) {
                throw new IndexOutOfBoundsException("Argument type name too long: " + this.prefix(n9));
            }
            argType = ArgType.SIMPLE;
            if (n6 == 6) {
                if (this.isChoice(n7)) {
                    argType = ArgType.CHOICE;
                } else if (this.isPlural(n7)) {
                    argType = ArgType.PLURAL;
                } else if (this.isSelect(n7)) {
                    argType = ArgType.SELECT;
                }
            } else if (n6 == 13 && this.isSelect(n7) && this.isOrdinal(n7 + 6)) {
                argType = ArgType.SELECTORDINAL;
            }
            this.parts.get(n5).value = (short)argType.ordinal();
            if (argType == ArgType.SIMPLE) {
                this.addPart(Part.Type.ARG_TYPE, n7, n6, 0);
            }
            if (n8 == 125) {
                if (argType != ArgType.SIMPLE) {
                    throw new IllegalArgumentException("No style field for complex argument: " + this.prefix(n9));
                }
            } else {
                ++n2;
                n2 = argType == ArgType.SIMPLE ? this.parseSimpleStyle(n2) : (argType == ArgType.CHOICE ? this.parseChoiceStyle(n2, n4) : this.parsePluralOrSelectStyle(argType, n2, n4));
            }
        }
        this.addLimitPart(n5, Part.Type.ARG_LIMIT, n2, 1, argType.ordinal());
        return n2 + 1;
    }

    private int parseSimpleStyle(int n2) {
        int n3 = n2;
        int n4 = 0;
        while (n2 < this.msg.length()) {
            int n5;
            char c2;
            if ((c2 = this.msg.charAt(n2++)) == '\'') {
                if ((n2 = this.msg.indexOf(39, n2)) < 0) {
                    throw new IllegalArgumentException("Quoted literal argument style text reaches to the end of the message: " + this.prefix(n3));
                }
                ++n2;
                continue;
            }
            if (c2 == '{') {
                ++n4;
                continue;
            }
            if (c2 != '}') continue;
            if (n4 > 0) {
                --n4;
                continue;
            }
            if ((n5 = --n2 - n3) > 65535) {
                throw new IndexOutOfBoundsException("Argument style text too long: " + this.prefix(n3));
            }
            this.addPart(Part.Type.ARG_STYLE, n3, n5, 0);
            return n2;
        }
        throw new IllegalArgumentException("Unmatched '{' braces in message " + this.prefix());
    }

    private int parseChoiceStyle(int n2, int n3) {
        int n4 = n2;
        if ((n2 = this.skipWhiteSpace(n2)) == this.msg.length() || this.msg.charAt(n2) == '}') {
            throw new IllegalArgumentException("Missing choice argument pattern in " + this.prefix());
        }
        while (true) {
            int n5 = n2;
            int n6 = (n2 = this.skipDouble(n2)) - n5;
            if (n6 == 0) {
                throw new IllegalArgumentException("Bad choice pattern syntax: " + this.prefix(n4));
            }
            if (n6 > 65535) {
                throw new IndexOutOfBoundsException("Choice number too long: " + this.prefix(n5));
            }
            this.parseDouble(n5, n2, true);
            n2 = this.skipWhiteSpace(n2);
            if (n2 == this.msg.length()) {
                throw new IllegalArgumentException("Bad choice pattern syntax: " + this.prefix(n4));
            }
            char c2 = this.msg.charAt(n2);
            if (c2 != '#' && c2 != '<' && c2 != '\u2264') {
                throw new IllegalArgumentException("Expected choice separator (#<\u2264) instead of '" + c2 + "' in choice pattern " + this.prefix(n4));
            }
            this.addPart(Part.Type.ARG_SELECTOR, n2, 1, 0);
            ++n2;
            n2 = this.parseMessage(n2, 0, n3 + 1, ArgType.CHOICE);
            if (n2 == this.msg.length()) {
                return n2;
            }
            if (this.msg.charAt(n2) == '}') {
                if (!this.inMessageFormatPattern(n3)) {
                    throw new IllegalArgumentException("Bad choice pattern syntax: " + this.prefix(n4));
                }
                return n2;
            }
            n2 = this.skipWhiteSpace(n2 + 1);
        }
    }

    private int parsePluralOrSelectStyle(ArgType argType, int n2, int n3) {
        int n4 = n2;
        boolean bl2 = true;
        boolean bl3 = false;
        while (true) {
            int n5;
            boolean bl4;
            boolean bl5 = bl4 = (n2 = this.skipWhiteSpace(n2)) == this.msg.length();
            if (bl4 || this.msg.charAt(n2) == '}') {
                if (bl4 == this.inMessageFormatPattern(n3)) {
                    throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(n4));
                }
                if (!bl3) {
                    throw new IllegalArgumentException("Missing 'other' keyword in " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern in " + this.prefix());
                }
                return n2;
            }
            int n6 = n2;
            if (argType.hasPluralStyle() && this.msg.charAt(n6) == '=') {
                n5 = (n2 = this.skipDouble(n2 + 1)) - n6;
                if (n5 == 1) {
                    throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(n4));
                }
                if (n5 > 65535) {
                    throw new IndexOutOfBoundsException("Argument selector too long: " + this.prefix(n6));
                }
                this.addPart(Part.Type.ARG_SELECTOR, n6, n5, 0);
                this.parseDouble(n6 + 1, n2, false);
            } else {
                n5 = (n2 = this.skipIdentifier(n2)) - n6;
                if (n5 == 0) {
                    throw new IllegalArgumentException("Bad " + argType.toString().toLowerCase(Locale.ENGLISH) + " pattern syntax: " + this.prefix(n4));
                }
                if (argType.hasPluralStyle() && n5 == 6 && n2 < this.msg.length() && this.msg.regionMatches(n6, "offset:", 0, 7)) {
                    if (!bl2) {
                        throw new IllegalArgumentException("Plural argument 'offset:' (if present) must precede key-message pairs: " + this.prefix(n4));
                    }
                    int n7 = this.skipWhiteSpace(n2 + 1);
                    if ((n2 = this.skipDouble(n7)) == n7) {
                        throw new IllegalArgumentException("Missing value for plural 'offset:' " + this.prefix(n4));
                    }
                    if (n2 - n7 > 65535) {
                        throw new IndexOutOfBoundsException("Plural offset value too long: " + this.prefix(n7));
                    }
                    this.parseDouble(n7, n2, false);
                    bl2 = false;
                    continue;
                }
                if (n5 > 65535) {
                    throw new IndexOutOfBoundsException("Argument selector too long: " + this.prefix(n6));
                }
                this.addPart(Part.Type.ARG_SELECTOR, n6, n5, 0);
                if (this.msg.regionMatches(n6, "other", 0, n5)) {
                    bl3 = true;
                }
            }
            n2 = this.skipWhiteSpace(n2);
            if (n2 == this.msg.length() || this.msg.charAt(n2) != '{') {
                throw new IllegalArgumentException("No message fragment after " + argType.toString().toLowerCase(Locale.ENGLISH) + " selector: " + this.prefix(n6));
            }
            n2 = this.parseMessage(n2, 1, n3 + 1, argType);
            bl2 = false;
        }
    }

    private static int parseArgNumber(CharSequence charSequence, int n2, int n3) {
        boolean bl2;
        int n4;
        char c2;
        if (n2 >= n3) {
            return -2;
        }
        if ((c2 = charSequence.charAt(n2++)) == '0') {
            if (n2 == n3) {
                return 0;
            }
            n4 = 0;
            bl2 = true;
        } else if ('1' <= c2 && c2 <= '9') {
            n4 = c2 - 48;
            bl2 = false;
        } else {
            return -1;
        }
        while (n2 < n3) {
            if ('0' <= (c2 = charSequence.charAt(n2++)) && c2 <= '9') {
                if (n4 >= 0xCCCCCCC) {
                    bl2 = true;
                }
                n4 = n4 * 10 + (c2 - 48);
                continue;
            }
            return -1;
        }
        if (bl2) {
            return -2;
        }
        return n4;
    }

    private int parseArgNumber(int n2, int n3) {
        return MessagePattern.parseArgNumber(this.msg, n2, n3);
    }

    private void parseDouble(int n2, int n3, boolean bl2) {
        block10: {
            char c2;
            int n4;
            int n5;
            int n6;
            block11: {
                block9: {
                    assert (n2 < n3);
                    n6 = 0;
                    n5 = 0;
                    n4 = n2;
                    if ((c2 = this.msg.charAt(n4++)) != '-') break block9;
                    n5 = 1;
                    if (n4 == n3) break block10;
                    c2 = this.msg.charAt(n4++);
                    break block11;
                }
                if (c2 != '+') break block11;
                if (n4 == n3) break block10;
                c2 = this.msg.charAt(n4++);
            }
            if (c2 == '\u221e') {
                if (bl2 && n4 == n3) {
                    this.addArgDoublePart(n5 != 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY, n2, n3 - n2);
                    return;
                }
            } else {
                while ('0' <= c2 && c2 <= '9' && (n6 = n6 * 10 + (c2 - 48)) <= Short.MAX_VALUE + n5) {
                    if (n4 == n3) {
                        this.addPart(Part.Type.ARG_INT, n2, n3 - n2, n5 != 0 ? -n6 : n6);
                        return;
                    }
                    c2 = this.msg.charAt(n4++);
                }
                double d2 = Double.parseDouble(this.msg.substring(n2, n3));
                this.addArgDoublePart(d2, n2, n3 - n2);
                return;
            }
        }
        throw new NumberFormatException("Bad syntax for numeric value: " + this.msg.substring(n2, n3));
    }

    static void appendReducedApostrophes(String string, int n2, int n3, StringBuilder stringBuilder) {
        int n4 = -1;
        while (true) {
            int n5;
            if ((n5 = string.indexOf(39, n2)) < 0 || n5 >= n3) break;
            if (n5 == n4) {
                stringBuilder.append('\'');
                ++n2;
                n4 = -1;
                continue;
            }
            stringBuilder.append(string, n2, n5);
            n4 = n2 = n5 + 1;
        }
        stringBuilder.append(string, n2, n3);
    }

    private int skipWhiteSpace(int n2) {
        return PatternProps.skipWhiteSpace(this.msg, n2);
    }

    private int skipIdentifier(int n2) {
        return PatternProps.skipIdentifier(this.msg, n2);
    }

    private int skipDouble(int n2) {
        char c2;
        while (!(n2 >= this.msg.length() || (c2 = this.msg.charAt(n2)) < '0' && "+-.".indexOf(c2) < 0 || c2 > '9' && c2 != 'e' && c2 != 'E' && c2 != '\u221e')) {
            ++n2;
        }
        return n2;
    }

    private static boolean isArgTypeChar(int n2) {
        return 97 <= n2 && n2 <= 122 || 65 <= n2 && n2 <= 90;
    }

    private boolean isChoice(int n2) {
        char c2;
        return !((c2 = this.msg.charAt(n2++)) != 'c' && c2 != 'C' || (c2 = this.msg.charAt(n2++)) != 'h' && c2 != 'H' || (c2 = this.msg.charAt(n2++)) != 'o' && c2 != 'O' || (c2 = this.msg.charAt(n2++)) != 'i' && c2 != 'I' || (c2 = this.msg.charAt(n2++)) != 'c' && c2 != 'C' || (c2 = this.msg.charAt(n2)) != 'e' && c2 != 'E');
    }

    private boolean isPlural(int n2) {
        char c2;
        return !((c2 = this.msg.charAt(n2++)) != 'p' && c2 != 'P' || (c2 = this.msg.charAt(n2++)) != 'l' && c2 != 'L' || (c2 = this.msg.charAt(n2++)) != 'u' && c2 != 'U' || (c2 = this.msg.charAt(n2++)) != 'r' && c2 != 'R' || (c2 = this.msg.charAt(n2++)) != 'a' && c2 != 'A' || (c2 = this.msg.charAt(n2)) != 'l' && c2 != 'L');
    }

    private boolean isSelect(int n2) {
        char c2;
        return !((c2 = this.msg.charAt(n2++)) != 's' && c2 != 'S' || (c2 = this.msg.charAt(n2++)) != 'e' && c2 != 'E' || (c2 = this.msg.charAt(n2++)) != 'l' && c2 != 'L' || (c2 = this.msg.charAt(n2++)) != 'e' && c2 != 'E' || (c2 = this.msg.charAt(n2++)) != 'c' && c2 != 'C' || (c2 = this.msg.charAt(n2)) != 't' && c2 != 'T');
    }

    private boolean isOrdinal(int n2) {
        char c2;
        return !((c2 = this.msg.charAt(n2++)) != 'o' && c2 != 'O' || (c2 = this.msg.charAt(n2++)) != 'r' && c2 != 'R' || (c2 = this.msg.charAt(n2++)) != 'd' && c2 != 'D' || (c2 = this.msg.charAt(n2++)) != 'i' && c2 != 'I' || (c2 = this.msg.charAt(n2++)) != 'n' && c2 != 'N' || (c2 = this.msg.charAt(n2++)) != 'a' && c2 != 'A' || (c2 = this.msg.charAt(n2)) != 'l' && c2 != 'L');
    }

    private boolean inMessageFormatPattern(int n2) {
        return n2 > 0 || this.parts.get(0).type == Part.Type.MSG_START;
    }

    private boolean inTopLevelChoiceMessage(int n2, ArgType argType) {
        return n2 == 1 && argType == ArgType.CHOICE && this.parts.get(0).type != Part.Type.MSG_START;
    }

    private void addPart(Part.Type type, int n2, int n3, int n4) {
        this.parts.add(new Part(type, n2, n3, n4));
    }

    private void addLimitPart(int n2, Part.Type type, int n3, int n4, int n5) {
        this.parts.get(n2).limitPartIndex = this.parts.size();
        this.addPart(type, n3, n4, n5);
    }

    private void addArgDoublePart(double d2, int n2, int n3) {
        int n4;
        if (this.numericValues == null) {
            this.numericValues = new ArrayList();
            n4 = 0;
        } else {
            n4 = this.numericValues.size();
            if (n4 > Short.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Too many numeric values");
            }
        }
        this.numericValues.add(d2);
        this.addPart(Part.Type.ARG_DOUBLE, n2, n3, n4);
    }

    private static String prefix(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder(44);
        if (n2 == 0) {
            stringBuilder.append("\"");
        } else {
            stringBuilder.append("[at pattern index ").append(n2).append("] \"");
        }
        int n3 = string.length() - n2;
        if (n3 <= 24) {
            stringBuilder.append(n2 == 0 ? string : string.substring(n2));
        } else {
            int n4 = n2 + 24 - 4;
            if (Character.isHighSurrogate(string.charAt(n4 - 1))) {
                --n4;
            }
            stringBuilder.append(string, n2, n4).append(" ...");
        }
        return stringBuilder.append("\"").toString();
    }

    private static String prefix(String string) {
        return MessagePattern.prefix(string, 0);
    }

    private String prefix(int n2) {
        return MessagePattern.prefix(this.msg, n2);
    }

    private String prefix() {
        return MessagePattern.prefix(this.msg, 0);
    }

    public static enum ArgType {
        NONE,
        SIMPLE,
        CHOICE,
        PLURAL,
        SELECT,
        SELECTORDINAL;


        public boolean hasPluralStyle() {
            return this == PLURAL || this == SELECTORDINAL;
        }
    }

    public static final class Part {
        private static final int MAX_LENGTH = 65535;
        private static final int MAX_VALUE = Short.MAX_VALUE;
        private final Type type;
        private final int index;
        private final char length;
        private short value;
        private int limitPartIndex;

        private Part(Type type, int n2, int n3, int n4) {
            this.type = type;
            this.index = n2;
            this.length = (char)n3;
            this.value = (short)n4;
        }

        public Type getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLength() {
            return this.length;
        }

        public int getLimit() {
            return this.index + this.length;
        }

        public int getValue() {
            return this.value;
        }

        public ArgType getArgType() {
            Type type = this.getType();
            if (type == Type.ARG_START || type == Type.ARG_LIMIT) {
                return argTypes[this.value];
            }
            return ArgType.NONE;
        }

        public String toString() {
            String string = this.type == Type.ARG_START || this.type == Type.ARG_LIMIT ? this.getArgType().name() : Integer.toString(this.value);
            return this.type.name() + "(" + string + ")@" + this.index;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Part part = (Part)object;
            return this.type.equals((Object)part.type) && this.index == part.index && this.length == part.length && this.value == part.value && this.limitPartIndex == part.limitPartIndex;
        }

        public int hashCode() {
            return ((this.type.hashCode() * 37 + this.index) * 37 + this.length) * 37 + this.value;
        }

        public static enum Type {
            MSG_START,
            MSG_LIMIT,
            SKIP_SYNTAX,
            INSERT_CHAR,
            REPLACE_NUMBER,
            ARG_START,
            ARG_LIMIT,
            ARG_NUMBER,
            ARG_NAME,
            ARG_TYPE,
            ARG_STYLE,
            ARG_SELECTOR,
            ARG_INT,
            ARG_DOUBLE;


            public boolean hasNumericValue() {
                return this == ARG_INT || this == ARG_DOUBLE;
            }
        }
    }

    public static enum ApostropheMode {
        DOUBLE_OPTIONAL,
        DOUBLE_REQUIRED;

    }
}

