/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public class FilteredNormalizer2
extends Normalizer2 {
    private Normalizer2 norm2;
    private UnicodeSet set;

    public FilteredNormalizer2(Normalizer2 normalizer2, UnicodeSet unicodeSet) {
        this.norm2 = normalizer2;
        this.set = unicodeSet;
    }

    @Override
    public StringBuilder normalize(CharSequence charSequence, StringBuilder stringBuilder) {
        if (stringBuilder == charSequence) {
            throw new IllegalArgumentException();
        }
        stringBuilder.setLength(0);
        this.normalize(charSequence, stringBuilder, UnicodeSet.SpanCondition.SIMPLE);
        return stringBuilder;
    }

    @Override
    public Appendable normalize(CharSequence charSequence, Appendable appendable) {
        if (appendable == charSequence) {
            throw new IllegalArgumentException();
        }
        return this.normalize(charSequence, appendable, UnicodeSet.SpanCondition.SIMPLE);
    }

    @Override
    public StringBuilder normalizeSecondAndAppend(StringBuilder stringBuilder, CharSequence charSequence) {
        return this.normalizeSecondAndAppend(stringBuilder, charSequence, true);
    }

    @Override
    public StringBuilder append(StringBuilder stringBuilder, CharSequence charSequence) {
        return this.normalizeSecondAndAppend(stringBuilder, charSequence, false);
    }

    @Override
    public String getDecomposition(int n2) {
        return this.set.contains(n2) ? this.norm2.getDecomposition(n2) : null;
    }

    @Override
    public String getRawDecomposition(int n2) {
        return this.set.contains(n2) ? this.norm2.getRawDecomposition(n2) : null;
    }

    @Override
    public int composePair(int n2, int n3) {
        return this.set.contains(n2) && this.set.contains(n3) ? this.norm2.composePair(n2, n3) : -1;
    }

    @Override
    public int getCombiningClass(int n2) {
        return this.set.contains(n2) ? this.norm2.getCombiningClass(n2) : 0;
    }

    @Override
    public boolean isNormalized(CharSequence charSequence) {
        UnicodeSet.SpanCondition spanCondition = UnicodeSet.SpanCondition.SIMPLE;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            int n3 = this.set.span(charSequence, n2, spanCondition);
            if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                spanCondition = UnicodeSet.SpanCondition.SIMPLE;
            } else {
                if (!this.norm2.isNormalized(charSequence.subSequence(n2, n3))) {
                    return false;
                }
                spanCondition = UnicodeSet.SpanCondition.NOT_CONTAINED;
            }
            n2 = n3;
        }
        return true;
    }

    @Override
    public Normalizer.QuickCheckResult quickCheck(CharSequence charSequence) {
        Normalizer.QuickCheckResult quickCheckResult = Normalizer.YES;
        UnicodeSet.SpanCondition spanCondition = UnicodeSet.SpanCondition.SIMPLE;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            int n3 = this.set.span(charSequence, n2, spanCondition);
            if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                spanCondition = UnicodeSet.SpanCondition.SIMPLE;
            } else {
                Normalizer.QuickCheckResult quickCheckResult2 = this.norm2.quickCheck(charSequence.subSequence(n2, n3));
                if (quickCheckResult2 == Normalizer.NO) {
                    return quickCheckResult2;
                }
                if (quickCheckResult2 == Normalizer.MAYBE) {
                    quickCheckResult = quickCheckResult2;
                }
                spanCondition = UnicodeSet.SpanCondition.NOT_CONTAINED;
            }
            n2 = n3;
        }
        return quickCheckResult;
    }

    @Override
    public int spanQuickCheckYes(CharSequence charSequence) {
        UnicodeSet.SpanCondition spanCondition = UnicodeSet.SpanCondition.SIMPLE;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            int n3 = this.set.span(charSequence, n2, spanCondition);
            if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                spanCondition = UnicodeSet.SpanCondition.SIMPLE;
            } else {
                int n4 = n2 + this.norm2.spanQuickCheckYes(charSequence.subSequence(n2, n3));
                if (n4 < n3) {
                    return n4;
                }
                spanCondition = UnicodeSet.SpanCondition.NOT_CONTAINED;
            }
            n2 = n3;
        }
        return charSequence.length();
    }

    @Override
    public boolean hasBoundaryBefore(int n2) {
        return !this.set.contains(n2) || this.norm2.hasBoundaryBefore(n2);
    }

    @Override
    public boolean hasBoundaryAfter(int n2) {
        return !this.set.contains(n2) || this.norm2.hasBoundaryAfter(n2);
    }

    @Override
    public boolean isInert(int n2) {
        return !this.set.contains(n2) || this.norm2.isInert(n2);
    }

    private Appendable normalize(CharSequence charSequence, Appendable appendable, UnicodeSet.SpanCondition spanCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n2 = 0;
            while (n2 < charSequence.length()) {
                int n3 = this.set.span(charSequence, n2, spanCondition);
                int n4 = n3 - n2;
                if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
                    if (n4 != 0) {
                        appendable.append(charSequence, n2, n3);
                    }
                    spanCondition = UnicodeSet.SpanCondition.SIMPLE;
                } else {
                    if (n4 != 0) {
                        appendable.append(this.norm2.normalize(charSequence.subSequence(n2, n3), stringBuilder));
                    }
                    spanCondition = UnicodeSet.SpanCondition.NOT_CONTAINED;
                }
                n2 = n3;
            }
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
        return appendable;
    }

    private StringBuilder normalizeSecondAndAppend(StringBuilder stringBuilder, CharSequence charSequence, boolean bl2) {
        CharSequence charSequence2;
        if (stringBuilder == charSequence) {
            throw new IllegalArgumentException();
        }
        if (stringBuilder.length() == 0) {
            if (bl2) {
                return this.normalize(charSequence, stringBuilder);
            }
            return stringBuilder.append(charSequence);
        }
        int n2 = this.set.span(charSequence, 0, UnicodeSet.SpanCondition.SIMPLE);
        if (n2 != 0) {
            charSequence2 = charSequence.subSequence(0, n2);
            int n3 = this.set.spanBack(stringBuilder, Integer.MAX_VALUE, UnicodeSet.SpanCondition.SIMPLE);
            if (n3 == 0) {
                if (bl2) {
                    this.norm2.normalizeSecondAndAppend(stringBuilder, charSequence2);
                } else {
                    this.norm2.append(stringBuilder, charSequence2);
                }
            } else {
                StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.subSequence(n3, stringBuilder.length()));
                if (bl2) {
                    this.norm2.normalizeSecondAndAppend(stringBuilder2, charSequence2);
                } else {
                    this.norm2.append(stringBuilder2, charSequence2);
                }
                stringBuilder.delete(n3, Integer.MAX_VALUE).append((CharSequence)stringBuilder2);
            }
        }
        if (n2 < charSequence.length()) {
            charSequence2 = charSequence.subSequence(n2, charSequence.length());
            if (bl2) {
                this.normalize(charSequence2, stringBuilder, UnicodeSet.SpanCondition.NOT_CONTAINED);
            } else {
                stringBuilder.append(charSequence2);
            }
        }
        return stringBuilder;
    }
}

