/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.message2;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.MFDataModel;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.StringUtils;

@Deprecated
public class MFSerializer {
    private boolean shouldDoubleQuotePattern = false;
    private boolean needSpace = false;
    private final StringBuilder result = new StringBuilder();
    private static final Pattern RE_NUMBER_LITERAL = Pattern.compile("^-?(0|[1-9][0-9]*)(\\.[0-9]+)?([eE][+\\-]?[0-9]+)?$");

    @Deprecated
    public static String dataModelToString(MFDataModel.Message message) {
        return new MFSerializer().messageToString(message);
    }

    private String messageToString(MFDataModel.Message message) {
        if (message instanceof MFDataModel.PatternMessage) {
            this.patternMessageToString((MFDataModel.PatternMessage)message);
        } else if (message instanceof MFDataModel.SelectMessage) {
            this.selectMessageToString((MFDataModel.SelectMessage)message);
        } else {
            this.errorType("Message", message);
        }
        return this.result.toString();
    }

    private void selectMessageToString(MFDataModel.SelectMessage selectMessage) {
        this.declarationsToString(selectMessage.declarations);
        this.shouldDoubleQuotePattern = true;
        this.addSpaceIfNeeded();
        this.result.append(".match");
        for (MFDataModel.Expression object : selectMessage.selectors) {
            this.result.append(' ');
            this.expressionToString(object);
        }
        for (MFDataModel.Variant variant : selectMessage.variants) {
            this.variantToString(variant);
        }
    }

    private void patternMessageToString(MFDataModel.PatternMessage patternMessage) {
        this.declarationsToString(patternMessage.declarations);
        this.patternToString(patternMessage.pattern);
    }

    private void patternToString(MFDataModel.Pattern pattern) {
        this.addSpaceIfNeeded();
        if (this.shouldDoubleQuotePattern) {
            this.result.append("{{");
        }
        for (MFDataModel.PatternPart patternPart : pattern.parts) {
            if (patternPart instanceof MFDataModel.StringPart) {
                this.stringPartToString((MFDataModel.StringPart)patternPart);
                continue;
            }
            this.expressionToString((MFDataModel.Expression)patternPart);
        }
        if (this.shouldDoubleQuotePattern) {
            this.result.append("}}");
        }
    }

    private void expressionToString(MFDataModel.Expression expression) {
        if (expression == null) {
            return;
        }
        if (expression instanceof MFDataModel.LiteralExpression) {
            this.literalExpressionToString((MFDataModel.LiteralExpression)expression);
        } else if (expression instanceof MFDataModel.VariableExpression) {
            this.variableExpressionToString((MFDataModel.VariableExpression)expression);
        } else if (expression instanceof MFDataModel.FunctionExpression) {
            this.functionExpressionToString((MFDataModel.FunctionExpression)expression);
        } else if (expression instanceof MFDataModel.Markup) {
            this.markupToString((MFDataModel.Markup)expression);
        } else if (expression instanceof MFDataModel.UnsupportedExpression) {
            this.unsupportedExpressionToString((MFDataModel.UnsupportedExpression)expression);
        } else {
            this.errorType("Expression", expression);
        }
    }

    private void unsupportedExpressionToString(MFDataModel.UnsupportedExpression unsupportedExpression) {
        this.result.append('{');
        this.annotationToString(unsupportedExpression.annotation);
        this.attributesToString(unsupportedExpression.attributes);
        this.result.append('}');
    }

    private void markupToString(MFDataModel.Markup markup) {
        this.result.append('{');
        if (markup.kind == MFDataModel.Markup.Kind.CLOSE) {
            this.result.append('/');
        } else {
            this.result.append('#');
        }
        this.result.append(markup.name);
        this.optionsToString(markup.options);
        this.attributesToString(markup.attributes);
        if (markup.kind == MFDataModel.Markup.Kind.STANDALONE) {
            this.result.append('/');
        }
        this.result.append('}');
    }

    private void optionsToString(Map<String, MFDataModel.Option> map) {
        for (MFDataModel.Option option : map.values()) {
            this.result.append(' ');
            this.result.append(option.name);
            this.result.append('=');
            this.literalOrVariableRefToString(option.value);
        }
    }

    private void functionExpressionToString(MFDataModel.FunctionExpression functionExpression) {
        this.result.append('{');
        this.annotationToString(functionExpression.annotation);
        this.attributesToString(functionExpression.attributes);
        this.result.append('}');
    }

    private void attributesToString(List<MFDataModel.Attribute> list) {
        if (list == null) {
            return;
        }
        for (MFDataModel.Attribute attribute : list) {
            this.result.append(" @");
            this.result.append(attribute.name);
            if (attribute.value == null) continue;
            this.result.append('=');
            this.literalOrVariableRefToString(attribute.value);
        }
    }

    private void annotationToString(MFDataModel.Annotation annotation) {
        if (annotation == null) {
            return;
        }
        if (annotation instanceof MFDataModel.FunctionAnnotation) {
            this.addSpaceIfNeeded();
            this.result.append(":");
            this.result.append(((MFDataModel.FunctionAnnotation)annotation).name);
            this.optionsToString(((MFDataModel.FunctionAnnotation)annotation).options);
        } else if (annotation instanceof MFDataModel.UnsupportedAnnotation) {
            this.addSpaceIfNeeded();
            String string = ((MFDataModel.UnsupportedAnnotation)annotation).source;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '\\' || c2 == '{' || c2 == '}') {
                    this.result.append('\\');
                }
                this.result.append(c2);
            }
        } else {
            this.errorType("Annotation", annotation);
        }
    }

    private void variableExpressionToString(MFDataModel.VariableExpression variableExpression) {
        if (variableExpression == null) {
            return;
        }
        this.result.append('{');
        this.literalOrVariableRefToString(variableExpression.arg);
        this.needSpace = true;
        this.annotationToString(variableExpression.annotation);
        this.attributesToString(variableExpression.attributes);
        this.result.append('}');
        this.needSpace = false;
    }

    private void literalOrVariableRefToString(MFDataModel.LiteralOrVariableRef literalOrVariableRef) {
        if (literalOrVariableRef instanceof MFDataModel.Literal) {
            this.literalToString((MFDataModel.Literal)literalOrVariableRef);
        } else if (literalOrVariableRef instanceof MFDataModel.VariableRef) {
            this.result.append("$" + ((MFDataModel.VariableRef)literalOrVariableRef).name);
        } else {
            this.errorType("LiteralOrVariableRef", literalOrVariableRef);
        }
    }

    private void literalToString(MFDataModel.Literal literal) {
        String string = literal.value;
        Matcher matcher = RE_NUMBER_LITERAL.matcher(string);
        if (matcher.find()) {
            this.result.append(string);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = true;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '\\' || c2 == '|') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c2);
                if (i2 == 0 && !StringUtils.isNameStart(c2)) {
                    bl2 = false;
                    continue;
                }
                if (StringUtils.isNameChar(c2)) continue;
                bl2 = false;
            }
            if (bl2 && stringBuilder.length() != 0) {
                this.result.append((CharSequence)stringBuilder);
            } else {
                this.result.append('|');
                this.result.append((CharSequence)stringBuilder);
                this.result.append('|');
            }
        }
    }

    private void literalExpressionToString(MFDataModel.LiteralExpression literalExpression) {
        this.result.append('{');
        this.literalOrVariableRefToString(literalExpression.arg);
        this.needSpace = true;
        this.annotationToString(literalExpression.annotation);
        this.attributesToString(literalExpression.attributes);
        this.result.append('}');
    }

    private void stringPartToString(MFDataModel.StringPart stringPart) {
        if (stringPart.value.startsWith(".") && !this.shouldDoubleQuotePattern) {
            this.shouldDoubleQuotePattern = true;
            this.result.append("{{");
        }
        for (int i2 = 0; i2 < stringPart.value.length(); ++i2) {
            char c2 = stringPart.value.charAt(i2);
            if (c2 == '\\' || c2 == '{' || c2 == '}') {
                this.result.append('\\');
            }
            this.result.append(c2);
        }
    }

    private void declarationsToString(List<MFDataModel.Declaration> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.shouldDoubleQuotePattern = true;
        for (MFDataModel.Declaration declaration : list) {
            if (declaration instanceof MFDataModel.LocalDeclaration) {
                this.localDeclarationToString((MFDataModel.LocalDeclaration)declaration);
                continue;
            }
            if (declaration instanceof MFDataModel.InputDeclaration) {
                this.inputDeclarationToString((MFDataModel.InputDeclaration)declaration);
                continue;
            }
            if (declaration instanceof MFDataModel.UnsupportedStatement) {
                this.unsupportedStatementToString((MFDataModel.UnsupportedStatement)declaration);
                continue;
            }
            this.errorType("Declaration", declaration);
        }
    }

    private void unsupportedStatementToString(MFDataModel.UnsupportedStatement unsupportedStatement) {
        this.addSpaceIfNeeded();
        this.result.append('.');
        this.result.append(unsupportedStatement.keyword);
        if (!unsupportedStatement.body.isEmpty()) {
            this.result.append(' ');
        }
        this.result.append('|');
        this.result.append(unsupportedStatement.body);
        this.result.append('|');
        this.needSpace = true;
        for (MFDataModel.Expression expression : unsupportedStatement.expressions) {
            this.addSpaceIfNeeded();
            this.expressionToString(expression);
            this.needSpace = true;
        }
    }

    private void inputDeclarationToString(MFDataModel.InputDeclaration inputDeclaration) {
        this.addSpaceIfNeeded();
        this.result.append(".input ");
        this.variableExpressionToString(inputDeclaration.value);
        this.needSpace = true;
    }

    private void localDeclarationToString(MFDataModel.LocalDeclaration localDeclaration) {
        this.addSpaceIfNeeded();
        this.result.append(".local $");
        this.result.append(localDeclaration.name);
        this.result.append(" = ");
        this.expressionToString(localDeclaration.value);
        this.needSpace = true;
    }

    private void variantToString(MFDataModel.Variant variant) {
        for (MFDataModel.LiteralOrCatchallKey literalOrCatchallKey : variant.keys) {
            this.result.append(' ');
            if (literalOrCatchallKey instanceof MFDataModel.CatchallKey) {
                this.result.append('*');
                continue;
            }
            this.literalToString((MFDataModel.Literal)literalOrCatchallKey);
        }
        this.result.append(' ');
        this.patternToString(variant.value);
    }

    private void addSpaceIfNeeded() {
        if (this.needSpace) {
            this.result.append(' ');
            this.needSpace = false;
        }
    }

    private void errorType(String string, Object object) {
        this.error("Unexpected '" + string + "' type: ", object);
    }

    private void error(String string, Object object) {
        this.error(string + object.getClass().getName());
    }

    private void error(String string) {
        throw new RuntimeException(string);
    }
}

