/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.message2;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.FormattedPlaceholder;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.Formatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.FormatterFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.OptUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.PlainStringFormattedValue;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.GregorianCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.SimpleTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;

class DateTimeFormatterFactory
implements FormatterFactory {
    private final String kind;
    private static final Pattern ISO_PATTERN = Pattern.compile("^(([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])){1}(T([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])(\\.[0-9]{1,3})?(Z|[+-]((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?$");

    DateTimeFormatterFactory(String string) {
        switch (string) {
            case "date": {
                break;
            }
            case "time": {
                break;
            }
            case "datetime": {
                break;
            }
            default: {
                string = "datetime";
            }
        }
        this.kind = string;
    }

    private static int stringToStyle(String string) {
        switch (string) {
            case "full": {
                return 0;
            }
            case "long": {
                return 1;
            }
            case "medium": {
                return 2;
            }
            case "short": {
                return 3;
            }
        }
        throw new IllegalArgumentException("Invalid datetime style: " + string);
    }

    @Override
    public Formatter createFormatter(Locale locale, Map<String, Object> map) {
        Object object;
        int n2 = -1;
        int n3 = -1;
        switch (this.kind) {
            case "date": {
                n2 = DateTimeFormatterFactory.getDateTimeStyle(map, "style");
                break;
            }
            case "time": {
                n3 = DateTimeFormatterFactory.getDateTimeStyle(map, "style");
                break;
            }
            default: {
                n2 = DateTimeFormatterFactory.getDateTimeStyle(map, "dateStyle");
                n3 = DateTimeFormatterFactory.getDateTimeStyle(map, "timeStyle");
            }
        }
        if (n2 == -1 && n3 == -1) {
            object = "";
            switch (this.kind) {
                case "date": {
                    object = DateTimeFormatterFactory.getDateFieldOptions(map);
                    break;
                }
                case "time": {
                    object = DateTimeFormatterFactory.getTimeFieldOptions(map);
                    break;
                }
                default: {
                    object = DateTimeFormatterFactory.getDateFieldOptions(map);
                    object = (String)object + DateTimeFormatterFactory.getTimeFieldOptions(map);
                }
            }
            if (((String)object).isEmpty()) {
                object = OptUtils.getString(map, "icu:skeleton", "");
            }
            if (!((String)object).isEmpty()) {
                Object object2 = DateFormat.getInstanceForSkeleton((String)object, locale);
                return new DateTimeFormatter(locale, (DateFormat)object2);
            }
            switch (this.kind) {
                case "date": {
                    n2 = 3;
                    n3 = -1;
                    break;
                }
                case "time": {
                    n2 = -1;
                    n3 = 3;
                    break;
                }
                default: {
                    n2 = 3;
                    n3 = 3;
                }
            }
        }
        object = DateFormat.getDateTimeInstance(n2, n3, locale);
        return new DateTimeFormatter(locale, (DateFormat)object);
    }

    private static int getDateTimeStyle(Map<String, Object> map, String string) {
        String string2 = OptUtils.getString(map, string);
        if (string2 != null) {
            return DateTimeFormatterFactory.stringToStyle(string2);
        }
        return -1;
    }

    private static String getDateFieldOptions(Map<String, Object> map) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        switch (string = OptUtils.getString(map, "weekday", "")) {
            case "long": {
                stringBuilder.append("EEEE");
                break;
            }
            case "short": {
                stringBuilder.append("E");
                break;
            }
            case "narrow": {
                stringBuilder.append("EEEEEE");
                break;
            }
        }
        switch (string = OptUtils.getString(map, "era", "")) {
            case "long": {
                stringBuilder.append("GGGG");
                break;
            }
            case "short": {
                stringBuilder.append("G");
                break;
            }
            case "narrow": {
                stringBuilder.append("GGGGG");
                break;
            }
        }
        switch (string = OptUtils.getString(map, "year", "")) {
            case "numeric": {
                stringBuilder.append("y");
                break;
            }
            case "2-digit": {
                stringBuilder.append("yy");
                break;
            }
        }
        switch (string = OptUtils.getString(map, "month", "")) {
            case "numeric": {
                stringBuilder.append("M");
                break;
            }
            case "2-digit": {
                stringBuilder.append("MM");
                break;
            }
            case "long": {
                stringBuilder.append("MMMM");
                break;
            }
            case "short": {
                stringBuilder.append("MMM");
                break;
            }
            case "narrow": {
                stringBuilder.append("MMMMM");
                break;
            }
        }
        switch (string = OptUtils.getString(map, "day", "")) {
            case "numeric": {
                stringBuilder.append("d");
                break;
            }
            case "2-digit": {
                stringBuilder.append("dd");
                break;
            }
        }
        return stringBuilder.toString();
    }

    private static String getTimeFieldOptions(Map<String, Object> map) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        switch (string = OptUtils.getString(map, "hour", "")) {
            case "numeric": {
                n2 = 1;
                break;
            }
            case "2-digit": {
                n2 = 2;
                break;
            }
        }
        if (n2 > 0) {
            String string2 = "";
            switch (string = OptUtils.getString(map, "hourCycle", "")) {
                case "h11": {
                    string2 = "K";
                    break;
                }
                case "h12": {
                    string2 = "h";
                    break;
                }
                case "h23": {
                    string2 = "H";
                    break;
                }
                case "h24": {
                    string2 = "k";
                    break;
                }
                default: {
                    string2 = "j";
                }
            }
            stringBuilder.append(string2);
            if (n2 == 2) {
                stringBuilder.append(string2);
            }
        }
        switch (string = OptUtils.getString(map, "minute", "")) {
            case "numeric": {
                stringBuilder.append("m");
                break;
            }
            case "2-digit": {
                stringBuilder.append("mm");
                break;
            }
        }
        switch (string = OptUtils.getString(map, "second", "")) {
            case "numeric": {
                stringBuilder.append("s");
                break;
            }
            case "2-digit": {
                stringBuilder.append("ss");
                break;
            }
        }
        switch (string = OptUtils.getString(map, "fractionalSecondDigits", "")) {
            case "1": {
                stringBuilder.append("S");
                break;
            }
            case "2": {
                stringBuilder.append("SS");
                break;
            }
            case "3": {
                stringBuilder.append("SSS");
                break;
            }
        }
        switch (string = OptUtils.getString(map, "timeZoneName", "")) {
            case "long": {
                stringBuilder.append("z");
                break;
            }
            case "short": {
                stringBuilder.append("zzzz");
                break;
            }
            case "shortOffset": {
                stringBuilder.append("O");
                break;
            }
            case "longOffset": {
                stringBuilder.append("OOOO");
                break;
            }
            case "shortGeneric": {
                stringBuilder.append("v");
                break;
            }
            case "longGeneric": {
                stringBuilder.append("vvvv");
                break;
            }
        }
        return stringBuilder.toString();
    }

    private static Integer safeParse(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return Integer.parseInt(string);
    }

    private static Object parseIso8601(String string) {
        Matcher matcher = ISO_PATTERN.matcher(string);
        if (matcher.find() && matcher.groupCount() == 12 && !matcher.group().isEmpty()) {
            String string2;
            Integer n2 = DateTimeFormatterFactory.safeParse(matcher.group(2));
            Integer n3 = DateTimeFormatterFactory.safeParse(matcher.group(3));
            Integer n4 = DateTimeFormatterFactory.safeParse(matcher.group(4));
            Integer n5 = DateTimeFormatterFactory.safeParse(matcher.group(6));
            Integer n6 = DateTimeFormatterFactory.safeParse(matcher.group(7));
            Integer n7 = DateTimeFormatterFactory.safeParse(matcher.group(8));
            Integer n8 = 0;
            if (matcher.group(9) != null) {
                string2 = (matcher.group(9) + "000").substring(1, 4);
                n8 = DateTimeFormatterFactory.safeParse(string2);
            } else {
                n8 = 0;
            }
            string2 = matcher.group(10);
            if (n5 == null) {
                n5 = 0;
                n6 = 0;
                n7 = 0;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4, n5, n6, n7);
            gregorianCalendar.set(14, n8);
            if (string2 != null) {
                if (string2.equals("Z")) {
                    gregorianCalendar.setTimeZone(TimeZone.GMT_ZONE);
                } else {
                    int n9 = string2.startsWith("-") ? -1 : 1;
                    String[] stringArray = string2.substring(1).split(":");
                    if (stringArray.length == 2) {
                        Integer n10 = DateTimeFormatterFactory.safeParse(stringArray[0]);
                        Integer n11 = DateTimeFormatterFactory.safeParse(stringArray[1]);
                        if (n10 != null && n11 != null) {
                            int n12 = n9 * (n10 * 60 + n11) * 60 * 1000;
                            gregorianCalendar.setTimeZone(new SimpleTimeZone(n12, "offset"));
                        }
                    }
                }
            }
            return gregorianCalendar;
        }
        return string;
    }

    private static class DateTimeFormatter
    implements Formatter {
        private final DateFormat icuFormatter;
        private final Locale locale;

        private DateTimeFormatter(Locale locale, DateFormat dateFormat) {
            this.locale = locale;
            this.icuFormatter = dateFormat;
        }

        @Override
        public FormattedPlaceholder format(Object object, Map<String, Object> map) {
            Object object2;
            if (object == null) {
                return null;
            }
            if (object instanceof CharSequence && (object = DateTimeFormatterFactory.parseIso8601(object.toString())) instanceof CharSequence) {
                return new FormattedPlaceholder(object, new PlainStringFormattedValue("{|" + object + "|}"));
            }
            if (object instanceof java.util.Calendar) {
                object2 = ((java.util.Calendar)object).getTimeZone();
                long l2 = ((java.util.Calendar)object).getTimeInMillis();
                TimeZone timeZone = TimeZone.getTimeZone(((java.util.TimeZone)object2).getID());
                Calendar calendar = Calendar.getInstance(timeZone, this.locale);
                calendar.setTimeInMillis(l2);
                object = calendar;
            }
            object2 = this.icuFormatter.format(object);
            return new FormattedPlaceholder(object, new PlainStringFormattedValue((String)object2));
        }

        @Override
        public String formatToString(Object object, Map<String, Object> map) {
            FormattedPlaceholder formattedPlaceholder = this.format(object, map);
            return formattedPlaceholder != null ? formattedPlaceholder.toString() : null;
        }
    }
}

