/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringSegment;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.CustomSymbolCurrency;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalFormatProperties;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Grouper;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PatternStringParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PropertiesAffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.AffixMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.AffixTokenMatcherFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.CombinedCurrencyMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.DecimalMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.IgnorablesMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.InfinityMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.MinusSignMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.MultiplierParseHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.NanMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.NumberParseMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.PaddingMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ParsedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.PercentMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.PermilleMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.PlusSignMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.RequireAffixValidator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.RequireCurrencyValidator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.RequireDecimalSeparatorValidator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.RequireNumberValidator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ScientificMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Scale;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CurrencyAmount;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class NumberParserImpl {
    private final int parseFlags;
    private final List<NumberParseMatcher> matchers = new ArrayList<NumberParseMatcher>();
    private boolean frozen;

    public static NumberParserImpl createSimpleParser(ULocale uLocale, String string, int n2) {
        NumberParserImpl numberParserImpl = new NumberParserImpl(n2);
        Currency currency = Currency.getInstance("USD");
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(uLocale);
        IgnorablesMatcher ignorablesMatcher = IgnorablesMatcher.getInstance(n2);
        AffixTokenMatcherFactory affixTokenMatcherFactory = new AffixTokenMatcherFactory();
        affixTokenMatcherFactory.currency = currency;
        affixTokenMatcherFactory.symbols = decimalFormatSymbols;
        affixTokenMatcherFactory.ignorables = ignorablesMatcher;
        affixTokenMatcherFactory.locale = uLocale;
        affixTokenMatcherFactory.parseFlags = n2;
        PatternStringParser.ParsedPatternInfo parsedPatternInfo = PatternStringParser.parseToPatternInfo(string);
        AffixMatcher.createMatchers(parsedPatternInfo, numberParserImpl, affixTokenMatcherFactory, ignorablesMatcher, n2);
        Grouper grouper = Grouper.forStrategy(NumberFormatter.GroupingStrategy.AUTO).withLocaleData(uLocale, parsedPatternInfo);
        numberParserImpl.addMatcher(ignorablesMatcher);
        numberParserImpl.addMatcher(DecimalMatcher.getInstance(decimalFormatSymbols, grouper, n2));
        numberParserImpl.addMatcher(MinusSignMatcher.getInstance(decimalFormatSymbols, false));
        numberParserImpl.addMatcher(PlusSignMatcher.getInstance(decimalFormatSymbols, false));
        numberParserImpl.addMatcher(PercentMatcher.getInstance(decimalFormatSymbols));
        numberParserImpl.addMatcher(PermilleMatcher.getInstance(decimalFormatSymbols));
        numberParserImpl.addMatcher(NanMatcher.getInstance(decimalFormatSymbols, n2));
        numberParserImpl.addMatcher(InfinityMatcher.getInstance(decimalFormatSymbols));
        numberParserImpl.addMatcher(PaddingMatcher.getInstance("@"));
        numberParserImpl.addMatcher(ScientificMatcher.getInstance(decimalFormatSymbols, grouper));
        numberParserImpl.addMatcher(CombinedCurrencyMatcher.getInstance(currency, decimalFormatSymbols, n2));
        numberParserImpl.addMatcher(new RequireNumberValidator());
        numberParserImpl.freeze();
        return numberParserImpl;
    }

    public static Number parseStatic(String string, ParsePosition parsePosition, DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols) {
        NumberParserImpl numberParserImpl = NumberParserImpl.createParserFromProperties(decimalFormatProperties, decimalFormatSymbols, false);
        ParsedNumber parsedNumber = new ParsedNumber();
        numberParserImpl.parse(string, true, parsedNumber);
        if (parsedNumber.success()) {
            parsePosition.setIndex(parsedNumber.charEnd);
            return parsedNumber.getNumber();
        }
        parsePosition.setErrorIndex(parsedNumber.charEnd);
        return null;
    }

    public static CurrencyAmount parseStaticCurrency(String string, ParsePosition parsePosition, DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols) {
        NumberParserImpl numberParserImpl = NumberParserImpl.createParserFromProperties(decimalFormatProperties, decimalFormatSymbols, true);
        ParsedNumber parsedNumber = new ParsedNumber();
        numberParserImpl.parse(string, true, parsedNumber);
        if (parsedNumber.success()) {
            parsePosition.setIndex(parsedNumber.charEnd);
            assert (parsedNumber.currencyCode != null);
            return new CurrencyAmount(parsedNumber.getNumber(), Currency.getInstance(parsedNumber.currencyCode));
        }
        parsePosition.setErrorIndex(parsedNumber.charEnd);
        return null;
    }

    public static NumberParserImpl createDefaultParserForLocale(ULocale uLocale) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(uLocale);
        DecimalFormatProperties decimalFormatProperties = PatternStringParser.parseToProperties("0");
        return NumberParserImpl.createParserFromProperties(decimalFormatProperties, decimalFormatSymbols, false);
    }

    public static NumberParserImpl createParserFromProperties(DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols, boolean bl2) {
        Scale scale;
        ULocale uLocale = decimalFormatSymbols.getULocale();
        AffixPatternProvider affixPatternProvider = PropertiesAffixPatternProvider.forProperties(decimalFormatProperties);
        Currency currency = CustomSymbolCurrency.resolve(decimalFormatProperties.getCurrency(), uLocale, decimalFormatSymbols);
        DecimalFormatProperties.ParseMode parseMode = decimalFormatProperties.getParseMode();
        if (parseMode == null) {
            parseMode = DecimalFormatProperties.ParseMode.LENIENT;
        }
        Grouper grouper = Grouper.forProperties(decimalFormatProperties);
        int n2 = 0;
        if (!decimalFormatProperties.getParseCaseSensitive()) {
            n2 |= 1;
        }
        if (decimalFormatProperties.getParseIntegerOnly()) {
            n2 |= 0x10;
        }
        if (decimalFormatProperties.getParseToBigDecimal()) {
            n2 |= 0x1000;
        }
        if (decimalFormatProperties.getSignAlwaysShown()) {
            n2 |= 0x400;
        }
        if (parseMode == DecimalFormatProperties.ParseMode.JAVA_COMPATIBILITY) {
            n2 |= 4;
            n2 |= 0x100;
            n2 |= 0x200;
            n2 |= 0x10000;
        } else if (parseMode == DecimalFormatProperties.ParseMode.STRICT) {
            n2 |= 8;
            n2 |= 4;
            n2 |= 0x100;
            n2 |= 0x200;
            n2 |= 0x8000;
        } else {
            n2 |= 0x80;
        }
        if (grouper.getPrimary() <= 0) {
            n2 |= 0x20;
        }
        if (bl2 || affixPatternProvider.hasCurrencySign()) {
            n2 |= 2;
        }
        if (!bl2) {
            n2 |= 0x2000;
        }
        NumberParserImpl numberParserImpl = new NumberParserImpl(n2);
        IgnorablesMatcher ignorablesMatcher = IgnorablesMatcher.getInstance(n2);
        AffixTokenMatcherFactory affixTokenMatcherFactory = new AffixTokenMatcherFactory();
        affixTokenMatcherFactory.currency = currency;
        affixTokenMatcherFactory.symbols = decimalFormatSymbols;
        affixTokenMatcherFactory.ignorables = ignorablesMatcher;
        affixTokenMatcherFactory.locale = uLocale;
        affixTokenMatcherFactory.parseFlags = n2;
        AffixMatcher.createMatchers(affixPatternProvider, numberParserImpl, affixTokenMatcherFactory, ignorablesMatcher, n2);
        if (bl2 || affixPatternProvider.hasCurrencySign()) {
            numberParserImpl.addMatcher(CombinedCurrencyMatcher.getInstance(currency, decimalFormatSymbols, n2));
        }
        if (parseMode == DecimalFormatProperties.ParseMode.LENIENT && affixPatternProvider.containsSymbolType(-4)) {
            numberParserImpl.addMatcher(PercentMatcher.getInstance(decimalFormatSymbols));
        }
        if (parseMode == DecimalFormatProperties.ParseMode.LENIENT && affixPatternProvider.containsSymbolType(-5)) {
            numberParserImpl.addMatcher(PermilleMatcher.getInstance(decimalFormatSymbols));
        }
        if (parseMode == DecimalFormatProperties.ParseMode.LENIENT) {
            numberParserImpl.addMatcher(PlusSignMatcher.getInstance(decimalFormatSymbols, false));
            numberParserImpl.addMatcher(MinusSignMatcher.getInstance(decimalFormatSymbols, false));
        }
        numberParserImpl.addMatcher(NanMatcher.getInstance(decimalFormatSymbols, n2));
        numberParserImpl.addMatcher(InfinityMatcher.getInstance(decimalFormatSymbols));
        String string = decimalFormatProperties.getPadString();
        if (string != null && !ignorablesMatcher.getSet().contains(string)) {
            numberParserImpl.addMatcher(PaddingMatcher.getInstance(string));
        }
        numberParserImpl.addMatcher(ignorablesMatcher);
        numberParserImpl.addMatcher(DecimalMatcher.getInstance(decimalFormatSymbols, grouper, n2));
        if (!decimalFormatProperties.getParseNoExponent() || decimalFormatProperties.getMinimumExponentDigits() > 0) {
            numberParserImpl.addMatcher(ScientificMatcher.getInstance(decimalFormatSymbols, grouper));
        }
        numberParserImpl.addMatcher(new RequireNumberValidator());
        if (parseMode != DecimalFormatProperties.ParseMode.LENIENT) {
            numberParserImpl.addMatcher(new RequireAffixValidator());
        }
        if (bl2) {
            numberParserImpl.addMatcher(new RequireCurrencyValidator());
        }
        if (decimalFormatProperties.getDecimalPatternMatchRequired()) {
            boolean bl3 = decimalFormatProperties.getDecimalSeparatorAlwaysShown() || decimalFormatProperties.getMaximumFractionDigits() != 0;
            numberParserImpl.addMatcher(RequireDecimalSeparatorValidator.getInstance(bl3));
        }
        if ((scale = RoundingUtils.scaleFromProperties(decimalFormatProperties)) != null) {
            numberParserImpl.addMatcher(new MultiplierParseHandler(scale));
        }
        numberParserImpl.freeze();
        return numberParserImpl;
    }

    public NumberParserImpl(int n2) {
        this.parseFlags = n2;
        this.frozen = false;
    }

    public void addMatcher(NumberParseMatcher numberParseMatcher) {
        assert (!this.frozen);
        this.matchers.add(numberParseMatcher);
    }

    public void addMatchers(Collection<? extends NumberParseMatcher> collection) {
        assert (!this.frozen);
        this.matchers.addAll(collection);
    }

    public void freeze() {
        this.frozen = true;
    }

    public int getParseFlags() {
        return this.parseFlags;
    }

    public void parse(String string, boolean bl2, ParsedNumber parsedNumber) {
        this.parse(string, 0, bl2, parsedNumber);
    }

    public void parse(String string, int n2, boolean bl2, ParsedNumber parsedNumber) {
        assert (this.frozen);
        assert (n2 >= 0 && n2 < string.length());
        StringSegment stringSegment = new StringSegment(string, 0 != (this.parseFlags & 1));
        stringSegment.adjustOffset(n2);
        if (bl2) {
            this.parseGreedy(stringSegment, parsedNumber);
        } else if (0 != (this.parseFlags & 0x4000)) {
            this.parseLongestRecursive(stringSegment, parsedNumber, 1);
        } else {
            this.parseLongestRecursive(stringSegment, parsedNumber, -100);
        }
        for (NumberParseMatcher numberParseMatcher : this.matchers) {
            numberParseMatcher.postProcess(parsedNumber);
        }
        parsedNumber.postProcess();
    }

    private void parseGreedy(StringSegment stringSegment, ParsedNumber parsedNumber) {
        int n2 = 0;
        while (n2 < this.matchers.size()) {
            if (stringSegment.length() == 0) {
                return;
            }
            NumberParseMatcher numberParseMatcher = this.matchers.get(n2);
            if (!numberParseMatcher.smokeTest(stringSegment)) {
                ++n2;
                continue;
            }
            int n3 = stringSegment.getOffset();
            numberParseMatcher.match(stringSegment, parsedNumber);
            if (stringSegment.getOffset() != n3) {
                n2 = 0;
                continue;
            }
            ++n2;
        }
    }

    private void parseLongestRecursive(StringSegment stringSegment, ParsedNumber parsedNumber, int n2) {
        if (stringSegment.length() == 0) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        ParsedNumber parsedNumber2 = new ParsedNumber();
        parsedNumber2.copyFrom(parsedNumber);
        ParsedNumber parsedNumber3 = new ParsedNumber();
        int n3 = stringSegment.getOffset();
        block0: for (int i2 = 0; i2 < this.matchers.size(); ++i2) {
            NumberParseMatcher numberParseMatcher = this.matchers.get(i2);
            if (!numberParseMatcher.smokeTest(stringSegment)) continue;
            int n4 = 0;
            while (n4 < stringSegment.length()) {
                n4 += Character.charCount(stringSegment.codePointAt(n4));
                parsedNumber3.copyFrom(parsedNumber2);
                stringSegment.setLength(n4);
                boolean bl2 = numberParseMatcher.match(stringSegment, parsedNumber3);
                stringSegment.resetLength();
                if (stringSegment.getOffset() - n3 == n4) {
                    this.parseLongestRecursive(stringSegment, parsedNumber3, n2 + 1);
                    if (parsedNumber3.isBetterThan(parsedNumber)) {
                        parsedNumber.copyFrom(parsedNumber3);
                    }
                }
                stringSegment.setOffset(n3);
                if (bl2) continue;
                continue block0;
            }
        }
    }

    public String toString() {
        return "<NumberParserImpl matchers=" + this.matchers.toString() + ">";
    }
}

