/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StaticUnicodeSets;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringSegment;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ParsedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.SymbolMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;

public class MinusSignMatcher
extends SymbolMatcher {
    private static final MinusSignMatcher DEFAULT = new MinusSignMatcher(false);
    private static final MinusSignMatcher DEFAULT_ALLOW_TRAILING = new MinusSignMatcher(true);
    private final boolean allowTrailing;

    public static MinusSignMatcher getInstance(DecimalFormatSymbols decimalFormatSymbols, boolean bl2) {
        String string = decimalFormatSymbols.getMinusSignString();
        if (MinusSignMatcher.DEFAULT.uniSet.contains(string)) {
            return bl2 ? DEFAULT_ALLOW_TRAILING : DEFAULT;
        }
        return new MinusSignMatcher(string, bl2);
    }

    private MinusSignMatcher(String string, boolean bl2) {
        super(string, MinusSignMatcher.DEFAULT.uniSet);
        this.allowTrailing = bl2;
    }

    private MinusSignMatcher(boolean bl2) {
        super(StaticUnicodeSets.Key.MINUS_SIGN);
        this.allowTrailing = bl2;
    }

    @Override
    protected boolean isDisabled(ParsedNumber parsedNumber) {
        return !this.allowTrailing && parsedNumber.seenNumber();
    }

    @Override
    protected void accept(StringSegment stringSegment, ParsedNumber parsedNumber) {
        parsedNumber.flags |= 1;
        parsedNumber.setCharsConsumed(stringSegment);
    }

    public String toString() {
        return "<MinusSignMatcher>";
    }
}

