/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringSegment;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.NumberParseMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ParsedNumber;

public class CodePointMatcher
implements NumberParseMatcher {
    private final int cp;

    public static CodePointMatcher getInstance(int n2) {
        return new CodePointMatcher(n2);
    }

    private CodePointMatcher(int n2) {
        this.cp = n2;
    }

    @Override
    public boolean match(StringSegment stringSegment, ParsedNumber parsedNumber) {
        if (stringSegment.startsWith(this.cp)) {
            stringSegment.adjustOffsetByCodePoint();
            parsedNumber.setCharsConsumed(stringSegment);
        }
        return false;
    }

    @Override
    public boolean smokeTest(StringSegment stringSegment) {
        return stringSegment.startsWith(this.cp);
    }

    @Override
    public void postProcess(ParsedNumber parsedNumber) {
    }

    public String toString() {
        return "<CodePointMatcher U+" + Integer.toHexString(this.cp) + ">";
    }
}

