/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.math.BigDecimal;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroPropsGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.ComplexUnitsConverter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.MeasureUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.UnitsRouter;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class UsagePrefsHandler
implements MicroPropsGenerator {
    private final MicroPropsGenerator fParent;
    private UnitsRouter fUnitsRouter;

    public UsagePrefsHandler(ULocale uLocale, MeasureUnit measureUnit, String string, MicroPropsGenerator microPropsGenerator) {
        assert (microPropsGenerator != null);
        this.fParent = microPropsGenerator;
        this.fUnitsRouter = new UnitsRouter(MeasureUnitImpl.forIdentifier(measureUnit.getIdentifier()), uLocale, string);
    }

    protected static void mixedMeasuresToMicros(ComplexUnitsConverter.ComplexConverterResult complexConverterResult, DecimalQuantity decimalQuantity, MicroProps microProps) {
        microProps.mixedMeasures = complexConverterResult.measures;
        microProps.indexOfQuantity = complexConverterResult.indexOfQuantity;
        decimalQuantity.setToBigDecimal((BigDecimal)microProps.mixedMeasures.get(microProps.indexOfQuantity).getNumber());
    }

    public List<MeasureUnit> getOutputUnits() {
        return this.fUnitsRouter.getOutputUnits();
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
        MicroProps microProps = this.fParent.processQuantity(decimalQuantity);
        decimalQuantity.roundToInfinity();
        UnitsRouter.RouteResult routeResult = this.fUnitsRouter.route(decimalQuantity.toBigDecimal(), microProps);
        microProps.outputUnit = routeResult.outputUnit.build();
        UsagePrefsHandler.mixedMeasuresToMicros(routeResult.complexConverterResult, decimalQuantity, microProps);
        return microProps;
    }
}

