/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.CurrencyPluralInfoAffixProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalFormatProperties;

public class PropertiesAffixPatternProvider
implements AffixPatternProvider {
    private final String posPrefix;
    private final String posSuffix;
    private final String negPrefix;
    private final String negSuffix;
    private final boolean isCurrencyPattern;
    private final boolean currencyAsDecimal;

    public static AffixPatternProvider forProperties(DecimalFormatProperties decimalFormatProperties) {
        if (decimalFormatProperties.getCurrencyPluralInfo() == null) {
            return new PropertiesAffixPatternProvider(decimalFormatProperties);
        }
        return new CurrencyPluralInfoAffixProvider(decimalFormatProperties.getCurrencyPluralInfo(), decimalFormatProperties);
    }

    PropertiesAffixPatternProvider(DecimalFormatProperties decimalFormatProperties) {
        String string = AffixUtils.escape(decimalFormatProperties.getPositivePrefix());
        String string2 = AffixUtils.escape(decimalFormatProperties.getPositiveSuffix());
        String string3 = AffixUtils.escape(decimalFormatProperties.getNegativePrefix());
        String string4 = AffixUtils.escape(decimalFormatProperties.getNegativeSuffix());
        String string5 = decimalFormatProperties.getPositivePrefixPattern();
        String string6 = decimalFormatProperties.getPositiveSuffixPattern();
        String string7 = decimalFormatProperties.getNegativePrefixPattern();
        String string8 = decimalFormatProperties.getNegativeSuffixPattern();
        this.posPrefix = string != null ? string : (string5 != null ? string5 : "");
        this.posSuffix = string2 != null ? string2 : (string6 != null ? string6 : "");
        if (string3 != null) {
            this.negPrefix = string3;
        } else if (string7 != null) {
            this.negPrefix = string7;
        } else {
            String string9 = this.negPrefix = string5 == null ? "-" : "-" + string5;
        }
        this.negSuffix = string4 != null ? string4 : (string8 != null ? string8 : (string6 == null ? "" : string6));
        this.isCurrencyPattern = AffixUtils.hasCurrencySymbols(string5) || AffixUtils.hasCurrencySymbols(string6) || AffixUtils.hasCurrencySymbols(string7) || AffixUtils.hasCurrencySymbols(string8) || decimalFormatProperties.getCurrencyAsDecimal();
        this.currencyAsDecimal = decimalFormatProperties.getCurrencyAsDecimal();
    }

    @Override
    public char charAt(int n2, int n3) {
        return this.getString(n2).charAt(n3);
    }

    @Override
    public int length(int n2) {
        return this.getString(n2).length();
    }

    @Override
    public String getString(int n2) {
        boolean bl2;
        boolean bl3 = (n2 & 0x100) != 0;
        boolean bl4 = bl2 = (n2 & 0x200) != 0;
        if (bl3 && bl2) {
            return this.negPrefix;
        }
        if (bl3) {
            return this.posPrefix;
        }
        if (bl2) {
            return this.negSuffix;
        }
        return this.posSuffix;
    }

    @Override
    public boolean positiveHasPlusSign() {
        return AffixUtils.containsType(this.posPrefix, -2) || AffixUtils.containsType(this.posSuffix, -2);
    }

    @Override
    public boolean hasNegativeSubpattern() {
        return this.negSuffix != this.posSuffix || this.negPrefix.length() != this.posPrefix.length() + 1 || !this.negPrefix.regionMatches(1, this.posPrefix, 0, this.posPrefix.length()) || this.negPrefix.charAt(0) != '-';
    }

    @Override
    public boolean negativeHasMinusSign() {
        return AffixUtils.containsType(this.negPrefix, -1) || AffixUtils.containsType(this.negSuffix, -1);
    }

    @Override
    public boolean hasCurrencySign() {
        return this.isCurrencyPattern;
    }

    @Override
    public boolean containsSymbolType(int n2) {
        return AffixUtils.containsType(this.posPrefix, n2) || AffixUtils.containsType(this.posSuffix, n2) || AffixUtils.containsType(this.negPrefix, n2) || AffixUtils.containsType(this.negSuffix, n2);
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public boolean currencyAsDecimal() {
        return this.currencyAsDecimal;
    }

    public String toString() {
        return super.toString() + " {" + this.posPrefix + "#" + this.posSuffix + ";" + this.negPrefix + "#" + this.negSuffix + "}";
    }
}

