/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalFormatProperties;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;

public class Padder {
    public static final String FALLBACK_PADDING_STRING = " ";
    public static final Padder NONE = new Padder(null, -1, null);
    String paddingString;
    int targetWidth;
    PadPosition position;

    public Padder(String string, int n2, PadPosition padPosition) {
        this.paddingString = string == null ? FALLBACK_PADDING_STRING : string;
        this.targetWidth = n2;
        this.position = padPosition == null ? PadPosition.BEFORE_PREFIX : padPosition;
    }

    public static Padder none() {
        return NONE;
    }

    public static Padder codePoints(int n2, int n3, PadPosition padPosition) {
        if (n3 >= 0) {
            String string = String.valueOf(Character.toChars(n2));
            return new Padder(string, n3, padPosition);
        }
        throw new IllegalArgumentException("Padding width must not be negative");
    }

    public static Padder forProperties(DecimalFormatProperties decimalFormatProperties) {
        return new Padder(decimalFormatProperties.getPadString(), decimalFormatProperties.getFormatWidth(), decimalFormatProperties.getPadPosition());
    }

    public boolean isValid() {
        return this.targetWidth > 0;
    }

    public int padAndApply(Modifier modifier, Modifier modifier2, FormattedStringBuilder formattedStringBuilder, int n2, int n3) {
        int n4 = modifier.getCodePointCount() + modifier2.getCodePointCount();
        int n5 = this.targetWidth - n4 - formattedStringBuilder.codePointCount();
        assert (n2 == 0 && n3 == formattedStringBuilder.length());
        int n6 = 0;
        if (n5 <= 0) {
            n6 += modifier.apply(formattedStringBuilder, n2, n3);
            n6 += modifier2.apply(formattedStringBuilder, n2, n3 + n6);
            return n6;
        }
        if (this.position == PadPosition.AFTER_PREFIX) {
            n6 += Padder.addPaddingHelper(this.paddingString, n5, formattedStringBuilder, n2);
        } else if (this.position == PadPosition.BEFORE_SUFFIX) {
            n6 += Padder.addPaddingHelper(this.paddingString, n5, formattedStringBuilder, n3 + n6);
        }
        n6 += modifier.apply(formattedStringBuilder, n2, n3 + n6);
        n6 += modifier2.apply(formattedStringBuilder, n2, n3 + n6);
        if (this.position == PadPosition.BEFORE_PREFIX) {
            n6 += Padder.addPaddingHelper(this.paddingString, n5, formattedStringBuilder, n2);
        } else if (this.position == PadPosition.AFTER_SUFFIX) {
            n6 += Padder.addPaddingHelper(this.paddingString, n5, formattedStringBuilder, n3 + n6);
        }
        return n6;
    }

    private static int addPaddingHelper(String string, int n2, FormattedStringBuilder formattedStringBuilder, int n3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            formattedStringBuilder.insert(n3, string, null);
        }
        return string.length() * n2;
    }

    public static enum PadPosition {
        BEFORE_PREFIX,
        AFTER_PREFIX,
        BEFORE_SUFFIX,
        AFTER_SUFFIX;


        public static PadPosition fromOld(int n2) {
            switch (n2) {
                case 0: {
                    return BEFORE_PREFIX;
                }
                case 1: {
                    return AFTER_PREFIX;
                }
                case 2: {
                    return BEFORE_SUFFIX;
                }
                case 3: {
                    return AFTER_SUFFIX;
                }
            }
            throw new IllegalArgumentException("Don't know how to map " + n2);
        }

        public int toOld() {
            switch (this) {
                case BEFORE_PREFIX: {
                    return 0;
                }
                case AFTER_PREFIX: {
                    return 1;
                }
                case BEFORE_SUFFIX: {
                    return 2;
                }
                case AFTER_SUFFIX: {
                    return 3;
                }
            }
            return -1;
        }
    }
}

