/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.MissingResourceException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CurrencyData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.LongNameMultiplexer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroPropsGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.ModifierStore;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.SimpleModifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.MeasureUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.SingleUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class LongNameHandler
implements LongNameMultiplexer.ParentlessMicroPropsGenerator,
MicroPropsGenerator,
ModifierStore {
    private static int i = 0;
    private static final int DNAM_INDEX = StandardPlural.COUNT + i++;
    private static final int PER_INDEX = StandardPlural.COUNT + i++;
    private static final int GENDER_INDEX = StandardPlural.COUNT + i++;
    static final int ARRAY_LENGTH = StandardPlural.COUNT + i++;
    private final Map<StandardPlural, SimpleModifier> modifiers;
    private final PluralRules rules;
    private final MicroPropsGenerator parent;
    private String gender = "";

    private static int getIndex(String string) {
        if (string.equals("dnam")) {
            return DNAM_INDEX;
        }
        if (string.equals("per")) {
            return PER_INDEX;
        }
        if (string.equals("gender")) {
            return GENDER_INDEX;
        }
        return StandardPlural.fromString(string).ordinal();
    }

    static String getWithPlural(String[] stringArray, StandardPlural standardPlural) {
        String string = stringArray[standardPlural.ordinal()];
        if (string == null) {
            string = stringArray[StandardPlural.OTHER.ordinal()];
        }
        if (string == null) {
            throw new ICUException("Could not find data in 'other' plural variant");
        }
        return string;
    }

    private static ExtractCorePatternResult extractCorePattern(String string) {
        ExtractCorePatternResult extractCorePatternResult = new ExtractCorePatternResult();
        extractCorePatternResult.joinerChar = '\u0000';
        int n2 = string.length();
        if (string.startsWith("{0}")) {
            extractCorePatternResult.placeholderPosition = PlaceholderPosition.BEGINNING;
            if (n2 > 3 && Character.isSpaceChar(string.charAt(3))) {
                extractCorePatternResult.joinerChar = string.charAt(3);
                extractCorePatternResult.coreUnit = string.substring(4);
            } else {
                extractCorePatternResult.coreUnit = string.substring(3);
            }
        } else if (string.endsWith("{0}")) {
            extractCorePatternResult.placeholderPosition = PlaceholderPosition.END;
            if (Character.isSpaceChar(string.charAt(n2 - 4))) {
                extractCorePatternResult.coreUnit = string.substring(0, n2 - 4);
                extractCorePatternResult.joinerChar = string.charAt(n2 - 4);
            } else {
                extractCorePatternResult.coreUnit = string.substring(0, n2 - 3);
            }
        } else if (string.indexOf("{0}", 1) == -1) {
            extractCorePatternResult.placeholderPosition = PlaceholderPosition.NONE;
            extractCorePatternResult.coreUnit = string;
        } else {
            extractCorePatternResult.placeholderPosition = PlaceholderPosition.MIDDLE;
            extractCorePatternResult.coreUnit = string;
        }
        return extractCorePatternResult;
    }

    private static String getGenderForBuiltin(ULocale uLocale, MeasureUnit measureUnit) {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/unit", uLocale);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("units/");
        stringBuilder.append(measureUnit.getType());
        stringBuilder.append("/");
        if (measureUnit.getSubtype() != null && measureUnit.getSubtype().endsWith("-person")) {
            stringBuilder.append(measureUnit.getSubtype(), 0, measureUnit.getSubtype().length() - 7);
        } else {
            stringBuilder.append(measureUnit.getSubtype());
        }
        stringBuilder.append("/gender");
        try {
            return iCUResourceBundle.getWithFallback(stringBuilder.toString()).getString();
        }
        catch (MissingResourceException missingResourceException) {
            return "";
        }
    }

    static void getInflectedMeasureData(String string, ULocale uLocale, NumberFormatter.UnitWidth unitWidth, String string2, String string3, String[] stringArray) {
        InflectedPluralSink inflectedPluralSink = new InflectedPluralSink(string2, string3, stringArray);
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/unit", uLocale);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("units");
        if (unitWidth == NumberFormatter.UnitWidth.NARROW) {
            stringBuilder.append("Narrow");
        } else if (unitWidth == NumberFormatter.UnitWidth.SHORT) {
            stringBuilder.append("Short");
        }
        stringBuilder.append("/");
        stringBuilder.append(string);
        try {
            iCUResourceBundle.getAllItemsWithFallback(stringBuilder.toString(), inflectedPluralSink);
            if (unitWidth == NumberFormatter.UnitWidth.SHORT) {
                return;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        iCUResourceBundle.getAllItemsWithFallback(stringBuilder.toString(), inflectedPluralSink);
    }

    static void getMeasureData(ULocale uLocale, MeasureUnit measureUnit, NumberFormatter.UnitWidth unitWidth, String string, String[] stringArray) {
        StringBuilder stringBuilder;
        PluralTableSink pluralTableSink = new PluralTableSink(stringArray);
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/unit", uLocale);
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("/");
        stringBuilder2.append(measureUnit.getType());
        stringBuilder2.append("/");
        String string2 = measureUnit.getSubtype();
        ICUResourceBundle iCUResourceBundle2 = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "metadata");
        AliasSink aliasSink = new AliasSink();
        iCUResourceBundle2.getAllItemsWithFallbackNoFail("alias/unit/" + string2, aliasSink);
        if (aliasSink.replacement != null) {
            string2 = aliasSink.replacement;
        }
        if (string2 != null && string2.endsWith("-person")) {
            stringBuilder2.append(string2, 0, string2.length() - 7);
        } else {
            stringBuilder2.append(string2);
        }
        if (unitWidth != NumberFormatter.UnitWidth.FULL_NAME) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("units");
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("/gender");
            try {
                stringArray[LongNameHandler.GENDER_INDEX] = iCUResourceBundle.getWithFallback(stringBuilder.toString()).getString();
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append("units");
        if (unitWidth == NumberFormatter.UnitWidth.NARROW) {
            stringBuilder.append("Narrow");
        } else if (unitWidth == NumberFormatter.UnitWidth.SHORT) {
            stringBuilder.append("Short");
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        if (unitWidth == NumberFormatter.UnitWidth.FULL_NAME && string != null && !string.isEmpty()) {
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append((CharSequence)stringBuilder);
            stringBuilder3.append("/case/");
            stringBuilder3.append(string);
            try {
                iCUResourceBundle.getAllItemsWithFallback(stringBuilder3.toString(), pluralTableSink);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            iCUResourceBundle.getAllItemsWithFallback(stringBuilder.toString(), pluralTableSink);
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("No data for unit " + measureUnit + ", width " + (Object)((Object)unitWidth), missingResourceException);
        }
    }

    private static void getCurrencyLongNameData(ULocale uLocale, Currency currency, String[] stringArray) {
        Map<String, String> map = CurrencyData.provider.getInstance(uLocale, true).getUnitPatterns();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            int n2 = LongNameHandler.getIndex(string);
            String string2 = currency.getName(uLocale, 2, string, null);
            String string3 = entry.getValue();
            stringArray[n2] = string3 = string3.replace("{1}", string2);
        }
    }

    private static String getCompoundValue(String string, ULocale uLocale, NumberFormatter.UnitWidth unitWidth) {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/unit", uLocale);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("units");
        if (unitWidth == NumberFormatter.UnitWidth.NARROW) {
            stringBuilder.append("Narrow");
        } else if (unitWidth == NumberFormatter.UnitWidth.SHORT) {
            stringBuilder.append("Short");
        }
        stringBuilder.append("/compound/");
        stringBuilder.append(string);
        try {
            return iCUResourceBundle.getStringWithFallback(stringBuilder.toString());
        }
        catch (MissingResourceException missingResourceException) {
            if (unitWidth == NumberFormatter.UnitWidth.SHORT) {
                return "";
            }
            try {
                return iCUResourceBundle.getStringWithFallback(stringBuilder.toString());
            }
            catch (MissingResourceException missingResourceException2) {
                return "";
            }
        }
    }

    private static String getDeriveCompoundRule(ULocale uLocale, String string, String string2) {
        ICUResourceBundle iCUResourceBundle;
        ICUResourceBundle iCUResourceBundle2 = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "grammaticalFeatures");
        iCUResourceBundle2 = (ICUResourceBundle)iCUResourceBundle2.get("grammaticalData");
        iCUResourceBundle2 = (ICUResourceBundle)iCUResourceBundle2.get("derivations");
        try {
            iCUResourceBundle = (ICUResourceBundle)iCUResourceBundle2.get(uLocale.getLanguage());
        }
        catch (MissingResourceException missingResourceException) {
            iCUResourceBundle = (ICUResourceBundle)iCUResourceBundle2.get("root");
        }
        iCUResourceBundle = (ICUResourceBundle)iCUResourceBundle.get("compound");
        iCUResourceBundle = (ICUResourceBundle)iCUResourceBundle.get(string);
        return iCUResourceBundle.getString(string2);
    }

    private static String getDerivedGender(ULocale uLocale, String string, String[] stringArray, String[] stringArray2) {
        String string2 = LongNameHandler.getDeriveCompoundRule(uLocale, "gender", string);
        if (string2.length() == 1) {
            switch (string2.charAt(0)) {
                case '0': {
                    return stringArray[GENDER_INDEX];
                }
                case '1': {
                    if (stringArray2 == null) {
                        return null;
                    }
                    return stringArray2[GENDER_INDEX];
                }
            }
        }
        return string2;
    }

    private static String calculateGenderForUnit(ULocale uLocale, MeasureUnit measureUnit) {
        String string;
        String string2;
        MeasureUnitImpl measureUnitImpl = measureUnit.getCopyOfMeasureUnitImpl();
        ArrayList<SingleUnitImpl> arrayList = measureUnitImpl.getSingleUnits();
        int n2 = 0;
        if (measureUnitImpl.getComplexity() == MeasureUnit.Complexity.COMPOUND) {
            String string3;
            int n3;
            int n4 = 0;
            assert (n3 > 0) : "COMPOUND units have more than one single unit";
            if (arrayList.get(n3).getDimensionality() < 0) {
                string3 = LongNameHandler.getDeriveCompoundRule(uLocale, "gender", "per");
                if (string3.length() != 1) {
                    return string3;
                }
                if (string3.charAt(0) == '1') {
                    while (arrayList.get(n4).getDimensionality() >= 0) {
                        ++n4;
                    }
                } else {
                    for (n3 = arrayList.size() - 1; n3 >= 0 && arrayList.get(n3).getDimensionality() < 0; --n3) {
                    }
                    if (n3 < 0) {
                        return "";
                    }
                }
            }
            if (n3 > n4) {
                string3 = LongNameHandler.getDeriveCompoundRule(uLocale, "gender", "times");
                if (string3.length() != 1) {
                    return string3;
                }
                if (string3.charAt(0) == '0') {
                    n3 = n4;
                } else {
                    n4 = n3;
                }
            }
            assert (n4 == n3);
            n2 = n4;
        } else {
            if (measureUnitImpl.getComplexity() == MeasureUnit.Complexity.MIXED) {
                throw new ICUException("calculateGenderForUnit does not support MIXED units");
            }
            assert (measureUnitImpl.getComplexity() == MeasureUnit.Complexity.SINGLE);
            assert (arrayList.size() == 1);
        }
        SingleUnitImpl singleUnitImpl = arrayList.get(n2);
        if (Math.abs(singleUnitImpl.getDimensionality()) != 1 && (string2 = LongNameHandler.getDeriveCompoundRule(uLocale, "gender", "power")).length() != 1) {
            return string2;
        }
        if (Math.abs(singleUnitImpl.getDimensionality()) != 1 && (string = LongNameHandler.getDeriveCompoundRule(uLocale, "gender", "prefix")).length() != 1) {
            return string;
        }
        return LongNameHandler.getGenderForBuiltin(uLocale, MeasureUnit.forIdentifier(singleUnitImpl.getSimpleUnitID()));
    }

    private static void maybeCalculateGender(ULocale uLocale, MeasureUnit measureUnit, String[] stringArray) {
        if (stringArray[GENDER_INDEX] == null) {
            String string = LongNameHandler.getGenderForBuiltin(uLocale, MeasureUnit.METER);
            if (string.isEmpty()) {
                return;
            }
            stringArray[LongNameHandler.GENDER_INDEX] = LongNameHandler.calculateGenderForUnit(uLocale, measureUnit);
        }
    }

    private LongNameHandler(Map<StandardPlural, SimpleModifier> map, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        this.modifiers = map;
        this.rules = pluralRules;
        this.parent = microPropsGenerator;
    }

    public static String getUnitDisplayName(ULocale uLocale, MeasureUnit measureUnit, NumberFormatter.UnitWidth unitWidth) {
        String[] stringArray = new String[ARRAY_LENGTH];
        LongNameHandler.getMeasureData(uLocale, measureUnit, unitWidth, "", stringArray);
        return stringArray[DNAM_INDEX];
    }

    public static LongNameHandler forCurrencyLongNames(ULocale uLocale, Currency currency, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        String[] stringArray = new String[ARRAY_LENGTH];
        LongNameHandler.getCurrencyLongNameData(uLocale, currency, stringArray);
        EnumMap<StandardPlural, SimpleModifier> enumMap = new EnumMap<StandardPlural, SimpleModifier>(StandardPlural.class);
        LongNameHandler longNameHandler = new LongNameHandler(enumMap, pluralRules, microPropsGenerator);
        longNameHandler.simpleFormatsToModifiers(stringArray, NumberFormat.Field.CURRENCY);
        return longNameHandler;
    }

    public static LongNameHandler forMeasureUnit(ULocale uLocale, MeasureUnit measureUnit, NumberFormatter.UnitWidth unitWidth, String string, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        if (measureUnit.getType() != null) {
            String[] stringArray = new String[ARRAY_LENGTH];
            LongNameHandler.getMeasureData(uLocale, measureUnit, unitWidth, string, stringArray);
            LongNameHandler.maybeCalculateGender(uLocale, measureUnit, stringArray);
            EnumMap<StandardPlural, SimpleModifier> enumMap = new EnumMap<StandardPlural, SimpleModifier>(StandardPlural.class);
            LongNameHandler longNameHandler = new LongNameHandler(enumMap, pluralRules, microPropsGenerator);
            longNameHandler.simpleFormatsToModifiers(stringArray, NumberFormat.Field.MEASURE_UNIT);
            if (stringArray[GENDER_INDEX] != null) {
                longNameHandler.gender = stringArray[GENDER_INDEX];
            }
            return longNameHandler;
        }
        assert (measureUnit.getComplexity() != MeasureUnit.Complexity.MIXED) : "Mixed units not supported by LongNameHandler: use MixedUnitLongNameHandler";
        return LongNameHandler.forArbitraryUnit(uLocale, measureUnit, unitWidth, string, pluralRules, microPropsGenerator);
    }

    private static LongNameHandler forArbitraryUnit(ULocale uLocale, MeasureUnit measureUnit, NumberFormatter.UnitWidth unitWidth, String string, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        Object object;
        Serializable serializable;
        MeasureUnitImpl measureUnitImpl = measureUnit.getCopyOfMeasureUnitImpl();
        measureUnit = null;
        MeasureUnit measureUnit2 = null;
        for (SingleUnitImpl object22 : measureUnitImpl.getSingleUnits()) {
            if (object22.getDimensionality() > 0) {
                if (measureUnit == null) {
                    measureUnit = object22.build();
                    continue;
                }
                measureUnit = measureUnit.product(object22.build());
                continue;
            }
            object22.setDimensionality(object22.getDimensionality() * -1);
            if (measureUnit2 == null) {
                measureUnit2 = object22.build();
                continue;
            }
            measureUnit2 = measureUnit2.product(object22.build());
        }
        MeasureUnitImpl measureUnitImpl2 = measureUnit == null ? null : measureUnit.getCopyOfMeasureUnitImpl();
        MeasureUnitImpl measureUnitImpl3 = measureUnit2 == null ? null : measureUnit2.getCopyOfMeasureUnitImpl();
        DerivedComponents derivedComponents = new DerivedComponents(uLocale, "case", "per");
        String[] stringArray = new String[ARRAY_LENGTH];
        LongNameHandler.processPatternTimes(measureUnitImpl2, uLocale, unitWidth, derivedComponents.value0(string), stringArray);
        String[] stringArray2 = new String[ARRAY_LENGTH];
        LongNameHandler.processPatternTimes(measureUnitImpl3, uLocale, unitWidth, derivedComponents.value1(string), stringArray2);
        String string2 = null;
        if (stringArray2[PER_INDEX] != null) {
            string2 = stringArray2[PER_INDEX];
        } else {
            serializable = new StringBuilder();
            object = LongNameHandler.getCompoundValue("per", uLocale, unitWidth);
            String string3 = SimpleFormatterImpl.compileToStringMinMaxArguments((CharSequence)object, serializable, 2, 2);
            String string4 = LongNameHandler.getWithPlural(stringArray2, StandardPlural.ONE);
            String string5 = SimpleFormatterImpl.compileToStringMinMaxArguments(string4, serializable, 0, 1);
            String string6 = PatternProps.trimSpaceChar(SimpleFormatterImpl.getTextWithNoArguments(string5));
            string2 = SimpleFormatterImpl.formatCompiledPattern(string3, "{0}", string6);
        }
        serializable = new EnumMap(StandardPlural.class);
        object = new LongNameHandler((Map<StandardPlural, SimpleModifier>)((Object)serializable), pluralRules, microPropsGenerator);
        if (string2.length() == 0) {
            super.simpleFormatsToModifiers(stringArray, NumberFormat.Field.MEASURE_UNIT);
        } else {
            super.multiSimpleFormatsToModifiers(stringArray, string2, NumberFormat.Field.MEASURE_UNIT);
        }
        ((LongNameHandler)object).gender = LongNameHandler.getDerivedGender(uLocale, "per", stringArray, stringArray2);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static void processPatternTimes(MeasureUnitImpl measureUnitImpl, ULocale uLocale, NumberFormatter.UnitWidth unitWidth, String string, String[] stringArray) {
        assert (stringArray[StandardPlural.OTHER.ordinal()] == null) : "outArray must have only null values!";
        assert (stringArray[PER_INDEX] == null) : "outArray must have only null values!";
        if (measureUnitImpl == null) {
            stringArray[StandardPlural.OTHER.ordinal()] = "";
            stringArray[LongNameHandler.PER_INDEX] = "";
            return;
        }
        if (measureUnitImpl.getComplexity() == MeasureUnit.Complexity.MIXED) {
            throw new UnsupportedOperationException("Mixed units not supported by LongNameHandler");
        }
        if (measureUnitImpl.getIdentifier() == null) {
            measureUnitImpl.serialize();
        }
        if (measureUnitImpl.getIdentifier().length() == 0) {
            return;
        }
        MeasureUnit measureUnit = MeasureUnit.findBySubType(measureUnitImpl.getIdentifier());
        if (measureUnit != null) {
            LongNameHandler.getMeasureData(uLocale, measureUnit, unitWidth, string, stringArray);
            LongNameHandler.maybeCalculateGender(uLocale, measureUnit, stringArray);
            return;
        }
        String string2 = LongNameHandler.getCompoundValue("times", uLocale, unitWidth);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = SimpleFormatterImpl.compileToStringMinMaxArguments(string2, stringBuilder, 2, 2);
        PlaceholderPosition[] placeholderPositionArray = new PlaceholderPosition[ARRAY_LENGTH];
        char c2 = '\u0000';
        for (StandardPlural standardPlural : StandardPlural.values()) {
            int n2 = standardPlural.ordinal();
            stringArray[n2] = standardPlural == StandardPlural.OTHER ? "" : null;
            placeholderPositionArray[n2] = null;
        }
        Object var11_12 = null;
        DerivedComponents derivedComponents = new DerivedComponents(uLocale, "plural", "times");
        DerivedComponents derivedComponents2 = new DerivedComponents(uLocale, "case", "times");
        DerivedComponents derivedComponents3 = new DerivedComponents(uLocale, "case", "power");
        ArrayList<SingleUnitImpl> arrayList = measureUnitImpl.getSingleUnits();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string4;
            void var11_13;
            SingleUnitImpl singleUnitImpl = arrayList.get(i2);
            if (i2 < arrayList.size() - 1) {
                string4 = derivedComponents.value0((String)var11_13);
                object4 = derivedComponents2.value0(string);
                String string5 = derivedComponents.value1((String)var11_13);
                string = derivedComponents2.value1(string);
            } else {
                string4 = derivedComponents.value1((String)var11_13);
                object4 = derivedComponents2.value1(string);
            }
            measureUnit = MeasureUnit.findBySubType(singleUnitImpl.getSimpleUnitID());
            if (measureUnit == null) {
                throw new UnsupportedOperationException("Unsupported sinlgeUnit: " + singleUnitImpl.getSimpleUnitID());
            }
            String string6 = LongNameHandler.getGenderForBuiltin(uLocale, measureUnit);
            assert (singleUnitImpl.getDimensionality() > 0);
            int n3 = singleUnitImpl.getDimensionality();
            String[] stringArray2 = new String[ARRAY_LENGTH];
            if (n3 != 1) {
                object3 = new StringBuilder("compound/power");
                ((StringBuilder)object3).append(n3);
                try {
                    LongNameHandler.getInflectedMeasureData(((StringBuilder)object3).toString(), uLocale, unitWidth, string6, (String)object4, stringArray2);
                }
                catch (MissingResourceException missingResourceException) {
                    if (n3 > 3) {
                        throw new UnsupportedOperationException("powerN not supported for N > 3: " + measureUnitImpl.getIdentifier());
                    }
                    throw missingResourceException;
                }
                object4 = derivedComponents3.value0((String)object4);
                singleUnitImpl.setDimensionality(1);
            }
            object3 = singleUnitImpl.getPrefix();
            String string7 = "";
            if (object3 != MeasureUnit.MeasurePrefix.ONE) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(((MeasureUnit.MeasurePrefix)((Object)object3)).getBase());
                ((StringBuilder)object2).append('p');
                ((StringBuilder)object2).append(((MeasureUnit.MeasurePrefix)((Object)object3)).getPower());
                string7 = LongNameHandler.getCompoundValue(((StringBuilder)object2).toString(), uLocale, unitWidth);
                singleUnitImpl.setPrefix(MeasureUnit.MeasurePrefix.ONE);
            }
            object2 = new String[ARRAY_LENGTH];
            assert (singleUnitImpl.build().getIdentifier().equals(singleUnitImpl.getSimpleUnitID())) : "Should be equal: singleUnit.build().getIdentifier() produced " + singleUnitImpl.build().getIdentifier() + ", singleUnit.getSimpleUnitID() produced " + singleUnitImpl.getSimpleUnitID();
            LongNameHandler.getMeasureData(uLocale, singleUnitImpl.build(), unitWidth, (String)object4, (String[])object2);
            if (object2[GENDER_INDEX] != null) {
                assert (!((String)object2[GENDER_INDEX]).isEmpty());
                if (object3 != MeasureUnit.MeasurePrefix.ONE) {
                    object2[LongNameHandler.GENDER_INDEX] = LongNameHandler.getDerivedGender(uLocale, "prefix", (String[])object2, null);
                }
                if (n3 != 1) {
                    object2[LongNameHandler.GENDER_INDEX] = LongNameHandler.getDerivedGender(uLocale, "power", (String[])object2, null);
                }
                if (((String)(object = LongNameHandler.getDeriveCompoundRule(uLocale, "gender", "times"))).length() == 1) {
                    switch (((String)object).charAt(0)) {
                        case '0': {
                            if (i2 != 0) break;
                            assert (stringArray[GENDER_INDEX] == null);
                            stringArray[LongNameHandler.GENDER_INDEX] = object2[GENDER_INDEX];
                            break;
                        }
                        case '1': {
                            if (i2 != arrayList.size() - 1) break;
                            assert (stringArray[GENDER_INDEX] == null);
                            stringArray[LongNameHandler.GENDER_INDEX] = object2[GENDER_INDEX];
                        }
                    }
                } else if (stringArray[GENDER_INDEX] == null) {
                    stringArray[LongNameHandler.GENDER_INDEX] = object;
                }
            }
            object = StandardPlural.values();
            int n4 = ((StandardPlural[])object).length;
            for (int i3 = 0; i3 < n4; ++i3) {
                String string8;
                StandardPlural standardPlural = object[i3];
                StandardPlural standardPlural2 = standardPlural;
                int n5 = standardPlural2.ordinal();
                if (stringArray[n5] == null) {
                    if (object2[n5] == null) continue;
                    stringArray[n5] = LongNameHandler.getWithPlural(stringArray, standardPlural2);
                }
                if (string4 != null) {
                    standardPlural2 = StandardPlural.fromString(string4);
                }
                ExtractCorePatternResult extractCorePatternResult = LongNameHandler.extractCorePattern(LongNameHandler.getWithPlural((String[])object2, standardPlural2));
                if (extractCorePatternResult.placeholderPosition == PlaceholderPosition.MIDDLE) {
                    throw new UnsupportedOperationException();
                }
                if (placeholderPositionArray[n5] == null) {
                    placeholderPositionArray[n5] = extractCorePatternResult.placeholderPosition;
                    c2 = extractCorePatternResult.joinerChar;
                } else assert (placeholderPositionArray[n5] == extractCorePatternResult.placeholderPosition);
                if (object3 != MeasureUnit.MeasurePrefix.ONE) {
                    string8 = SimpleFormatterImpl.compileToStringMinMaxArguments(string7, stringBuilder, 1, 1);
                    if (unitWidth == NumberFormatter.UnitWidth.FULL_NAME) {
                        extractCorePatternResult.coreUnit = UCharacter.toLowerCase(uLocale, extractCorePatternResult.coreUnit);
                    }
                    extractCorePatternResult.coreUnit = SimpleFormatterImpl.formatCompiledPattern(string8, extractCorePatternResult.coreUnit);
                }
                if (n3 != 1) {
                    string8 = SimpleFormatterImpl.compileToStringMinMaxArguments(LongNameHandler.getWithPlural(stringArray2, standardPlural2), stringBuilder, 1, 1);
                    if (unitWidth == NumberFormatter.UnitWidth.FULL_NAME) {
                        extractCorePatternResult.coreUnit = UCharacter.toLowerCase(uLocale, extractCorePatternResult.coreUnit);
                    }
                    extractCorePatternResult.coreUnit = SimpleFormatterImpl.formatCompiledPattern(string8, extractCorePatternResult.coreUnit);
                }
                stringArray[n5] = stringArray[n5].length() == 0 ? extractCorePatternResult.coreUnit : SimpleFormatterImpl.formatCompiledPattern(string3, stringArray[n5], extractCorePatternResult.coreUnit);
            }
        }
        for (Object object4 : StandardPlural.values()) {
            int n6 = object4.ordinal();
            if (placeholderPositionArray[n6] == PlaceholderPosition.BEGINNING) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("{0}");
                if (c2 != '\u0000') {
                    stringBuilder2.append(c2);
                }
                stringBuilder2.append(stringArray[n6]);
                stringArray[n6] = stringBuilder2.toString();
                continue;
            }
            if (placeholderPositionArray[n6] != PlaceholderPosition.END) continue;
            if (c2 != '\u0000') {
                stringArray[n6] = stringArray[n6] + c2;
            }
            stringArray[n6] = stringArray[n6] + "{0}";
        }
    }

    private void simpleFormatsToModifiers(String[] stringArray, NumberFormat.Field field) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StandardPlural standardPlural : StandardPlural.VALUES) {
            String string = LongNameHandler.getWithPlural(stringArray, standardPlural);
            String string2 = SimpleFormatterImpl.compileToStringMinMaxArguments(string, stringBuilder, 0, 1);
            Modifier.Parameters parameters = new Modifier.Parameters();
            parameters.obj = this;
            parameters.signum = null;
            parameters.plural = standardPlural;
            this.modifiers.put(standardPlural, new SimpleModifier(string2, field, false, parameters));
        }
    }

    private void multiSimpleFormatsToModifiers(String[] stringArray, String string, NumberFormat.Field field) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = SimpleFormatterImpl.compileToStringMinMaxArguments(string, stringBuilder, 1, 1);
        for (StandardPlural standardPlural : StandardPlural.VALUES) {
            String string3 = LongNameHandler.getWithPlural(stringArray, standardPlural);
            String string4 = string3.length() == 0 ? string : SimpleFormatterImpl.formatCompiledPattern(string2, string3);
            String string5 = SimpleFormatterImpl.compileToStringMinMaxArguments(string4, stringBuilder, 0, 1);
            Modifier.Parameters parameters = new Modifier.Parameters();
            parameters.obj = this;
            parameters.signum = null;
            parameters.plural = standardPlural;
            this.modifiers.put(standardPlural, new SimpleModifier(string5, field, false, parameters));
        }
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
        MicroProps microProps = this.parent.processQuantity(decimalQuantity);
        StandardPlural standardPlural = RoundingUtils.getPluralSafe(microProps.rounder, this.rules, decimalQuantity);
        microProps.modOuter = this.modifiers.get((Object)standardPlural);
        microProps.gender = this.gender;
        return microProps;
    }

    @Override
    public MicroProps processQuantityWithMicros(DecimalQuantity decimalQuantity, MicroProps microProps) {
        StandardPlural standardPlural = RoundingUtils.getPluralSafe(microProps.rounder, this.rules, decimalQuantity);
        microProps.modOuter = this.modifiers.get((Object)standardPlural);
        return microProps;
    }

    @Override
    public Modifier getModifier(Modifier.Signum signum, StandardPlural standardPlural) {
        return this.modifiers.get((Object)standardPlural);
    }

    private static class DerivedComponents {
        private String value0 = "";
        private String value1 = "";

        DerivedComponents(ULocale uLocale, String string, String string2) {
            try {
                ICUResourceBundle iCUResourceBundle;
                ICUResourceBundle iCUResourceBundle2 = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "grammaticalFeatures");
                iCUResourceBundle2 = (ICUResourceBundle)iCUResourceBundle2.get("grammaticalData");
                iCUResourceBundle2 = (ICUResourceBundle)iCUResourceBundle2.get("derivations");
                try {
                    iCUResourceBundle = (ICUResourceBundle)iCUResourceBundle2.get(uLocale.getLanguage());
                }
                catch (MissingResourceException missingResourceException) {
                    iCUResourceBundle = (ICUResourceBundle)iCUResourceBundle2.get("root");
                }
                iCUResourceBundle = (ICUResourceBundle)iCUResourceBundle.get("component");
                iCUResourceBundle = (ICUResourceBundle)iCUResourceBundle.get(string);
                iCUResourceBundle = (ICUResourceBundle)iCUResourceBundle.get(string2);
                String string3 = iCUResourceBundle.getString(0);
                this.value0 = string3.compareTo("compound") == 0 ? null : string3;
                string3 = iCUResourceBundle.getString(1);
                this.value1 = string3.compareTo("compound") == 0 ? null : string3;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }

        String value0(String string) {
            return this.value0 != null ? this.value0 : string;
        }

        String value1(String string) {
            return this.value1 != null ? this.value1 : string;
        }
    }

    private static final class AliasSink
    extends UResource.Sink {
        String replacement;

        private AliasSink() {
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                String string = key.toString();
                if (string.equals("replacement")) {
                    this.replacement = value.toString();
                }
                ++n2;
            }
        }
    }

    private static final class PluralTableSink
    extends UResource.Sink {
        String[] outArray;

        public PluralTableSink(String[] stringArray) {
            this.outArray = stringArray;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                int n3;
                String string = key.toString();
                if (!string.equals("case") && this.outArray[n3 = LongNameHandler.getIndex(string)] == null) {
                    String string2;
                    this.outArray[n3] = string2 = value.getString();
                }
                ++n2;
            }
        }
    }

    private static final class InflectedPluralSink
    extends UResource.Sink {
        String gender;
        String caseVariant;
        String[] outArray;

        public InflectedPluralSink(String string, String string2, String[] stringArray) {
            this.gender = string;
            this.caseVariant = string2;
            this.outArray = stringArray;
            for (int i2 = 0; i2 < ARRAY_LENGTH; ++i2) {
                stringArray[i2] = null;
            }
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                UResource.Table table2;
                String string = key.toString();
                int n3 = LongNameHandler.getIndex(string);
                if (this.outArray[n3] == null && this.loadForPluralForm(table2 = value.getTable(), value)) {
                    this.outArray[n3] = value.getString();
                }
                ++n2;
            }
        }

        private boolean loadForPluralForm(UResource.Table table, UResource.Value value) {
            if (this.gender != null && !this.gender.isEmpty()) {
                if (this.loadForGender(table, this.gender, value)) {
                    return true;
                }
                if (this.gender != "neuter" && this.loadForGender(table, "neuter", value)) {
                    return true;
                }
            }
            return this.loadForGender(table, "_", value);
        }

        private boolean loadForGender(UResource.Table table, String string, UResource.Value value) {
            if (!table.findValue(string, value)) {
                return false;
            }
            UResource.Table table2 = value.getTable();
            if (this.caseVariant != null && !this.caseVariant.isEmpty()) {
                if (this.loadForCase(table2, this.caseVariant, value)) {
                    return true;
                }
                if (this.caseVariant != "nominative" && this.loadForCase(table2, "nominative", value)) {
                    return true;
                }
            }
            return this.loadForCase(table2, "_", value);
        }

        private boolean loadForCase(UResource.Table table, String string, UResource.Value value) {
            return table.findValue(string, value);
        }
    }

    private static class ExtractCorePatternResult {
        String coreUnit;
        PlaceholderPosition placeholderPosition;
        char joinerChar;

        private ExtractCorePatternResult() {
        }
    }

    private static enum PlaceholderPosition {
        NONE,
        BEGINNING,
        MIDDLE,
        END;

    }
}

