/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalFormatProperties;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PatternStringParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class Grouper {
    private static final Grouper GROUPER_NEVER = new Grouper(-1, -1, -2);
    private static final Grouper GROUPER_MIN2 = new Grouper(-2, -2, -3);
    private static final Grouper GROUPER_AUTO = new Grouper(-2, -2, -2);
    private static final Grouper GROUPER_ON_ALIGNED = new Grouper(-4, -4, 1);
    private static final Grouper GROUPER_WESTERN = new Grouper(3, 3, 1);
    private static final Grouper GROUPER_INDIC = new Grouper(3, 2, 1);
    private static final Grouper GROUPER_WESTERN_MIN2 = new Grouper(3, 3, 2);
    private static final Grouper GROUPER_INDIC_MIN2 = new Grouper(3, 2, 2);
    private final short grouping1;
    private final short grouping2;
    private final short minGrouping;

    public static Grouper forStrategy(NumberFormatter.GroupingStrategy groupingStrategy) {
        switch (groupingStrategy) {
            case OFF: {
                return GROUPER_NEVER;
            }
            case MIN2: {
                return GROUPER_MIN2;
            }
            case AUTO: {
                return GROUPER_AUTO;
            }
            case ON_ALIGNED: {
                return GROUPER_ON_ALIGNED;
            }
            case THOUSANDS: {
                return GROUPER_WESTERN;
            }
        }
        throw new AssertionError();
    }

    public static Grouper forProperties(DecimalFormatProperties decimalFormatProperties) {
        if (!decimalFormatProperties.getGroupingUsed()) {
            return GROUPER_NEVER;
        }
        short s2 = (short)decimalFormatProperties.getGroupingSize();
        short s3 = (short)decimalFormatProperties.getSecondaryGroupingSize();
        short s4 = (short)decimalFormatProperties.getMinimumGroupingDigits();
        s2 = s2 > 0 ? s2 : (s3 > 0 ? s3 : s2);
        s3 = s3 > 0 ? s3 : s2;
        return Grouper.getInstance(s2, s3, s4);
    }

    public static Grouper getInstance(short s2, short s3, short s4) {
        if (s2 == -1) {
            return GROUPER_NEVER;
        }
        if (s2 == 3 && s3 == 3 && s4 == 1) {
            return GROUPER_WESTERN;
        }
        if (s2 == 3 && s3 == 2 && s4 == 1) {
            return GROUPER_INDIC;
        }
        if (s2 == 3 && s3 == 3 && s4 == 2) {
            return GROUPER_WESTERN_MIN2;
        }
        if (s2 == 3 && s3 == 2 && s4 == 2) {
            return GROUPER_INDIC_MIN2;
        }
        return new Grouper(s2, s3, s4);
    }

    private static short getMinGroupingForLocale(ULocale uLocale) {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
        String string = iCUResourceBundle.getStringWithFallback("NumberElements/minimumGroupingDigits");
        return Short.parseShort(string);
    }

    private Grouper(short s2, short s3, short s4) {
        this.grouping1 = s2;
        this.grouping2 = s3;
        this.minGrouping = s4;
    }

    public Grouper withLocaleData(ULocale uLocale, PatternStringParser.ParsedPatternInfo parsedPatternInfo) {
        short s2;
        short s22 = this.minGrouping == -2 ? Grouper.getMinGroupingForLocale(uLocale) : (this.minGrouping == -3 ? (short)Math.max(2, Grouper.getMinGroupingForLocale(uLocale)) : this.minGrouping);
        if (this.grouping1 != -2 && this.grouping2 != -4) {
            if (s22 == this.minGrouping) {
                return this;
            }
            return Grouper.getInstance(this.grouping1, this.grouping2, s22);
        }
        int n2 = (int)(parsedPatternInfo.positive.groupingSizes & 0xFFFFL);
        short s3 = (short)(parsedPatternInfo.positive.groupingSizes >>> 16 & 0xFFFFL);
        short s4 = (short)(parsedPatternInfo.positive.groupingSizes >>> 32 & 0xFFFFL);
        if (s3 == -1) {
            int n3 = n2 = this.grouping1 == -4 ? 3 : -1;
        }
        if (s4 == -1) {
            s2 = n2;
        }
        return Grouper.getInstance((short)n2, s2, s22);
    }

    public boolean groupAtPosition(int n2, DecimalQuantity decimalQuantity) {
        assert (this.grouping1 != -2 && this.grouping1 != -4);
        if (this.grouping1 == -1 || this.grouping1 == 0) {
            return false;
        }
        return (n2 -= this.grouping1) >= 0 && n2 % this.grouping2 == 0 && decimalQuantity.getUpperDisplayMagnitude() - this.grouping1 + 1 >= this.minGrouping;
    }

    public short getPrimary() {
        return this.grouping1;
    }

    public short getSecondary() {
        return this.grouping2;
    }
}

