/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.FieldPosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UFieldPosition;

public abstract class DecimalQuantity_AbstractBCD
implements DecimalQuantity {
    protected int scale;
    protected int precision;
    protected byte flags;
    protected static final int NEGATIVE_FLAG = 1;
    protected static final int INFINITY_FLAG = 2;
    protected static final int NAN_FLAG = 4;
    protected double origDouble;
    protected int origDelta;
    protected boolean isApproximate;
    protected int lReqPos = 0;
    protected int rReqPos = 0;
    protected int exponent = 0;
    private static final double[] DOUBLE_MULTIPLIERS = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21};
    @Deprecated
    public boolean explicitExactDouble = false;
    static final byte[] INT64_BCD = new byte[]{9, 2, 2, 3, 3, 7, 2, 0, 3, 6, 8, 5, 4, 7, 7, 5, 8, 0, 8};
    private static final int SECTION_LOWER_EDGE = -1;
    private static final int SECTION_UPPER_EDGE = -2;

    @Override
    public void copyFrom(DecimalQuantity decimalQuantity) {
        this.copyBcdFrom(decimalQuantity);
        DecimalQuantity_AbstractBCD decimalQuantity_AbstractBCD = (DecimalQuantity_AbstractBCD)decimalQuantity;
        this.lReqPos = decimalQuantity_AbstractBCD.lReqPos;
        this.rReqPos = decimalQuantity_AbstractBCD.rReqPos;
        this.scale = decimalQuantity_AbstractBCD.scale;
        this.precision = decimalQuantity_AbstractBCD.precision;
        this.flags = decimalQuantity_AbstractBCD.flags;
        this.origDouble = decimalQuantity_AbstractBCD.origDouble;
        this.origDelta = decimalQuantity_AbstractBCD.origDelta;
        this.isApproximate = decimalQuantity_AbstractBCD.isApproximate;
        this.exponent = decimalQuantity_AbstractBCD.exponent;
    }

    public DecimalQuantity_AbstractBCD clear() {
        this.lReqPos = 0;
        this.rReqPos = 0;
        this.flags = 0;
        this.setBcdToZero();
        return this;
    }

    @Override
    public void setMinInteger(int n2) {
        assert (n2 >= 0);
        if (n2 < this.lReqPos) {
            n2 = this.lReqPos;
        }
        this.lReqPos = n2;
    }

    @Override
    public void setMinFraction(int n2) {
        assert (n2 >= 0);
        this.rReqPos = -n2;
    }

    @Override
    public void applyMaxInteger(int n2) {
        assert (n2 >= 0);
        if (this.precision == 0) {
            return;
        }
        if (n2 <= this.scale) {
            this.setBcdToZero();
            return;
        }
        int n3 = this.getMagnitude();
        if (n2 <= n3) {
            this.popFromLeft(n3 - n2 + 1);
            this.compact();
        }
    }

    @Override
    public long getPositionFingerprint() {
        long l2 = 0L;
        l2 ^= (long)(this.lReqPos << 16);
        return l2 ^= (long)this.rReqPos << 32;
    }

    @Override
    public void roundToIncrement(BigDecimal bigDecimal, MathContext mathContext) {
        assert (bigDecimal.stripTrailingZeros().precision() != 1 || bigDecimal.stripTrailingZeros().unscaledValue().intValue() != 5 || bigDecimal.stripTrailingZeros().unscaledValue().intValue() != 1);
        BigDecimal bigDecimal2 = this.toBigDecimal();
        if ((bigDecimal2 = bigDecimal2.divide(bigDecimal, 0, mathContext.getRoundingMode()).multiply(bigDecimal).round(mathContext)).signum() == 0) {
            this.setBcdToZero();
        } else {
            this.setToBigDecimal(bigDecimal2);
        }
    }

    @Override
    public void multiplyBy(BigDecimal bigDecimal) {
        if (this.isZeroish()) {
            return;
        }
        BigDecimal bigDecimal2 = this.toBigDecimal();
        bigDecimal2 = bigDecimal2.multiply(bigDecimal);
        this.setToBigDecimal(bigDecimal2);
    }

    @Override
    public void negate() {
        this.flags = (byte)(this.flags ^ 1);
    }

    @Override
    public int getMagnitude() throws ArithmeticException {
        if (this.precision == 0) {
            throw new ArithmeticException("Magnitude is not well-defined for zero");
        }
        return this.scale + this.precision - 1;
    }

    @Override
    public void adjustMagnitude(int n2) {
        if (this.precision != 0) {
            this.scale = Utility.addExact(this.scale, n2);
            this.origDelta = Utility.addExact(this.origDelta, n2);
            Utility.addExact(this.scale, this.precision);
        }
    }

    @Override
    public int getExponent() {
        return this.exponent;
    }

    @Override
    public void adjustExponent(int n2) {
        this.exponent += n2;
    }

    @Override
    public void resetExponent() {
        this.adjustMagnitude(this.exponent);
        this.exponent = 0;
    }

    @Override
    public boolean isHasIntegerValue() {
        return this.scale >= 0;
    }

    @Override
    public StandardPlural getStandardPlural(PluralRules pluralRules) {
        if (pluralRules == null) {
            return StandardPlural.OTHER;
        }
        String string = pluralRules.select(this);
        return StandardPlural.orOtherFromString(string);
    }

    @Override
    public double getPluralOperand(PluralRules.Operand operand) {
        assert (!this.isApproximate);
        switch (operand) {
            case i: {
                return this.isNegative() ? (double)(-this.toLong(true)) : (double)this.toLong(true);
            }
            case f: {
                return this.toFractionLong(true);
            }
            case t: {
                return this.toFractionLong(false);
            }
            case v: {
                return this.fractionCount();
            }
            case w: {
                return this.fractionCountWithoutTrailingZeros();
            }
            case e: {
                return this.getExponent();
            }
            case c: {
                return this.getExponent();
            }
        }
        return Math.abs(this.toDouble());
    }

    @Override
    public void populateUFieldPosition(FieldPosition fieldPosition) {
        if (fieldPosition instanceof UFieldPosition) {
            ((UFieldPosition)fieldPosition).setFractionDigits((int)this.getPluralOperand(PluralRules.Operand.v), (long)this.getPluralOperand(PluralRules.Operand.f));
        }
    }

    @Override
    public int getUpperDisplayMagnitude() {
        assert (!this.isApproximate);
        int n2 = this.scale + this.precision;
        int n3 = this.lReqPos > n2 ? this.lReqPos : n2;
        return n3 - 1;
    }

    @Override
    public int getLowerDisplayMagnitude() {
        assert (!this.isApproximate);
        int n2 = this.scale;
        int n3 = this.rReqPos < n2 ? this.rReqPos : n2;
        return n3;
    }

    @Override
    public byte getDigit(int n2) {
        assert (!this.isApproximate);
        return this.getDigitPos(n2 - this.scale);
    }

    private int fractionCount() {
        return Math.max(0, -this.getLowerDisplayMagnitude() - this.exponent);
    }

    private int fractionCountWithoutTrailingZeros() {
        return Math.max(-this.scale - this.exponent, 0);
    }

    @Override
    public boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    @Override
    public Modifier.Signum signum() {
        boolean bl2 = this.isZeroish() && !this.isInfinite();
        boolean bl3 = this.isNegative();
        if (bl2 && bl3) {
            return Modifier.Signum.NEG_ZERO;
        }
        if (bl2) {
            return Modifier.Signum.POS_ZERO;
        }
        if (bl3) {
            return Modifier.Signum.NEG;
        }
        return Modifier.Signum.POS;
    }

    @Override
    public boolean isInfinite() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isNaN() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isZeroish() {
        return this.precision == 0;
    }

    public void setToInt(int n2) {
        this.setBcdToZero();
        this.flags = 0;
        if (n2 < 0) {
            this.flags = (byte)(this.flags | 1);
            n2 = -n2;
        }
        if (n2 != 0) {
            this._setToInt(n2);
            this.compact();
        }
    }

    private void _setToInt(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.readLongToBcd(-((long)n2));
        } else {
            this.readIntToBcd(n2);
        }
    }

    public void setToLong(long l2) {
        this.setBcdToZero();
        this.flags = 0;
        if (l2 < 0L) {
            this.flags = (byte)(this.flags | 1);
            l2 = -l2;
        }
        if (l2 != 0L) {
            this._setToLong(l2);
            this.compact();
        }
    }

    private void _setToLong(long l2) {
        if (l2 == Long.MIN_VALUE) {
            this.readBigIntegerToBcd(BigInteger.valueOf(l2).negate());
        } else if (l2 <= Integer.MAX_VALUE) {
            this.readIntToBcd((int)l2);
        } else {
            this.readLongToBcd(l2);
        }
    }

    public void setToBigInteger(BigInteger bigInteger) {
        this.setBcdToZero();
        this.flags = 0;
        if (bigInteger.signum() == -1) {
            this.flags = (byte)(this.flags | 1);
            bigInteger = bigInteger.negate();
        }
        if (bigInteger.signum() != 0) {
            this._setToBigInteger(bigInteger);
            this.compact();
        }
    }

    private void _setToBigInteger(BigInteger bigInteger) {
        if (bigInteger.bitLength() < 32) {
            this.readIntToBcd(bigInteger.intValue());
        } else if (bigInteger.bitLength() < 64) {
            this.readLongToBcd(bigInteger.longValue());
        } else {
            this.readBigIntegerToBcd(bigInteger);
        }
    }

    public void setToDouble(double d2) {
        this.setBcdToZero();
        this.flags = 0;
        if (Double.doubleToRawLongBits(d2) < 0L) {
            this.flags = (byte)(this.flags | 1);
            d2 = -d2;
        }
        if (Double.isNaN(d2)) {
            this.flags = (byte)(this.flags | 4);
        } else if (Double.isInfinite(d2)) {
            this.flags = (byte)(this.flags | 2);
        } else if (d2 != 0.0) {
            this._setToDoubleFast(d2);
            this.compact();
        }
    }

    private void _setToDoubleFast(double d2) {
        int n2;
        this.isApproximate = true;
        this.origDouble = d2;
        this.origDelta = 0;
        long l2 = Double.doubleToLongBits(d2);
        int n3 = (int)((l2 & 0x7FF0000000000000L) >> 52) - 1023;
        if (n3 <= 52 && (double)((long)d2) == d2) {
            this._setToLong((long)d2);
            return;
        }
        if (n3 == -1023 || n3 == 1024) {
            this.convertToAccurateDouble();
            return;
        }
        int n4 = (int)((double)(52 - n3) / 3.321928094887362);
        if (n4 >= 0) {
            for (n2 = n4; n2 >= 22; n2 -= 22) {
                d2 *= 1.0E22;
            }
            d2 *= DOUBLE_MULTIPLIERS[n2];
        } else {
            for (n2 = n4; n2 <= -22; n2 += 22) {
                d2 /= 1.0E22;
            }
            d2 /= DOUBLE_MULTIPLIERS[-n2];
        }
        long l3 = Math.round(d2);
        if (l3 != 0L) {
            this._setToLong(l3);
            this.scale -= n4;
        }
    }

    private void convertToAccurateDouble() {
        double d2 = this.origDouble;
        assert (d2 != 0.0);
        int n2 = this.origDelta;
        this.setBcdToZero();
        String string = Double.toString(d2);
        if (string.indexOf(69) != -1) {
            assert (string.indexOf(46) == 1);
            int n3 = string.indexOf(69);
            this._setToLong(Long.parseLong(string.charAt(0) + string.substring(2, n3)));
            this.scale += Integer.parseInt(string.substring(n3 + 1)) - (n3 - 1) + 1;
        } else if (string.charAt(0) == '0') {
            assert (string.indexOf(46) == 1);
            this._setToLong(Long.parseLong(string.substring(2)));
            this.scale += 2 - string.length();
        } else if (string.charAt(string.length() - 1) == '0') {
            assert (string.indexOf(46) == string.length() - 2);
            assert (string.length() - 2 <= 18);
            this._setToLong(Long.parseLong(string.substring(0, string.length() - 2)));
        } else {
            int n4 = string.indexOf(46);
            this._setToLong(Long.parseLong(string.substring(0, n4) + string.substring(n4 + 1)));
            this.scale += n4 - string.length() + 1;
        }
        this.scale += n2;
        this.compact();
        this.explicitExactDouble = true;
    }

    @Override
    public void setToBigDecimal(BigDecimal bigDecimal) {
        this.setBcdToZero();
        this.flags = 0;
        if (bigDecimal.signum() == -1) {
            this.flags = (byte)(this.flags | 1);
            bigDecimal = bigDecimal.negate();
        }
        if (bigDecimal.signum() != 0) {
            this._setToBigDecimal(bigDecimal);
            this.compact();
        }
    }

    private void _setToBigDecimal(BigDecimal bigDecimal) {
        int n2 = bigDecimal.scale();
        bigDecimal = bigDecimal.scaleByPowerOfTen(n2);
        BigInteger bigInteger = bigDecimal.toBigInteger();
        this._setToBigInteger(bigInteger);
        this.scale -= n2;
    }

    @Override
    public long toLong(boolean bl2) {
        assert (bl2 || this.fitsInLong());
        long l2 = 0L;
        int n2 = this.exponent + this.scale + this.precision - 1;
        if (bl2) {
            n2 = Math.min(n2, 17);
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            l2 = l2 * 10L + (long)this.getDigitPos(i2 - this.scale - this.exponent);
        }
        if (this.isNegative()) {
            l2 = -l2;
        }
        return l2;
    }

    public long toFractionLong(boolean bl2) {
        long l2 = 0L;
        int n2 = -1 - this.exponent;
        int n3 = this.scale;
        if (bl2) {
            n3 = Math.min(n3, this.rReqPos);
        }
        while (n2 >= n3 && (double)l2 <= 1.0E17) {
            l2 = l2 * 10L + (long)this.getDigitPos(n2 - this.scale);
            --n2;
        }
        if (!bl2) {
            while (l2 > 0L && l2 % 10L == 0L) {
                l2 /= 10L;
            }
        }
        return l2;
    }

    public boolean fitsInLong() {
        if (this.isInfinite() || this.isNaN()) {
            return false;
        }
        if (this.isZeroish()) {
            return true;
        }
        if (this.exponent + this.scale < 0) {
            return false;
        }
        int n2 = this.getMagnitude();
        if (n2 < 18) {
            return true;
        }
        if (n2 > 18) {
            return false;
        }
        for (int i2 = 0; i2 < this.precision; ++i2) {
            byte by2 = this.getDigit(18 - i2);
            if (by2 < INT64_BCD[i2]) {
                return true;
            }
            if (by2 <= INT64_BCD[i2]) continue;
            return false;
        }
        return this.isNegative();
    }

    @Override
    public double toDouble() {
        assert (!this.isApproximate);
        if (this.isNaN()) {
            return Double.NaN;
        }
        if (this.isInfinite()) {
            return this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.toScientificString(stringBuilder);
        return Double.parseDouble(stringBuilder.toString());
    }

    @Override
    public BigDecimal toBigDecimal() {
        if (this.isApproximate) {
            this.convertToAccurateDouble();
        }
        return this.bcdToBigDecimal();
    }

    private static int safeSubtract(int n2, int n3) {
        int n4 = n2 - n3;
        if (n3 < 0 && n4 < n2) {
            return Integer.MAX_VALUE;
        }
        if (n3 > 0 && n4 > n2) {
            return Integer.MIN_VALUE;
        }
        return n4;
    }

    public void truncate() {
        if (this.scale < 0) {
            this.shiftRight(-this.scale);
            this.scale = 0;
            this.compact();
        }
    }

    @Override
    public void roundToNickel(int n2, MathContext mathContext) {
        this.roundToMagnitude(n2, mathContext, true);
    }

    @Override
    public void roundToMagnitude(int n2, MathContext mathContext) {
        this.roundToMagnitude(n2, mathContext, false);
    }

    private void roundToMagnitude(int n2, MathContext mathContext, boolean bl2) {
        int n3 = DecimalQuantity_AbstractBCD.safeSubtract(n2, this.scale);
        int n4 = mathContext.getPrecision();
        if (n4 > 0 && this.precision - n4 > n3) {
            n3 = this.precision - n4;
        }
        int n5 = this.getDigitPos(n3);
        if ((n3 > 0 || this.isApproximate || bl2 && n5 != 0 && n5 != 5) && this.precision != 0) {
            int n6;
            int n7;
            int n8;
            int n9;
            byte by2 = this.getDigitPos(DecimalQuantity_AbstractBCD.safeSubtract(n3, 1));
            if (!this.isApproximate) {
                if (bl2 && n5 != 2 && n5 != 7) {
                    n9 = n5 < 2 ? 1 : (n5 < 5 ? 3 : (n5 < 7 ? 1 : 3));
                } else if (by2 < 5) {
                    n9 = 1;
                } else if (by2 > 5) {
                    n9 = 3;
                } else {
                    n9 = 2;
                    for (n8 = DecimalQuantity_AbstractBCD.safeSubtract(n3, 2); n8 >= 0; --n8) {
                        if (this.getDigitPos(n8) == 0) continue;
                        n9 = 3;
                        break;
                    }
                }
            } else {
                n7 = Math.max(0, this.precision - 14);
                if (!(by2 != 0 || bl2 && n5 != 0 && n5 != 5)) {
                    n9 = -1;
                    for (n8 = DecimalQuantity_AbstractBCD.safeSubtract(n3, 2); n8 >= n7; --n8) {
                        if (this.getDigitPos(n8) == 0) continue;
                        n9 = 1;
                        break;
                    }
                } else if (!(by2 != 4 || bl2 && n5 != 2 && n5 != 7)) {
                    n9 = 2;
                    while (n8 >= n7) {
                        if (this.getDigitPos(n8) != 9) {
                            n9 = 1;
                            break;
                        }
                        --n8;
                    }
                } else if (!(by2 != 5 || bl2 && n5 != 2 && n5 != 7)) {
                    n9 = 2;
                    while (n8 >= n7) {
                        if (this.getDigitPos(n8) != 0) {
                            n9 = 3;
                            break;
                        }
                        --n8;
                    }
                } else if (!(by2 != 9 || bl2 && n5 != 4 && n5 != 9)) {
                    n9 = -2;
                    while (n8 >= n7) {
                        if (this.getDigitPos(n8) != 9) {
                            n9 = 3;
                            break;
                        }
                        --n8;
                    }
                } else {
                    n9 = bl2 && n5 != 2 && n5 != 7 ? (n5 < 2 ? 1 : (n5 < 5 ? 3 : (n5 < 7 ? 1 : 3))) : (by2 < 5 ? 1 : 3);
                }
                n6 = RoundingUtils.roundsAtMidpoint(mathContext.getRoundingMode().ordinal());
                if (DecimalQuantity_AbstractBCD.safeSubtract(n3, 1) < this.precision - 14 || n6 != 0 && n9 == 2 || n6 == 0 && n9 < 0) {
                    this.convertToAccurateDouble();
                    this.roundToMagnitude(n2, mathContext, bl2);
                    return;
                }
                this.isApproximate = false;
                this.origDouble = 0.0;
                this.origDelta = 0;
                if (!(n3 > 0 || bl2 && n5 != 0 && n5 != 5)) {
                    return;
                }
                if (n9 == -1) {
                    n9 = 1;
                }
                if (n9 == -2) {
                    n9 = 3;
                }
            }
            n8 = bl2 ? (n5 < 2 || n5 > 7 || n5 == 2 && n9 != 3 || n5 == 7 && n9 == 3 ? 1 : 0) : (n5 % 2 == 0 ? 1 : 0);
            n7 = RoundingUtils.getRoundingDirection(n8 != 0, this.isNegative(), n9, mathContext.getRoundingMode().ordinal(), this) ? 1 : 0;
            if (n3 >= this.precision) {
                assert (n5 == 0);
                this.setBcdToZero();
                this.scale = n2;
            } else {
                this.shiftRight(n3);
            }
            if (bl2) {
                if (n5 < 5 && n7 != 0) {
                    this.setDigitPos(0, (byte)0);
                    this.compact();
                    return;
                }
                if (n5 >= 5 && n7 == 0) {
                    this.setDigitPos(0, (byte)9);
                    n5 = 9;
                } else {
                    this.setDigitPos(0, (byte)5);
                    if (this.precision == 0) {
                        this.precision = 1;
                    }
                    return;
                }
            }
            if (n7 == 0) {
                if (n5 == 9) {
                    n6 = 0;
                    while (this.getDigitPos(n6) == 9) {
                        ++n6;
                    }
                    this.shiftRight(n6);
                }
                n6 = this.getDigitPos(0);
                assert (n6 != 9);
                this.setDigitPos(0, (byte)(n6 + 1));
                ++this.precision;
            }
            this.compact();
        }
    }

    @Override
    public void roundToInfinity() {
        if (this.isApproximate) {
            this.convertToAccurateDouble();
        }
    }

    @Deprecated
    public void appendDigit(byte by2, int n2, boolean bl2) {
        assert (n2 >= 0);
        if (by2 == 0) {
            if (bl2 && this.precision != 0) {
                this.scale += n2 + 1;
            }
            return;
        }
        if (this.scale > 0) {
            n2 += this.scale;
            if (bl2) {
                this.scale = 0;
            }
        }
        this.shiftLeft(n2 + 1);
        this.setDigitPos(0, by2);
        if (bl2) {
            this.scale += n2 + 1;
        }
    }

    @Override
    public String toPlainString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toPlainString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toPlainString(StringBuilder stringBuilder) {
        int n2;
        assert (!this.isApproximate);
        if (this.isNegative()) {
            stringBuilder.append('-');
        }
        if (this.precision == 0) {
            stringBuilder.append('0');
            return;
        }
        int n3 = this.scale + this.precision + this.exponent - 1;
        int n4 = this.scale + this.exponent;
        if (n3 < this.lReqPos - 1) {
            n3 = this.lReqPos - 1;
        }
        if (n4 > this.rReqPos) {
            n4 = this.rReqPos;
        }
        if ((n2 = n3) < 0) {
            stringBuilder.append('0');
        }
        while (n2 >= 0) {
            stringBuilder.append((char)(48 + this.getDigitPos(n2 - this.scale - this.exponent)));
            --n2;
        }
        if (n4 < 0) {
            stringBuilder.append('.');
        }
        while (n2 >= n4) {
            stringBuilder.append((char)(48 + this.getDigitPos(n2 - this.scale - this.exponent)));
            --n2;
        }
    }

    public String toScientificString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toScientificString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toScientificString(StringBuilder stringBuilder) {
        assert (!this.isApproximate);
        if (this.isNegative()) {
            stringBuilder.append('-');
        }
        if (this.precision == 0) {
            stringBuilder.append("0E+0");
            return;
        }
        int n2 = this.precision - 1;
        int n3 = 0;
        int n4 = n2;
        stringBuilder.append((char)(48 + this.getDigitPos(n4)));
        if (--n4 >= n3) {
            stringBuilder.append('.');
            while (n4 >= n3) {
                stringBuilder.append((char)(48 + this.getDigitPos(n4)));
                --n4;
            }
        }
        stringBuilder.append('E');
        int n5 = n2 + this.scale + this.exponent;
        if (n5 == Integer.MIN_VALUE) {
            stringBuilder.append("-2147483648");
            return;
        }
        if (n5 < 0) {
            n5 *= -1;
            stringBuilder.append('-');
        } else {
            stringBuilder.append('+');
        }
        if (n5 == 0) {
            stringBuilder.append('0');
        }
        int n6 = stringBuilder.length();
        while (n5 > 0) {
            int n7 = n5 / 10;
            int n8 = n5 % 10;
            stringBuilder.insert(n6, (char)(48 + n8));
            n5 = n7;
        }
    }

    @Override
    public String toExponentString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toExponentString(stringBuilder);
        return stringBuilder.toString();
    }

    private void toExponentString(StringBuilder stringBuilder) {
        int n2;
        assert (!this.isApproximate);
        if (this.isNegative()) {
            stringBuilder.append('-');
        }
        int n3 = this.scale + this.precision - 1;
        int n4 = this.scale;
        if (n3 < this.lReqPos - 1) {
            n3 = this.lReqPos - 1;
        }
        if (n4 > this.rReqPos) {
            n4 = this.rReqPos;
        }
        if ((n2 = n3) < 0) {
            stringBuilder.append('0');
        }
        while (n2 >= 0) {
            stringBuilder.append((char)(48 + this.getDigitPos(n2 - this.scale)));
            --n2;
        }
        if (n4 < 0) {
            stringBuilder.append('.');
        }
        while (n2 >= n4) {
            stringBuilder.append((char)(48 + this.getDigitPos(n2 - this.scale)));
            --n2;
        }
        if (this.exponent != 0) {
            stringBuilder.append('c');
            stringBuilder.append(this.exponent);
        }
    }

    public boolean equals(Object object) {
        boolean bl2;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DecimalQuantity_AbstractBCD)) {
            return false;
        }
        DecimalQuantity_AbstractBCD decimalQuantity_AbstractBCD = (DecimalQuantity_AbstractBCD)object;
        boolean bl3 = bl2 = this.scale == decimalQuantity_AbstractBCD.scale && this.precision == decimalQuantity_AbstractBCD.precision && this.flags == decimalQuantity_AbstractBCD.flags && this.lReqPos == decimalQuantity_AbstractBCD.lReqPos && this.rReqPos == decimalQuantity_AbstractBCD.rReqPos && this.isApproximate == decimalQuantity_AbstractBCD.isApproximate;
        if (!bl2) {
            return false;
        }
        if (this.precision == 0) {
            return true;
        }
        if (this.isApproximate) {
            return this.origDouble == decimalQuantity_AbstractBCD.origDouble && this.origDelta == decimalQuantity_AbstractBCD.origDelta;
        }
        for (int i2 = this.getUpperDisplayMagnitude(); i2 >= this.getLowerDisplayMagnitude(); --i2) {
            if (this.getDigit(i2) == decimalQuantity_AbstractBCD.getDigit(i2)) continue;
            return false;
        }
        return true;
    }

    protected abstract byte getDigitPos(int var1);

    protected abstract void setDigitPos(int var1, byte var2);

    protected abstract void shiftLeft(int var1);

    protected abstract void shiftRight(int var1);

    protected abstract void popFromLeft(int var1);

    protected abstract void setBcdToZero();

    protected abstract void readIntToBcd(int var1);

    protected abstract void readLongToBcd(long var1);

    protected abstract void readBigIntegerToBcd(BigInteger var1);

    protected abstract BigDecimal bcdToBigDecimal();

    protected abstract void copyBcdFrom(DecimalQuantity var1);

    protected abstract void compact();
}

