/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.TimeUnit;

public final class Period {
    final byte timeLimit;
    final boolean inFuture;
    final int[] counts;

    public static Period at(float f2, TimeUnit timeUnit) {
        Period.checkCount(f2);
        return new Period(0, false, f2, timeUnit);
    }

    public static Period moreThan(float f2, TimeUnit timeUnit) {
        Period.checkCount(f2);
        return new Period(2, false, f2, timeUnit);
    }

    public static Period lessThan(float f2, TimeUnit timeUnit) {
        Period.checkCount(f2);
        return new Period(1, false, f2, timeUnit);
    }

    public Period and(float f2, TimeUnit timeUnit) {
        Period.checkCount(f2);
        return this.setTimeUnitValue(timeUnit, f2);
    }

    public Period omit(TimeUnit timeUnit) {
        return this.setTimeUnitInternalValue(timeUnit, 0);
    }

    public Period at() {
        return this.setTimeLimit((byte)0);
    }

    public Period moreThan() {
        return this.setTimeLimit((byte)2);
    }

    public Period lessThan() {
        return this.setTimeLimit((byte)1);
    }

    public Period inFuture() {
        return this.setFuture(true);
    }

    public Period inPast() {
        return this.setFuture(false);
    }

    public Period inFuture(boolean bl2) {
        return this.setFuture(bl2);
    }

    public Period inPast(boolean bl2) {
        return this.setFuture(!bl2);
    }

    public boolean isSet() {
        for (int i2 = 0; i2 < this.counts.length; ++i2) {
            if (this.counts[i2] == 0) continue;
            return true;
        }
        return false;
    }

    public boolean isSet(TimeUnit timeUnit) {
        return this.counts[timeUnit.ordinal] > 0;
    }

    public float getCount(TimeUnit timeUnit) {
        byte by2 = timeUnit.ordinal;
        if (this.counts[by2] == 0) {
            return 0.0f;
        }
        return (float)(this.counts[by2] - 1) / 1000.0f;
    }

    public boolean isInFuture() {
        return this.inFuture;
    }

    public boolean isInPast() {
        return !this.inFuture;
    }

    public boolean isMoreThan() {
        return this.timeLimit == 2;
    }

    public boolean isLessThan() {
        return this.timeLimit == 1;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((Period)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equals(Period period) {
        if (period != null && this.timeLimit == period.timeLimit && this.inFuture == period.inFuture) {
            for (int i2 = 0; i2 < this.counts.length; ++i2) {
                if (this.counts[i2] == period.counts[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.timeLimit << 1 | (this.inFuture ? 1 : 0);
        for (int i2 = 0; i2 < this.counts.length; ++i2) {
            n2 = n2 << 2 ^ this.counts[i2];
        }
        return n2;
    }

    private Period(int n2, boolean bl2, float f2, TimeUnit timeUnit) {
        this.timeLimit = (byte)n2;
        this.inFuture = bl2;
        this.counts = new int[TimeUnit.units.length];
        this.counts[timeUnit.ordinal] = (int)(f2 * 1000.0f) + 1;
    }

    Period(int n2, boolean bl2, int[] nArray) {
        this.timeLimit = (byte)n2;
        this.inFuture = bl2;
        this.counts = nArray;
    }

    private Period setTimeUnitValue(TimeUnit timeUnit, float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("value: " + f2);
        }
        return this.setTimeUnitInternalValue(timeUnit, (int)(f2 * 1000.0f) + 1);
    }

    private Period setTimeUnitInternalValue(TimeUnit timeUnit, int n2) {
        byte by2 = timeUnit.ordinal;
        if (this.counts[by2] != n2) {
            int[] nArray = new int[this.counts.length];
            for (int i2 = 0; i2 < this.counts.length; ++i2) {
                nArray[i2] = this.counts[i2];
            }
            nArray[by2] = n2;
            return new Period(this.timeLimit, this.inFuture, nArray);
        }
        return this;
    }

    private Period setFuture(boolean bl2) {
        if (this.inFuture != bl2) {
            return new Period(this.timeLimit, bl2, this.counts);
        }
        return this;
    }

    private Period setTimeLimit(byte by2) {
        if (this.timeLimit != by2) {
            return new Period(by2, this.inFuture, this.counts);
        }
        return this;
    }

    private static void checkCount(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("count (" + f2 + ") cannot be negative");
        }
    }
}

