/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.Collation;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UTF16CollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrie;

public final class ContractionsAndExpansions {
    private CollationData data;
    private UnicodeSet contractions;
    private UnicodeSet expansions;
    private CESink sink;
    private boolean addPrefixes;
    private int checkTailored = 0;
    private UnicodeSet tailored = new UnicodeSet();
    private UnicodeSet ranges;
    private StringBuilder unreversedPrefix = new StringBuilder();
    private String suffix;
    private long[] ces = new long[31];

    public ContractionsAndExpansions(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, CESink cESink, boolean bl2) {
        this.contractions = unicodeSet;
        this.expansions = unicodeSet2;
        this.sink = cESink;
        this.addPrefixes = bl2;
    }

    public void forData(CollationData collationData) {
        if (collationData.base != null) {
            this.checkTailored = -1;
        }
        this.data = collationData;
        for (Trie2.Range range : this.data.trie) {
            if (range.leadSurrogate) break;
            this.enumCnERange(range.startCodePoint, range.endCodePoint, range.value, this);
        }
        if (collationData.base == null) {
            return;
        }
        this.tailored.freeze();
        this.checkTailored = 1;
        this.data = collationData.base;
        for (Trie2.Range range : this.data.trie) {
            if (range.leadSurrogate) break;
            this.enumCnERange(range.startCodePoint, range.endCodePoint, range.value, this);
        }
    }

    private void enumCnERange(int n2, int n3, int n4, ContractionsAndExpansions contractionsAndExpansions) {
        if (contractionsAndExpansions.checkTailored != 0) {
            if (contractionsAndExpansions.checkTailored < 0) {
                if (n4 == 192) {
                    return;
                }
                contractionsAndExpansions.tailored.add(n2, n3);
            } else if (n2 == n3) {
                if (contractionsAndExpansions.tailored.contains(n2)) {
                    return;
                }
            } else if (contractionsAndExpansions.tailored.containsSome(n2, n3)) {
                if (contractionsAndExpansions.ranges == null) {
                    contractionsAndExpansions.ranges = new UnicodeSet();
                }
                contractionsAndExpansions.ranges.set(n2, n3).removeAll(contractionsAndExpansions.tailored);
                int n5 = contractionsAndExpansions.ranges.getRangeCount();
                for (int i2 = 0; i2 < n5; ++i2) {
                    contractionsAndExpansions.handleCE32(contractionsAndExpansions.ranges.getRangeStart(i2), contractionsAndExpansions.ranges.getRangeEnd(i2), n4);
                }
            }
        }
        contractionsAndExpansions.handleCE32(n2, n3, n4);
    }

    public void forCodePoint(CollationData collationData, int n2) {
        int n3 = collationData.getCE32(n2);
        if (n3 == 192) {
            collationData = collationData.base;
            n3 = collationData.getCE32(n2);
        }
        this.data = collationData;
        this.handleCE32(n2, n2, n3);
    }

    private void handleCE32(int n2, int n3, int n4) {
        while (true) {
            if ((n4 & 0xFF) < 192) {
                if (this.sink != null) {
                    this.sink.handleCE(Collation.ceFromSimpleCE32(n4));
                }
                return;
            }
            switch (Collation.tagFromCE32(n4)) {
                case 0: {
                    return;
                }
                case 3: 
                case 7: 
                case 13: {
                    throw new AssertionError((Object)String.format("Unexpected CE32 tag type %d for ce32=0x%08x", Collation.tagFromCE32(n4), n4));
                }
                case 1: {
                    if (this.sink != null) {
                        this.sink.handleCE(Collation.ceFromLongPrimaryCE32(n4));
                    }
                    return;
                }
                case 2: {
                    if (this.sink != null) {
                        this.sink.handleCE(Collation.ceFromLongSecondaryCE32(n4));
                    }
                    return;
                }
                case 4: {
                    if (this.sink != null) {
                        this.ces[0] = Collation.latinCE0FromCE32(n4);
                        this.ces[1] = Collation.latinCE1FromCE32(n4);
                        this.sink.handleExpansion(this.ces, 0, 2);
                    }
                    if (this.unreversedPrefix.length() == 0) {
                        this.addExpansions(n2, n3);
                    }
                    return;
                }
                case 5: {
                    if (this.sink != null) {
                        int n5 = Collation.indexFromCE32(n4);
                        int n6 = Collation.lengthFromCE32(n4);
                        for (int i2 = 0; i2 < n6; ++i2) {
                            this.ces[i2] = Collation.ceFromCE32(this.data.ce32s[n5 + i2]);
                        }
                        this.sink.handleExpansion(this.ces, 0, n6);
                    }
                    if (this.unreversedPrefix.length() == 0) {
                        this.addExpansions(n2, n3);
                    }
                    return;
                }
                case 6: {
                    if (this.sink != null) {
                        int n7 = Collation.indexFromCE32(n4);
                        int n8 = Collation.lengthFromCE32(n4);
                        this.sink.handleExpansion(this.data.ces, n7, n8);
                    }
                    if (this.unreversedPrefix.length() == 0) {
                        this.addExpansions(n2, n3);
                    }
                    return;
                }
                case 8: {
                    this.handlePrefixes(n2, n3, n4);
                    return;
                }
                case 9: {
                    this.handleContractions(n2, n3, n4);
                    return;
                }
                case 10: {
                    n4 = this.data.ce32s[Collation.indexFromCE32(n4)];
                    break;
                }
                case 11: {
                    assert (n2 == 0 && n3 == 0);
                    n4 = this.data.ce32s[0];
                    break;
                }
                case 12: {
                    if (this.sink != null) {
                        UTF16CollationIterator uTF16CollationIterator = new UTF16CollationIterator(this.data);
                        StringBuilder stringBuilder = new StringBuilder(1);
                        for (int i3 = n2; i3 <= n3; ++i3) {
                            stringBuilder.setLength(0);
                            stringBuilder.appendCodePoint(i3);
                            uTF16CollationIterator.setText(false, stringBuilder, 0);
                            int n9 = uTF16CollationIterator.fetchCEs();
                            assert (n9 >= 2 && uTF16CollationIterator.getCE(n9 - 1) == 0x101000100L);
                            this.sink.handleExpansion(uTF16CollationIterator.getCEs(), 0, n9 - 1);
                        }
                    }
                    if (this.unreversedPrefix.length() == 0) {
                        this.addExpansions(n2, n3);
                    }
                    return;
                }
                case 14: {
                    return;
                }
                case 15: {
                    return;
                }
            }
        }
    }

    private void handlePrefixes(int n2, int n3, int n4) {
        int n5 = Collation.indexFromCE32(n4);
        n4 = this.data.getCE32FromContexts(n5);
        this.handleCE32(n2, n3, n4);
        if (!this.addPrefixes) {
            return;
        }
        for (CharsTrie.Entry entry : new CharsTrie(this.data.contexts, n5 + 2)) {
            this.setPrefix(entry.chars);
            this.addStrings(n2, n3, this.contractions);
            this.addStrings(n2, n3, this.expansions);
            this.handleCE32(n2, n3, entry.value);
        }
        this.resetPrefix();
    }

    void handleContractions(int n2, int n3, int n4) {
        int n5 = Collation.indexFromCE32(n4);
        if ((n4 & 0x100) != 0) {
            assert (this.unreversedPrefix.length() != 0);
        } else {
            n4 = this.data.getCE32FromContexts(n5);
            assert (!Collation.isContractionCE32(n4));
            this.handleCE32(n2, n3, n4);
        }
        for (CharsTrie.Entry entry : new CharsTrie(this.data.contexts, n5 + 2)) {
            this.suffix = entry.chars.toString();
            this.addStrings(n2, n3, this.contractions);
            if (this.unreversedPrefix.length() != 0) {
                this.addStrings(n2, n3, this.expansions);
            }
            this.handleCE32(n2, n3, entry.value);
        }
        this.suffix = null;
    }

    void addExpansions(int n2, int n3) {
        if (this.unreversedPrefix.length() == 0 && this.suffix == null) {
            if (this.expansions != null) {
                this.expansions.add(n2, n3);
            }
        } else {
            this.addStrings(n2, n3, this.expansions);
        }
    }

    void addStrings(int n2, int n3, UnicodeSet unicodeSet) {
        if (unicodeSet == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(this.unreversedPrefix);
        do {
            stringBuilder.appendCodePoint(n2);
            if (this.suffix != null) {
                stringBuilder.append(this.suffix);
            }
            unicodeSet.add(stringBuilder);
            stringBuilder.setLength(this.unreversedPrefix.length());
        } while (++n2 <= n3);
    }

    private void setPrefix(CharSequence charSequence) {
        this.unreversedPrefix.setLength(0);
        this.unreversedPrefix.append(charSequence).reverse();
    }

    private void resetPrefix() {
        this.unreversedPrefix.setLength(0);
    }

    public static interface CESink {
        public void handleCE(long var1);

        public void handleExpansion(long[] var1, int var2, int var3);
    }
}

