/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import java.util.Arrays;

public final class CollationWeights {
    private int middleLength;
    private int[] minBytes = new int[5];
    private int[] maxBytes = new int[5];
    private WeightRange[] ranges = new WeightRange[7];
    private int rangeIndex;
    private int rangeCount;

    public void initForPrimary(boolean bl2) {
        this.middleLength = 1;
        this.minBytes[1] = 3;
        this.maxBytes[1] = 255;
        if (bl2) {
            this.minBytes[2] = 4;
            this.maxBytes[2] = 254;
        } else {
            this.minBytes[2] = 2;
            this.maxBytes[2] = 255;
        }
        this.minBytes[3] = 2;
        this.maxBytes[3] = 255;
        this.minBytes[4] = 2;
        this.maxBytes[4] = 255;
    }

    public void initForSecondary() {
        this.middleLength = 3;
        this.minBytes[1] = 0;
        this.maxBytes[1] = 0;
        this.minBytes[2] = 0;
        this.maxBytes[2] = 0;
        this.minBytes[3] = 2;
        this.maxBytes[3] = 255;
        this.minBytes[4] = 2;
        this.maxBytes[4] = 255;
    }

    public void initForTertiary() {
        this.middleLength = 3;
        this.minBytes[1] = 0;
        this.maxBytes[1] = 0;
        this.minBytes[2] = 0;
        this.maxBytes[2] = 0;
        this.minBytes[3] = 2;
        this.maxBytes[3] = 63;
        this.minBytes[4] = 2;
        this.maxBytes[4] = 63;
    }

    public boolean allocWeights(long l2, long l3, int n2) {
        int n3;
        if (!this.getWeightRanges(l2, l3)) {
            return false;
        }
        while (!this.allocWeightsInShortRanges(n2, n3 = this.ranges[0].length)) {
            if (n3 == 4) {
                return false;
            }
            if (this.allocWeightsInMinLengthRanges(n2, n3)) break;
            for (int i2 = 0; i2 < this.rangeCount && this.ranges[i2].length == n3; ++i2) {
                this.lengthenRange(this.ranges[i2]);
            }
        }
        this.rangeIndex = 0;
        if (this.rangeCount < this.ranges.length) {
            this.ranges[this.rangeCount] = null;
        }
        return true;
    }

    public long nextWeight() {
        if (this.rangeIndex >= this.rangeCount) {
            return 0xFFFFFFFFL;
        }
        WeightRange weightRange = this.ranges[this.rangeIndex];
        long l2 = weightRange.start;
        if (--weightRange.count == 0) {
            ++this.rangeIndex;
        } else {
            weightRange.start = this.incWeight(l2, weightRange.length);
            assert (weightRange.start <= weightRange.end);
        }
        return l2;
    }

    public static int lengthOfWeight(long l2) {
        if ((l2 & 0xFFFFFFL) == 0L) {
            return 1;
        }
        if ((l2 & 0xFFFFL) == 0L) {
            return 2;
        }
        if ((l2 & 0xFFL) == 0L) {
            return 3;
        }
        return 4;
    }

    private static int getWeightTrail(long l2, int n2) {
        return (int)(l2 >> 8 * (4 - n2)) & 0xFF;
    }

    private static long setWeightTrail(long l2, int n2, int n3) {
        n2 = 8 * (4 - n2);
        return l2 & 0xFFFFFF00L << n2 | (long)n3 << n2;
    }

    private static int getWeightByte(long l2, int n2) {
        return CollationWeights.getWeightTrail(l2, n2);
    }

    private static long setWeightByte(long l2, int n2, int n3) {
        long l3 = (n2 *= 8) < 32 ? 0xFFFFFFFFL >> n2 : 0L;
        n2 = 32 - n2;
        return l2 & (l3 |= 0xFFFFFF00L << n2) | (long)n3 << n2;
    }

    private static long truncateWeight(long l2, int n2) {
        return l2 & 0xFFFFFFFFL << 8 * (4 - n2);
    }

    private static long incWeightTrail(long l2, int n2) {
        return l2 + (1L << 8 * (4 - n2));
    }

    private static long decWeightTrail(long l2, int n2) {
        return l2 - (1L << 8 * (4 - n2));
    }

    private int countBytes(int n2) {
        return this.maxBytes[n2] - this.minBytes[n2] + 1;
    }

    private long incWeight(long l2, int n2) {
        while (true) {
            int n3;
            if ((n3 = CollationWeights.getWeightByte(l2, n2)) < this.maxBytes[n2]) {
                return CollationWeights.setWeightByte(l2, n2, n3 + 1);
            }
            l2 = CollationWeights.setWeightByte(l2, n2, this.minBytes[n2]);
            assert (--n2 > 0);
        }
    }

    private long incWeightByOffset(long l2, int n2, int n3) {
        while (true) {
            if ((n3 += CollationWeights.getWeightByte(l2, n2)) <= this.maxBytes[n2]) {
                return CollationWeights.setWeightByte(l2, n2, n3);
            }
            l2 = CollationWeights.setWeightByte(l2, n2, this.minBytes[n2] + (n3 -= this.minBytes[n2]) % this.countBytes(n2));
            n3 /= this.countBytes(n2);
            assert (--n2 > 0);
        }
    }

    private void lengthenRange(WeightRange weightRange) {
        int n2 = weightRange.length + 1;
        weightRange.start = CollationWeights.setWeightTrail(weightRange.start, n2, this.minBytes[n2]);
        weightRange.end = CollationWeights.setWeightTrail(weightRange.end, n2, this.maxBytes[n2]);
        weightRange.count *= this.countBytes(n2);
        weightRange.length = n2;
    }

    private boolean getWeightRanges(long l2, long l3) {
        int n2;
        int n3;
        assert (l2 != 0L);
        assert (l3 != 0L);
        int n4 = CollationWeights.lengthOfWeight(l2);
        int n5 = CollationWeights.lengthOfWeight(l3);
        assert (n4 >= this.middleLength);
        if (l2 >= l3) {
            return false;
        }
        if (n4 < n5 && l2 == CollationWeights.truncateWeight(l3, n4)) {
            return false;
        }
        WeightRange[] weightRangeArray = new WeightRange[5];
        WeightRange weightRange = new WeightRange();
        WeightRange[] weightRangeArray2 = new WeightRange[5];
        long l4 = l2;
        for (n3 = n4; n3 > this.middleLength; --n3) {
            n2 = CollationWeights.getWeightTrail(l4, n3);
            if (n2 < this.maxBytes[n3]) {
                weightRangeArray[n3] = new WeightRange();
                weightRangeArray[n3].start = CollationWeights.incWeightTrail(l4, n3);
                weightRangeArray[n3].end = CollationWeights.setWeightTrail(l4, n3, this.maxBytes[n3]);
                weightRangeArray[n3].length = n3;
                weightRangeArray[n3].count = this.maxBytes[n3] - n2;
            }
            l4 = CollationWeights.truncateWeight(l4, n3 - 1);
        }
        weightRange.start = l4 < 0xFF000000L ? CollationWeights.incWeightTrail(l4, this.middleLength) : 0xFFFFFFFFL;
        l4 = l3;
        for (n3 = n5; n3 > this.middleLength; --n3) {
            n2 = CollationWeights.getWeightTrail(l4, n3);
            if (n2 > this.minBytes[n3]) {
                weightRangeArray2[n3] = new WeightRange();
                weightRangeArray2[n3].start = CollationWeights.setWeightTrail(l4, n3, this.minBytes[n3]);
                weightRangeArray2[n3].end = CollationWeights.decWeightTrail(l4, n3);
                weightRangeArray2[n3].length = n3;
                weightRangeArray2[n3].count = n2 - this.minBytes[n3];
            }
            l4 = CollationWeights.truncateWeight(l4, n3 - 1);
        }
        weightRange.end = CollationWeights.decWeightTrail(l4, this.middleLength);
        weightRange.length = this.middleLength;
        if (weightRange.end >= weightRange.start) {
            weightRange.count = (int)(weightRange.end - weightRange.start >> 8 * (4 - this.middleLength)) + 1;
        } else {
            for (n3 = 4; n3 > this.middleLength; --n3) {
                if (weightRangeArray[n3] == null || weightRangeArray2[n3] == null || weightRangeArray[n3].count <= 0 || weightRangeArray2[n3].count <= 0) continue;
                long l5 = weightRangeArray[n3].end;
                long l6 = weightRangeArray2[n3].start;
                boolean bl2 = false;
                if (l5 > l6) {
                    assert (CollationWeights.truncateWeight(l5, n3 - 1) == CollationWeights.truncateWeight(l6, n3 - 1));
                    weightRangeArray[n3].end = weightRangeArray2[n3].end;
                    weightRangeArray[n3].count = CollationWeights.getWeightTrail(weightRangeArray[n3].end, n3) - CollationWeights.getWeightTrail(weightRangeArray[n3].start, n3) + 1;
                    bl2 = true;
                } else if (l5 == l6) {
                    assert (this.minBytes[n3] < this.maxBytes[n3]);
                } else if (this.incWeight(l5, n3) == l6) {
                    weightRangeArray[n3].end = weightRangeArray2[n3].end;
                    weightRangeArray[n3].count += weightRangeArray2[n3].count;
                    bl2 = true;
                }
                if (!bl2) continue;
                weightRangeArray2[n3].count = 0;
                while (--n3 > this.middleLength) {
                    weightRangeArray2[n3] = null;
                    weightRangeArray[n3] = null;
                }
                break;
            }
        }
        this.rangeCount = 0;
        if (weightRange.count > 0) {
            this.ranges[0] = weightRange;
            this.rangeCount = 1;
        }
        for (n3 = this.middleLength + 1; n3 <= 4; ++n3) {
            if (weightRangeArray2[n3] != null && weightRangeArray2[n3].count > 0) {
                this.ranges[this.rangeCount++] = weightRangeArray2[n3];
            }
            if (weightRangeArray[n3] == null || weightRangeArray[n3].count <= 0) continue;
            this.ranges[this.rangeCount++] = weightRangeArray[n3];
        }
        return this.rangeCount > 0;
    }

    private boolean allocWeightsInShortRanges(int n2, int n3) {
        for (int i2 = 0; i2 < this.rangeCount && this.ranges[i2].length <= n3 + 1; ++i2) {
            if (n2 <= this.ranges[i2].count) {
                if (this.ranges[i2].length > n3) {
                    this.ranges[i2].count = n2;
                }
                this.rangeCount = i2 + 1;
                if (this.rangeCount > 1) {
                    Arrays.sort(this.ranges, 0, this.rangeCount);
                }
                return true;
            }
            n2 -= this.ranges[i2].count;
        }
        return false;
    }

    private boolean allocWeightsInMinLengthRanges(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        for (n5 = 0; n5 < this.rangeCount && this.ranges[n5].length == n3; ++n5) {
            n6 += this.ranges[n5].count;
        }
        int n7 = this.countBytes(n3 + 1);
        if (n2 > n6 * n7) {
            return false;
        }
        long l2 = this.ranges[0].start;
        long l3 = this.ranges[0].end;
        for (n4 = 1; n4 < n5; ++n4) {
            if (this.ranges[n4].start < l2) {
                l2 = this.ranges[n4].start;
            }
            if (this.ranges[n4].end <= l3) continue;
            l3 = this.ranges[n4].end;
        }
        n4 = (n2 - n6) / (n7 - 1);
        int n8 = n6 - n4;
        if (n4 == 0 || n8 + n4 * n7 < n2) assert (--n8 + ++n4 * n7 >= n2);
        this.ranges[0].start = l2;
        if (n8 == 0) {
            this.ranges[0].end = l3;
            this.ranges[0].count = n6;
            this.lengthenRange(this.ranges[0]);
            this.rangeCount = 1;
        } else {
            this.ranges[0].end = this.incWeightByOffset(l2, n3, n8 - 1);
            this.ranges[0].count = n8;
            if (this.ranges[1] == null) {
                this.ranges[1] = new WeightRange();
            }
            this.ranges[1].start = this.incWeight(this.ranges[0].end, n3);
            this.ranges[1].end = l3;
            this.ranges[1].length = n3;
            this.ranges[1].count = n4;
            this.lengthenRange(this.ranges[1]);
            this.rangeCount = 2;
        }
        return true;
    }

    private static final class WeightRange
    implements Comparable<WeightRange> {
        long start;
        long end;
        int length;
        int count;

        private WeightRange() {
        }

        @Override
        public int compareTo(WeightRange weightRange) {
            long l2 = this.start;
            long l3 = weightRange.start;
            if (l2 < l3) {
                return -1;
            }
            if (l2 > l3) {
                return 1;
            }
            return 0;
        }
    }
}

