/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import java.text.ParseException;
import java.util.ArrayList;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IllegalIcuArgumentException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationSettings;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class CollationRuleParser {
    static final Position[] POSITION_VALUES = Position.values();
    static final char POS_LEAD = '\ufffe';
    static final char POS_BASE = '\u2800';
    private static final int UCOL_DEFAULT = -1;
    private static final int UCOL_OFF = 0;
    private static final int UCOL_ON = 1;
    private static final int STRENGTH_MASK = 15;
    private static final int STARRED_FLAG = 16;
    private static final int OFFSET_SHIFT = 8;
    private static final String BEFORE = "[before";
    private final StringBuilder rawBuilder = new StringBuilder();
    private static final String[] positions = new String[]{"first tertiary ignorable", "last tertiary ignorable", "first secondary ignorable", "last secondary ignorable", "first primary ignorable", "last primary ignorable", "first variable", "last variable", "first regular", "last regular", "first implicit", "last implicit", "first trailing", "last trailing"};
    private static final String[] gSpecialReorderCodes = new String[]{"space", "punct", "symbol", "currency", "digit"};
    private static final int U_PARSE_CONTEXT_LEN = 16;
    private Normalizer2 nfd = Normalizer2.getNFDInstance();
    private Normalizer2 nfc = Normalizer2.getNFCInstance();
    private String rules;
    private final CollationData baseData;
    private CollationSettings settings;
    private Sink sink;
    private Importer importer;
    private int ruleIndex;

    CollationRuleParser(CollationData collationData) {
        this.baseData = collationData;
    }

    void setSink(Sink sink) {
        this.sink = sink;
    }

    void setImporter(Importer importer) {
        this.importer = importer;
    }

    void parse(String string, CollationSettings collationSettings) throws ParseException {
        this.settings = collationSettings;
        this.parse(string);
    }

    private void parse(String string) throws ParseException {
        this.rules = string;
        this.ruleIndex = 0;
        block7: while (this.ruleIndex < this.rules.length()) {
            char c2 = this.rules.charAt(this.ruleIndex);
            if (PatternProps.isWhiteSpace(c2)) {
                ++this.ruleIndex;
                continue;
            }
            switch (c2) {
                case '&': {
                    this.parseRuleChain();
                    continue block7;
                }
                case '[': {
                    this.parseSetting();
                    continue block7;
                }
                case '#': {
                    this.ruleIndex = this.skipComment(this.ruleIndex + 1);
                    continue block7;
                }
                case '@': {
                    this.settings.setFlag(2048, true);
                    ++this.ruleIndex;
                    continue block7;
                }
                case '!': {
                    ++this.ruleIndex;
                    continue block7;
                }
            }
            this.setParseError("expected a reset or setting or comment");
        }
    }

    private void parseRuleChain() throws ParseException {
        int n2 = this.parseResetAndPosition();
        boolean bl2 = true;
        while (true) {
            int n3;
            if ((n3 = this.parseRelationOperator()) < 0) {
                if (this.ruleIndex < this.rules.length() && this.rules.charAt(this.ruleIndex) == '#') {
                    this.ruleIndex = this.skipComment(this.ruleIndex + 1);
                    continue;
                }
                if (bl2) {
                    this.setParseError("reset not followed by a relation");
                }
                return;
            }
            int n4 = n3 & 0xF;
            if (n2 < 15) {
                if (bl2) {
                    if (n4 != n2) {
                        this.setParseError("reset-before strength differs from its first relation");
                        return;
                    }
                } else if (n4 < n2) {
                    this.setParseError("reset-before strength followed by a stronger relation");
                    return;
                }
            }
            int n5 = this.ruleIndex + (n3 >> 8);
            if ((n3 & 0x10) == 0) {
                this.parseRelationStrings(n4, n5);
            } else {
                this.parseStarredCharacters(n4, n5);
            }
            bl2 = false;
        }
    }

    private int parseResetAndPosition() throws ParseException {
        int n2;
        char c2;
        int n3;
        int n4 = this.skipWhiteSpace(this.ruleIndex + 1);
        if (this.rules.regionMatches(n4, BEFORE, 0, BEFORE.length()) && (n3 = n4 + BEFORE.length()) < this.rules.length() && PatternProps.isWhiteSpace(this.rules.charAt(n3)) && (n3 = this.skipWhiteSpace(n3 + 1)) + 1 < this.rules.length() && '1' <= (c2 = this.rules.charAt(n3)) && c2 <= '3' && this.rules.charAt(n3 + 1) == ']') {
            n2 = 0 + (c2 - 49);
            n4 = this.skipWhiteSpace(n3 + 2);
        } else {
            n2 = 15;
        }
        if (n4 >= this.rules.length()) {
            this.setParseError("reset without position");
            return -1;
        }
        n4 = this.rules.charAt(n4) == '[' ? this.parseSpecialPosition(n4, this.rawBuilder) : this.parseTailoringString(n4, this.rawBuilder);
        try {
            this.sink.addReset(n2, this.rawBuilder);
        }
        catch (Exception exception) {
            this.setParseError("adding reset failed", exception);
            return -1;
        }
        this.ruleIndex = n4;
        return n2;
    }

    private int parseRelationOperator() {
        int n2;
        this.ruleIndex = this.skipWhiteSpace(this.ruleIndex);
        if (this.ruleIndex >= this.rules.length()) {
            return -1;
        }
        int n3 = this.ruleIndex;
        char c2 = this.rules.charAt(n3++);
        switch (c2) {
            case '<': {
                if (n3 < this.rules.length() && this.rules.charAt(n3) == '<') {
                    if (++n3 < this.rules.length() && this.rules.charAt(n3) == '<') {
                        if (++n3 < this.rules.length() && this.rules.charAt(n3) == '<') {
                            ++n3;
                            n2 = 3;
                        } else {
                            n2 = 2;
                        }
                    } else {
                        n2 = 1;
                    }
                } else {
                    n2 = 0;
                }
                if (n3 >= this.rules.length() || this.rules.charAt(n3) != '*') break;
                ++n3;
                n2 |= 0x10;
                break;
            }
            case ';': {
                n2 = 1;
                break;
            }
            case ',': {
                n2 = 2;
                break;
            }
            case '=': {
                n2 = 15;
                if (n3 >= this.rules.length() || this.rules.charAt(n3) != '*') break;
                ++n3;
                n2 |= 0x10;
                break;
            }
            default: {
                return -1;
            }
        }
        return n3 - this.ruleIndex << 8 | n2;
    }

    private void parseRelationStrings(int n2, int n3) throws ParseException {
        char c2;
        String string = "";
        CharSequence charSequence = "";
        char c3 = c2 = (n3 = this.parseTailoringString(n3, this.rawBuilder)) < this.rules.length() ? this.rules.charAt(n3) : (char)'\u0000';
        if (c2 == '|') {
            string = this.rawBuilder.toString();
            char c4 = c2 = (n3 = this.parseTailoringString(n3 + 1, this.rawBuilder)) < this.rules.length() ? this.rules.charAt(n3) : (char)'\u0000';
        }
        if (c2 == '/') {
            StringBuilder stringBuilder = new StringBuilder();
            n3 = this.parseTailoringString(n3 + 1, stringBuilder);
            charSequence = stringBuilder;
        }
        if (string.length() != 0) {
            int n4 = string.codePointAt(0);
            int n5 = this.rawBuilder.codePointAt(0);
            if (!this.nfc.hasBoundaryBefore(n4) || !this.nfc.hasBoundaryBefore(n5)) {
                this.setParseError("in 'prefix|str', prefix and str must each start with an NFC boundary");
                return;
            }
        }
        try {
            this.sink.addRelation(n2, string, this.rawBuilder, charSequence);
        }
        catch (Exception exception) {
            this.setParseError("adding relation failed", exception);
            return;
        }
        this.ruleIndex = n3;
    }

    private void parseStarredCharacters(int n2, int n3) throws ParseException {
        String string = "";
        n3 = this.parseString(this.skipWhiteSpace(n3), this.rawBuilder);
        if (this.rawBuilder.length() == 0) {
            this.setParseError("missing starred-relation string");
            return;
        }
        int n4 = -1;
        int n5 = 0;
        while (true) {
            int n6;
            if (n5 < this.rawBuilder.length()) {
                n6 = this.rawBuilder.codePointAt(n5);
                if (!this.nfd.isInert(n6)) {
                    this.setParseError("starred-relation string is not all NFD-inert");
                    return;
                }
                try {
                    this.sink.addRelation(n2, string, UTF16.valueOf(n6), string);
                }
                catch (Exception exception) {
                    this.setParseError("adding relation failed", exception);
                    return;
                }
                n5 += Character.charCount(n6);
                n4 = n6;
                continue;
            }
            if (n3 >= this.rules.length() || this.rules.charAt(n3) != '-') break;
            if (n4 < 0) {
                this.setParseError("range without start in starred-relation string");
                return;
            }
            n3 = this.parseString(n3 + 1, this.rawBuilder);
            if (this.rawBuilder.length() == 0) {
                this.setParseError("range without end in starred-relation string");
                return;
            }
            n6 = this.rawBuilder.codePointAt(0);
            if (n6 < n4) {
                this.setParseError("range start greater than end in starred-relation string");
                return;
            }
            while (++n4 <= n6) {
                if (!this.nfd.isInert(n4)) {
                    this.setParseError("starred-relation string range is not all NFD-inert");
                    return;
                }
                if (CollationRuleParser.isSurrogate(n4)) {
                    this.setParseError("starred-relation string range contains a surrogate");
                    return;
                }
                if (65533 <= n4 && n4 <= 65535) {
                    this.setParseError("starred-relation string range contains U+FFFD, U+FFFE or U+FFFF");
                    return;
                }
                try {
                    this.sink.addRelation(n2, string, UTF16.valueOf(n4), string);
                }
                catch (Exception exception) {
                    this.setParseError("adding relation failed", exception);
                    return;
                }
            }
            n4 = -1;
            n5 = Character.charCount(n6);
        }
        this.ruleIndex = this.skipWhiteSpace(n3);
    }

    private int parseTailoringString(int n2, StringBuilder stringBuilder) throws ParseException {
        n2 = this.parseString(this.skipWhiteSpace(n2), stringBuilder);
        if (stringBuilder.length() == 0) {
            this.setParseError("missing relation string");
        }
        return this.skipWhiteSpace(n2);
    }

    private int parseString(int n2, StringBuilder stringBuilder) throws ParseException {
        int n3;
        char c2;
        stringBuilder.setLength(0);
        block0: while (n2 < this.rules.length()) {
            if (CollationRuleParser.isSyntaxChar(c2 = this.rules.charAt(n2++))) {
                if (c2 == '\'') {
                    if (n2 < this.rules.length() && this.rules.charAt(n2) == '\'') {
                        stringBuilder.append('\'');
                        ++n2;
                        continue;
                    }
                    while (true) {
                        if (n2 == this.rules.length()) {
                            this.setParseError("quoted literal text missing terminating apostrophe");
                            return n2;
                        }
                        if ((c2 = (char)this.rules.charAt(n2++)) == '\'') {
                            if (n2 >= this.rules.length() || this.rules.charAt(n2) != '\'') continue block0;
                            ++n2;
                        }
                        stringBuilder.append(c2);
                    }
                }
                if (c2 == '\\') {
                    if (n2 == this.rules.length()) {
                        this.setParseError("backslash escape at the end of the rule string");
                        return n2;
                    }
                    n3 = this.rules.codePointAt(n2);
                    stringBuilder.appendCodePoint(n3);
                    n2 += Character.charCount(n3);
                    continue;
                }
                --n2;
                break;
            }
            if (PatternProps.isWhiteSpace(c2)) {
                --n2;
                break;
            }
            stringBuilder.append(c2);
        }
        for (c2 = '\u0000'; c2 < stringBuilder.length(); c2 += Character.charCount(n3)) {
            n3 = stringBuilder.codePointAt(c2);
            if (CollationRuleParser.isSurrogate(n3)) {
                this.setParseError("string contains an unpaired surrogate");
                return n2;
            }
            if (65533 > n3 || n3 > 65535) continue;
            this.setParseError("string contains U+FFFD, U+FFFE or U+FFFF");
            return n2;
        }
        return n2;
    }

    private static final boolean isSurrogate(int n2) {
        return (n2 & 0xFFFFF800) == 55296;
    }

    private int parseSpecialPosition(int n2, StringBuilder stringBuilder) throws ParseException {
        int n3 = this.readWords(n2 + 1, this.rawBuilder);
        if (n3 > n2 && this.rules.charAt(n3) == ']' && this.rawBuilder.length() != 0) {
            ++n3;
            String string = this.rawBuilder.toString();
            stringBuilder.setLength(0);
            for (int i2 = 0; i2 < positions.length; ++i2) {
                if (!string.equals(positions[i2])) continue;
                stringBuilder.append('\ufffe').append((char)(10240 + i2));
                return n3;
            }
            if (string.equals("top")) {
                stringBuilder.append('\ufffe').append((char)(10240 + Position.LAST_REGULAR.ordinal()));
                return n3;
            }
            if (string.equals("variable top")) {
                stringBuilder.append('\ufffe').append((char)(10240 + Position.LAST_VARIABLE.ordinal()));
                return n3;
            }
        }
        this.setParseError("not a valid special reset position");
        return n2;
    }

    private void parseSetting() throws ParseException {
        int n2 = this.ruleIndex + 1;
        int n3 = this.readWords(n2, this.rawBuilder);
        if (n3 <= n2 || this.rawBuilder.length() == 0) {
            this.setParseError("expected a setting/option at '['");
        }
        String string = this.rawBuilder.toString();
        if (this.rules.charAt(n3) == ']') {
            String string2;
            ++n3;
            if (string.startsWith("reorder") && (string.length() == 7 || string.charAt(7) == ' ')) {
                this.parseReordering(string);
                this.ruleIndex = n3;
                return;
            }
            if (string.equals("backwards 2")) {
                this.settings.setFlag(2048, true);
                this.ruleIndex = n3;
                return;
            }
            int n4 = string.lastIndexOf(32);
            if (n4 >= 0) {
                string2 = string.substring(n4 + 1);
                string = string.substring(0, n4);
            } else {
                string2 = "";
            }
            if (string.equals("strength") && string2.length() == 1) {
                int n5 = -1;
                char c2 = string2.charAt(0);
                if ('1' <= c2 && c2 <= '4') {
                    n5 = 0 + (c2 - 49);
                } else if (c2 == 'I') {
                    n5 = 15;
                }
                if (n5 != -1) {
                    this.settings.setStrength(n5);
                    this.ruleIndex = n3;
                    return;
                }
            } else if (string.equals("alternate")) {
                int n6 = -1;
                if (string2.equals("non-ignorable")) {
                    n6 = 0;
                } else if (string2.equals("shifted")) {
                    n6 = 1;
                }
                if (n6 != -1) {
                    this.settings.setAlternateHandlingShifted(n6 > 0);
                    this.ruleIndex = n3;
                    return;
                }
            } else if (string.equals("maxVariable")) {
                int n7 = -1;
                if (string2.equals("space")) {
                    n7 = 0;
                } else if (string2.equals("punct")) {
                    n7 = 1;
                } else if (string2.equals("symbol")) {
                    n7 = 2;
                } else if (string2.equals("currency")) {
                    n7 = 3;
                }
                if (n7 != -1) {
                    this.settings.setMaxVariable(n7, 0);
                    this.settings.variableTop = this.baseData.getLastPrimaryForGroup(4096 + n7);
                    assert (this.settings.variableTop != 0L);
                    this.ruleIndex = n3;
                    return;
                }
            } else if (string.equals("caseFirst")) {
                int n8 = -1;
                if (string2.equals("off")) {
                    n8 = 0;
                } else if (string2.equals("lower")) {
                    n8 = 512;
                } else if (string2.equals("upper")) {
                    n8 = 768;
                }
                if (n8 != -1) {
                    this.settings.setCaseFirst(n8);
                    this.ruleIndex = n3;
                    return;
                }
            } else if (string.equals("caseLevel")) {
                int n9 = CollationRuleParser.getOnOffValue(string2);
                if (n9 != -1) {
                    this.settings.setFlag(1024, n9 > 0);
                    this.ruleIndex = n3;
                    return;
                }
            } else if (string.equals("normalization")) {
                int n10 = CollationRuleParser.getOnOffValue(string2);
                if (n10 != -1) {
                    this.settings.setFlag(1, n10 > 0);
                    this.ruleIndex = n3;
                    return;
                }
            } else if (string.equals("numericOrdering")) {
                int n11 = CollationRuleParser.getOnOffValue(string2);
                if (n11 != -1) {
                    this.settings.setFlag(2, n11 > 0);
                    this.ruleIndex = n3;
                    return;
                }
            } else if (string.equals("hiraganaQ")) {
                int n12 = CollationRuleParser.getOnOffValue(string2);
                if (n12 != -1) {
                    if (n12 == 1) {
                        this.setParseError("[hiraganaQ on] is not supported");
                    }
                    this.ruleIndex = n3;
                    return;
                }
            } else if (string.equals("import")) {
                ULocale uLocale;
                try {
                    uLocale = new ULocale.Builder().setLanguageTag(string2).build();
                }
                catch (Exception exception) {
                    this.setParseError("expected language tag in [import langTag]", exception);
                    return;
                }
                String string3 = uLocale.getBaseName();
                String string4 = uLocale.getKeywordValue("collation");
                if (this.importer == null) {
                    this.setParseError("[import langTag] is not supported");
                } else {
                    String string5;
                    try {
                        string5 = this.importer.getRules(string3, string4 != null ? string4 : "standard");
                    }
                    catch (Exception exception) {
                        this.setParseError("[import langTag] failed", exception);
                        return;
                    }
                    String string6 = this.rules;
                    int n13 = this.ruleIndex;
                    try {
                        this.parse(string5);
                    }
                    catch (Exception exception) {
                        this.ruleIndex = n13;
                        this.setParseError("parsing imported rules failed", exception);
                    }
                    this.rules = string6;
                    this.ruleIndex = n3;
                }
                return;
            }
        } else if (this.rules.charAt(n3) == '[') {
            UnicodeSet unicodeSet = new UnicodeSet();
            n3 = this.parseUnicodeSet(n3, unicodeSet);
            if (string.equals("optimize")) {
                try {
                    this.sink.optimize(unicodeSet);
                }
                catch (Exception exception) {
                    this.setParseError("[optimize set] failed", exception);
                }
                this.ruleIndex = n3;
                return;
            }
            if (string.equals("suppressContractions")) {
                try {
                    this.sink.suppressContractions(unicodeSet);
                }
                catch (Exception exception) {
                    this.setParseError("[suppressContractions set] failed", exception);
                }
                this.ruleIndex = n3;
                return;
            }
        }
        this.setParseError("not a valid setting/option");
    }

    private void parseReordering(CharSequence charSequence) throws ParseException {
        int n2 = 7;
        if (n2 == charSequence.length()) {
            this.settings.resetReordering();
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (n2 < charSequence.length()) {
            int n3;
            for (n3 = ++n2; n3 < charSequence.length() && charSequence.charAt(n3) != ' '; ++n3) {
            }
            String string = charSequence.subSequence(n2, n3).toString();
            int n4 = CollationRuleParser.getReorderCode(string);
            if (n4 < 0) {
                this.setParseError("unknown script or reorder code");
                return;
            }
            arrayList.add(n4);
            n2 = n3;
        }
        if (arrayList.isEmpty()) {
            this.settings.resetReordering();
        } else {
            int[] nArray = new int[arrayList.size()];
            int n5 = 0;
            for (Integer n6 : arrayList) {
                nArray[n5++] = n6;
            }
            this.settings.setReordering(this.baseData, nArray);
        }
    }

    public static int getReorderCode(String string) {
        int n2;
        for (n2 = 0; n2 < gSpecialReorderCodes.length; ++n2) {
            if (!string.equalsIgnoreCase(gSpecialReorderCodes[n2])) continue;
            return 4096 + n2;
        }
        try {
            n2 = UCharacter.getPropertyValueEnum(4106, string);
            if (n2 >= 0) {
                return n2;
            }
        }
        catch (IllegalIcuArgumentException illegalIcuArgumentException) {
            // empty catch block
        }
        if (string.equalsIgnoreCase("others")) {
            return 103;
        }
        return -1;
    }

    private static int getOnOffValue(String string) {
        if (string.equals("on")) {
            return 1;
        }
        if (string.equals("off")) {
            return 0;
        }
        return -1;
    }

    private int parseUnicodeSet(int n2, UnicodeSet unicodeSet) throws ParseException {
        int n3 = 0;
        int n4 = n2;
        while (true) {
            char c2;
            if (n4 == this.rules.length()) {
                this.setParseError("unbalanced UnicodeSet pattern brackets");
                return n4;
            }
            if ((c2 = this.rules.charAt(n4++)) == '[') {
                ++n3;
                continue;
            }
            if (c2 == ']' && --n3 == 0) break;
        }
        try {
            unicodeSet.applyPattern(this.rules.substring(n2, n4));
        }
        catch (Exception exception) {
            this.setParseError("not a valid UnicodeSet pattern: " + exception.getMessage());
        }
        n4 = this.skipWhiteSpace(n4);
        if (n4 == this.rules.length() || this.rules.charAt(n4) != ']') {
            this.setParseError("missing option-terminating ']' after UnicodeSet pattern");
            return n4;
        }
        return ++n4;
    }

    private int readWords(int n2, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        n2 = this.skipWhiteSpace(n2);
        while (n2 < this.rules.length()) {
            char c2 = this.rules.charAt(n2);
            if (CollationRuleParser.isSyntaxChar(c2) && c2 != '-' && c2 != '_') {
                if (stringBuilder.length() == 0) {
                    return n2;
                }
                int n3 = stringBuilder.length() - 1;
                if (stringBuilder.charAt(n3) == ' ') {
                    stringBuilder.setLength(n3);
                }
                return n2;
            }
            if (PatternProps.isWhiteSpace(c2)) {
                stringBuilder.append(' ');
                n2 = this.skipWhiteSpace(n2 + 1);
                continue;
            }
            stringBuilder.append(c2);
            ++n2;
        }
        return 0;
    }

    private int skipComment(int n2) {
        char c2;
        while (n2 < this.rules.length() && (c2 = this.rules.charAt(n2++)) != '\n' && c2 != '\f' && c2 != '\r' && c2 != '\u0085' && c2 != '\u2028' && c2 != '\u2029') {
        }
        return n2;
    }

    private void setParseError(String string) throws ParseException {
        throw this.makeParseException(string);
    }

    private void setParseError(String string, Exception exception) throws ParseException {
        ParseException parseException = this.makeParseException(string + ": " + exception.getMessage());
        parseException.initCause(exception);
        throw parseException;
    }

    private ParseException makeParseException(String string) {
        return new ParseException(this.appendErrorContext(string), this.ruleIndex);
    }

    private String appendErrorContext(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" at index ").append(this.ruleIndex);
        stringBuilder.append(" near \"");
        int n2 = this.ruleIndex - 15;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 0 && Character.isLowSurrogate(this.rules.charAt(n2))) {
            ++n2;
        }
        stringBuilder.append(this.rules, n2, this.ruleIndex);
        stringBuilder.append('!');
        int n3 = this.rules.length() - this.ruleIndex;
        if (n3 >= 16 && Character.isHighSurrogate(this.rules.charAt(this.ruleIndex + (n3 = 15) - 1))) {
            --n3;
        }
        stringBuilder.append(this.rules, this.ruleIndex, this.ruleIndex + n3);
        return stringBuilder.append('\"').toString();
    }

    private static boolean isSyntaxChar(int n2) {
        return 33 <= n2 && n2 <= 126 && (n2 <= 47 || 58 <= n2 && n2 <= 64 || 91 <= n2 && n2 <= 96 || 123 <= n2);
    }

    private int skipWhiteSpace(int n2) {
        while (n2 < this.rules.length() && PatternProps.isWhiteSpace(this.rules.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    static interface Importer {
        public String getRules(String var1, String var2);
    }

    static abstract class Sink {
        Sink() {
        }

        abstract void addReset(int var1, CharSequence var2);

        abstract void addRelation(int var1, CharSequence var2, CharSequence var3, CharSequence var4);

        void suppressContractions(UnicodeSet unicodeSet) {
        }

        void optimize(UnicodeSet unicodeSet) {
        }
    }

    static enum Position {
        FIRST_TERTIARY_IGNORABLE,
        LAST_TERTIARY_IGNORABLE,
        FIRST_SECONDARY_IGNORABLE,
        LAST_SECONDARY_IGNORABLE,
        FIRST_PRIMARY_IGNORABLE,
        LAST_PRIMARY_IGNORABLE,
        FIRST_VARIABLE,
        LAST_VARIABLE,
        FIRST_REGULAR,
        LAST_REGULAR,
        FIRST_IMPLICIT,
        LAST_IMPLICIT,
        FIRST_TRAILING,
        LAST_TRAILING;

    }
}

