/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Norm2AllModes;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2Writable;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.Collation;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationFastLatinBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationSettings;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UVector32;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UVector64;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSetIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrieBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.StringTrieBuilder;

final class CollationDataBuilder {
    private static final int IS_BUILDER_JAMO_CE32 = 256;
    protected Normalizer2Impl nfcImpl;
    protected CollationData base;
    protected CollationSettings baseSettings;
    protected Trie2Writable trie;
    protected UVector32 ce32s;
    protected UVector64 ce64s;
    protected ArrayList<ConditionalCE32> conditionalCE32s;
    protected UnicodeSet contextChars = new UnicodeSet();
    protected StringBuilder contexts = new StringBuilder();
    private int contextsEra = 0;
    protected UnicodeSet unsafeBackwardSet = new UnicodeSet();
    protected boolean modified;
    protected boolean fastLatinEnabled;
    protected CollationFastLatinBuilder fastLatinBuilder;
    protected DataBuilderCollationIterator collIter;

    CollationDataBuilder() {
        this.nfcImpl = Norm2AllModes.getNFCInstance().impl;
        this.base = null;
        this.baseSettings = null;
        this.trie = null;
        this.ce32s = new UVector32();
        this.ce64s = new UVector64();
        this.conditionalCE32s = new ArrayList();
        this.modified = false;
        this.fastLatinEnabled = false;
        this.fastLatinBuilder = null;
        this.collIter = null;
        this.ce32s.addElement(0);
    }

    void initForTailoring(CollationData collationData) {
        int n2;
        if (this.trie != null) {
            throw new IllegalStateException("attempt to reuse a CollationDataBuilder");
        }
        if (collationData == null) {
            throw new IllegalArgumentException("null CollationData");
        }
        this.base = collationData;
        this.trie = new Trie2Writable(192, -195323);
        for (n2 = 192; n2 <= 255; ++n2) {
            this.trie.set(n2, 192);
        }
        n2 = Collation.makeCE32FromTagAndIndex(12, 0);
        this.trie.setRange(44032, 55203, n2, true);
        this.unsafeBackwardSet.addAll(collationData.unsafeBackwardSet);
    }

    boolean isCompressibleLeadByte(int n2) {
        return this.base.isCompressibleLeadByte(n2);
    }

    boolean isCompressiblePrimary(long l2) {
        return this.isCompressibleLeadByte((int)l2 >>> 24);
    }

    boolean hasMappings() {
        return this.modified;
    }

    boolean isAssigned(int n2) {
        return Collation.isAssignedCE32(this.trie.get(n2));
    }

    void add(CharSequence charSequence, CharSequence charSequence2, long[] lArray, int n2) {
        int n3 = this.encodeCEs(lArray, n2);
        this.addCE32(charSequence, charSequence2, n3);
    }

    int encodeCEs(long[] lArray, int n2) {
        if (n2 < 0 || n2 > 31) {
            throw new IllegalArgumentException("mapping to too many CEs");
        }
        if (!this.isMutable()) {
            throw new IllegalStateException("attempt to add mappings after build()");
        }
        if (n2 == 0) {
            return CollationDataBuilder.encodeOneCEAsCE32(0L);
        }
        if (n2 == 1) {
            return this.encodeOneCE(lArray[0]);
        }
        if (n2 == 2) {
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = l2 >>> 32;
            if ((l2 & 0xFFFFFFFFFF00FFL) == 0x5000000L && (l3 & 0xFFFFFFFF00FFFFFFL) == 1280L && l4 != 0L) {
                return (int)l4 | ((int)l2 & 0xFF00) << 8 | (int)l3 >> 16 & 0xFF00 | 0xC0 | 4;
            }
        }
        int[] nArray = new int[31];
        int n3 = 0;
        while (true) {
            if (n3 == n2) {
                return this.encodeExpansion32(nArray, 0, n2);
            }
            int n4 = CollationDataBuilder.encodeOneCEAsCE32(lArray[n3]);
            if (n4 == 1) break;
            nArray[n3] = n4;
            ++n3;
        }
        return this.encodeExpansion(lArray, 0, n2);
    }

    void addCE32(CharSequence charSequence, CharSequence charSequence2, int n2) {
        boolean bl2;
        if (charSequence2.length() == 0) {
            throw new IllegalArgumentException("mapping from empty string");
        }
        if (!this.isMutable()) {
            throw new IllegalStateException("attempt to add mappings after build()");
        }
        int n3 = Character.codePointAt(charSequence2, 0);
        int n4 = Character.charCount(n3);
        int n5 = this.trie.get(n3);
        boolean bl3 = bl2 = charSequence.length() != 0 || charSequence2.length() > n4;
        if (n5 == 192) {
            int n6 = this.base.getFinalCE32(this.base.getCE32(n3));
            if (bl2 || Collation.ce32HasContext(n6)) {
                n5 = this.copyFromBaseCE32(n3, n6, true);
                this.trie.set(n3, n5);
            }
        }
        if (!bl2) {
            if (!CollationDataBuilder.isBuilderContextCE32(n5)) {
                this.trie.set(n3, n2);
            } else {
                ConditionalCE32 conditionalCE32 = this.getConditionalCE32ForCE32(n5);
                conditionalCE32.builtCE32 = 1;
                conditionalCE32.ce32 = n2;
            }
        } else {
            ConditionalCE32 conditionalCE32;
            if (!CollationDataBuilder.isBuilderContextCE32(n5)) {
                int n7 = this.addConditionalCE32("\u0000", n5);
                int n8 = CollationDataBuilder.makeBuilderContextCE32(n7);
                this.trie.set(n3, n8);
                this.contextChars.add(n3);
                conditionalCE32 = this.getConditionalCE32(n7);
            } else {
                conditionalCE32 = this.getConditionalCE32ForCE32(n5);
                conditionalCE32.builtCE32 = 1;
            }
            CharSequence charSequence3 = charSequence2.subSequence(n4, charSequence2.length());
            String string = "" + (char)charSequence.length() + charSequence + charSequence3;
            this.unsafeBackwardSet.addAll(charSequence3);
            while (true) {
                int n9;
                if ((n9 = conditionalCE32.next) < 0) {
                    int n10;
                    conditionalCE32.next = n10 = this.addConditionalCE32(string, n2);
                    break;
                }
                ConditionalCE32 conditionalCE322 = this.getConditionalCE32(n9);
                int n11 = string.compareTo(conditionalCE322.context);
                if (n11 < 0) {
                    int n12;
                    conditionalCE32.next = n12 = this.addConditionalCE32(string, n2);
                    this.getConditionalCE32((int)n12).next = n9;
                    break;
                }
                if (n11 == 0) {
                    conditionalCE322.ce32 = n2;
                    break;
                }
                conditionalCE32 = conditionalCE322;
            }
        }
        this.modified = true;
    }

    void copyFrom(CollationDataBuilder collationDataBuilder, CEModifier cEModifier) {
        if (!this.isMutable()) {
            throw new IllegalStateException("attempt to copyFrom() after build()");
        }
        CopyHelper copyHelper = new CopyHelper(collationDataBuilder, this, cEModifier);
        for (Trie2.Range range : collationDataBuilder.trie) {
            if (range.leadSurrogate) break;
            CollationDataBuilder.enumRangeForCopy(range.startCodePoint, range.endCodePoint, range.value, copyHelper);
        }
        this.modified |= collationDataBuilder.modified;
    }

    void optimize(UnicodeSet unicodeSet) {
        if (unicodeSet.isEmpty()) {
            return;
        }
        UnicodeSetIterator unicodeSetIterator = new UnicodeSetIterator(unicodeSet);
        while (unicodeSetIterator.next() && unicodeSetIterator.codepoint != -1) {
            int n2 = unicodeSetIterator.codepoint;
            int n3 = this.trie.get(n2);
            if (n3 != 192) continue;
            n3 = this.base.getFinalCE32(this.base.getCE32(n2));
            n3 = this.copyFromBaseCE32(n2, n3, true);
            this.trie.set(n2, n3);
        }
        this.modified = true;
    }

    void suppressContractions(UnicodeSet unicodeSet) {
        if (unicodeSet.isEmpty()) {
            return;
        }
        UnicodeSetIterator unicodeSetIterator = new UnicodeSetIterator(unicodeSet);
        while (unicodeSetIterator.next() && unicodeSetIterator.codepoint != -1) {
            int n2 = unicodeSetIterator.codepoint;
            int n3 = this.trie.get(n2);
            if (n3 == 192) {
                n3 = this.base.getFinalCE32(this.base.getCE32(n2));
                if (!Collation.ce32HasContext(n3)) continue;
                n3 = this.copyFromBaseCE32(n2, n3, false);
                this.trie.set(n2, n3);
                continue;
            }
            if (!CollationDataBuilder.isBuilderContextCE32(n3)) continue;
            n3 = this.getConditionalCE32ForCE32((int)n3).ce32;
            this.trie.set(n2, n3);
            this.contextChars.remove(n2);
        }
        this.modified = true;
    }

    void enableFastLatin() {
        this.fastLatinEnabled = true;
    }

    void build(CollationData collationData) {
        this.buildMappings(collationData);
        if (this.base != null) {
            collationData.numericPrimary = this.base.numericPrimary;
            collationData.compressibleBytes = this.base.compressibleBytes;
            collationData.numScripts = this.base.numScripts;
            collationData.scriptsIndex = this.base.scriptsIndex;
            collationData.scriptStarts = this.base.scriptStarts;
        }
        this.buildFastLatinTable(collationData);
    }

    int getCEs(CharSequence charSequence, long[] lArray, int n2) {
        return this.getCEs(charSequence, 0, lArray, n2);
    }

    int getCEs(CharSequence charSequence, CharSequence charSequence2, long[] lArray, int n2) {
        int n3 = charSequence.length();
        if (n3 == 0) {
            return this.getCEs(charSequence2, 0, lArray, n2);
        }
        return this.getCEs((CharSequence)new StringBuilder(charSequence).append(charSequence2), n3, lArray, n2);
    }

    protected int getCE32FromOffsetCE32(boolean bl2, int n2, int n3) {
        int n4 = Collation.indexFromCE32(n3);
        long l2 = bl2 ? this.base.ces[n4] : this.ce64s.elementAti(n4);
        long l3 = Collation.getThreeBytePrimaryForOffsetData(n2, l2);
        return Collation.makeLongPrimaryCE32(l3);
    }

    protected int addCE(long l2) {
        int n2 = this.ce64s.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (l2 != this.ce64s.elementAti(i2)) continue;
            return i2;
        }
        this.ce64s.addElement(l2);
        return n2;
    }

    protected int addCE32(int n2) {
        int n3 = this.ce32s.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 != this.ce32s.elementAti(i2)) continue;
            return i2;
        }
        this.ce32s.addElement(n2);
        return n3;
    }

    protected int addConditionalCE32(String string, int n2) {
        assert (string.length() != 0);
        int n3 = this.conditionalCE32s.size();
        if (n3 > 524287) {
            throw new IndexOutOfBoundsException("too many context-sensitive mappings");
        }
        ConditionalCE32 conditionalCE32 = new ConditionalCE32(string, n2);
        this.conditionalCE32s.add(conditionalCE32);
        return n3;
    }

    protected ConditionalCE32 getConditionalCE32(int n2) {
        return this.conditionalCE32s.get(n2);
    }

    protected ConditionalCE32 getConditionalCE32ForCE32(int n2) {
        return this.getConditionalCE32(Collation.indexFromCE32(n2));
    }

    protected static int makeBuilderContextCE32(int n2) {
        return Collation.makeCE32FromTagAndIndex(7, n2);
    }

    protected static boolean isBuilderContextCE32(int n2) {
        return Collation.hasCE32Tag(n2, 7);
    }

    protected static int encodeOneCEAsCE32(long l2) {
        long l3 = l2 >>> 32;
        int n2 = (int)l2;
        int n3 = n2 & 0xFFFF;
        assert ((n3 & 0xC000) != 49152);
        if ((l2 & 0xFFFF00FF00FFL) == 0L) {
            return (int)l3 | n2 >>> 16 | n3 >> 8;
        }
        if ((l2 & 0xFFFFFFFFFFL) == 0x5000500L) {
            return Collation.makeLongPrimaryCE32(l3);
        }
        if (l3 == 0L && (n3 & 0xFF) == 0) {
            return Collation.makeLongSecondaryCE32(n2);
        }
        return 1;
    }

    protected int encodeOneCE(long l2) {
        int n2 = CollationDataBuilder.encodeOneCEAsCE32(l2);
        if (n2 != 1) {
            return n2;
        }
        int n3 = this.addCE(l2);
        if (n3 > 524287) {
            throw new IndexOutOfBoundsException("too many mappings");
        }
        return Collation.makeCE32FromTagIndexAndLength(6, n3, 1);
    }

    protected int encodeExpansion(long[] lArray, int n2, int n3) {
        int n4;
        int n5;
        long l2 = lArray[n2];
        int n6 = this.ce64s.size() - n3;
        block0: for (n5 = 0; n5 <= n6; ++n5) {
            if (l2 != this.ce64s.elementAti(n5)) continue;
            if (n5 > 524287) {
                throw new IndexOutOfBoundsException("too many mappings");
            }
            n4 = 1;
            while (n4 != n3) {
                if (this.ce64s.elementAti(n5 + n4) != lArray[n2 + n4]) continue block0;
                ++n4;
            }
            return Collation.makeCE32FromTagIndexAndLength(6, n5, n3);
        }
        n5 = this.ce64s.size();
        if (n5 > 524287) {
            throw new IndexOutOfBoundsException("too many mappings");
        }
        for (n4 = 0; n4 < n3; ++n4) {
            this.ce64s.addElement(lArray[n2 + n4]);
        }
        return Collation.makeCE32FromTagIndexAndLength(6, n5, n3);
    }

    protected int encodeExpansion32(int[] nArray, int n2, int n3) {
        int n4;
        int n5;
        int n6 = nArray[n2];
        int n7 = this.ce32s.size() - n3;
        block0: for (n5 = 0; n5 <= n7; ++n5) {
            if (n6 != this.ce32s.elementAti(n5)) continue;
            if (n5 > 524287) {
                throw new IndexOutOfBoundsException("too many mappings");
            }
            n4 = 1;
            while (n4 != n3) {
                if (this.ce32s.elementAti(n5 + n4) != nArray[n2 + n4]) continue block0;
                ++n4;
            }
            return Collation.makeCE32FromTagIndexAndLength(5, n5, n3);
        }
        n5 = this.ce32s.size();
        if (n5 > 524287) {
            throw new IndexOutOfBoundsException("too many mappings");
        }
        for (n4 = 0; n4 < n3; ++n4) {
            this.ce32s.addElement(nArray[n2 + n4]);
        }
        return Collation.makeCE32FromTagIndexAndLength(5, n5, n3);
    }

    protected int copyFromBaseCE32(int n2, int n3, boolean bl2) {
        if (!Collation.isSpecialCE32(n3)) {
            return n3;
        }
        switch (Collation.tagFromCE32(n3)) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 5: {
                int n4 = Collation.indexFromCE32(n3);
                int n5 = Collation.lengthFromCE32(n3);
                n3 = this.encodeExpansion32(this.base.ce32s, n4, n5);
                break;
            }
            case 6: {
                int n6 = Collation.indexFromCE32(n3);
                int n7 = Collation.lengthFromCE32(n3);
                n3 = this.encodeExpansion(this.base.ces, n6, n7);
                break;
            }
            case 8: {
                int n8;
                int n9 = Collation.indexFromCE32(n3);
                n3 = this.base.getCE32FromContexts(n9);
                if (!bl2) {
                    return this.copyFromBaseCE32(n2, n3, false);
                }
                ConditionalCE32 conditionalCE32 = new ConditionalCE32("", 0);
                StringBuilder stringBuilder = new StringBuilder("\u0000");
                if (Collation.isContractionCE32(n3)) {
                    n8 = this.copyContractionsFromBaseCE32(stringBuilder, n2, n3, conditionalCE32);
                } else {
                    n3 = this.copyFromBaseCE32(n2, n3, true);
                    conditionalCE32.next = n8 = this.addConditionalCE32(stringBuilder.toString(), n3);
                }
                ConditionalCE32 conditionalCE322 = this.getConditionalCE32(n8);
                CharsTrie.Iterator iterator = CharsTrie.iterator(this.base.contexts, n9 + 2, 0);
                while (iterator.hasNext()) {
                    CharsTrie.Entry entry = iterator.next();
                    stringBuilder.setLength(0);
                    stringBuilder.append(entry.chars).reverse().insert(0, (char)entry.chars.length());
                    n3 = entry.value;
                    if (Collation.isContractionCE32(n3)) {
                        n8 = this.copyContractionsFromBaseCE32(stringBuilder, n2, n3, conditionalCE322);
                    } else {
                        n3 = this.copyFromBaseCE32(n2, n3, true);
                        conditionalCE322.next = n8 = this.addConditionalCE32(stringBuilder.toString(), n3);
                    }
                    conditionalCE322 = this.getConditionalCE32(n8);
                }
                n3 = CollationDataBuilder.makeBuilderContextCE32(conditionalCE32.next);
                this.contextChars.add(n2);
                break;
            }
            case 9: {
                if (!bl2) {
                    int n10 = Collation.indexFromCE32(n3);
                    n3 = this.base.getCE32FromContexts(n10);
                    return this.copyFromBaseCE32(n2, n3, false);
                }
                ConditionalCE32 conditionalCE32 = new ConditionalCE32("", 0);
                StringBuilder stringBuilder = new StringBuilder("\u0000");
                this.copyContractionsFromBaseCE32(stringBuilder, n2, n3, conditionalCE32);
                n3 = CollationDataBuilder.makeBuilderContextCE32(conditionalCE32.next);
                this.contextChars.add(n2);
                break;
            }
            case 12: {
                throw new UnsupportedOperationException("We forbid tailoring of Hangul syllables.");
            }
            case 14: {
                n3 = this.getCE32FromOffsetCE32(true, n2, n3);
                break;
            }
            case 15: {
                n3 = this.encodeOneCE(Collation.unassignedCEFromCodePoint(n2));
                break;
            }
            default: {
                throw new AssertionError((Object)"copyFromBaseCE32(c, ce32, withContext) requires ce32 == base.getFinalCE32(ce32)");
            }
        }
        return n3;
    }

    protected int copyContractionsFromBaseCE32(StringBuilder stringBuilder, int n2, int n3, ConditionalCE32 conditionalCE32) {
        int n4;
        int n5 = Collation.indexFromCE32(n3);
        if ((n3 & 0x100) != 0) {
            assert (stringBuilder.length() > 1);
            n4 = -1;
        } else {
            n3 = this.base.getCE32FromContexts(n5);
            assert (!Collation.isContractionCE32(n3));
            n3 = this.copyFromBaseCE32(n2, n3, true);
            conditionalCE32.next = n4 = this.addConditionalCE32(stringBuilder.toString(), n3);
            conditionalCE32 = this.getConditionalCE32(n4);
        }
        int n6 = stringBuilder.length();
        CharsTrie.Iterator iterator = CharsTrie.iterator(this.base.contexts, n5 + 2, 0);
        while (iterator.hasNext()) {
            CharsTrie.Entry entry = iterator.next();
            stringBuilder.append(entry.chars);
            n3 = this.copyFromBaseCE32(n2, entry.value, true);
            conditionalCE32.next = n4 = this.addConditionalCE32(stringBuilder.toString(), n3);
            conditionalCE32 = this.getConditionalCE32(n4);
            stringBuilder.setLength(n6);
        }
        assert (n4 >= 0);
        return n4;
    }

    private static void enumRangeForCopy(int n2, int n3, int n4, CopyHelper copyHelper) {
        if (n4 != -1 && n4 != 192) {
            copyHelper.copyRangeCE32(n2, n3, n4);
        }
    }

    protected boolean getJamoCE32s(int[] nArray) {
        int n2;
        int n3;
        boolean bl2 = this.base == null;
        boolean bl3 = false;
        for (n3 = 0; n3 < 67; ++n3) {
            n2 = CollationDataBuilder.jamoCpFromIndex(n3);
            boolean bl4 = false;
            int n4 = this.trie.get(n2);
            bl2 |= Collation.isAssignedCE32(n4);
            if (n4 == 192) {
                bl4 = true;
                n4 = this.base.getCE32(n2);
            }
            if (Collation.isSpecialCE32(n4)) {
                switch (Collation.tagFromCE32(n4)) {
                    case 1: 
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: {
                        if (!bl4) break;
                        n4 = 192;
                        bl3 = true;
                        break;
                    }
                    case 15: {
                        assert (bl4);
                        n4 = 192;
                        bl3 = true;
                        break;
                    }
                    case 14: {
                        n4 = this.getCE32FromOffsetCE32(bl4, n2, n4);
                        break;
                    }
                    case 0: 
                    case 3: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        throw new AssertionError((Object)String.format("unexpected special tag in ce32=0x%08x", n4));
                    }
                }
            }
            nArray[n3] = n4;
        }
        if (bl2 && bl3) {
            for (n3 = 0; n3 < 67; ++n3) {
                if (nArray[n3] != 192) continue;
                n2 = CollationDataBuilder.jamoCpFromIndex(n3);
                nArray[n3] = this.copyFromBaseCE32(n2, this.base.getCE32(n2), true);
            }
        }
        return bl2;
    }

    protected void setDigitTags() {
        UnicodeSet unicodeSet = new UnicodeSet("[:Nd:]");
        UnicodeSetIterator unicodeSetIterator = new UnicodeSetIterator(unicodeSet);
        while (unicodeSetIterator.next()) {
            assert (unicodeSetIterator.codepoint != -1);
            int n2 = unicodeSetIterator.codepoint;
            int n3 = this.trie.get(n2);
            if (n3 == 192 || n3 == -1) continue;
            int n4 = this.addCE32(n3);
            if (n4 > 524287) {
                throw new IndexOutOfBoundsException("too many mappings");
            }
            n3 = Collation.makeCE32FromTagIndexAndLength(10, n4, UCharacter.digit(n2));
            this.trie.set(n2, n3);
        }
    }

    protected void setLeadSurrogates() {
        for (char c2 = '\ud800'; c2 < '\udc00'; c2 = (char)(c2 + '\u0001')) {
            int n2 = -1;
            Iterator<Trie2.Range> iterator = this.trie.iteratorForLeadSurrogate(c2);
            while (iterator.hasNext()) {
                Trie2.Range range = iterator.next();
                int n3 = range.value;
                if (n3 == -1) {
                    n3 = 0;
                } else if (n3 == 192) {
                    n3 = 256;
                } else {
                    n2 = 512;
                    break;
                }
                if (n2 < 0) {
                    n2 = n3;
                    continue;
                }
                if (n2 == n3) continue;
                n2 = 512;
                break;
            }
            this.trie.setForLeadSurrogateCodeUnit(c2, Collation.makeCE32FromTagAndIndex(13, 0) | n2);
        }
    }

    protected void buildMappings(CollationData collationData) {
        int n2;
        int n3;
        int n4;
        if (!this.isMutable()) {
            throw new IllegalStateException("attempt to build() after build()");
        }
        this.buildContexts();
        int[] nArray = new int[67];
        int n5 = -1;
        if (this.getJamoCE32s(nArray)) {
            n5 = this.ce32s.size();
            for (n4 = 0; n4 < 67; ++n4) {
                this.ce32s.addElement(nArray[n4]);
            }
            n4 = 0;
            for (n3 = 19; n3 < 67; ++n3) {
                if (!Collation.isSpecialCE32(nArray[n3])) continue;
                n4 = 1;
                break;
            }
            n3 = Collation.makeCE32FromTagAndIndex(12, 0);
            n2 = 44032;
            for (int i2 = 0; i2 < 19; ++i2) {
                int n6 = n3;
                if (n4 == 0 && !Collation.isSpecialCE32(nArray[i2])) {
                    n6 |= 0x100;
                }
                int n7 = n2 + 588;
                this.trie.setRange(n2, n7 - 1, n6, true);
                n2 = n7;
            }
        } else {
            n4 = 44032;
            while (n4 < 55204) {
                n3 = this.base.getCE32(n4);
                assert (Collation.hasCE32Tag(n3, 12));
                n2 = n4 + 588;
                this.trie.setRange(n4, n2 - 1, n3, true);
                n4 = n2;
            }
        }
        this.setDigitTags();
        this.setLeadSurrogates();
        this.ce32s.setElementAt(this.trie.get(0), 0);
        this.trie.set(0, Collation.makeCE32FromTagAndIndex(11, 0));
        collationData.trie = this.trie.toTrie2_32();
        n4 = 65536;
        n3 = 55296;
        while (n3 < 56320) {
            if (this.unsafeBackwardSet.containsSome(n4, n4 + 1023)) {
                this.unsafeBackwardSet.add(n3);
            }
            n3 = (char)(n3 + 1);
            n4 += 1024;
        }
        this.unsafeBackwardSet.freeze();
        collationData.ce32s = this.ce32s.getBuffer();
        collationData.ces = this.ce64s.getBuffer();
        collationData.contexts = this.contexts.toString();
        collationData.base = this.base;
        collationData.jamoCE32s = n5 >= 0 ? nArray : this.base.jamoCE32s;
        collationData.unsafeBackwardSet = this.unsafeBackwardSet;
    }

    protected void clearContexts() {
        this.contexts.setLength(0);
        ++this.contextsEra;
    }

    protected void buildContexts() {
        this.clearContexts();
        UnicodeSetIterator unicodeSetIterator = new UnicodeSetIterator(this.contextChars);
        while (unicodeSetIterator.next()) {
            assert (unicodeSetIterator.codepoint != -1);
            int n2 = unicodeSetIterator.codepoint;
            int n3 = this.trie.get(n2);
            if (!CollationDataBuilder.isBuilderContextCE32(n3)) {
                throw new AssertionError((Object)"Impossible: No context data for c in contextChars.");
            }
            ConditionalCE32 conditionalCE32 = this.getConditionalCE32ForCE32(n3);
            n3 = this.buildContext(conditionalCE32);
            this.trie.set(n2, n3);
        }
    }

    protected int buildContext(ConditionalCE32 conditionalCE32) {
        assert (!conditionalCE32.hasContext());
        assert (conditionalCE32.next >= 0);
        CharsTrieBuilder charsTrieBuilder = null;
        CharsTrieBuilder charsTrieBuilder2 = null;
        ConditionalCE32 conditionalCE322 = conditionalCE32;
        while (true) {
            int n2;
            ConditionalCE32 conditionalCE323;
            assert (conditionalCE322 == conditionalCE32 || conditionalCE322.hasContext());
            int n3 = conditionalCE322.prefixLength();
            StringBuilder stringBuilder = new StringBuilder().append(conditionalCE322.context, 0, n3 + 1);
            String string = stringBuilder.toString();
            ConditionalCE32 conditionalCE324 = conditionalCE322;
            do {
                conditionalCE323 = conditionalCE322;
                conditionalCE322.defaultCE32 = 1;
                if (conditionalCE322.next < 0) break;
                conditionalCE322 = this.getConditionalCE32(conditionalCE322.next);
            } while (conditionalCE322.context.startsWith(string));
            int n4 = n3 + 1;
            if (conditionalCE323.context.length() == n4) {
                assert (conditionalCE324 == conditionalCE323);
                n2 = conditionalCE323.ce32;
                conditionalCE322 = conditionalCE323;
            } else {
                int n5;
                if (charsTrieBuilder2 == null) {
                    charsTrieBuilder2 = new CharsTrieBuilder();
                } else {
                    charsTrieBuilder2.clear();
                }
                int n6 = 1;
                int n7 = 0;
                if (conditionalCE324.context.length() == n4) {
                    n6 = conditionalCE324.ce32;
                    conditionalCE322 = this.getConditionalCE32(conditionalCE324.next);
                } else {
                    n7 |= 0x100;
                    conditionalCE322 = conditionalCE32;
                    while ((n5 = conditionalCE322.prefixLength()) != n3) {
                        if (conditionalCE322.defaultCE32 != 1 && (n5 == 0 || string.regionMatches(stringBuilder.length() - n5, conditionalCE322.context, 1, n5))) {
                            n6 = conditionalCE322.defaultCE32;
                        }
                        conditionalCE322 = this.getConditionalCE32(conditionalCE322.next);
                    }
                    conditionalCE322 = conditionalCE324;
                }
                n7 |= 0x200;
                while (true) {
                    String string2;
                    int n8;
                    if ((n8 = this.nfcImpl.getFCD16((string2 = conditionalCE322.context.substring(n4)).codePointAt(0))) <= 255) {
                        n7 &= 0xFFFFFDFF;
                    }
                    if ((n8 = this.nfcImpl.getFCD16(string2.codePointBefore(string2.length()))) > 255) {
                        n7 |= 0x400;
                    }
                    charsTrieBuilder2.add(string2, conditionalCE322.ce32);
                    if (conditionalCE322 == conditionalCE323) break;
                    conditionalCE322 = this.getConditionalCE32(conditionalCE322.next);
                }
                n5 = this.addContextTrie(n6, charsTrieBuilder2);
                if (n5 > 524287) {
                    throw new IndexOutOfBoundsException("too many context-sensitive mappings");
                }
                n2 = Collation.makeCE32FromTagAndIndex(9, n5) | n7;
            }
            assert (conditionalCE322 == conditionalCE323);
            conditionalCE324.defaultCE32 = n2;
            if (n3 == 0) {
                if (conditionalCE322.next < 0) {
                    return n2;
                }
            } else {
                stringBuilder.delete(0, 1);
                stringBuilder.reverse();
                if (charsTrieBuilder == null) {
                    charsTrieBuilder = new CharsTrieBuilder();
                }
                charsTrieBuilder.add(stringBuilder, n2);
                if (conditionalCE322.next < 0) break;
            }
            conditionalCE322 = this.getConditionalCE32(conditionalCE322.next);
        }
        assert (conditionalCE32.defaultCE32 != 1);
        int n9 = this.addContextTrie(conditionalCE32.defaultCE32, charsTrieBuilder);
        if (n9 > 524287) {
            throw new IndexOutOfBoundsException("too many context-sensitive mappings");
        }
        return Collation.makeCE32FromTagAndIndex(8, n9);
    }

    protected int addContextTrie(int n2, CharsTrieBuilder charsTrieBuilder) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)(n2 >> 16)).append((char)n2);
        stringBuilder.append(charsTrieBuilder.buildCharSequence(StringTrieBuilder.Option.SMALL));
        int n3 = this.contexts.indexOf(stringBuilder.toString());
        if (n3 < 0) {
            n3 = this.contexts.length();
            this.contexts.append((CharSequence)stringBuilder);
        }
        return n3;
    }

    protected void buildFastLatinTable(CollationData collationData) {
        if (!this.fastLatinEnabled) {
            return;
        }
        this.fastLatinBuilder = new CollationFastLatinBuilder();
        if (this.fastLatinBuilder.forData(collationData)) {
            char[] cArray = this.fastLatinBuilder.getHeader();
            char[] cArray2 = this.fastLatinBuilder.getTable();
            if (this.base != null && Arrays.equals(cArray, this.base.fastLatinTableHeader) && Arrays.equals(cArray2, this.base.fastLatinTable)) {
                this.fastLatinBuilder = null;
                cArray = this.base.fastLatinTableHeader;
                cArray2 = this.base.fastLatinTable;
            }
            collationData.fastLatinTableHeader = cArray;
            collationData.fastLatinTable = cArray2;
        } else {
            this.fastLatinBuilder = null;
        }
    }

    protected int getCEs(CharSequence charSequence, int n2, long[] lArray, int n3) {
        if (this.collIter == null) {
            this.collIter = new DataBuilderCollationIterator(this, new CollationData(this.nfcImpl));
            if (this.collIter == null) {
                return 0;
            }
        }
        return this.collIter.fetchCEs(charSequence, n2, lArray, n3);
    }

    protected static int jamoCpFromIndex(int n2) {
        if (n2 < 19) {
            return 4352 + n2;
        }
        if ((n2 -= 19) < 21) {
            return 4449 + n2;
        }
        return 4520 + (n2 -= 21);
    }

    protected final boolean isMutable() {
        return this.trie != null && this.unsafeBackwardSet != null && !this.unsafeBackwardSet.isFrozen();
    }

    private static final class DataBuilderCollationIterator
    extends CollationIterator {
        protected final CollationDataBuilder builder;
        protected final CollationData builderData;
        protected final int[] jamoCE32s = new int[67];
        protected CharSequence s;
        protected int pos;

        DataBuilderCollationIterator(CollationDataBuilder collationDataBuilder, CollationData collationData) {
            super(collationData, false);
            this.builder = collationDataBuilder;
            this.builderData = collationData;
            this.builderData.base = this.builder.base;
            for (int i2 = 0; i2 < 67; ++i2) {
                int n2 = CollationDataBuilder.jamoCpFromIndex(i2);
                this.jamoCE32s[i2] = Collation.makeCE32FromTagAndIndex(7, n2) | 0x100;
            }
            this.builderData.jamoCE32s = this.jamoCE32s;
        }

        int fetchCEs(CharSequence charSequence, int n2, long[] lArray, int n3) {
            this.builderData.ce32s = this.builder.ce32s.getBuffer();
            this.builderData.ces = this.builder.ce64s.getBuffer();
            this.builderData.contexts = this.builder.contexts.toString();
            this.reset();
            this.s = charSequence;
            this.pos = n2;
            while (this.pos < this.s.length()) {
                CollationData collationData;
                this.clearCEs();
                int n4 = Character.codePointAt(this.s, this.pos);
                this.pos += Character.charCount(n4);
                int n5 = this.builder.trie.get(n4);
                if (n5 == 192) {
                    collationData = this.builder.base;
                    n5 = this.builder.base.getCE32(n4);
                } else {
                    collationData = this.builderData;
                }
                this.appendCEsFromCE32(collationData, n4, n5, true);
                for (int i2 = 0; i2 < this.getCEsLength(); ++i2) {
                    long l2 = this.getCE(i2);
                    if (l2 == 0L) continue;
                    if (n3 < 31) {
                        lArray[n3] = l2;
                    }
                    ++n3;
                }
            }
            return n3;
        }

        @Override
        public void resetToOffset(int n2) {
            this.reset();
            this.pos = n2;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public int nextCodePoint() {
            if (this.pos == this.s.length()) {
                return -1;
            }
            int n2 = Character.codePointAt(this.s, this.pos);
            this.pos += Character.charCount(n2);
            return n2;
        }

        @Override
        public int previousCodePoint() {
            if (this.pos == 0) {
                return -1;
            }
            int n2 = Character.codePointBefore(this.s, this.pos);
            this.pos -= Character.charCount(n2);
            return n2;
        }

        @Override
        protected void forwardNumCodePoints(int n2) {
            this.pos = Character.offsetByCodePoints(this.s, this.pos, n2);
        }

        @Override
        protected void backwardNumCodePoints(int n2) {
            this.pos = Character.offsetByCodePoints(this.s, this.pos, -n2);
        }

        @Override
        protected int getDataCE32(int n2) {
            return this.builder.trie.get(n2);
        }

        @Override
        protected int getCE32FromBuilderData(int n2) {
            assert (Collation.hasCE32Tag(n2, 7));
            if ((n2 & 0x100) != 0) {
                int n3 = Collation.indexFromCE32(n2);
                return this.builder.trie.get(n3);
            }
            ConditionalCE32 conditionalCE32 = this.builder.getConditionalCE32ForCE32(n2);
            if (conditionalCE32.builtCE32 == 1 || conditionalCE32.era != this.builder.contextsEra) {
                try {
                    conditionalCE32.builtCE32 = this.builder.buildContext(conditionalCE32);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.builder.clearContexts();
                    conditionalCE32.builtCE32 = this.builder.buildContext(conditionalCE32);
                }
                conditionalCE32.era = this.builder.contextsEra;
                this.builderData.contexts = this.builder.contexts.toString();
            }
            return conditionalCE32.builtCE32;
        }
    }

    private static final class CopyHelper {
        CollationDataBuilder src;
        CollationDataBuilder dest;
        CEModifier modifier;
        long[] modifiedCEs = new long[31];

        CopyHelper(CollationDataBuilder collationDataBuilder, CollationDataBuilder collationDataBuilder2, CEModifier cEModifier) {
            this.src = collationDataBuilder;
            this.dest = collationDataBuilder2;
            this.modifier = cEModifier;
        }

        void copyRangeCE32(int n2, int n3, int n4) {
            n4 = this.copyCE32(n4);
            this.dest.trie.setRange(n2, n3, n4, true);
            if (CollationDataBuilder.isBuilderContextCE32(n4)) {
                this.dest.contextChars.add(n2, n3);
            }
        }

        int copyCE32(int n2) {
            if (!Collation.isSpecialCE32(n2)) {
                long l2 = this.modifier.modifyCE32(n2);
                if (l2 != 0x101000100L) {
                    n2 = this.dest.encodeOneCE(l2);
                }
            } else {
                int n3 = Collation.tagFromCE32(n2);
                if (n3 == 5) {
                    int[] nArray = this.src.ce32s.getBuffer();
                    int n4 = Collation.indexFromCE32(n2);
                    int n5 = Collation.lengthFromCE32(n2);
                    boolean bl2 = false;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        long l3;
                        n2 = nArray[n4 + i2];
                        if (Collation.isSpecialCE32(n2) || (l3 = this.modifier.modifyCE32(n2)) == 0x101000100L) {
                            if (!bl2) continue;
                            this.modifiedCEs[i2] = Collation.ceFromCE32(n2);
                            continue;
                        }
                        if (!bl2) {
                            for (int i3 = 0; i3 < i2; ++i3) {
                                this.modifiedCEs[i3] = Collation.ceFromCE32(nArray[n4 + i3]);
                            }
                            bl2 = true;
                        }
                        this.modifiedCEs[i2] = l3;
                    }
                    n2 = bl2 ? this.dest.encodeCEs(this.modifiedCEs, n5) : this.dest.encodeExpansion32(nArray, n4, n5);
                } else if (n3 == 6) {
                    long[] lArray = this.src.ce64s.getBuffer();
                    int n6 = Collation.indexFromCE32(n2);
                    int n7 = Collation.lengthFromCE32(n2);
                    boolean bl3 = false;
                    for (int i4 = 0; i4 < n7; ++i4) {
                        long l4 = lArray[n6 + i4];
                        long l5 = this.modifier.modifyCE(l4);
                        if (l5 == 0x101000100L) {
                            if (!bl3) continue;
                            this.modifiedCEs[i4] = l4;
                            continue;
                        }
                        if (!bl3) {
                            for (int i5 = 0; i5 < i4; ++i5) {
                                this.modifiedCEs[i5] = lArray[n6 + i5];
                            }
                            bl3 = true;
                        }
                        this.modifiedCEs[i4] = l5;
                    }
                    n2 = bl3 ? this.dest.encodeCEs(this.modifiedCEs, n7) : this.dest.encodeExpansion(lArray, n6, n7);
                } else if (n3 == 7) {
                    ConditionalCE32 conditionalCE32 = this.src.getConditionalCE32ForCE32(n2);
                    assert (!conditionalCE32.hasContext());
                    int n8 = this.dest.addConditionalCE32(conditionalCE32.context, this.copyCE32(conditionalCE32.ce32));
                    n2 = CollationDataBuilder.makeBuilderContextCE32(n8);
                    while (conditionalCE32.next >= 0) {
                        conditionalCE32 = this.src.getConditionalCE32(conditionalCE32.next);
                        ConditionalCE32 conditionalCE322 = this.dest.getConditionalCE32(n8);
                        n8 = this.dest.addConditionalCE32(conditionalCE32.context, this.copyCE32(conditionalCE32.ce32));
                        int n9 = conditionalCE32.prefixLength() + 1;
                        this.dest.unsafeBackwardSet.addAll(conditionalCE32.context.substring(n9));
                        conditionalCE322.next = n8;
                    }
                } else assert (n3 == 1 || n3 == 2 || n3 == 4 || n3 == 12);
            }
            return n2;
        }
    }

    private static final class ConditionalCE32 {
        String context;
        int ce32;
        int defaultCE32;
        int builtCE32;
        int era = -1;
        int next;

        ConditionalCE32(String string, int n2) {
            this.context = string;
            this.ce32 = n2;
            this.defaultCE32 = 1;
            this.builtCE32 = 1;
            this.next = -1;
        }

        boolean hasContext() {
            return this.context.length() > 1;
        }

        int prefixLength() {
            return this.context.charAt(0);
        }
    }

    static interface CEModifier {
        public long modifyCE32(int var1);

        public long modifyCE(long var1);
    }
}

