/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter;

import java.io.IOException;
import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Assert;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.BytesDictionaryMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.CharsDictionaryMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

final class DictionaryData {
    public static final int TRIE_TYPE_BYTES = 0;
    public static final int TRIE_TYPE_UCHARS = 1;
    public static final int TRIE_TYPE_MASK = 7;
    public static final int TRIE_HAS_VALUES = 8;
    public static final int TRANSFORM_NONE = 0;
    public static final int TRANSFORM_TYPE_OFFSET = 0x1000000;
    public static final int TRANSFORM_TYPE_MASK = 0x7F000000;
    public static final int TRANSFORM_OFFSET_MASK = 0x1FFFFF;
    public static final int IX_STRING_TRIE_OFFSET = 0;
    public static final int IX_RESERVED1_OFFSET = 1;
    public static final int IX_RESERVED2_OFFSET = 2;
    public static final int IX_TOTAL_SIZE = 3;
    public static final int IX_TRIE_TYPE = 4;
    public static final int IX_TRANSFORM = 5;
    public static final int IX_RESERVED6 = 6;
    public static final int IX_RESERVED7 = 7;
    public static final int IX_COUNT = 8;
    private static final int DATA_FORMAT_ID = 1147757428;

    private DictionaryData() {
    }

    public static DictionaryMatcher loadDictionaryFor(String string) throws IOException {
        int n2;
        int n3;
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/brkitr");
        String string2 = iCUResourceBundle.getStringWithFallback("dictionaries/" + string);
        string2 = "brkitr/" + string2;
        ByteBuffer byteBuffer = ICUBinary.getRequiredData(string2);
        ICUBinary.readHeader(byteBuffer, 1147757428, null);
        int[] nArray = new int[8];
        for (n3 = 0; n3 < 8; ++n3) {
            nArray[n3] = byteBuffer.getInt();
        }
        n3 = nArray[0];
        Assert.assrt(n3 >= 32);
        if (n3 > 32) {
            n2 = n3 - 32;
            ICUBinary.skipBytes(byteBuffer, n2);
        }
        n2 = nArray[4] & 7;
        int n4 = nArray[3] - n3;
        DictionaryMatcher dictionaryMatcher = null;
        if (n2 == 0) {
            int n5 = nArray[5];
            byte[] byArray = new byte[n4];
            byteBuffer.get(byArray);
            dictionaryMatcher = new BytesDictionaryMatcher(byArray, n5);
        } else if (n2 == 1) {
            Assert.assrt(n4 % 2 == 0);
            String string3 = ICUBinary.getString(byteBuffer, n4 / 2, n4 & 1);
            dictionaryMatcher = new CharsDictionaryMatcher(string3);
        } else {
            dictionaryMatcher = null;
        }
        return dictionaryMatcher;
    }
}

