/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter;

import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Assert;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CharacterIteration;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUConfig;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.MlBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSetIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundleIterator;

public class CjkBreakEngine
extends DictionaryBreakEngine {
    private UnicodeSet fHangulWordSet = new UnicodeSet("[\\uac00-\\ud7a3]");
    private UnicodeSet fDigitOrOpenPunctuationOrAlphabetSet;
    private UnicodeSet fClosePunctuationSet;
    private DictionaryMatcher fDictionary = null;
    private HashSet<String> fSkipSet;
    private MlBreakEngine fMlBreakEngine;
    private boolean isCj = false;
    private static final int kMaxKatakanaLength = 8;
    private static final int kMaxKatakanaGroupLength = 20;
    private static final int maxSnlp = 255;
    private static final int kint32max = Integer.MAX_VALUE;

    public CjkBreakEngine(boolean bl2) throws IOException {
        this.fHangulWordSet.freeze();
        this.fDigitOrOpenPunctuationOrAlphabetSet = new UnicodeSet("[[:Nd:][:Pi:][:Ps:][:Alphabetic:]]");
        this.fDigitOrOpenPunctuationOrAlphabetSet.freeze();
        this.fClosePunctuationSet = new UnicodeSet("[[:Pc:][:Pd:][:Pe:][:Pf:][:Po:]]");
        this.fClosePunctuationSet.freeze();
        this.fSkipSet = new HashSet();
        this.fDictionary = DictionaryData.loadDictionaryFor("Hira");
        if (bl2) {
            this.setCharacters(this.fHangulWordSet);
        } else {
            this.isCj = true;
            UnicodeSet unicodeSet = new UnicodeSet("[[:Han:][:Hiragana:][:Katakana:]\\u30fc\\uff70\\uff9e\\uff9f]");
            this.setCharacters(unicodeSet);
            if (Boolean.parseBoolean(ICUConfig.get("macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.useMLPhraseBreaking", "false"))) {
                this.fMlBreakEngine = new MlBreakEngine(this.fDigitOrOpenPunctuationOrAlphabetSet, this.fClosePunctuationSet);
            } else {
                this.initializeJapanesePhraseParamater();
            }
        }
    }

    private void initializeJapanesePhraseParamater() {
        this.loadJapaneseExtensions();
        this.loadHiragana();
    }

    private void loadJapaneseExtensions() {
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/brkitr", "ja");
        String string = "extensions";
        UResourceBundle uResourceBundle2 = uResourceBundle.get("extensions");
        UResourceBundleIterator uResourceBundleIterator = uResourceBundle2.getIterator();
        while (uResourceBundleIterator.hasNext()) {
            this.fSkipSet.add(uResourceBundleIterator.nextString());
        }
    }

    private void loadHiragana() {
        UnicodeSet unicodeSet = new UnicodeSet("[:Hiragana:]");
        unicodeSet.freeze();
        UnicodeSetIterator unicodeSetIterator = new UnicodeSetIterator(unicodeSet);
        while (unicodeSetIterator.next()) {
            this.fSkipSet.add(unicodeSetIterator.getString());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof CjkBreakEngine) {
            CjkBreakEngine cjkBreakEngine = (CjkBreakEngine)object;
            return this.fSet.equals(cjkBreakEngine.fSet);
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static int getKatakanaCost(int n2) {
        int[] nArray = new int[]{8192, 984, 408, 240, 204, 252, 300, 372, 480};
        return n2 > 8 ? 8192 : nArray[n2];
    }

    private static boolean isKatakana(int n2) {
        return n2 >= 12449 && n2 <= 12542 && n2 != 12539 || n2 >= 65382 && n2 <= 65439;
    }

    @Override
    public int divideUpDictionaryRange(CharacterIterator characterIterator, int n2, int n3, DictionaryBreakEngine.DequeI dequeI, boolean bl2) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        StringCharacterIterator stringCharacterIterator;
        if (n2 >= n3) {
            return 0;
        }
        characterIterator.setIndex(n2);
        int n10 = n3 - n2;
        int[] nArray = new int[n10 + 1];
        StringBuffer stringBuffer = new StringBuffer("");
        characterIterator.setIndex(n2);
        while (characterIterator.getIndex() < n3) {
            stringBuffer.append(characterIterator.current());
            characterIterator.next();
        }
        String string = stringBuffer.toString();
        boolean bl3 = Normalizer.quickCheck(string, Normalizer.NFKC) == Normalizer.YES || Normalizer.isNormalized(string, Normalizer.NFKC, 0);
        int n11 = 0;
        if (bl3) {
            stringCharacterIterator = new StringCharacterIterator(string);
            int n12 = 0;
            nArray[0] = 0;
            while (n12 < string.length()) {
                int n13 = string.codePointAt(n12);
                nArray[++n11] = n12 += Character.charCount(n13);
            }
        } else {
            String string2 = Normalizer.normalize(string, Normalizer.NFKC);
            stringCharacterIterator = new StringCharacterIterator(string2);
            nArray = new int[string2.length() + 1];
            Normalizer normalizer = new Normalizer(string, Normalizer.NFKC, 0);
            n9 = 0;
            nArray[0] = 0;
            while (n9 < normalizer.endIndex()) {
                normalizer.next();
                nArray[++n11] = n9 = normalizer.getIndex();
            }
        }
        if (Boolean.parseBoolean(ICUConfig.get("macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.useMLPhraseBreaking", "false")) && bl2 && this.isCj) {
            return this.fMlBreakEngine.divideUpRange(characterIterator, n2, n3, stringCharacterIterator, n11, nArray, dequeI);
        }
        int[] nArray2 = new int[n11 + 1];
        nArray2[0] = 0;
        for (int i2 = 1; i2 <= n11; ++i2) {
            nArray2[i2] = Integer.MAX_VALUE;
        }
        int[] nArray3 = new int[n11 + 1];
        for (n9 = 0; n9 <= n11; ++n9) {
            nArray3[n9] = -1;
        }
        n9 = 20;
        int[] nArray4 = new int[n11];
        int[] nArray5 = new int[n11];
        int n14 = 0;
        stringCharacterIterator.setIndex(n14);
        int n15 = 0;
        for (int i3 = 0; i3 < n11; ++i3) {
            n14 = stringCharacterIterator.getIndex();
            if (nArray2[i3] != Integer.MAX_VALUE) {
                n8 = i3 + 20 < n11 ? 20 : n11 - i3;
                int[] nArray6 = new int[1];
                this.fDictionary.matches(stringCharacterIterator, n8, nArray5, nArray6, n8, nArray4);
                n7 = nArray6[0];
                stringCharacterIterator.setIndex(n14);
                if (!(n7 != 0 && nArray5[0] == 1 || CharacterIteration.current32(stringCharacterIterator) == Integer.MAX_VALUE || this.fHangulWordSet.contains(CharacterIteration.current32(stringCharacterIterator)))) {
                    nArray4[n7] = 255;
                    nArray5[n7] = 1;
                    ++n7;
                }
                for (n6 = 0; n6 < n7; ++n6) {
                    n5 = nArray2[i3] + nArray4[n6];
                    if (n5 >= nArray2[nArray5[n6] + i3]) continue;
                    nArray2[nArray5[n6] + i3] = n5;
                    nArray3[nArray5[n6] + i3] = i3;
                }
                n6 = CjkBreakEngine.isKatakana(CharacterIteration.current32(stringCharacterIterator)) ? 1 : 0;
                if (n15 == 0 && n6 != 0) {
                    CharacterIteration.next32(stringCharacterIterator);
                    for (n5 = i3 + 1; n5 < n11 && n5 - i3 < 20 && CjkBreakEngine.isKatakana(CharacterIteration.current32(stringCharacterIterator)); ++n5) {
                        CharacterIteration.next32(stringCharacterIterator);
                    }
                    if (n5 - i3 < 20 && (n4 = nArray2[i3] + CjkBreakEngine.getKatakanaCost(n5 - i3)) < nArray2[n5]) {
                        nArray2[n5] = n4;
                        nArray3[n5] = i3;
                    }
                }
                n15 = n6;
            }
            stringCharacterIterator.setIndex(n14);
            CharacterIteration.next32(stringCharacterIterator);
        }
        int[] nArray7 = new int[n11 + 1];
        n8 = 0;
        if (nArray2[n11] == Integer.MAX_VALUE) {
            nArray7[n8] = n11;
            ++n8;
        } else if (bl2) {
            nArray7[n8] = n11;
            ++n8;
            int n16 = n11;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            n4 = nArray3[n11];
            while (n4 > 0) {
                n7 = string.offsetByCodePoints(0, n4);
                n6 = string.offsetByCodePoints(0, n16);
                n5 = n6 - n7;
                n16 = n4;
                String string3 = this.getPatternFromText(stringCharacterIterator, stringBuffer, n7, n5);
                stringCharacterIterator.setIndex(n7);
                if (!(this.fSkipSet.contains(string3) || CjkBreakEngine.isKatakana(CharacterIteration.current32(stringCharacterIterator)) && CjkBreakEngine.isKatakana(CharacterIteration.previous32(stringCharacterIterator)))) {
                    nArray7[n8] = n4;
                    ++n8;
                }
                n4 = nArray3[n4];
            }
        } else {
            int n17 = n11;
            while (n17 > 0) {
                nArray7[n8] = n17;
                ++n8;
                n17 = nArray3[n17];
            }
            Assert.assrt(nArray3[nArray7[n8 - 1]] == 0);
        }
        if (dequeI.size() == 0 || dequeI.peek() < n2) {
            nArray7[n8++] = 0;
        }
        int n18 = 0;
        n7 = -1;
        for (n6 = n8 - 1; n6 >= 0; --n6) {
            n5 = nArray[nArray7[n6]] + n2;
            characterIterator.setIndex(n5);
            if (n5 > n7 && (n5 != n2 || bl2 && n5 > 0 && this.fClosePunctuationSet.contains(CharacterIteration.previous32(characterIterator)))) {
                dequeI.push(nArray[nArray7[n6]] + n2);
                ++n18;
            }
            n7 = n5;
        }
        if (!dequeI.isEmpty() && dequeI.peek() == n3) {
            if (bl2) {
                characterIterator.setIndex(n3);
                n6 = CharacterIteration.current32(characterIterator);
                if (n6 != Integer.MAX_VALUE && !this.fDigitOrOpenPunctuationOrAlphabetSet.contains(n6)) {
                    dequeI.pop();
                    --n18;
                }
            } else {
                dequeI.pop();
                --n18;
            }
        }
        if (!dequeI.isEmpty()) {
            characterIterator.setIndex(dequeI.peek());
        }
        return n18;
    }

    private String getPatternFromText(CharacterIterator characterIterator, StringBuffer stringBuffer, int n2, int n3) {
        stringBuffer.setLength(0);
        if (n3 > 0) {
            characterIterator.setIndex(n2);
            stringBuffer.append(characterIterator.current());
            for (int i2 = 1; i2 < n3; ++i2) {
                stringBuffer.append(characterIterator.next());
            }
        }
        return stringBuffer.toString();
    }
}

