/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.MissingResourceException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.EmojiProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Norm2AllModes;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_16;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UBiDiProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UCaseProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UScript;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.VersionInfo;

public final class UCharacterProperty {
    public static final UCharacterProperty INSTANCE;
    public Trie2_16 m_trie_;
    public VersionInfo m_unicodeVersion_;
    public static final char LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE_ = '\u0130';
    public static final char LATIN_SMALL_LETTER_DOTLESS_I_ = '\u0131';
    public static final char LATIN_SMALL_LETTER_I_ = 'i';
    public static final int TYPE_MASK = 31;
    public static final int SRC_NONE = 0;
    public static final int SRC_CHAR = 1;
    public static final int SRC_PROPSVEC = 2;
    public static final int SRC_NAMES = 3;
    public static final int SRC_CASE = 4;
    public static final int SRC_BIDI = 5;
    public static final int SRC_CHAR_AND_PROPSVEC = 6;
    public static final int SRC_CASE_AND_NORM = 7;
    public static final int SRC_NFC = 8;
    public static final int SRC_NFKC = 9;
    public static final int SRC_NFKC_CF = 10;
    public static final int SRC_NFC_CANON_ITER = 11;
    public static final int SRC_INPC = 12;
    public static final int SRC_INSC = 13;
    public static final int SRC_VO = 14;
    public static final int SRC_EMOJI = 15;
    public static final int SRC_IDSU = 16;
    public static final int SRC_ID_COMPAT_MATH = 17;
    public static final int SRC_COUNT = 18;
    static final int MY_MASK = 30;
    private static final int GC_CN_MASK;
    private static final int GC_CC_MASK;
    private static final int GC_CS_MASK;
    private static final int GC_ZS_MASK;
    private static final int GC_ZL_MASK;
    private static final int GC_ZP_MASK;
    private static final int GC_Z_MASK;
    private static final int[] ID_COMPAT_MATH_CONTINUE;
    private static final int[] ID_COMPAT_MATH_START;
    BinaryProperty[] binProps = new BinaryProperty[]{new BinaryProperty(1, 256), new BinaryProperty(1, 128), new BinaryProperty(5){

        @Override
        boolean contains(int n2) {
            return UBiDiProps.INSTANCE.isBidiControl(n2);
        }
    }, new BinaryProperty(5){

        @Override
        boolean contains(int n2) {
            return UBiDiProps.INSTANCE.isMirrored(n2);
        }
    }, new BinaryProperty(1, 2), new BinaryProperty(1, 524288), new BinaryProperty(1, 0x100000), new BinaryProperty(1, 1024), new BinaryProperty(1, 2048), new BinaryProperty(8){

        @Override
        boolean contains(int n2) {
            Normalizer2Impl normalizer2Impl = Norm2AllModes.getNFCInstance().impl;
            return normalizer2Impl.isCompNo(normalizer2Impl.getNorm16(n2));
        }
    }, new BinaryProperty(1, 0x4000000), new BinaryProperty(1, 8192), new BinaryProperty(1, 16384), new BinaryProperty(1, 64), new BinaryProperty(1, 4), new BinaryProperty(1, 0x2000000), new BinaryProperty(1, 0x1000000), new BinaryProperty(1, 512), new BinaryProperty(1, 32768), new BinaryProperty(1, 65536), new BinaryProperty(5){

        @Override
        boolean contains(int n2) {
            return UBiDiProps.INSTANCE.isJoinControl(n2);
        }
    }, new BinaryProperty(1, 0x200000), new CaseBinaryProperty(22), new BinaryProperty(1, 32), new BinaryProperty(1, 4096), new BinaryProperty(1, 8), new BinaryProperty(1, 131072), new CaseBinaryProperty(27), new BinaryProperty(1, 16), new BinaryProperty(1, 262144), new CaseBinaryProperty(30), new BinaryProperty(1, 1), new BinaryProperty(1, 0x800000), new BinaryProperty(1, 0x400000), new CaseBinaryProperty(34), new BinaryProperty(1, 0x8000000), new BinaryProperty(1, 0x10000000), new NormInertBinaryProperty(8, 37), new NormInertBinaryProperty(9, 38), new NormInertBinaryProperty(8, 39), new NormInertBinaryProperty(9, 40), new BinaryProperty(11){

        @Override
        boolean contains(int n2) {
            return Norm2AllModes.getNFCInstance().impl.ensureCanonIterData().isCanonSegmentStarter(n2);
        }
    }, new BinaryProperty(1, 0x20000000), new BinaryProperty(1, 0x40000000), new BinaryProperty(6){

        @Override
        boolean contains(int n2) {
            return UCharacter.isUAlphabetic(n2) || UCharacter.isDigit(n2);
        }
    }, new BinaryProperty(1){

        @Override
        boolean contains(int n2) {
            if (n2 <= 159) {
                return n2 == 9 || n2 == 32;
            }
            return UCharacter.getType(n2) == 12;
        }
    }, new BinaryProperty(1){

        @Override
        boolean contains(int n2) {
            return UCharacterProperty.isgraphPOSIX(n2);
        }
    }, new BinaryProperty(1){

        @Override
        boolean contains(int n2) {
            return UCharacter.getType(n2) == 12 || UCharacterProperty.isgraphPOSIX(n2);
        }
    }, new BinaryProperty(1){

        @Override
        boolean contains(int n2) {
            if (n2 <= 102 && n2 >= 65 && (n2 <= 70 || n2 >= 97) || n2 >= 65313 && n2 <= 65350 && (n2 <= 65318 || n2 >= 65345)) {
                return true;
            }
            return UCharacter.getType(n2) == 9;
        }
    }, new CaseBinaryProperty(49), new CaseBinaryProperty(50), new CaseBinaryProperty(51), new CaseBinaryProperty(52), new CaseBinaryProperty(53), new BinaryProperty(7){

        @Override
        boolean contains(int n2) {
            String string = Norm2AllModes.getNFCInstance().impl.getDecomposition(n2);
            if (string != null) {
                n2 = string.codePointAt(0);
                if (Character.charCount(n2) != string.length()) {
                    n2 = -1;
                }
            } else if (n2 < 0) {
                return false;
            }
            if (n2 >= 0) {
                UCaseProps uCaseProps = UCaseProps.INSTANCE;
                UCaseProps.dummyStringBuilder.setLength(0);
                return uCaseProps.toFullFolding(n2, UCaseProps.dummyStringBuilder, 0) >= 0;
            }
            String string2 = UCharacter.foldCase(string, true);
            return !string2.equals(string);
        }
    }, new CaseBinaryProperty(55), new BinaryProperty(10){

        @Override
        boolean contains(int n2) {
            Normalizer2Impl normalizer2Impl = Norm2AllModes.getNFKC_CFInstance().impl;
            String string = UTF16.valueOf(n2);
            StringBuilder stringBuilder = new StringBuilder();
            Normalizer2Impl.ReorderingBuffer reorderingBuffer = new Normalizer2Impl.ReorderingBuffer(normalizer2Impl, stringBuilder, 5);
            normalizer2Impl.compose(string, 0, string.length(), false, true, reorderingBuffer);
            return !Normalizer2Impl.UTF16Plus.equal(stringBuilder, string);
        }
    }, new EmojiBinaryProperty(57), new EmojiBinaryProperty(58), new EmojiBinaryProperty(59), new EmojiBinaryProperty(60), new EmojiBinaryProperty(61), new BinaryProperty(2){

        @Override
        boolean contains(int n2) {
            return 127462 <= n2 && n2 <= 127487;
        }
    }, new BinaryProperty(1, Integer.MIN_VALUE), new EmojiBinaryProperty(64), new EmojiBinaryProperty(65), new EmojiBinaryProperty(66), new EmojiBinaryProperty(67), new EmojiBinaryProperty(68), new EmojiBinaryProperty(69), new EmojiBinaryProperty(70), new EmojiBinaryProperty(71), new BinaryProperty(16){

        @Override
        boolean contains(int n2) {
            return 12286 <= n2 && n2 <= 12287;
        }
    }, new MathCompatBinaryProperty(73), new MathCompatBinaryProperty(74)};
    private static final int[] gcbToHst;
    IntProperty[] intProps = new IntProperty[]{new BiDiIntProperty(){

        @Override
        int getValue(int n2) {
            return UBiDiProps.INSTANCE.getClass(n2);
        }
    }, new IntProperty(0, 130816, 8), new CombiningClassIntProperty(8){

        @Override
        int getValue(int n2) {
            return Normalizer2.getNFDInstance().getCombiningClass(n2);
        }
    }, new IntProperty(2, 31, 0), new IntProperty(0, 917504, 17), new IntProperty(1){

        @Override
        int getValue(int n2) {
            return UCharacterProperty.this.getType(n2);
        }

        @Override
        int getMaxValue(int n2) {
            return 29;
        }
    }, new BiDiIntProperty(){

        @Override
        int getValue(int n2) {
            return UBiDiProps.INSTANCE.getJoiningGroup(n2);
        }
    }, new BiDiIntProperty(){

        @Override
        int getValue(int n2) {
            return UBiDiProps.INSTANCE.getJoiningType(n2);
        }
    }, new IntProperty(2, 0x3F00000, 20), new IntProperty(1){

        @Override
        int getValue(int n2) {
            return UCharacterProperty.ntvGetType(UCharacterProperty.getNumericTypeValue(UCharacterProperty.this.getProperty(n2)));
        }

        @Override
        int getMaxValue(int n2) {
            return 3;
        }
    }, new IntProperty(2){

        @Override
        int getValue(int n2) {
            return UScript.getScript(n2);
        }

        @Override
        int getMaxValue(int n2) {
            int n3 = UCharacterProperty.this.getMaxValues(0) & 0xF000FF;
            return UCharacterProperty.mergeScriptCodeOrIndex(n3);
        }
    }, new IntProperty(2){

        @Override
        int getValue(int n2) {
            int n3 = (UCharacterProperty.this.getAdditional(n2, 2) & 0x3E0) >>> 5;
            if (n3 < gcbToHst.length) {
                return gcbToHst[n3];
            }
            return 0;
        }

        @Override
        int getMaxValue(int n2) {
            return 5;
        }
    }, new NormQuickCheckIntProperty(8, 4108, 1), new NormQuickCheckIntProperty(9, 4109, 1), new NormQuickCheckIntProperty(8, 4110, 2), new NormQuickCheckIntProperty(9, 4111, 2), new CombiningClassIntProperty(8){

        @Override
        int getValue(int n2) {
            return Norm2AllModes.getNFCInstance().impl.getFCD16(n2) >> 8;
        }
    }, new CombiningClassIntProperty(8){

        @Override
        int getValue(int n2) {
            return Norm2AllModes.getNFCInstance().impl.getFCD16(n2) & 0xFF;
        }
    }, new IntProperty(2, 992, 5), new IntProperty(2, 1015808, 15), new IntProperty(2, 31744, 10), new BiDiIntProperty(){

        @Override
        int getValue(int n2) {
            return UBiDiProps.INSTANCE.getPairedBracketType(n2);
        }
    }, new IntProperty(12){

        @Override
        int getValue(int n2) {
            CodePointTrie codePointTrie = LayoutProps.INSTANCE.inpcTrie;
            return codePointTrie != null ? codePointTrie.get(n2) : 0;
        }

        @Override
        int getMaxValue(int n2) {
            return LayoutProps.INSTANCE.maxInpcValue;
        }
    }, new IntProperty(13){

        @Override
        int getValue(int n2) {
            CodePointTrie codePointTrie = LayoutProps.INSTANCE.inscTrie;
            return codePointTrie != null ? codePointTrie.get(n2) : 0;
        }

        @Override
        int getMaxValue(int n2) {
            return LayoutProps.INSTANCE.maxInscValue;
        }
    }, new IntProperty(14){

        @Override
        int getValue(int n2) {
            CodePointTrie codePointTrie = LayoutProps.INSTANCE.voTrie;
            return codePointTrie != null ? codePointTrie.get(n2) : 0;
        }

        @Override
        int getMaxValue(int n2) {
            return LayoutProps.INSTANCE.maxVoValue;
        }
    }, new IntProperty(2){

        @Override
        int getValue(int n2) {
            int n3 = UCharacterProperty.this.getAdditional(n2, 2) >>> 26;
            return n3 >= 60 ? UCharacter.IdentifierStatus.ALLOWED.ordinal() : UCharacter.IdentifierStatus.RESTRICTED.ordinal();
        }

        @Override
        int getMaxValue(int n2) {
            return UCharacter.IdentifierStatus.ALLOWED.ordinal();
        }
    }};
    Trie2_16 m_additionalTrie_;
    int[] m_additionalVectors_;
    int m_additionalColumnsCount_;
    int m_maxBlockScriptValue_;
    int m_maxJTGValue_;
    public char[] m_scriptExtensions_;
    private static final String DATA_FILE_NAME_ = "uprops.icu";
    private static final int NUMERIC_TYPE_VALUE_SHIFT_ = 6;
    private static final int NTV_NONE_ = 0;
    private static final int NTV_DECIMAL_START_ = 1;
    private static final int NTV_DIGIT_START_ = 11;
    private static final int NTV_NUMERIC_START_ = 21;
    private static final int NTV_FRACTION_START_ = 176;
    private static final int NTV_LARGE_START_ = 480;
    private static final int NTV_BASE60_START_ = 768;
    private static final int NTV_FRACTION20_START_ = 804;
    private static final int NTV_FRACTION32_START_ = 828;
    private static final int NTV_RESERVED_START_ = 844;
    public static final int SCRIPT_X_MASK = 0xF000FF;
    public static final int SCRIPT_HIGH_MASK = 0x300000;
    public static final int SCRIPT_HIGH_SHIFT = 12;
    public static final int MAX_SCRIPT = 1023;
    private static final int EAST_ASIAN_MASK_ = 917504;
    private static final int EAST_ASIAN_SHIFT_ = 17;
    private static final int BLOCK_MASK_ = 130816;
    private static final int BLOCK_SHIFT_ = 8;
    public static final int SCRIPT_LOW_MASK = 255;
    public static final int SCRIPT_X_WITH_COMMON = 0x400000;
    public static final int SCRIPT_X_WITH_INHERITED = 0x800000;
    public static final int SCRIPT_X_WITH_OTHER = 0xC00000;
    private static final int WHITE_SPACE_PROPERTY_ = 0;
    private static final int DASH_PROPERTY_ = 1;
    private static final int HYPHEN_PROPERTY_ = 2;
    private static final int QUOTATION_MARK_PROPERTY_ = 3;
    private static final int TERMINAL_PUNCTUATION_PROPERTY_ = 4;
    private static final int MATH_PROPERTY_ = 5;
    private static final int HEX_DIGIT_PROPERTY_ = 6;
    private static final int ASCII_HEX_DIGIT_PROPERTY_ = 7;
    private static final int ALPHABETIC_PROPERTY_ = 8;
    private static final int IDEOGRAPHIC_PROPERTY_ = 9;
    private static final int DIACRITIC_PROPERTY_ = 10;
    private static final int EXTENDER_PROPERTY_ = 11;
    private static final int NONCHARACTER_CODE_POINT_PROPERTY_ = 12;
    private static final int GRAPHEME_EXTEND_PROPERTY_ = 13;
    private static final int GRAPHEME_LINK_PROPERTY_ = 14;
    private static final int IDS_BINARY_OPERATOR_PROPERTY_ = 15;
    private static final int IDS_TRINARY_OPERATOR_PROPERTY_ = 16;
    private static final int RADICAL_PROPERTY_ = 17;
    private static final int UNIFIED_IDEOGRAPH_PROPERTY_ = 18;
    private static final int DEFAULT_IGNORABLE_CODE_POINT_PROPERTY_ = 19;
    private static final int DEPRECATED_PROPERTY_ = 20;
    private static final int LOGICAL_ORDER_EXCEPTION_PROPERTY_ = 21;
    private static final int XID_START_PROPERTY_ = 22;
    private static final int XID_CONTINUE_PROPERTY_ = 23;
    private static final int ID_START_PROPERTY_ = 24;
    private static final int ID_CONTINUE_PROPERTY_ = 25;
    private static final int GRAPHEME_BASE_PROPERTY_ = 26;
    private static final int S_TERM_PROPERTY_ = 27;
    private static final int VARIATION_SELECTOR_PROPERTY_ = 28;
    private static final int PATTERN_SYNTAX = 29;
    private static final int PATTERN_WHITE_SPACE = 30;
    private static final int PREPENDED_CONCATENATION_MARK = 31;
    private static final int ID_TYPE_SHIFT = 26;
    private static final int ID_TYPE_BIT = 128;
    private static final int ID_TYPE_EXCLUSION = 32;
    private static final int ID_TYPE_LIMITED_USE = 16;
    private static final int ID_TYPE_UNCOMMON_USE = 8;
    private static final int ID_TYPE_TECHNICAL = 4;
    private static final int ID_TYPE_OBSOLETE = 2;
    private static final int ID_TYPE_NOT_XID = 1;
    private static final int ID_TYPE_NOT_CHARACTER = 0;
    private static final int ID_TYPE_FORBIDDEN = 48;
    private static final int ID_TYPE_DEPRECATED = 48;
    private static final int ID_TYPE_DEFAULT_IGNORABLE = 49;
    private static final int ID_TYPE_NOT_NFKC = 50;
    private static final int ID_TYPE_ALLOWED_MIN = 60;
    private static final int ID_TYPE_INCLUSION = 62;
    private static final int ID_TYPE_RECOMMENDED = 63;
    private static final int[] idTypeToEncoded;
    private static final int LB_MASK = 0x3F00000;
    private static final int LB_SHIFT = 20;
    private static final int SB_MASK = 1015808;
    private static final int SB_SHIFT = 15;
    private static final int WB_MASK = 31744;
    private static final int WB_SHIFT = 10;
    private static final int GCB_MASK = 992;
    private static final int GCB_SHIFT = 5;
    private static final int DECOMPOSITION_TYPE_MASK_ = 31;
    private static final int FIRST_NIBBLE_SHIFT_ = 4;
    private static final int LAST_NIBBLE_MASK_ = 15;
    private static final int AGE_SHIFT_ = 24;
    private static final int DATA_FORMAT = 1431335535;
    private static final int TAB = 9;
    private static final int CR = 13;
    private static final int U_A = 65;
    private static final int U_F = 70;
    private static final int U_Z = 90;
    private static final int U_a = 97;
    private static final int U_f = 102;
    private static final int U_z = 122;
    private static final int DEL = 127;
    private static final int NL = 133;
    private static final int NBSP = 160;
    private static final int CGJ = 847;
    private static final int FIGURESP = 8199;
    private static final int HAIRSP = 8202;
    private static final int RLM = 8207;
    private static final int NNBSP = 8239;
    private static final int WJ = 8288;
    private static final int INHSWAP = 8298;
    private static final int NOMDIG = 8303;
    private static final int U_FW_A = 65313;
    private static final int U_FW_F = 65318;
    private static final int U_FW_Z = 65338;
    private static final int U_FW_a = 65345;
    private static final int U_FW_f = 65350;
    private static final int U_FW_z = 65370;
    private static final int ZWNBSP = 65279;

    public final int getProperty(int n2) {
        return this.m_trie_.get(n2);
    }

    public int getAdditional(int n2, int n3) {
        assert (n3 >= 0);
        if (n3 >= this.m_additionalColumnsCount_) {
            return 0;
        }
        return this.m_additionalVectors_[this.m_additionalTrie_.get(n2) + n3];
    }

    public VersionInfo getAge(int n2) {
        int n3 = this.getAdditional(n2, 0) >> 24;
        return VersionInfo.getInstance(n3 >> 4 & 0xF, n3 & 0xF, 0, 0);
    }

    private static final boolean isgraphPOSIX(int n2) {
        return (UCharacterProperty.getMask(UCharacter.getType(n2)) & (GC_CC_MASK | GC_CS_MASK | GC_CN_MASK | GC_Z_MASK)) == 0;
    }

    public boolean hasBinaryProperty(int n2, int n3) {
        if (n3 < 0 || 75 <= n3) {
            return false;
        }
        return this.binProps[n3].contains(n2);
    }

    public int getType(int n2) {
        return this.getProperty(n2) & 0x1F;
    }

    public int getIntPropertyValue(int n2, int n3) {
        if (n3 < 4096) {
            if (0 <= n3 && n3 < 75) {
                return this.binProps[n3].contains(n2) ? 1 : 0;
            }
        } else {
            if (n3 < 4122) {
                return this.intProps[n3 - 4096].getValue(n2);
            }
            if (n3 == 8192) {
                return UCharacterProperty.getMask(this.getType(n2));
            }
        }
        return 0;
    }

    public int getIntPropertyMaxValue(int n2) {
        if (n2 < 4096) {
            if (0 <= n2 && n2 < 75) {
                return 1;
            }
        } else if (n2 < 4122) {
            return this.intProps[n2 - 4096].getMaxValue(n2);
        }
        return -1;
    }

    final int getSource(int n2) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 < 75) {
            return this.binProps[n2].getSource();
        }
        if (n2 < 4096) {
            return 0;
        }
        if (n2 < 4122) {
            return this.intProps[n2 - 4096].getSource();
        }
        if (n2 < 16384) {
            switch (n2) {
                case 8192: 
                case 12288: {
                    return 1;
                }
            }
            return 0;
        }
        if (n2 < 16398) {
            switch (n2) {
                case 16384: {
                    return 2;
                }
                case 16385: {
                    return 5;
                }
                case 16386: 
                case 16388: 
                case 16390: 
                case 16391: 
                case 16392: 
                case 16393: 
                case 16394: 
                case 16396: {
                    return 4;
                }
                case 16387: 
                case 16389: 
                case 16395: {
                    return 3;
                }
            }
            return 0;
        }
        switch (n2) {
            case 28672: 
            case 28673: {
                return 2;
            }
        }
        return 0;
    }

    public int getMaxValues(int n2) {
        switch (n2) {
            case 0: {
                return this.m_maxBlockScriptValue_;
            }
            case 2: {
                return this.m_maxJTGValue_;
            }
        }
        return 0;
    }

    public static final int getMask(int n2) {
        return 1 << n2;
    }

    public static int getEuropeanDigit(int n2) {
        if (n2 > 122 && n2 < 65313 || n2 < 65 || n2 > 90 && n2 < 97 || n2 > 65370 || n2 > 65338 && n2 < 65345) {
            return -1;
        }
        if (n2 <= 122) {
            return n2 + 10 - (n2 <= 90 ? 65 : 97);
        }
        if (n2 <= 65338) {
            return n2 + 10 - 65313;
        }
        return n2 + 10 - 65345;
    }

    public int digit(int n2) {
        int n3 = UCharacterProperty.getNumericTypeValue(this.getProperty(n2)) - 1;
        if (n3 <= 9) {
            return n3;
        }
        return -1;
    }

    public int getNumericValue(int n2) {
        int n3 = UCharacterProperty.getNumericTypeValue(this.getProperty(n2));
        if (n3 == 0) {
            return UCharacterProperty.getEuropeanDigit(n2);
        }
        if (n3 < 11) {
            return n3 - 1;
        }
        if (n3 < 21) {
            return n3 - 11;
        }
        if (n3 < 176) {
            return n3 - 21;
        }
        if (n3 < 480) {
            return -2;
        }
        if (n3 < 768) {
            int n4 = (n3 >> 5) - 14;
            int n5 = (n3 & 0x1F) + 2;
            if (n5 < 9 || n5 == 9 && n4 <= 2) {
                int n6 = n4;
                do {
                    n6 *= 10;
                } while (--n5 > 0);
                return n6;
            }
            return -2;
        }
        if (n3 < 804) {
            int n7 = (n3 >> 2) - 191;
            int n8 = (n3 & 3) + 1;
            switch (n8) {
                case 4: {
                    n7 *= 12960000;
                    break;
                }
                case 3: {
                    n7 *= 216000;
                    break;
                }
                case 2: {
                    n7 *= 3600;
                    break;
                }
                case 1: {
                    n7 *= 60;
                    break;
                }
            }
            return n7;
        }
        if (n3 < 844) {
            return -2;
        }
        return -2;
    }

    public double getUnicodeNumericValue(int n2) {
        int n3 = UCharacterProperty.getNumericTypeValue(this.getProperty(n2));
        if (n3 == 0) {
            return -1.23456789E8;
        }
        if (n3 < 11) {
            return n3 - 1;
        }
        if (n3 < 21) {
            return n3 - 11;
        }
        if (n3 < 176) {
            return n3 - 21;
        }
        if (n3 < 480) {
            int n4 = (n3 >> 4) - 12;
            int n5 = (n3 & 0xF) + 1;
            return (double)n4 / (double)n5;
        }
        if (n3 < 768) {
            int n6;
            int n7 = (n3 >> 5) - 14;
            double d2 = n7;
            for (n6 = (n3 & 0x1F) + 2; n6 >= 4; n6 -= 4) {
                d2 *= 10000.0;
            }
            switch (n6) {
                case 3: {
                    d2 *= 1000.0;
                    break;
                }
                case 2: {
                    d2 *= 100.0;
                    break;
                }
                case 1: {
                    d2 *= 10.0;
                    break;
                }
            }
            return d2;
        }
        if (n3 < 804) {
            int n8 = (n3 >> 2) - 191;
            int n9 = (n3 & 3) + 1;
            switch (n9) {
                case 4: {
                    n8 *= 12960000;
                    break;
                }
                case 3: {
                    n8 *= 216000;
                    break;
                }
                case 2: {
                    n8 *= 3600;
                    break;
                }
                case 1: {
                    n8 *= 60;
                    break;
                }
            }
            return n8;
        }
        if (n3 < 828) {
            int n10 = n3 - 804;
            int n11 = 2 * (n10 & 3) + 1;
            int n12 = 20 << (n10 >> 2);
            return (double)n11 / (double)n12;
        }
        if (n3 < 844) {
            int n13 = n3 - 828;
            int n14 = 2 * (n13 & 3) + 1;
            int n15 = 32 << (n13 >> 2);
            return (double)n14 / (double)n15;
        }
        return -1.23456789E8;
    }

    private static final int getNumericTypeValue(int n2) {
        return n2 >> 6;
    }

    private static final int ntvGetType(int n2) {
        return n2 == 0 ? 0 : (n2 < 11 ? 1 : (n2 < 21 ? 2 : 3));
    }

    public static final int mergeScriptCodeOrIndex(int n2) {
        return (n2 & 0x300000) >> 12 | n2 & 0xFF;
    }

    private UCharacterProperty() throws IOException {
        int n2;
        if (this.binProps.length != 75) {
            throw new ICUException("binProps.length!=UProperty.BINARY_LIMIT");
        }
        if (this.intProps.length != 26) {
            throw new ICUException("intProps.length!=(UProperty.INT_LIMIT-UProperty.INT_START)");
        }
        ByteBuffer byteBuffer = ICUBinary.getRequiredData(DATA_FILE_NAME_);
        this.m_unicodeVersion_ = ICUBinary.readHeaderAndDataVersion(byteBuffer, 1431335535, new IsAcceptable());
        int n3 = byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.getInt();
        this.m_additionalColumnsCount_ = byteBuffer.getInt();
        int n6 = byteBuffer.getInt();
        int n7 = byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        this.m_maxBlockScriptValue_ = byteBuffer.getInt();
        this.m_maxJTGValue_ = byteBuffer.getInt();
        ICUBinary.skipBytes(byteBuffer, 16);
        this.m_trie_ = Trie2_16.createFromSerialized(byteBuffer);
        int n8 = (n3 - 16) * 4;
        int n9 = this.m_trie_.getSerializedLength();
        if (n9 > n8) {
            throw new IOException("uprops.icu: not enough bytes for main trie");
        }
        ICUBinary.skipBytes(byteBuffer, n8 - n9);
        ICUBinary.skipBytes(byteBuffer, (n4 - n3) * 4);
        if (this.m_additionalColumnsCount_ > 0) {
            this.m_additionalTrie_ = Trie2_16.createFromSerialized(byteBuffer);
            n8 = (n5 - n4) * 4;
            n9 = this.m_additionalTrie_.getSerializedLength();
            if (n9 > n8) {
                throw new IOException("uprops.icu: not enough bytes for additional-properties trie");
            }
            ICUBinary.skipBytes(byteBuffer, n8 - n9);
            n2 = n6 - n5;
            this.m_additionalVectors_ = ICUBinary.getInts(byteBuffer, n2, 0);
        }
        if ((n2 = (n7 - n6) * 2) > 0) {
            this.m_scriptExtensions_ = ICUBinary.getChars(byteBuffer, n2, 0);
        }
    }

    public UnicodeSet addPropertyStarts(UnicodeSet unicodeSet) {
        for (Trie2.Range range : this.m_trie_) {
            if (range.leadSurrogate) break;
            unicodeSet.add(range.startCodePoint);
        }
        unicodeSet.add(9);
        unicodeSet.add(10);
        unicodeSet.add(14);
        unicodeSet.add(28);
        unicodeSet.add(32);
        unicodeSet.add(133);
        unicodeSet.add(134);
        unicodeSet.add(127);
        unicodeSet.add(8202);
        unicodeSet.add(8208);
        unicodeSet.add(8298);
        unicodeSet.add(8304);
        unicodeSet.add(65279);
        unicodeSet.add(65280);
        unicodeSet.add(160);
        unicodeSet.add(161);
        unicodeSet.add(8199);
        unicodeSet.add(8200);
        unicodeSet.add(8239);
        unicodeSet.add(8240);
        unicodeSet.add(12295);
        unicodeSet.add(12296);
        unicodeSet.add(19968);
        unicodeSet.add(19969);
        unicodeSet.add(20108);
        unicodeSet.add(20109);
        unicodeSet.add(19977);
        unicodeSet.add(19978);
        unicodeSet.add(22235);
        unicodeSet.add(22236);
        unicodeSet.add(20116);
        unicodeSet.add(20117);
        unicodeSet.add(20845);
        unicodeSet.add(20846);
        unicodeSet.add(19971);
        unicodeSet.add(19972);
        unicodeSet.add(20843);
        unicodeSet.add(20844);
        unicodeSet.add(20061);
        unicodeSet.add(20062);
        unicodeSet.add(97);
        unicodeSet.add(123);
        unicodeSet.add(65);
        unicodeSet.add(91);
        unicodeSet.add(65345);
        unicodeSet.add(65371);
        unicodeSet.add(65313);
        unicodeSet.add(65339);
        unicodeSet.add(103);
        unicodeSet.add(71);
        unicodeSet.add(65351);
        unicodeSet.add(65319);
        unicodeSet.add(8288);
        unicodeSet.add(65520);
        unicodeSet.add(65532);
        unicodeSet.add(917504);
        unicodeSet.add(921600);
        unicodeSet.add(847);
        unicodeSet.add(848);
        return unicodeSet;
    }

    public void upropsvec_addPropertyStarts(UnicodeSet unicodeSet) {
        if (this.m_additionalColumnsCount_ > 0) {
            for (Trie2.Range range : this.m_additionalTrie_) {
                if (range.leadSurrogate) break;
                unicodeSet.add(range.startCodePoint);
            }
        }
    }

    static UnicodeSet ulayout_addPropertyStarts(int n2, UnicodeSet unicodeSet) {
        return LayoutProps.INSTANCE.addPropertyStarts(n2, unicodeSet);
    }

    static void mathCompat_addPropertyStarts(UnicodeSet unicodeSet) {
        for (int n2 : ID_COMPAT_MATH_CONTINUE) {
            unicodeSet.add(n2);
        }
        for (int n2 : ID_COMPAT_MATH_START) {
            unicodeSet.add(n2);
            unicodeSet.add(n2 + 1);
        }
    }

    public boolean hasIDType(int n2, int n3) {
        if (n3 < 0 || n3 >= idTypeToEncoded.length) {
            return false;
        }
        int n4 = idTypeToEncoded[n3];
        int n5 = this.getAdditional(n2, 2) >>> 26;
        if ((n4 & 0x80) != 0) {
            return n5 < 48 && (n5 & n4) != 0;
        }
        return n5 == n4;
    }

    public boolean hasIDType(int n2, UCharacter.IdentifierType identifierType) {
        return this.hasIDType(n2, identifierType.ordinal());
    }

    private static void maybeAddType(int n2, int n3, UCharacter.IdentifierType identifierType, EnumSet<UCharacter.IdentifierType> enumSet) {
        if ((n2 & n3) != 0) {
            enumSet.add(identifierType);
        }
    }

    public int getIDTypes(int n2, EnumSet<UCharacter.IdentifierType> enumSet) {
        enumSet.clear();
        int n3 = this.getAdditional(n2, 2) >>> 26;
        if ((n3 & 0x30) == 48 || n3 == 0) {
            UCharacter.IdentifierType identifierType;
            switch (n3) {
                case 0: {
                    identifierType = UCharacter.IdentifierType.NOT_CHARACTER;
                    break;
                }
                case 48: {
                    identifierType = UCharacter.IdentifierType.DEPRECATED;
                    break;
                }
                case 49: {
                    identifierType = UCharacter.IdentifierType.DEFAULT_IGNORABLE;
                    break;
                }
                case 50: {
                    identifierType = UCharacter.IdentifierType.NOT_NFKC;
                    break;
                }
                case 62: {
                    identifierType = UCharacter.IdentifierType.INCLUSION;
                    break;
                }
                case 63: {
                    identifierType = UCharacter.IdentifierType.RECOMMENDED;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("unknown IdentifierType data value 0x%02x", n3));
                }
            }
            enumSet.add(identifierType);
            return 1;
        }
        UCharacterProperty.maybeAddType(n3, 1, UCharacter.IdentifierType.NOT_XID, enumSet);
        UCharacterProperty.maybeAddType(n3, 32, UCharacter.IdentifierType.EXCLUSION, enumSet);
        UCharacterProperty.maybeAddType(n3, 2, UCharacter.IdentifierType.OBSOLETE, enumSet);
        UCharacterProperty.maybeAddType(n3, 4, UCharacter.IdentifierType.TECHNICAL, enumSet);
        UCharacterProperty.maybeAddType(n3, 8, UCharacter.IdentifierType.UNCOMMON_USE, enumSet);
        UCharacterProperty.maybeAddType(n3, 16, UCharacter.IdentifierType.LIMITED_USE, enumSet);
        return enumSet.size();
    }

    static {
        GC_CN_MASK = UCharacterProperty.getMask(0);
        GC_CC_MASK = UCharacterProperty.getMask(15);
        GC_CS_MASK = UCharacterProperty.getMask(18);
        GC_ZS_MASK = UCharacterProperty.getMask(12);
        GC_ZL_MASK = UCharacterProperty.getMask(13);
        GC_ZP_MASK = UCharacterProperty.getMask(14);
        GC_Z_MASK = GC_ZS_MASK | GC_ZL_MASK | GC_ZP_MASK;
        ID_COMPAT_MATH_CONTINUE = new int[]{178, 180, 185, 186, 8304, 8305, 8308, 8319, 8320, 8335};
        ID_COMPAT_MATH_START = new int[]{8706, 8711, 8734, 120513, 120539, 120571, 120597, 120629, 120655, 120687, 120713, 120745, 120771};
        gcbToHst = new int[]{0, 0, 0, 0, 1, 0, 4, 5, 3, 2};
        idTypeToEncoded = new int[]{0, 48, 49, 50, 129, 160, 130, 132, 136, 144, 62, 63};
        try {
            INSTANCE = new UCharacterProperty();
        }
        catch (IOException iOException) {
            throw new MissingResourceException(iOException.getMessage(), "", "");
        }
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return byArray[0] == 8;
        }
    }

    private class NormQuickCheckIntProperty
    extends IntProperty {
        int which;
        int max;

        NormQuickCheckIntProperty(int n2, int n3, int n4) {
            super(n2);
            this.which = n3;
            this.max = n4;
        }

        @Override
        int getValue(int n2) {
            return Norm2AllModes.getN2WithImpl(this.which - 4108).getQuickCheck(n2);
        }

        @Override
        int getMaxValue(int n2) {
            return this.max;
        }
    }

    private class CombiningClassIntProperty
    extends IntProperty {
        CombiningClassIntProperty(int n2) {
            super(n2);
        }

        @Override
        int getMaxValue(int n2) {
            return 255;
        }
    }

    private class BiDiIntProperty
    extends IntProperty {
        BiDiIntProperty() {
            super(5);
        }

        @Override
        int getMaxValue(int n2) {
            return UBiDiProps.INSTANCE.getMaxValue(n2);
        }
    }

    private class IntProperty {
        int column;
        int mask;
        int shift;

        IntProperty(int n2, int n3, int n4) {
            this.column = n2;
            this.mask = n3;
            this.shift = n4;
        }

        IntProperty(int n2) {
            this.column = n2;
            this.mask = 0;
        }

        final int getSource() {
            return this.mask == 0 ? this.column : 2;
        }

        int getValue(int n2) {
            return (UCharacterProperty.this.getAdditional(n2, this.column) & this.mask) >>> this.shift;
        }

        int getMaxValue(int n2) {
            return (UCharacterProperty.this.getMaxValues(this.column) & this.mask) >>> this.shift;
        }
    }

    private class MathCompatBinaryProperty
    extends BinaryProperty {
        int which;

        MathCompatBinaryProperty(int n2) {
            super(17);
            this.which = n2;
        }

        @Override
        boolean contains(int n2) {
            if (this.which == 74) {
                for (int i2 = 0; i2 < ID_COMPAT_MATH_CONTINUE.length; i2 += 2) {
                    if (n2 < ID_COMPAT_MATH_CONTINUE[i2]) {
                        return false;
                    }
                    if (n2 >= ID_COMPAT_MATH_CONTINUE[i2 + 1]) continue;
                    return true;
                }
            }
            if (n2 < ID_COMPAT_MATH_START[0]) {
                return false;
            }
            for (int n3 : ID_COMPAT_MATH_START) {
                if (n2 != n3) continue;
                return true;
            }
            return false;
        }
    }

    private class NormInertBinaryProperty
    extends BinaryProperty {
        int which;

        NormInertBinaryProperty(int n2, int n3) {
            super(n2);
            this.which = n3;
        }

        @Override
        boolean contains(int n2) {
            return Norm2AllModes.getN2WithImpl(this.which - 37).isInert(n2);
        }
    }

    private class EmojiBinaryProperty
    extends BinaryProperty {
        int which;

        EmojiBinaryProperty(int n2) {
            super(15);
            this.which = n2;
        }

        @Override
        boolean contains(int n2) {
            return EmojiProps.INSTANCE.hasBinaryProperty(n2, this.which);
        }
    }

    private class CaseBinaryProperty
    extends BinaryProperty {
        int which;

        CaseBinaryProperty(int n2) {
            super(4);
            this.which = n2;
        }

        @Override
        boolean contains(int n2) {
            return UCaseProps.INSTANCE.hasBinaryProperty(n2, this.which);
        }
    }

    private class BinaryProperty {
        int column;
        int mask;

        BinaryProperty(int n2, int n3) {
            this.column = n2;
            this.mask = n3;
        }

        BinaryProperty(int n2) {
            this.column = n2;
            this.mask = 0;
        }

        final int getSource() {
            return this.mask == 0 ? this.column : 2;
        }

        boolean contains(int n2) {
            return (UCharacterProperty.this.getAdditional(n2, this.column) & this.mask) != 0;
        }
    }

    private static final class LayoutProps {
        private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
        private static final int DATA_FORMAT = 1281456495;
        private static final int IX_INPC_TRIE_TOP = 1;
        private static final int IX_INSC_TRIE_TOP = 2;
        private static final int IX_VO_TRIE_TOP = 3;
        private static final int IX_MAX_VALUES = 9;
        private static final int MAX_INPC_SHIFT = 24;
        private static final int MAX_INSC_SHIFT = 16;
        private static final int MAX_VO_SHIFT = 8;
        static final LayoutProps INSTANCE = new LayoutProps();
        CodePointTrie inpcTrie = null;
        CodePointTrie inscTrie = null;
        CodePointTrie voTrie = null;
        int maxInpcValue = 0;
        int maxInscValue = 0;
        int maxVoValue = 0;

        LayoutProps() {
            ByteBuffer byteBuffer = ICUBinary.getRequiredData("ulayout.icu");
            try {
                int n2;
                ICUBinary.readHeaderAndDataVersion(byteBuffer, 1281456495, IS_ACCEPTABLE);
                int n3 = byteBuffer.position();
                int n4 = byteBuffer.getInt();
                if (n4 < 12) {
                    throw new ICUUncheckedIOException("Text layout properties data: not enough indexes");
                }
                int[] nArray = new int[n4];
                nArray[0] = n4;
                for (n2 = 1; n2 < n4; ++n2) {
                    nArray[n2] = byteBuffer.getInt();
                }
                int n5 = nArray[1];
                n2 = n4 * 4;
                int n6 = n5 - n2;
                if (n6 >= 16) {
                    this.inpcTrie = CodePointTrie.fromBinary(null, null, byteBuffer);
                }
                int n7 = byteBuffer.position() - n3;
                assert (n5 >= n7);
                ICUBinary.skipBytes(byteBuffer, n5 - n7);
                n2 = n5;
                n5 = nArray[2];
                n6 = n5 - n2;
                if (n6 >= 16) {
                    this.inscTrie = CodePointTrie.fromBinary(null, null, byteBuffer);
                }
                n7 = byteBuffer.position() - n3;
                assert (n5 >= n7);
                ICUBinary.skipBytes(byteBuffer, n5 - n7);
                n2 = n5;
                n5 = nArray[3];
                n6 = n5 - n2;
                if (n6 >= 16) {
                    this.voTrie = CodePointTrie.fromBinary(null, null, byteBuffer);
                }
                n7 = byteBuffer.position() - n3;
                assert (n5 >= n7);
                ICUBinary.skipBytes(byteBuffer, n5 - n7);
                int n8 = nArray[9];
                this.maxInpcValue = n8 >>> 24;
                this.maxInscValue = n8 >> 16 & 0xFF;
                this.maxVoValue = n8 >> 8 & 0xFF;
            }
            catch (IOException iOException) {
                throw new ICUUncheckedIOException(iOException);
            }
        }

        public UnicodeSet addPropertyStarts(int n2, UnicodeSet unicodeSet) {
            CodePointTrie codePointTrie;
            switch (n2) {
                case 12: {
                    codePointTrie = this.inpcTrie;
                    break;
                }
                case 13: {
                    codePointTrie = this.inscTrie;
                    break;
                }
                case 14: {
                    codePointTrie = this.voTrie;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (codePointTrie == null) {
                throw new MissingResourceException("no data for one of the text layout properties; src=" + n2, "LayoutProps", "");
            }
            CodePointMap.Range range = new CodePointMap.Range();
            int n3 = 0;
            while (codePointTrie.getRange(n3, null, range)) {
                unicodeSet.add(n3);
                n3 = range.getEnd() + 1;
            }
            return unicodeSet;
        }

        private static final class IsAcceptable
        implements ICUBinary.Authenticate {
            private IsAcceptable() {
            }

            @Override
            public boolean isDataVersionAcceptable(byte[] byArray) {
                return byArray[0] == 1;
            }
        }
    }
}

