/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;

public final class UCharArrayIterator
extends UCharacterIterator {
    private final char[] text;
    private final int start;
    private final int limit;
    private int pos;

    public UCharArrayIterator(char[] cArray, int n2, int n3) {
        if (n2 < 0 || n3 > cArray.length || n2 > n3) {
            throw new IllegalArgumentException("start: " + n2 + " or limit: " + n3 + " out of range [0, " + cArray.length + ")");
        }
        this.text = cArray;
        this.start = n2;
        this.limit = n3;
        this.pos = n2;
    }

    @Override
    public int current() {
        return this.pos < this.limit ? this.text[this.pos] : -1;
    }

    @Override
    public int getLength() {
        return this.limit - this.start;
    }

    @Override
    public int getIndex() {
        return this.pos - this.start;
    }

    @Override
    public int next() {
        return this.pos < this.limit ? this.text[this.pos++] : -1;
    }

    @Override
    public int previous() {
        return this.pos > this.start ? this.text[--this.pos] : -1;
    }

    @Override
    public void setIndex(int n2) {
        if (n2 < 0 || n2 > this.limit - this.start) {
            throw new IndexOutOfBoundsException("index: " + n2 + " out of range [0, " + (this.limit - this.start) + ")");
        }
        this.pos = this.start + n2;
    }

    @Override
    public int getText(char[] cArray, int n2) {
        int n3 = this.limit - this.start;
        System.arraycopy(this.text, this.start, cArray, n2, n3);
        return n3;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

