/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_16;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_32;

public class Trie2Writable
extends Trie2 {
    private static final int UTRIE2_MAX_INDEX_LENGTH = 65535;
    private static final int UTRIE2_MAX_DATA_LENGTH = 262140;
    private static final int UNEWTRIE2_INITIAL_DATA_LENGTH = 16384;
    private static final int UNEWTRIE2_MEDIUM_DATA_LENGTH = 131072;
    private static final int UNEWTRIE2_INDEX_2_NULL_OFFSET = 2656;
    private static final int UNEWTRIE2_INDEX_2_START_OFFSET = 2720;
    private static final int UNEWTRIE2_DATA_NULL_OFFSET = 192;
    private static final int UNEWTRIE2_DATA_START_OFFSET = 256;
    private static final int UNEWTRIE2_DATA_0800_OFFSET = 2176;
    private int[] index1 = new int[544];
    private int[] index2 = new int[35488];
    private int[] data;
    private int index2Length;
    private int dataCapacity;
    private int firstFreeBlock;
    private int index2NullOffset;
    private boolean isCompacted;
    private int[] map = new int[34852];
    private boolean UTRIE2_DEBUG = false;

    public Trie2Writable(int n2, int n3) {
        this.init(n2, n3);
    }

    private void init(int n2, int n3) {
        int n4;
        int n5;
        this.initialValue = n2;
        this.errorValue = n3;
        this.highStart = 0x110000;
        this.data = new int[16384];
        this.dataCapacity = 16384;
        this.initialValue = n2;
        this.errorValue = n3;
        this.highStart = 0x110000;
        this.firstFreeBlock = 0;
        this.isCompacted = false;
        for (n5 = 0; n5 < 128; ++n5) {
            this.data[n5] = this.initialValue;
        }
        while (n5 < 192) {
            this.data[n5] = this.errorValue;
            ++n5;
        }
        for (n5 = 192; n5 < 256; ++n5) {
            this.data[n5] = this.initialValue;
        }
        this.dataNullOffset = 192;
        this.dataLength = 256;
        n5 = 0;
        for (n4 = 0; n4 < 128; n4 += 32) {
            this.index2[n5] = n4;
            this.map[n5] = 1;
            ++n5;
        }
        while (n4 < 192) {
            this.map[n5] = 0;
            ++n5;
            n4 += 32;
        }
        this.map[n5++] = 34845;
        n4 += 32;
        while (n4 < 256) {
            this.map[n5] = 0;
            ++n5;
            n4 += 32;
        }
        for (n5 = 4; n5 < 2080; ++n5) {
            this.index2[n5] = 192;
        }
        for (n5 = 0; n5 < 576; ++n5) {
            this.index2[2080 + n5] = -1;
        }
        for (n5 = 0; n5 < 64; ++n5) {
            this.index2[2656 + n5] = 192;
        }
        this.index2NullOffset = 2656;
        this.index2Length = 2720;
        n5 = 0;
        n4 = 0;
        while (n5 < 32) {
            this.index1[n5] = n4;
            ++n5;
            n4 += 64;
        }
        while (n5 < 544) {
            this.index1[n5] = 2656;
            ++n5;
        }
        for (n5 = 128; n5 < 2048; n5 += 32) {
            this.set(n5, this.initialValue);
        }
    }

    public Trie2Writable(Trie2 trie2) {
        this.init(trie2.initialValue, trie2.errorValue);
        for (Trie2.Range range : trie2) {
            this.setRange(range, true);
        }
    }

    private boolean isInNullBlock(int n2, boolean bl2) {
        int n3 = Character.isHighSurrogate((char)n2) && bl2 ? 320 + (n2 >> 5) : this.index1[n2 >> 11] + (n2 >> 5 & 0x3F);
        int n4 = this.index2[n3];
        return n4 == this.dataNullOffset;
    }

    private int allocIndex2Block() {
        int n2 = this.index2Length;
        int n3 = n2 + 64;
        if (n3 > this.index2.length) {
            throw new IllegalStateException("Internal error in Trie2 creation.");
        }
        this.index2Length = n3;
        System.arraycopy(this.index2, this.index2NullOffset, this.index2, n2, 64);
        return n2;
    }

    private int getIndex2Block(int n2, boolean bl2) {
        if (n2 >= 55296 && n2 < 56320 && bl2) {
            return 2048;
        }
        int n3 = n2 >> 11;
        int n4 = this.index1[n3];
        if (n4 == this.index2NullOffset) {
            this.index1[n3] = n4 = this.allocIndex2Block();
        }
        return n4;
    }

    private int allocDataBlock(int n2) {
        int n3;
        if (this.firstFreeBlock != 0) {
            n3 = this.firstFreeBlock;
            this.firstFreeBlock = -this.map[n3 >> 5];
        } else {
            n3 = this.dataLength;
            int n4 = n3 + 32;
            if (n4 > this.dataCapacity) {
                int n5;
                if (this.dataCapacity < 131072) {
                    n5 = 131072;
                } else if (this.dataCapacity < 1115264) {
                    n5 = 1115264;
                } else {
                    throw new IllegalStateException("Internal error in Trie2 creation.");
                }
                int[] nArray = new int[n5];
                System.arraycopy(this.data, 0, nArray, 0, this.dataLength);
                this.data = nArray;
                this.dataCapacity = n5;
            }
            this.dataLength = n4;
        }
        System.arraycopy(this.data, n2, this.data, n3, 32);
        this.map[n3 >> 5] = 0;
        return n3;
    }

    private void releaseDataBlock(int n2) {
        this.map[n2 >> 5] = -this.firstFreeBlock;
        this.firstFreeBlock = n2;
    }

    private boolean isWritableBlock(int n2) {
        return n2 != this.dataNullOffset && 1 == this.map[n2 >> 5];
    }

    private void setIndex2Entry(int n2, int n3) {
        int n4 = n3 >> 5;
        this.map[n4] = this.map[n4] + 1;
        int n5 = this.index2[n2];
        int n6 = n5 >> 5;
        this.map[n6] = this.map[n6] - 1;
        if (0 == this.map[n6]) {
            this.releaseDataBlock(n5);
        }
        this.index2[n2] = n3;
    }

    private int getDataBlock(int n2, boolean bl2) {
        int n3 = this.getIndex2Block(n2, bl2);
        int n4 = this.index2[n3 += n2 >> 5 & 0x3F];
        if (this.isWritableBlock(n4)) {
            return n4;
        }
        int n5 = this.allocDataBlock(n4);
        this.setIndex2Entry(n3, n5);
        return n5;
    }

    public Trie2Writable set(int n2, int n3) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point.");
        }
        this.set(n2, true, n3);
        this.fHash = 0;
        return this;
    }

    private Trie2Writable set(int n2, boolean bl2, int n3) {
        if (this.isCompacted) {
            this.uncompact();
        }
        int n4 = this.getDataBlock(n2, bl2);
        this.data[n4 + (n2 & 0x1F)] = n3;
        return this;
    }

    private void uncompact() {
        Trie2Writable trie2Writable = new Trie2Writable(this);
        this.index1 = trie2Writable.index1;
        this.index2 = trie2Writable.index2;
        this.data = trie2Writable.data;
        this.index2Length = trie2Writable.index2Length;
        this.dataCapacity = trie2Writable.dataCapacity;
        this.isCompacted = trie2Writable.isCompacted;
        this.header = trie2Writable.header;
        this.index = trie2Writable.index;
        this.data16 = trie2Writable.data16;
        this.data32 = trie2Writable.data32;
        this.indexLength = trie2Writable.indexLength;
        this.dataLength = trie2Writable.dataLength;
        this.index2NullOffset = trie2Writable.index2NullOffset;
        this.initialValue = trie2Writable.initialValue;
        this.errorValue = trie2Writable.errorValue;
        this.highStart = trie2Writable.highStart;
        this.highValueIndex = trie2Writable.highValueIndex;
        this.dataNullOffset = trie2Writable.dataNullOffset;
    }

    private void writeBlock(int n2, int n3) {
        int n4 = n2 + 32;
        while (n2 < n4) {
            this.data[n2++] = n3;
        }
    }

    private void fillBlock(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        int n7 = n2 + n4;
        if (bl2) {
            for (int i2 = n2 + n3; i2 < n7; ++i2) {
                this.data[i2] = n5;
            }
        } else {
            for (int i3 = n2 + n3; i3 < n7; ++i3) {
                if (this.data[i3] != n6) continue;
                this.data[i3] = n5;
            }
        }
    }

    public Trie2Writable setRange(int n2, int n3, int n4, boolean bl2) {
        int n5;
        int n6;
        if (n2 > 0x10FFFF || n2 < 0 || n3 > 0x10FFFF || n3 < 0 || n2 > n3) {
            throw new IllegalArgumentException("Invalid code point range.");
        }
        if (!bl2 && n4 == this.initialValue) {
            return this;
        }
        this.fHash = 0;
        if (this.isCompacted) {
            this.uncompact();
        }
        int n7 = n3 + 1;
        if ((n2 & 0x1F) != 0) {
            n6 = this.getDataBlock(n2, true);
            n5 = n2 + 32 & 0xFFFFFFE0;
            if (n5 <= n7) {
                this.fillBlock(n6, n2 & 0x1F, 32, n4, this.initialValue, bl2);
                n2 = n5;
            } else {
                this.fillBlock(n6, n2 & 0x1F, n7 & 0x1F, n4, this.initialValue, bl2);
                return this;
            }
        }
        int n8 = n7 & 0x1F;
        n7 &= 0xFFFFFFE0;
        int n9 = n4 == this.initialValue ? this.dataNullOffset : -1;
        while (n2 < n7) {
            boolean bl3 = false;
            if (n4 == this.initialValue && this.isInNullBlock(n2, true)) {
                n2 += 32;
                continue;
            }
            n5 = this.getIndex2Block(n2, true);
            n6 = this.index2[n5 += n2 >> 5 & 0x3F];
            if (this.isWritableBlock(n6)) {
                if (bl2 && n6 >= 2176) {
                    bl3 = true;
                } else {
                    this.fillBlock(n6, 0, 32, n4, this.initialValue, bl2);
                }
            } else if (this.data[n6] != n4 && (bl2 || n6 == this.dataNullOffset)) {
                bl3 = true;
            }
            if (bl3) {
                if (n9 >= 0) {
                    this.setIndex2Entry(n5, n9);
                } else {
                    n9 = this.getDataBlock(n2, true);
                    this.writeBlock(n9, n4);
                }
            }
            n2 += 32;
        }
        if (n8 > 0) {
            n6 = this.getDataBlock(n2, true);
            this.fillBlock(n6, 0, n8, n4, this.initialValue, bl2);
        }
        return this;
    }

    public Trie2Writable setRange(Trie2.Range range, boolean bl2) {
        this.fHash = 0;
        if (range.leadSurrogate) {
            for (int i2 = range.startCodePoint; i2 <= range.endCodePoint; ++i2) {
                if (!bl2 && this.getFromU16SingleLead((char)i2) != this.initialValue) continue;
                this.setForLeadSurrogateCodeUnit((char)i2, range.value);
            }
        } else {
            this.setRange(range.startCodePoint, range.endCodePoint, range.value, bl2);
        }
        return this;
    }

    public Trie2Writable setForLeadSurrogateCodeUnit(char c2, int n2) {
        this.fHash = 0;
        this.set(c2, false, n2);
        return this;
    }

    @Override
    public int get(int n2) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            return this.errorValue;
        }
        return this.get(n2, true);
    }

    private int get(int n2, boolean bl2) {
        if (n2 >= this.highStart && (n2 < 55296 || n2 >= 56320 || bl2)) {
            return this.data[this.dataLength - 4];
        }
        int n3 = n2 >= 55296 && n2 < 56320 && bl2 ? 320 + (n2 >> 5) : this.index1[n2 >> 11] + (n2 >> 5 & 0x3F);
        int n4 = this.index2[n3];
        return this.data[n4 + (n2 & 0x1F)];
    }

    @Override
    public int getFromU16SingleLead(char c2) {
        return this.get(c2, false);
    }

    private boolean equal_int(int[] nArray, int n2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            if (nArray[n2 + i2] == nArray[n3 + i2]) continue;
            return false;
        }
        return true;
    }

    private int findSameIndex2Block(int n2, int n3) {
        n2 -= 64;
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (!this.equal_int(this.index2, i2, n3, 64)) continue;
            return i2;
        }
        return -1;
    }

    private int findSameDataBlock(int n2, int n3, int n4) {
        n2 -= n4;
        for (int i2 = 0; i2 <= n2; i2 += 4) {
            if (!this.equal_int(this.data, i2, n3, n4)) continue;
            return i2;
        }
        return -1;
    }

    private int findHighStart(int n2) {
        int n3;
        int n4;
        if (n2 == this.initialValue) {
            n4 = this.index2NullOffset;
            n3 = this.dataNullOffset;
        } else {
            n4 = -1;
            n3 = -1;
        }
        int n5 = 0x110000;
        int n6 = 544;
        int n7 = n5;
        while (n7 > 0) {
            int n8;
            if ((n8 = this.index1[--n6]) == n4) {
                n7 -= 2048;
                continue;
            }
            n4 = n8;
            if (n8 == this.index2NullOffset) {
                if (n2 != this.initialValue) {
                    return n7;
                }
                n7 -= 2048;
                continue;
            }
            int n9 = 64;
            while (n9 > 0) {
                int n10;
                if ((n10 = this.index2[n8 + --n9]) == n3) {
                    n7 -= 32;
                    continue;
                }
                n3 = n10;
                if (n10 == this.dataNullOffset) {
                    if (n2 != this.initialValue) {
                        return n7;
                    }
                    n7 -= 32;
                    continue;
                }
                int n11 = 32;
                while (n11 > 0) {
                    int n12;
                    if ((n12 = this.data[n10 + --n11]) != n2) {
                        return n7;
                    }
                    --n7;
                }
            }
        }
        return 0;
    }

    private void compactData() {
        int n2 = 192;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            this.map[n4] = n3;
            n3 += 32;
            ++n4;
        }
        int n5 = 64;
        int n6 = n5 >> 5;
        n3 = n2;
        while (n3 < this.dataLength) {
            int n7;
            int n8;
            if (n3 == 2176) {
                n5 = 32;
                n6 = 1;
            }
            if (this.map[n3 >> 5] <= 0) {
                n3 += n5;
                continue;
            }
            int n9 = this.findSameDataBlock(n2, n3, n5);
            if (n9 >= 0) {
                n8 = n3 >> 5;
                for (n4 = n6; n4 > 0; --n4) {
                    this.map[n8++] = n9;
                    n9 += 32;
                }
                n3 += n5;
                continue;
            }
            for (n7 = n5 - 4; n7 > 0 && !this.equal_int(this.data, n2 - n7, n3, n7); n7 -= 4) {
            }
            if (n7 > 0 || n2 < n3) {
                n9 = n2 - n7;
                n8 = n3 >> 5;
                for (n4 = n6; n4 > 0; --n4) {
                    this.map[n8++] = n9;
                    n9 += 32;
                }
                n3 += n7;
                for (n4 = n5 - n7; n4 > 0; --n4) {
                    this.data[n2++] = this.data[n3++];
                }
                continue;
            }
            n8 = n3 >> 5;
            for (n4 = n6; n4 > 0; --n4) {
                this.map[n8++] = n3;
                n3 += 32;
            }
            n2 = n3;
        }
        for (n4 = 0; n4 < this.index2Length; ++n4) {
            if (n4 == 2080) {
                n4 += 576;
            }
            this.index2[n4] = this.map[this.index2[n4] >> 5];
        }
        this.dataNullOffset = this.map[this.dataNullOffset >> 5];
        while ((n2 & 3) != 0) {
            this.data[n2++] = this.initialValue;
        }
        if (this.UTRIE2_DEBUG) {
            System.out.printf("compacting UTrie2: count of 32-bit data words %d->%d%n", this.dataLength, n2);
        }
        this.dataLength = n2;
    }

    private void compactIndex2() {
        int n2 = 2080;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            this.map[n4] = n3;
            n3 += 64;
            ++n4;
        }
        n2 += 32 + (this.highStart - 65536 >> 11);
        n3 = 2656;
        while (n3 < this.index2Length) {
            int n5;
            int n6 = this.findSameIndex2Block(n2, n3);
            if (n6 >= 0) {
                this.map[n3 >> 6] = n6;
                n3 += 64;
                continue;
            }
            for (n5 = 63; n5 > 0 && !this.equal_int(this.index2, n2 - n5, n3, n5); --n5) {
            }
            if (n5 > 0 || n2 < n3) {
                this.map[n3 >> 6] = n2 - n5;
                n3 += n5;
                for (n4 = 64 - n5; n4 > 0; --n4) {
                    this.index2[n2++] = this.index2[n3++];
                }
                continue;
            }
            this.map[n3 >> 6] = n3;
            n2 = n3 += 64;
        }
        for (n4 = 0; n4 < 544; ++n4) {
            this.index1[n4] = this.map[this.index1[n4] >> 6];
        }
        this.index2NullOffset = this.map[this.index2NullOffset >> 6];
        while ((n2 & 3) != 0) {
            this.index2[n2++] = 262140;
        }
        if (this.UTRIE2_DEBUG) {
            System.out.printf("compacting UTrie2: count of 16-bit index-2 words %d->%d%n", this.index2Length, n2);
        }
        this.index2Length = n2;
    }

    private void compactTrie() {
        int n2 = this.get(0x10FFFF);
        int n3 = this.findHighStart(n2);
        if ((n3 = n3 + 2047 & 0xFFFFF800) == 0x110000) {
            n2 = this.errorValue;
        }
        this.highStart = n3;
        if (this.UTRIE2_DEBUG) {
            System.out.printf("UTrie2: highStart U+%04x  highValue 0x%x  initialValue 0x%x%n", this.highStart, n2, this.initialValue);
        }
        if (this.highStart < 0x110000) {
            int n4 = this.highStart <= 65536 ? 65536 : this.highStart;
            this.setRange(n4, 0x10FFFF, this.initialValue, true);
        }
        this.compactData();
        if (this.highStart > 65536) {
            this.compactIndex2();
        } else if (this.UTRIE2_DEBUG) {
            System.out.printf("UTrie2: highStart U+%04x  count of 16-bit index-2 words %d->%d%n", this.highStart, this.index2Length, 2112);
        }
        this.data[this.dataLength++] = n2;
        while ((this.dataLength & 3) != 0) {
            this.data[this.dataLength++] = this.initialValue;
        }
        this.isCompacted = true;
    }

    public Trie2_16 toTrie2_16() {
        Trie2_16 trie2_16 = new Trie2_16();
        this.freeze(trie2_16, Trie2.ValueWidth.BITS_16);
        return trie2_16;
    }

    public Trie2_32 toTrie2_32() {
        Trie2_32 trie2_32 = new Trie2_32();
        this.freeze(trie2_32, Trie2.ValueWidth.BITS_32);
        return trie2_32;
    }

    private void freeze(Trie2 trie2, Trie2.ValueWidth valueWidth) {
        int n2;
        if (!this.isCompacted) {
            this.compactTrie();
        }
        int n3 = this.highStart <= 65536 ? 2112 : this.index2Length;
        int n4 = valueWidth == Trie2.ValueWidth.BITS_16 ? n3 : 0;
        if (n3 > 65535 || n4 + this.dataNullOffset > 65535 || n4 + 2176 > 65535 || n4 + this.dataLength > 262140) {
            throw new UnsupportedOperationException("Trie2 data is too large.");
        }
        int n5 = n3;
        if (valueWidth == Trie2.ValueWidth.BITS_16) {
            n5 += this.dataLength;
        } else {
            trie2.data32 = new int[this.dataLength];
        }
        trie2.index = new char[n5];
        trie2.indexLength = n3;
        trie2.dataLength = this.dataLength;
        trie2.index2NullOffset = this.highStart <= 65536 ? 65535 : 0 + this.index2NullOffset;
        trie2.initialValue = this.initialValue;
        trie2.errorValue = this.errorValue;
        trie2.highStart = this.highStart;
        trie2.highValueIndex = n4 + this.dataLength - 4;
        trie2.dataNullOffset = n4 + this.dataNullOffset;
        trie2.header = new Trie2.UTrie2Header();
        trie2.header.signature = 1416784178;
        trie2.header.options = valueWidth == Trie2.ValueWidth.BITS_16 ? 0 : 1;
        trie2.header.indexLength = trie2.indexLength;
        trie2.header.shiftedDataLength = trie2.dataLength >> 2;
        trie2.header.index2NullOffset = trie2.index2NullOffset;
        trie2.header.dataNullOffset = trie2.dataNullOffset;
        trie2.header.shiftedHighStart = trie2.highStart >> 11;
        int n6 = 0;
        for (n2 = 0; n2 < 2080; ++n2) {
            trie2.index[n6++] = (char)(this.index2[n2] + n4 >> 2);
        }
        if (this.UTRIE2_DEBUG) {
            System.out.println("\n\nIndex2 for BMP limit is " + Integer.toHexString(n6));
        }
        for (n2 = 0; n2 < 2; ++n2) {
            trie2.index[n6++] = (char)(n4 + 128);
        }
        while (n2 < 32) {
            trie2.index[n6++] = (char)(n4 + this.index2[n2 << 1]);
            ++n2;
        }
        if (this.UTRIE2_DEBUG) {
            System.out.println("Index2 for UTF-8 2byte values limit is " + Integer.toHexString(n6));
        }
        if (this.highStart > 65536) {
            int n7 = this.highStart - 65536 >> 11;
            int n8 = 2112 + n7;
            for (n2 = 0; n2 < n7; ++n2) {
                trie2.index[n6++] = (char)(0 + this.index1[n2 + 32]);
            }
            if (this.UTRIE2_DEBUG) {
                System.out.println("Index 1 for supplementals, limit is " + Integer.toHexString(n6));
            }
            for (n2 = 0; n2 < this.index2Length - n8; ++n2) {
                trie2.index[n6++] = (char)(n4 + this.index2[n8 + n2] >> 2);
            }
            if (this.UTRIE2_DEBUG) {
                System.out.println("Index 2 for supplementals, limit is " + Integer.toHexString(n6));
            }
        }
        switch (valueWidth) {
            case BITS_16: {
                assert (n6 == n4);
                trie2.data16 = n6;
                for (n2 = 0; n2 < this.dataLength; ++n2) {
                    trie2.index[n6++] = (char)this.data[n2];
                }
                break;
            }
            case BITS_32: {
                for (n2 = 0; n2 < this.dataLength; ++n2) {
                    trie2.data32[n2] = this.data[n2];
                }
                break;
            }
        }
    }
}

