/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.text.Format;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public final class SimpleFormatterImpl {
    private static final int ARG_NUM_LIMIT = 256;
    private static final char LEN1_CHAR = '\u0101';
    private static final char LEN2_CHAR = '\u0102';
    private static final char LEN3_CHAR = '\u0103';
    private static final char SEGMENT_LENGTH_ARGUMENT_CHAR = '\uffff';
    private static final int MAX_SEGMENT_LENGTH = 65279;
    private static final String[][] COMMON_PATTERNS = new String[][]{{"{0} {1}", "\u0002\u0000\u0101 \u0001"}, {"{0} ({1})", "\u0002\u0000\u0102 (\u0001\u0101)"}, {"{0}, {1}", "\u0002\u0000\u0102, \u0001"}, {"{0} \u2013 {1}", "\u0002\u0000\u0103 \u2013 \u0001"}};

    private SimpleFormatterImpl() {
    }

    public static String compileToStringMinMaxArguments(CharSequence charSequence, StringBuilder stringBuilder, int n2, int n3) {
        if (n2 <= 2 && 2 <= n3) {
            for (String[] stringArray : COMMON_PATTERNS) {
                if (!stringArray[0].contentEquals(charSequence)) continue;
                assert (stringArray[1].charAt(0) == '\u0002');
                return stringArray[1];
            }
        }
        int n4 = charSequence.length();
        stringBuilder.ensureCapacity(n4);
        stringBuilder.setLength(1);
        int n5 = 0;
        int n6 = -1;
        boolean bl2 = false;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            if ((n8 = charSequence.charAt(n7++)) == 39) {
                if (n7 < n4 && (n8 = charSequence.charAt(n7)) == 39) {
                    ++n7;
                } else {
                    if (bl2) {
                        bl2 = false;
                        continue;
                    }
                    if (n8 == 123 || n8 == 125) {
                        ++n7;
                        bl2 = true;
                    } else {
                        n8 = 39;
                    }
                }
            } else if (!bl2 && n8 == 123) {
                int n9;
                if (n5 > 0) {
                    stringBuilder.setCharAt(stringBuilder.length() - n5 - 1, (char)(256 + n5));
                    n5 = 0;
                }
                if (n7 + 1 < n4 && 0 <= (n9 = charSequence.charAt(n7) - 48) && n9 <= 9 && charSequence.charAt(n7 + 1) == '}') {
                    n7 += 2;
                } else {
                    int n10 = n7 - 1;
                    n9 = -1;
                    if (n7 < n4) {
                        char c2 = charSequence.charAt(n7++);
                        n8 = c2;
                        if ('1' <= c2 && n8 <= 57) {
                            n9 = n8 - 48;
                            while (n7 < n4) {
                                char c3 = charSequence.charAt(n7++);
                                n8 = c3;
                                if ('0' <= c3 && n8 <= 57 && (n9 = n9 * 10 + (n8 - 48)) < 256) continue;
                            }
                        }
                    }
                    if (n9 < 0 || n8 != 125) {
                        throw new IllegalArgumentException("Argument syntax error in pattern \"" + charSequence + "\" at index " + n10 + ": " + charSequence.subSequence(n10, n7));
                    }
                }
                if (n9 > n6) {
                    n6 = n9;
                }
                stringBuilder.append((char)n9);
                continue;
            }
            if (n5 == 0) {
                stringBuilder.append('\uffff');
            }
            stringBuilder.append((char)n8);
            if (++n5 != 65279) continue;
            n5 = 0;
        }
        if (n5 > 0) {
            stringBuilder.setCharAt(stringBuilder.length() - n5 - 1, (char)(256 + n5));
        }
        if ((n7 = n6 + 1) < n2) {
            throw new IllegalArgumentException("Fewer than minimum " + n2 + " arguments in pattern \"" + charSequence + "\"");
        }
        if (n7 > n3) {
            throw new IllegalArgumentException("More than maximum " + n3 + " arguments in pattern \"" + charSequence + "\"");
        }
        stringBuilder.setCharAt(0, (char)n7);
        return stringBuilder.toString();
    }

    public static int getArgumentLimit(String string) {
        return string.charAt(0);
    }

    public static String formatCompiledPattern(String string, CharSequence ... charSequenceArray) {
        return SimpleFormatterImpl.formatAndAppend(string, new StringBuilder(), null, charSequenceArray).toString();
    }

    public static String formatRawPattern(String string, int n2, int n3, CharSequence ... charSequenceArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = SimpleFormatterImpl.compileToStringMinMaxArguments(string, stringBuilder, n2, n3);
        stringBuilder.setLength(0);
        return SimpleFormatterImpl.formatAndAppend(string2, stringBuilder, null, charSequenceArray).toString();
    }

    public static StringBuilder formatAndAppend(String string, StringBuilder stringBuilder, int[] nArray, CharSequence ... charSequenceArray) {
        int n2;
        int n3 = n2 = charSequenceArray != null ? charSequenceArray.length : 0;
        if (n2 < SimpleFormatterImpl.getArgumentLimit(string)) {
            throw new IllegalArgumentException("Too few values.");
        }
        return SimpleFormatterImpl.format(string, charSequenceArray, stringBuilder, null, true, nArray);
    }

    public static StringBuilder formatAndReplace(String string, StringBuilder stringBuilder, int[] nArray, CharSequence ... charSequenceArray) {
        int n2;
        int n3 = n2 = charSequenceArray != null ? charSequenceArray.length : 0;
        if (n2 < SimpleFormatterImpl.getArgumentLimit(string)) {
            throw new IllegalArgumentException("Too few values.");
        }
        int n4 = -1;
        String string2 = null;
        if (SimpleFormatterImpl.getArgumentLimit(string) > 0) {
            int n5 = 1;
            while (n5 < string.length()) {
                char c2;
                if ((c2 = string.charAt(n5++)) < '\u0100') {
                    if (charSequenceArray[c2] != stringBuilder) continue;
                    if (n5 == 2) {
                        n4 = c2;
                        continue;
                    }
                    if (string2 != null) continue;
                    string2 = stringBuilder.toString();
                    continue;
                }
                n5 += c2 - 256;
            }
        }
        if (n4 < 0) {
            stringBuilder.setLength(0);
        }
        return SimpleFormatterImpl.format(string, charSequenceArray, stringBuilder, string2, false, nArray);
    }

    public static String getTextWithNoArguments(String string) {
        int n2 = string.length() - 1 - SimpleFormatterImpl.getArgumentLimit(string);
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 1;
        while (n3 < string.length()) {
            int n4;
            if ((n4 = string.charAt(n3++) - 256) <= 0) continue;
            int n5 = n3 + n4;
            stringBuilder.append(string, n3, n5);
            n3 = n5;
        }
        return stringBuilder.toString();
    }

    public static int getLength(String string, boolean bl2) {
        int n2 = 0;
        int n3 = 1;
        while (n3 < string.length()) {
            int n4;
            if ((n4 = string.charAt(n3++) - 256) <= 0) continue;
            int n5 = n3 + n4;
            n2 = bl2 ? (n2 += Character.codePointCount(string, n3, n5)) : (n2 += n5 - n3);
            n3 = n5;
        }
        return n2;
    }

    public static int getPrefixLength(String string) {
        if (string.length() == 1) {
            return 0;
        }
        if (string.charAt(0) == '\u0000') {
            return string.length() - 2;
        }
        if (string.charAt(1) <= '\u0100') {
            return 0;
        }
        return string.charAt(1) - 256;
    }

    public static int formatPrefixSuffix(String string, Format.Field field, int n2, int n3, FormattedStringBuilder formattedStringBuilder) {
        int n4;
        int n5;
        int n6 = SimpleFormatterImpl.getArgumentLimit(string);
        if (n6 == 0) {
            return formattedStringBuilder.splice(n2, n3, string, 2, string.length(), field);
        }
        assert (n6 == 1);
        int n7 = 0;
        if (string.charAt(1) != '\u0000') {
            n5 = string.charAt(1) - 256;
            n7 = formattedStringBuilder.insert(n2, string, 2, 2 + n5, field);
            n4 = 3 + n5;
        } else {
            n4 = 2;
        }
        if (n4 < string.length()) {
            n5 = string.charAt(n4) - 256;
            n7 += formattedStringBuilder.insert(n3 + n7, string, 1 + n4, 1 + n4 + n5, field);
        }
        return n7;
    }

    private static StringBuilder format(String string, CharSequence[] charSequenceArray, StringBuilder stringBuilder, String string2, boolean bl2, int[] nArray) {
        int n2;
        int n3;
        if (nArray == null) {
            n3 = 0;
        } else {
            n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = -1;
            }
        }
        n2 = 1;
        while (n2 < string.length()) {
            char c2;
            if ((c2 = string.charAt(n2++)) < '\u0100') {
                CharSequence charSequence = charSequenceArray[c2];
                if (charSequence == stringBuilder) {
                    if (bl2) {
                        throw new IllegalArgumentException("Value must not be same object as result");
                    }
                    if (n2 == 2) {
                        if (c2 >= n3) continue;
                        nArray[c2] = 0;
                        continue;
                    }
                    if (c2 < n3) {
                        nArray[c2] = stringBuilder.length();
                    }
                    stringBuilder.append(string2);
                    continue;
                }
                if (c2 < n3) {
                    nArray[c2] = stringBuilder.length();
                }
                stringBuilder.append(charSequence);
                continue;
            }
            int n4 = n2 + (c2 - 256);
            stringBuilder.append(string, n2, n4);
            n2 = n4;
        }
        return stringBuilder;
    }

    public static class IterInternal {
        public static final long DONE = -1L;

        public static long step(long l2, CharSequence charSequence, Appendable appendable) {
            int n2 = (int)(l2 >>> 32);
            assert (n2 < charSequence.length());
            ++n2;
            while (n2 < charSequence.length() && charSequence.charAt(n2) > '\u0100') {
                int n3 = n2 + charSequence.charAt(n2) + 1 - 256;
                try {
                    appendable.append(charSequence, n2 + 1, n3);
                }
                catch (IOException iOException) {
                    throw new ICUUncheckedIOException(iOException);
                }
                n2 = n3;
            }
            if (n2 == charSequence.length()) {
                return -1L;
            }
            return (long)n2 << 32 | (long)charSequence.charAt(n2);
        }

        public static int getArgIndex(long l2) {
            return (int)l2;
        }
    }
}

