/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.text.ParsePosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SymbolTable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public class RuleCharacterIterator {
    private String text;
    private ParsePosition pos;
    private SymbolTable sym;
    private String buf;
    private int bufPos;
    private boolean isEscaped;
    public static final int DONE = -1;
    public static final int PARSE_VARIABLES = 1;
    public static final int PARSE_ESCAPES = 2;
    public static final int SKIP_WHITESPACE = 4;

    public RuleCharacterIterator(String string, SymbolTable symbolTable, ParsePosition parsePosition) {
        if (string == null || parsePosition.getIndex() > string.length()) {
            throw new IllegalArgumentException();
        }
        this.text = string;
        this.sym = symbolTable;
        this.pos = parsePosition;
        this.buf = null;
    }

    public boolean atEnd() {
        return this.buf == null && this.pos.getIndex() == this.text.length();
    }

    public int next(int n2) {
        int n3;
        block6: {
            n3 = -1;
            this.isEscaped = false;
            while (true) {
                n3 = this._current();
                this._advance(UTF16.getCharCount(n3));
                if (n3 == 36 && this.buf == null && (n2 & 1) != 0 && this.sym != null) {
                    String string = this.sym.parseReference(this.text, this.pos, this.text.length());
                    if (string != null) {
                        this.bufPos = 0;
                        char[] cArray = this.sym.lookup(string);
                        if (cArray == null) {
                            this.buf = null;
                            throw new IllegalArgumentException("Undefined variable: " + string);
                        }
                        if (cArray.length == 0) {
                            this.buf = null;
                        }
                        this.buf = new String(cArray);
                        continue;
                    }
                    break block6;
                }
                if ((n2 & 4) == 0 || !PatternProps.isWhiteSpace(n3)) break;
            }
            if (n3 != 92 || (n2 & 2) == 0) break block6;
            int n4 = Utility.unescapeAndLengthAt(this.getCurrentBuffer(), this.getCurrentBufferPos());
            if (n4 < 0) {
                throw new IllegalArgumentException("Invalid escape");
            }
            n3 = Utility.cpFromCodePointAndLength(n4);
            this.jumpahead(Utility.lengthFromCodePointAndLength(n4));
            this.isEscaped = true;
        }
        return n3;
    }

    public boolean isEscaped() {
        return this.isEscaped;
    }

    public boolean inVariable() {
        return this.buf != null;
    }

    public Position getPos(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.buf = this.buf;
        position.bufPos = this.bufPos;
        position.posIndex = this.pos.getIndex();
        return position;
    }

    public void setPos(Position position) {
        this.buf = position.buf;
        this.pos.setIndex(position.posIndex);
        this.bufPos = position.bufPos;
    }

    public void skipIgnored(int n2) {
        if ((n2 & 4) != 0) {
            int n3;
            while (PatternProps.isWhiteSpace(n3 = this._current())) {
                this._advance(UTF16.getCharCount(n3));
            }
        }
    }

    public String getCurrentBuffer() {
        if (this.buf != null) {
            return this.buf;
        }
        return this.text;
    }

    public int getCurrentBufferPos() {
        if (this.buf != null) {
            return this.bufPos;
        }
        return this.pos.getIndex();
    }

    public void jumpahead(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (this.buf != null) {
            this.bufPos += n2;
            if (this.bufPos > this.buf.length()) {
                throw new IllegalArgumentException();
            }
            if (this.bufPos == this.buf.length()) {
                this.buf = null;
            }
        } else {
            int n3 = this.pos.getIndex() + n2;
            this.pos.setIndex(n3);
            if (n3 > this.text.length()) {
                throw new IllegalArgumentException();
            }
        }
    }

    public String toString() {
        int n2 = this.pos.getIndex();
        return this.text.substring(0, n2) + '|' + this.text.substring(n2);
    }

    private int _current() {
        if (this.buf != null) {
            return UTF16.charAt(this.buf, this.bufPos);
        }
        int n2 = this.pos.getIndex();
        return n2 < this.text.length() ? UTF16.charAt(this.text, n2) : -1;
    }

    private void _advance(int n2) {
        if (this.buf != null) {
            this.bufPos += n2;
            if (this.bufPos == this.buf.length()) {
                this.buf = null;
            }
        } else {
            this.pos.setIndex(this.pos.getIndex() + n2);
            if (this.pos.getIndex() > this.text.length()) {
                this.pos.setIndex(this.text.length());
            }
        }
    }

    public static final class Position {
        private String buf;
        private int bufPos;
        private int posIndex;
    }
}

