/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ReplaceableString;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public class ReplaceableUCharacterIterator
extends UCharacterIterator {
    private Replaceable replaceable;
    private int currentIndex;

    public ReplaceableUCharacterIterator(Replaceable replaceable) {
        if (replaceable == null) {
            throw new IllegalArgumentException();
        }
        this.replaceable = replaceable;
        this.currentIndex = 0;
    }

    public ReplaceableUCharacterIterator(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.replaceable = new ReplaceableString(string);
        this.currentIndex = 0;
    }

    public ReplaceableUCharacterIterator(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException();
        }
        this.replaceable = new ReplaceableString(stringBuffer);
        this.currentIndex = 0;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public int current() {
        if (this.currentIndex < this.replaceable.length()) {
            return this.replaceable.charAt(this.currentIndex);
        }
        return -1;
    }

    @Override
    public int currentCodePoint() {
        int n2 = this.current();
        if (UTF16.isLeadSurrogate(n2)) {
            this.next();
            int n3 = this.current();
            this.previous();
            if (UTF16.isTrailSurrogate(n3)) {
                return Character.toCodePoint((char)n2, (char)n3);
            }
        }
        return n2;
    }

    @Override
    public int getLength() {
        return this.replaceable.length();
    }

    @Override
    public int getIndex() {
        return this.currentIndex;
    }

    @Override
    public int next() {
        if (this.currentIndex < this.replaceable.length()) {
            return this.replaceable.charAt(this.currentIndex++);
        }
        return -1;
    }

    @Override
    public int previous() {
        if (this.currentIndex > 0) {
            return this.replaceable.charAt(--this.currentIndex);
        }
        return -1;
    }

    @Override
    public void setIndex(int n2) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 > this.replaceable.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.currentIndex = n2;
    }

    @Override
    public int getText(char[] cArray, int n2) {
        int n3 = this.replaceable.length();
        if (n2 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException(Integer.toString(n3));
        }
        this.replaceable.getChars(0, n3, cArray, n2);
        return n3;
    }
}

