/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MutableCodePointTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.VersionInfo;

public final class Normalizer2Impl {
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    private static final int DATA_FORMAT = 1316121906;
    private static final CodePointMap.ValueFilter segmentStarterMapper = new CodePointMap.ValueFilter(){

        @Override
        public int apply(int n2) {
            return n2 & Integer.MIN_VALUE;
        }
    };
    public static final int MIN_YES_YES_WITH_CC = 65026;
    public static final int JAMO_VT = 65024;
    public static final int MIN_NORMAL_MAYBE_YES = 64512;
    public static final int JAMO_L = 2;
    public static final int INERT = 1;
    public static final int HAS_COMP_BOUNDARY_AFTER = 1;
    public static final int OFFSET_SHIFT = 1;
    public static final int DELTA_TCCC_0 = 0;
    public static final int DELTA_TCCC_1 = 2;
    public static final int DELTA_TCCC_GT_1 = 4;
    public static final int DELTA_TCCC_MASK = 6;
    public static final int DELTA_SHIFT = 3;
    public static final int MAX_DELTA = 64;
    public static final int IX_NORM_TRIE_OFFSET = 0;
    public static final int IX_EXTRA_DATA_OFFSET = 1;
    public static final int IX_SMALL_FCD_OFFSET = 2;
    public static final int IX_RESERVED3_OFFSET = 3;
    public static final int IX_TOTAL_SIZE = 7;
    public static final int IX_MIN_DECOMP_NO_CP = 8;
    public static final int IX_MIN_COMP_NO_MAYBE_CP = 9;
    public static final int IX_MIN_YES_NO = 10;
    public static final int IX_MIN_NO_NO = 11;
    public static final int IX_LIMIT_NO_NO = 12;
    public static final int IX_MIN_MAYBE_YES = 13;
    public static final int IX_MIN_YES_NO_MAPPINGS_ONLY = 14;
    public static final int IX_MIN_NO_NO_COMP_BOUNDARY_BEFORE = 15;
    public static final int IX_MIN_NO_NO_COMP_NO_MAYBE_CC = 16;
    public static final int IX_MIN_NO_NO_EMPTY = 17;
    public static final int IX_MIN_LCCC_CP = 18;
    public static final int IX_COUNT = 20;
    public static final int MAPPING_HAS_CCC_LCCC_WORD = 128;
    public static final int MAPPING_HAS_RAW_MAPPING = 64;
    public static final int MAPPING_LENGTH_MASK = 31;
    public static final int COMP_1_LAST_TUPLE = 32768;
    public static final int COMP_1_TRIPLE = 1;
    public static final int COMP_1_TRAIL_LIMIT = 13312;
    public static final int COMP_1_TRAIL_MASK = 32766;
    public static final int COMP_1_TRAIL_SHIFT = 9;
    public static final int COMP_2_TRAIL_SHIFT = 6;
    public static final int COMP_2_TRAIL_MASK = 65472;
    private VersionInfo dataVersion;
    private int minDecompNoCP;
    private int minCompNoMaybeCP;
    private int minLcccCP;
    private int minYesNo;
    private int minYesNoMappingsOnly;
    private int minNoNo;
    private int minNoNoCompBoundaryBefore;
    private int minNoNoCompNoMaybeCC;
    private int minNoNoEmpty;
    private int limitNoNo;
    private int centerNoNoDelta;
    private int minMaybeYes;
    private CodePointTrie.Fast16 normTrie;
    private String maybeYesCompositions;
    private String extraData;
    private byte[] smallFCD;
    private CodePointTrie canonIterData;
    private ArrayList<UnicodeSet> canonStartSets;
    private static final int CANON_NOT_SEGMENT_STARTER = Integer.MIN_VALUE;
    private static final int CANON_HAS_COMPOSITIONS = 0x40000000;
    private static final int CANON_HAS_SET = 0x200000;
    private static final int CANON_VALUE_MASK = 0x1FFFFF;

    public Normalizer2Impl load(ByteBuffer byteBuffer) {
        try {
            int n2;
            this.dataVersion = ICUBinary.readHeaderAndDataVersion(byteBuffer, 1316121906, IS_ACCEPTABLE);
            int n3 = byteBuffer.getInt() / 4;
            if (n3 <= 18) {
                throw new ICUUncheckedIOException("Normalizer2 data: not enough indexes");
            }
            int[] nArray = new int[n3];
            nArray[0] = n3 * 4;
            for (n2 = 1; n2 < n3; ++n2) {
                nArray[n2] = byteBuffer.getInt();
            }
            this.minDecompNoCP = nArray[8];
            this.minCompNoMaybeCP = nArray[9];
            this.minLcccCP = nArray[18];
            this.minYesNo = nArray[10];
            this.minYesNoMappingsOnly = nArray[14];
            this.minNoNo = nArray[11];
            this.minNoNoCompBoundaryBefore = nArray[15];
            this.minNoNoCompNoMaybeCC = nArray[16];
            this.minNoNoEmpty = nArray[17];
            this.limitNoNo = nArray[12];
            this.minMaybeYes = nArray[13];
            assert ((this.minMaybeYes & 7) == 0);
            this.centerNoNoDelta = (this.minMaybeYes >> 3) - 64 - 1;
            n2 = nArray[0];
            int n4 = nArray[1];
            int n5 = byteBuffer.position();
            this.normTrie = CodePointTrie.Fast16.fromBinary(byteBuffer);
            int n6 = byteBuffer.position() - n5;
            if (n6 > n4 - n2) {
                throw new ICUUncheckedIOException("Normalizer2 data: not enough bytes for normTrie");
            }
            ICUBinary.skipBytes(byteBuffer, n4 - n2 - n6);
            n2 = n4;
            n4 = nArray[2];
            int n7 = (n4 - n2) / 2;
            if (n7 != 0) {
                this.maybeYesCompositions = ICUBinary.getString(byteBuffer, n7, 0);
                this.extraData = this.maybeYesCompositions.substring(64512 - this.minMaybeYes >> 1);
            }
            n2 = n4;
            this.smallFCD = new byte[256];
            byteBuffer.get(this.smallFCD);
            return this;
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    public Normalizer2Impl load(String string) {
        return this.load(ICUBinary.getRequiredData(string));
    }

    public void addLcccChars(UnicodeSet unicodeSet) {
        int n2 = 0;
        CodePointMap.Range range = new CodePointMap.Range();
        while (this.normTrie.getRange(n2, CodePointMap.RangeOption.FIXED_LEAD_SURROGATES, 1, null, range)) {
            int n3;
            int n4 = range.getEnd();
            int n5 = range.getValue();
            if (n5 > 64512 && n5 != 65024) {
                unicodeSet.add(n2, n4);
            } else if (this.minNoNoCompNoMaybeCC <= n5 && n5 < this.limitNoNo && (n3 = this.getFCD16(n2)) > 255) {
                unicodeSet.add(n2, n4);
            }
            n2 = n4 + 1;
        }
    }

    public void addPropertyStarts(UnicodeSet unicodeSet) {
        int n2;
        int n3 = 0;
        CodePointMap.Range range = new CodePointMap.Range();
        while (this.normTrie.getRange(n3, CodePointMap.RangeOption.FIXED_LEAD_SURROGATES, 1, null, range)) {
            n2 = range.getEnd();
            int n4 = range.getValue();
            unicodeSet.add(n3);
            if (n3 != n2 && this.isAlgorithmicNoNo(n4) && (n4 & 6) > 2) {
                int n5 = this.getFCD16(n3);
                while (++n3 <= n2) {
                    int n6 = this.getFCD16(n3);
                    if (n6 == n5) continue;
                    unicodeSet.add(n3);
                    n5 = n6;
                }
            }
            n3 = n2 + 1;
        }
        for (n2 = 44032; n2 < 55204; n2 += 28) {
            unicodeSet.add(n2);
            unicodeSet.add(n2 + 1);
        }
        unicodeSet.add(55204);
    }

    public void addCanonIterPropertyStarts(UnicodeSet unicodeSet) {
        this.ensureCanonIterData();
        int n2 = 0;
        CodePointMap.Range range = new CodePointMap.Range();
        while (this.canonIterData.getRange(n2, segmentStarterMapper, range)) {
            unicodeSet.add(n2);
            n2 = range.getEnd() + 1;
        }
    }

    public synchronized Normalizer2Impl ensureCanonIterData() {
        if (this.canonIterData == null) {
            MutableCodePointTrie mutableCodePointTrie = new MutableCodePointTrie(0, 0);
            this.canonStartSets = new ArrayList();
            int n2 = 0;
            CodePointMap.Range range = new CodePointMap.Range();
            while (this.normTrie.getRange(n2, CodePointMap.RangeOption.FIXED_LEAD_SURROGATES, 1, null, range)) {
                int n3 = range.getEnd();
                int n4 = range.getValue();
                if (Normalizer2Impl.isInert(n4) || this.minYesNo <= n4 && n4 < this.minNoNo) {
                    n2 = n3 + 1;
                    continue;
                }
                for (int i2 = n2; i2 <= n3; ++i2) {
                    int n5;
                    int n6 = n5 = mutableCodePointTrie.get(i2);
                    if (this.isMaybeOrNonZeroCC(n4)) {
                        n6 |= Integer.MIN_VALUE;
                        if (n4 < 64512) {
                            n6 |= 0x40000000;
                        }
                    } else if (n4 < this.minYesNo) {
                        n6 |= 0x40000000;
                    } else {
                        int n7 = i2;
                        int n8 = n4;
                        if (this.isDecompNoAlgorithmic(n8)) {
                            n7 = this.mapAlgorithmic(n7, n8);
                            n8 = this.getRawNorm16(n7);
                            assert (!this.isHangulLV(n8) && !this.isHangulLVT(n8));
                        }
                        if (n8 > this.minYesNo) {
                            int n9 = n8 >> 1;
                            char c2 = this.extraData.charAt(n9);
                            int n10 = c2 & 0x1F;
                            if ((c2 & 0x80) != 0 && i2 == n7 && (this.extraData.charAt(n9 - 1) & 0xFF) != 0) {
                                n6 |= Integer.MIN_VALUE;
                            }
                            if (n10 != 0) {
                                int n11 = ++n9 + n10;
                                n7 = this.extraData.codePointAt(n9);
                                this.addToStartSet(mutableCodePointTrie, i2, n7);
                                if (n8 >= this.minNoNo) {
                                    while ((n9 += Character.charCount(n7)) < n11) {
                                        n7 = this.extraData.codePointAt(n9);
                                        int n12 = mutableCodePointTrie.get(n7);
                                        if ((n12 & Integer.MIN_VALUE) != 0) continue;
                                        mutableCodePointTrie.set(n7, n12 | Integer.MIN_VALUE);
                                    }
                                }
                            }
                        } else {
                            this.addToStartSet(mutableCodePointTrie, i2, n7);
                        }
                    }
                    if (n6 == n5) continue;
                    mutableCodePointTrie.set(i2, n6);
                }
                n2 = n3 + 1;
            }
            this.canonIterData = mutableCodePointTrie.buildImmutable(CodePointTrie.Type.SMALL, CodePointTrie.ValueWidth.BITS_32);
        }
        return this;
    }

    public int getNorm16(int n2) {
        return UTF16Plus.isLeadSurrogate(n2) ? 1 : this.normTrie.get(n2);
    }

    public int getRawNorm16(int n2) {
        return this.normTrie.get(n2);
    }

    public int getCompQuickCheck(int n2) {
        if (n2 < this.minNoNo || 65026 <= n2) {
            return 1;
        }
        if (this.minMaybeYes <= n2) {
            return 2;
        }
        return 0;
    }

    public boolean isAlgorithmicNoNo(int n2) {
        return this.limitNoNo <= n2 && n2 < this.minMaybeYes;
    }

    public boolean isCompNo(int n2) {
        return this.minNoNo <= n2 && n2 < this.minMaybeYes;
    }

    public boolean isDecompYes(int n2) {
        return n2 < this.minYesNo || this.minMaybeYes <= n2;
    }

    public int getCC(int n2) {
        if (n2 >= 64512) {
            return Normalizer2Impl.getCCFromNormalYesOrMaybe(n2);
        }
        if (n2 < this.minNoNo || this.limitNoNo <= n2) {
            return 0;
        }
        return this.getCCFromNoNo(n2);
    }

    public static int getCCFromNormalYesOrMaybe(int n2) {
        return n2 >> 1 & 0xFF;
    }

    public static int getCCFromYesOrMaybe(int n2) {
        return n2 >= 64512 ? Normalizer2Impl.getCCFromNormalYesOrMaybe(n2) : 0;
    }

    public int getCCFromYesOrMaybeCP(int n2) {
        if (n2 < this.minCompNoMaybeCP) {
            return 0;
        }
        return Normalizer2Impl.getCCFromYesOrMaybe(this.getNorm16(n2));
    }

    public int getFCD16(int n2) {
        if (n2 < this.minDecompNoCP) {
            return 0;
        }
        if (n2 <= 65535 && !this.singleLeadMightHaveNonZeroFCD16(n2)) {
            return 0;
        }
        return this.getFCD16FromNormData(n2);
    }

    public boolean singleLeadMightHaveNonZeroFCD16(int n2) {
        byte by2 = this.smallFCD[n2 >> 8];
        if (by2 == 0) {
            return false;
        }
        return (by2 >> (n2 >> 5 & 7) & 1) != 0;
    }

    public int getFCD16FromNormData(int n2) {
        int n3;
        int n4 = this.getNorm16(n2);
        if (n4 >= this.limitNoNo) {
            if (n4 >= 64512) {
                n4 = Normalizer2Impl.getCCFromNormalYesOrMaybe(n4);
                return n4 | n4 << 8;
            }
            if (n4 >= this.minMaybeYes) {
                return 0;
            }
            n3 = n4 & 6;
            if (n3 <= 2) {
                return n3 >> 1;
            }
            n2 = this.mapAlgorithmic(n2, n4);
            n4 = this.getRawNorm16(n2);
        }
        if (n4 <= this.minYesNo || this.isHangulLVT(n4)) {
            return 0;
        }
        n3 = n4 >> 1;
        char c2 = this.extraData.charAt(n3);
        int n5 = c2 >> 8;
        if ((c2 & 0x80) != 0) {
            n5 |= this.extraData.charAt(n3 - 1) & 0xFF00;
        }
        return n5;
    }

    public String getDecomposition(int n2) {
        int n3;
        if (n2 < this.minDecompNoCP || this.isMaybeOrNonZeroCC(n3 = this.getNorm16(n2))) {
            return null;
        }
        int n4 = -1;
        if (this.isDecompNoAlgorithmic(n3)) {
            n4 = n2 = this.mapAlgorithmic(n2, n3);
            n3 = this.getRawNorm16(n2);
        }
        if (n3 < this.minYesNo) {
            if (n4 < 0) {
                return null;
            }
            return UTF16.valueOf(n4);
        }
        if (this.isHangulLV(n3) || this.isHangulLVT(n3)) {
            StringBuilder stringBuilder = new StringBuilder();
            Hangul.decompose(n2, stringBuilder);
            return stringBuilder.toString();
        }
        int n5 = n3 >> 1;
        int n6 = this.extraData.charAt(n5++) & 0x1F;
        return this.extraData.substring(n5, n5 + n6);
    }

    public String getRawDecomposition(int n2) {
        int n3;
        if (n2 < this.minDecompNoCP || this.isDecompYes(n3 = this.getNorm16(n2))) {
            return null;
        }
        if (this.isHangulLV(n3) || this.isHangulLVT(n3)) {
            StringBuilder stringBuilder = new StringBuilder();
            Hangul.getRawDecomposition(n2, stringBuilder);
            return stringBuilder.toString();
        }
        if (this.isDecompNoAlgorithmic(n3)) {
            return UTF16.valueOf(this.mapAlgorithmic(n2, n3));
        }
        int n4 = n3 >> 1;
        char c2 = this.extraData.charAt(n4);
        int n5 = c2 & 0x1F;
        if ((c2 & 0x40) != 0) {
            int n6 = n4 - (c2 >> 7 & 1) - 1;
            char c3 = this.extraData.charAt(n6);
            if (c3 <= '\u001f') {
                return this.extraData.substring(n6 - c3, n6);
            }
            StringBuilder stringBuilder = new StringBuilder(n5 - 1).append(c3);
            return stringBuilder.append(this.extraData, n4 += 3, n4 + n5 - 2).toString();
        }
        return this.extraData.substring(++n4, n4 + n5);
    }

    public boolean isCanonSegmentStarter(int n2) {
        return this.canonIterData.get(n2) >= 0;
    }

    public boolean getCanonStartSet(int n2, UnicodeSet unicodeSet) {
        int n3 = this.canonIterData.get(n2) & Integer.MAX_VALUE;
        if (n3 == 0) {
            return false;
        }
        unicodeSet.clear();
        int n4 = n3 & 0x1FFFFF;
        if ((n3 & 0x200000) != 0) {
            unicodeSet.addAll(this.canonStartSets.get(n4));
        } else if (n4 != 0) {
            unicodeSet.add(n4);
        }
        if ((n3 & 0x40000000) != 0) {
            int n5 = this.getRawNorm16(n2);
            if (n5 == 2) {
                int n6 = 44032 + (n2 - 4352) * 588;
                unicodeSet.add(n6, n6 + 588 - 1);
            } else {
                this.addComposites(this.getCompositionsList(n5), unicodeSet);
            }
        }
        return true;
    }

    public Appendable decompose(CharSequence charSequence, StringBuilder stringBuilder) {
        this.decompose(charSequence, 0, charSequence.length(), stringBuilder, charSequence.length());
        return stringBuilder;
    }

    public void decompose(CharSequence charSequence, int n2, int n3, StringBuilder stringBuilder, int n4) {
        if (n4 < 0) {
            n4 = n3 - n2;
        }
        stringBuilder.setLength(0);
        ReorderingBuffer reorderingBuffer = new ReorderingBuffer(this, stringBuilder, n4);
        this.decompose(charSequence, n2, n3, reorderingBuffer);
    }

    public int decompose(CharSequence charSequence, int n2, int n3, ReorderingBuffer reorderingBuffer) {
        block9: {
            int n4 = this.minDecompNoCP;
            int n5 = 0;
            int n6 = 0;
            int n7 = n2;
            char c2 = '\u0000';
            while (true) {
                char c3;
                int n8 = n2;
                while (n2 != n3) {
                    n5 = charSequence.charAt(n2);
                    if (n5 < n4 || this.isMostDecompYesAndZeroCC(n6 = this.normTrie.bmpGet(n5))) {
                        ++n2;
                        continue;
                    }
                    if (!UTF16Plus.isLeadSurrogate(n5)) break;
                    if (n2 + 1 != n3) {
                        char c4 = charSequence.charAt(n2 + 1);
                        c3 = c4;
                        if (Character.isLowSurrogate(c4)) {
                            n6 = this.normTrie.suppGet(n5 = Character.toCodePoint((char)n5, c3));
                            if (!this.isMostDecompYesAndZeroCC(n6)) break;
                            n2 += 2;
                            continue;
                        }
                    }
                    ++n2;
                }
                if (n2 != n8) {
                    if (reorderingBuffer != null) {
                        reorderingBuffer.flushAndAppendZeroCC(charSequence, n8, n2);
                    } else {
                        c2 = '\u0000';
                        n7 = n2;
                    }
                }
                if (n2 == n3) break block9;
                n2 += Character.charCount(n5);
                if (reorderingBuffer != null) {
                    this.decompose(n5, n6, reorderingBuffer);
                    continue;
                }
                if (!this.isDecompYes(n6) || c2 > (c3 = Normalizer2Impl.getCCFromYesOrMaybe(n6)) && c3 != '\u0000') break;
                c2 = c3;
                if (c3 > '\u0001') continue;
                n7 = n2;
            }
            return n7;
        }
        return n2;
    }

    public void decomposeAndAppend(CharSequence charSequence, boolean bl2, ReorderingBuffer reorderingBuffer) {
        int n2;
        int n3 = charSequence.length();
        if (n3 == 0) {
            return;
        }
        if (bl2) {
            this.decompose(charSequence, 0, n3, reorderingBuffer);
            return;
        }
        int n4 = Character.codePointAt(charSequence, 0);
        int n5 = 0;
        int n6 = n2 = this.getCC(this.getNorm16(n4));
        int n7 = n2;
        while (n2 != 0) {
            n6 = n2;
            if ((n5 += Character.charCount(n4)) >= n3) break;
            n4 = Character.codePointAt(charSequence, n5);
            n2 = this.getCC(this.getNorm16(n4));
        }
        reorderingBuffer.append(charSequence, 0, n5, false, n7, n6);
        reorderingBuffer.append(charSequence, n5, n3);
    }

    public boolean compose(CharSequence charSequence, int n2, int n3, boolean bl2, boolean bl3, ReorderingBuffer reorderingBuffer) {
        int n4 = n2;
        int n5 = this.minCompNoMaybeCP;
        while (true) {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = 0;
            int n11 = 0;
            while (true) {
                if (n2 == n3) {
                    if (n4 != n3 && bl3) {
                        reorderingBuffer.append(charSequence, n4, n3);
                    }
                    return true;
                }
                n10 = charSequence.charAt(n2);
                if (n10 < n5 || this.isCompYesAndZeroCC(n11 = this.normTrie.bmpGet(n10))) {
                    ++n2;
                    continue;
                }
                n9 = n2++;
                if (!UTF16Plus.isLeadSurrogate(n10)) break;
                if (n2 == n3 || !Character.isLowSurrogate((char)(n8 = charSequence.charAt(n2)))) continue;
                ++n2;
                n11 = this.normTrie.suppGet(n10 = Character.toCodePoint((char)n10, (char)n8));
                if (!this.isCompYesAndZeroCC(n11)) break;
            }
            if (!this.isMaybeOrNonZeroCC(n11)) {
                if (!bl3) {
                    return false;
                }
                if (this.isDecompNoAlgorithmic(n11)) {
                    if (this.norm16HasCompBoundaryAfter(n11, bl2) || this.hasCompBoundaryBefore(charSequence, n2, n3)) {
                        if (n4 != n9) {
                            reorderingBuffer.append(charSequence, n4, n9);
                        }
                        reorderingBuffer.append(this.mapAlgorithmic(n10, n11), 0);
                        n4 = n2;
                        continue;
                    }
                } else if (n11 < this.minNoNoCompBoundaryBefore) {
                    if (this.norm16HasCompBoundaryAfter(n11, bl2) || this.hasCompBoundaryBefore(charSequence, n2, n3)) {
                        if (n4 != n9) {
                            reorderingBuffer.append(charSequence, n4, n9);
                        }
                        n8 = n11 >> 1;
                        n7 = this.extraData.charAt(n8++) & 0x1F;
                        reorderingBuffer.append(this.extraData, n8, n8 + n7);
                        n4 = n2;
                        continue;
                    }
                } else if (n11 >= this.minNoNoEmpty && (this.hasCompBoundaryBefore(charSequence, n2, n3) || this.hasCompBoundaryAfter(charSequence, n4, n9, bl2))) {
                    if (n4 != n9) {
                        reorderingBuffer.append(charSequence, n4, n9);
                    }
                    n4 = n2;
                    continue;
                }
            } else if (Normalizer2Impl.isJamoVT(n11) && n4 != n9) {
                n8 = charSequence.charAt(n9 - 1);
                if (n10 < 4519) {
                    n7 = n8 - 4352;
                    if (n7 < 19) {
                        if (!bl3) {
                            return false;
                        }
                        if (n2 != n3 && 0 < (n6 = charSequence.charAt(n2) - 4519) && n6 < 28) {
                            ++n2;
                        } else {
                            n6 = this.hasCompBoundaryBefore(charSequence, n2, n3) ? 0 : -1;
                        }
                        if (n6 >= 0) {
                            int n12 = 44032 + (n7 * 21 + (n10 - 4449)) * 28 + n6;
                            if (n4 != --n9) {
                                reorderingBuffer.append(charSequence, n4, n9);
                            }
                            reorderingBuffer.append((char)n12);
                            n4 = n2;
                            continue;
                        }
                    }
                } else if (Hangul.isHangulLV(n8)) {
                    if (!bl3) {
                        return false;
                    }
                    n7 = n8 + n10 - 4519;
                    if (n4 != --n9) {
                        reorderingBuffer.append(charSequence, n4, n9);
                    }
                    reorderingBuffer.append((char)n7);
                    n4 = n2;
                    continue;
                }
            } else if (n11 > 65024) {
                n8 = Normalizer2Impl.getCCFromNormalYesOrMaybe(n11);
                if (bl2 && this.getPreviousTrailCC(charSequence, n4, n9) > n8) {
                    if (!bl3) {
                        return false;
                    }
                } else {
                    while (true) {
                        if (n2 == n3) {
                            if (bl3) {
                                reorderingBuffer.append(charSequence, n4, n3);
                            }
                            return true;
                        }
                        n6 = n8;
                        n10 = Character.codePointAt(charSequence, n2);
                        n7 = this.normTrie.get(n10);
                        if (n7 < 65026) break;
                        n8 = Normalizer2Impl.getCCFromNormalYesOrMaybe(n7);
                        if (n6 > n8) {
                            if (bl3) break;
                            return false;
                        }
                        n2 += Character.charCount(n10);
                    }
                    if (this.norm16HasCompBoundaryBefore(n7)) {
                        if (!this.isCompYesAndZeroCC(n7)) continue;
                        n2 += Character.charCount(n10);
                        continue;
                    }
                }
            }
            if (n4 != n9 && !this.norm16HasCompBoundaryBefore(n11) && !this.norm16HasCompBoundaryAfter(n11 = this.normTrie.get(n10 = Character.codePointBefore(charSequence, n9)), bl2)) {
                n9 -= Character.charCount(n10);
            }
            if (bl3 && n4 != n9) {
                reorderingBuffer.append(charSequence, n4, n9);
            }
            n8 = reorderingBuffer.length();
            this.decomposeShort(charSequence, n9, n2, false, bl2, reorderingBuffer);
            n2 = this.decomposeShort(charSequence, n2, n3, true, bl2, reorderingBuffer);
            this.recompose(reorderingBuffer, n8, bl2);
            if (!bl3) {
                if (!reorderingBuffer.equals(charSequence, n9, n2)) {
                    return false;
                }
                reorderingBuffer.remove();
            }
            n4 = n2;
        }
    }

    public int composeQuickCheck(CharSequence charSequence, int n2, int n3, boolean bl2, boolean bl3) {
        int n4 = 0;
        int n5 = n2;
        int n6 = this.minCompNoMaybeCP;
        while (true) {
            int n7;
            int n8;
            int n9;
            int n10 = 0;
            int n11 = 0;
            while (true) {
                if (n2 == n3) {
                    return n2 << 1 | n4;
                }
                n10 = charSequence.charAt(n2);
                if (n10 < n6 || this.isCompYesAndZeroCC(n11 = this.normTrie.bmpGet(n10))) {
                    ++n2;
                    continue;
                }
                n9 = n2++;
                if (!UTF16Plus.isLeadSurrogate(n10)) break;
                if (n2 == n3 || !Character.isLowSurrogate((char)(n8 = charSequence.charAt(n2)))) continue;
                ++n2;
                n11 = this.normTrie.suppGet(n10 = Character.toCodePoint((char)n10, (char)n8));
                if (!this.isCompYesAndZeroCC(n11)) break;
            }
            n8 = 1;
            if (n5 != n9) {
                n5 = n9;
                if (!this.norm16HasCompBoundaryBefore(n11) && !this.norm16HasCompBoundaryAfter(n7 = this.getNorm16(n10 = Character.codePointBefore(charSequence, n9)), bl2)) {
                    n5 -= Character.charCount(n10);
                    n8 = n7;
                }
            }
            if (!this.isMaybeOrNonZeroCC(n11)) break;
            n7 = Normalizer2Impl.getCCFromYesOrMaybe(n11);
            if (bl2 && n7 != 0 && this.getTrailCCFromCompYesAndZeroCC(n8) > n7) break;
            while (true) {
                if (n11 < 65026) {
                    if (!bl3) {
                        n4 = 1;
                    } else {
                        return n5 << 1;
                    }
                }
                if (n2 == n3) {
                    return n2 << 1 | n4;
                }
                int n12 = n7;
                n10 = Character.codePointAt(charSequence, n2);
                n11 = this.getNorm16(n10);
                if (!this.isMaybeOrNonZeroCC(n11) || n12 > (n7 = Normalizer2Impl.getCCFromYesOrMaybe(n11)) && n7 != 0) break;
                n2 += Character.charCount(n10);
            }
            if (!this.isCompYesAndZeroCC(n11)) break;
            n5 = n2;
            n2 += Character.charCount(n10);
        }
        return n5 << 1;
    }

    public void composeAndAppend(CharSequence charSequence, boolean bl2, boolean bl3, ReorderingBuffer reorderingBuffer) {
        int n2;
        int n3 = 0;
        int n4 = charSequence.length();
        if (!reorderingBuffer.isEmpty() && 0 != (n2 = this.findNextCompBoundary(charSequence, 0, n4, bl3))) {
            int n5 = this.findPreviousCompBoundary(reorderingBuffer.getStringBuilder(), reorderingBuffer.length(), bl3);
            StringBuilder stringBuilder = new StringBuilder(reorderingBuffer.length() - n5 + n2 + 16);
            stringBuilder.append(reorderingBuffer.getStringBuilder(), n5, reorderingBuffer.length());
            reorderingBuffer.removeSuffix(reorderingBuffer.length() - n5);
            stringBuilder.append(charSequence, 0, n2);
            this.compose(stringBuilder, 0, stringBuilder.length(), bl3, true, reorderingBuffer);
            n3 = n2;
        }
        if (bl2) {
            this.compose(charSequence, n3, n4, bl3, true, reorderingBuffer);
        } else {
            reorderingBuffer.append(charSequence, n3, n4);
        }
    }

    public int makeFCD(CharSequence charSequence, int n2, int n3, ReorderingBuffer reorderingBuffer) {
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (true) {
            int n8;
            int n9 = n2;
            while (n2 != n3) {
                n5 = charSequence.charAt(n2);
                if (n5 < this.minLcccCP) {
                    n6 = ~n5;
                    ++n2;
                    continue;
                }
                if (!this.singleLeadMightHaveNonZeroFCD16(n5)) {
                    n6 = 0;
                    ++n2;
                    continue;
                }
                if (UTF16Plus.isLeadSurrogate(n5) && n2 + 1 != n3) {
                    char c2 = charSequence.charAt(n2 + 1);
                    n8 = c2;
                    if (Character.isLowSurrogate(c2)) {
                        n5 = Character.toCodePoint((char)n5, (char)n8);
                    }
                }
                if ((n7 = this.getFCD16FromNormData(n5)) > 255) break;
                n6 = n7;
                n2 += Character.charCount(n5);
            }
            if (n2 != n9) {
                if (n2 == n3) {
                    if (reorderingBuffer == null) break;
                    reorderingBuffer.flushAndAppendZeroCC(charSequence, n9, n2);
                    break;
                }
                n4 = n2;
                if (n6 < 0) {
                    n8 = ~n6;
                    if (n8 < this.minDecompNoCP) {
                        n6 = 0;
                    } else {
                        n6 = this.getFCD16FromNormData(n8);
                        if (n6 > 1) {
                            --n4;
                        }
                    }
                } else {
                    n8 = n2 - 1;
                    if (Character.isLowSurrogate(charSequence.charAt(n8)) && n9 < n8 && Character.isHighSurrogate(charSequence.charAt(n8 - 1))) {
                        n6 = this.getFCD16FromNormData(Character.toCodePoint(charSequence.charAt(--n8), charSequence.charAt(n8 + '\u0001')));
                    }
                    if (n6 > 1) {
                        n4 = n8;
                    }
                }
                if (reorderingBuffer != null) {
                    reorderingBuffer.flushAndAppendZeroCC(charSequence, n9, n4);
                    reorderingBuffer.append(charSequence, n4, n2);
                }
                n9 = n2;
            } else if (n2 == n3) break;
            n2 += Character.charCount(n5);
            if ((n6 & 0xFF) <= n7 >> 8) {
                if ((n7 & 0xFF) <= 1) {
                    n4 = n2;
                }
                if (reorderingBuffer != null) {
                    reorderingBuffer.appendZeroCC(n5);
                }
                n6 = n7;
                continue;
            }
            if (reorderingBuffer == null) {
                return n4;
            }
            reorderingBuffer.removeSuffix(n9 - n4);
            n2 = this.findNextFCDBoundary(charSequence, n2, n3);
            this.decomposeShort(charSequence, n4, n2, false, false, reorderingBuffer);
            n4 = n2;
            n6 = 0;
        }
        return n2;
    }

    public void makeFCDAndAppend(CharSequence charSequence, boolean bl2, ReorderingBuffer reorderingBuffer) {
        int n2;
        int n3 = 0;
        int n4 = charSequence.length();
        if (!reorderingBuffer.isEmpty() && 0 != (n2 = this.findNextFCDBoundary(charSequence, 0, n4))) {
            int n5 = this.findPreviousFCDBoundary(reorderingBuffer.getStringBuilder(), reorderingBuffer.length());
            StringBuilder stringBuilder = new StringBuilder(reorderingBuffer.length() - n5 + n2 + 16);
            stringBuilder.append(reorderingBuffer.getStringBuilder(), n5, reorderingBuffer.length());
            reorderingBuffer.removeSuffix(reorderingBuffer.length() - n5);
            stringBuilder.append(charSequence, 0, n2);
            this.makeFCD(stringBuilder, 0, stringBuilder.length(), reorderingBuffer);
            n3 = n2;
        }
        if (bl2) {
            this.makeFCD(charSequence, n3, n4, reorderingBuffer);
        } else {
            reorderingBuffer.append(charSequence, n3, n4);
        }
    }

    public boolean hasDecompBoundaryBefore(int n2) {
        return n2 < this.minLcccCP || n2 <= 65535 && !this.singleLeadMightHaveNonZeroFCD16(n2) || this.norm16HasDecompBoundaryBefore(this.getNorm16(n2));
    }

    public boolean norm16HasDecompBoundaryBefore(int n2) {
        if (n2 < this.minNoNoCompNoMaybeCC) {
            return true;
        }
        if (n2 >= this.limitNoNo) {
            return n2 <= 64512 || n2 == 65024;
        }
        int n3 = n2 >> 1;
        char c2 = this.extraData.charAt(n3);
        return (c2 & 0x80) == 0 || (this.extraData.charAt(n3 - 1) & 0xFF00) == 0;
    }

    public boolean hasDecompBoundaryAfter(int n2) {
        if (n2 < this.minDecompNoCP) {
            return true;
        }
        if (n2 <= 65535 && !this.singleLeadMightHaveNonZeroFCD16(n2)) {
            return true;
        }
        return this.norm16HasDecompBoundaryAfter(this.getNorm16(n2));
    }

    public boolean norm16HasDecompBoundaryAfter(int n2) {
        if (n2 <= this.minYesNo || this.isHangulLVT(n2)) {
            return true;
        }
        if (n2 >= this.limitNoNo) {
            if (this.isMaybeOrNonZeroCC(n2)) {
                return n2 <= 64512 || n2 == 65024;
            }
            return (n2 & 6) <= 2;
        }
        int n3 = n2 >> 1;
        char c2 = this.extraData.charAt(n3);
        if (c2 > '\u01ff') {
            return false;
        }
        if (c2 <= '\u00ff') {
            return true;
        }
        return (c2 & 0x80) == 0 || (this.extraData.charAt(n3 - 1) & 0xFF00) == 0;
    }

    public boolean isDecompInert(int n2) {
        return this.isDecompYesAndZeroCC(this.getNorm16(n2));
    }

    public boolean hasCompBoundaryBefore(int n2) {
        return n2 < this.minCompNoMaybeCP || this.norm16HasCompBoundaryBefore(this.getNorm16(n2));
    }

    public boolean hasCompBoundaryAfter(int n2, boolean bl2) {
        return this.norm16HasCompBoundaryAfter(this.getNorm16(n2), bl2);
    }

    public boolean isCompInert(int n2, boolean bl2) {
        int n3 = this.getNorm16(n2);
        return this.isCompYesAndZeroCC(n3) && (n3 & 1) != 0 && (!bl2 || Normalizer2Impl.isInert(n3) || this.extraData.charAt(n3 >> 1) <= '\u01ff');
    }

    public boolean hasFCDBoundaryBefore(int n2) {
        return this.hasDecompBoundaryBefore(n2);
    }

    public boolean hasFCDBoundaryAfter(int n2) {
        return this.hasDecompBoundaryAfter(n2);
    }

    public boolean isFCDInert(int n2) {
        return this.getFCD16(n2) <= 1;
    }

    private boolean isMaybe(int n2) {
        return this.minMaybeYes <= n2 && n2 <= 65024;
    }

    private boolean isMaybeOrNonZeroCC(int n2) {
        return n2 >= this.minMaybeYes;
    }

    private static boolean isInert(int n2) {
        return n2 == 1;
    }

    private static boolean isJamoL(int n2) {
        return n2 == 2;
    }

    private static boolean isJamoVT(int n2) {
        return n2 == 65024;
    }

    private int hangulLVT() {
        return this.minYesNoMappingsOnly | 1;
    }

    private boolean isHangulLV(int n2) {
        return n2 == this.minYesNo;
    }

    private boolean isHangulLVT(int n2) {
        return n2 == this.hangulLVT();
    }

    private boolean isCompYesAndZeroCC(int n2) {
        return n2 < this.minNoNo;
    }

    private boolean isDecompYesAndZeroCC(int n2) {
        return n2 < this.minYesNo || n2 == 65024 || this.minMaybeYes <= n2 && n2 <= 64512;
    }

    private boolean isMostDecompYesAndZeroCC(int n2) {
        return n2 < this.minYesNo || n2 == 64512 || n2 == 65024;
    }

    private boolean isDecompNoAlgorithmic(int n2) {
        return n2 >= this.limitNoNo;
    }

    private int getCCFromNoNo(int n2) {
        int n3 = n2 >> 1;
        if ((this.extraData.charAt(n3) & 0x80) != 0) {
            return this.extraData.charAt(n3 - 1) & 0xFF;
        }
        return 0;
    }

    int getTrailCCFromCompYesAndZeroCC(int n2) {
        if (n2 <= this.minYesNo) {
            return 0;
        }
        return this.extraData.charAt(n2 >> 1) >> 8;
    }

    private int mapAlgorithmic(int n2, int n3) {
        return n2 + (n3 >> 3) - this.centerNoNoDelta;
    }

    private int getCompositionsListForDecompYes(int n2) {
        if (n2 < 2 || 64512 <= n2) {
            return -1;
        }
        if ((n2 -= this.minMaybeYes) < 0) {
            n2 += 64512;
        }
        return n2 >> 1;
    }

    private int getCompositionsListForComposite(int n2) {
        int n3 = 64512 - this.minMaybeYes + n2 >> 1;
        char c2 = this.maybeYesCompositions.charAt(n3);
        return n3 + 1 + (c2 & 0x1F);
    }

    private int getCompositionsListForMaybe(int n2) {
        return n2 - this.minMaybeYes >> 1;
    }

    private int getCompositionsList(int n2) {
        return this.isDecompYes(n2) ? this.getCompositionsListForDecompYes(n2) : this.getCompositionsListForComposite(n2);
    }

    private int decomposeShort(CharSequence charSequence, int n2, int n3, boolean bl2, boolean bl3, ReorderingBuffer reorderingBuffer) {
        while (n2 < n3) {
            int n4 = Character.codePointAt(charSequence, n2);
            if (bl2 && n4 < this.minCompNoMaybeCP) {
                return n2;
            }
            int n5 = this.getNorm16(n4);
            if (bl2 && this.norm16HasCompBoundaryBefore(n5)) {
                return n2;
            }
            n2 += Character.charCount(n4);
            this.decompose(n4, n5, reorderingBuffer);
            if (!bl2 || !this.norm16HasCompBoundaryAfter(n5, bl3)) continue;
            return n2;
        }
        return n2;
    }

    private void decompose(int n2, int n3, ReorderingBuffer reorderingBuffer) {
        if (n3 >= this.limitNoNo) {
            if (this.isMaybeOrNonZeroCC(n3)) {
                reorderingBuffer.append(n2, Normalizer2Impl.getCCFromYesOrMaybe(n3));
                return;
            }
            n2 = this.mapAlgorithmic(n2, n3);
            n3 = this.getRawNorm16(n2);
        }
        if (n3 < this.minYesNo) {
            reorderingBuffer.append(n2, 0);
        } else if (this.isHangulLV(n3) || this.isHangulLVT(n3)) {
            Hangul.decompose(n2, reorderingBuffer);
        } else {
            int n4 = n3 >> 1;
            char c2 = this.extraData.charAt(n4);
            int n5 = c2 & 0x1F;
            int n6 = c2 >> 8;
            int n7 = (c2 & 0x80) != 0 ? this.extraData.charAt(n4 - 1) >> 8 : 0;
            reorderingBuffer.append(this.extraData, ++n4, n4 + n5, true, n7, n6);
        }
    }

    private static int combine(String string, int n2, int n3) {
        block9: {
            if (n3 < 13312) {
                char c2;
                int n4 = n3 << 1;
                while (n4 > (c2 = string.charAt(n2))) {
                    n2 += 2 + (c2 & '\u0001');
                }
                if (n4 == (c2 & 0x7FFE)) {
                    if ((c2 & '\u0001') != 0) {
                        return string.charAt(n2 + 1) << 16 | string.charAt(n2 + 2);
                    }
                    return string.charAt(n2 + 1);
                }
            } else {
                char c3;
                int n5 = 13312 + (n3 >> 9 & 0xFFFFFFFE);
                int n6 = n3 << 6 & 0xFFFF;
                while (true) {
                    char c4;
                    if (n5 > (c4 = string.charAt(n2))) {
                        n2 += 2 + (c4 & '\u0001');
                        continue;
                    }
                    if (n5 != (c4 & 0x7FFE)) break block9;
                    c3 = string.charAt(n2 + 1);
                    if (n6 <= c3) break;
                    if ((c4 & 0x8000) == 0) {
                        n2 += 3;
                        continue;
                    }
                    break block9;
                    break;
                }
                if (n6 == (c3 & 0xFFC0)) {
                    return (c3 & 0xFFFF003F) << 16 | string.charAt(n2 + 2);
                }
            }
        }
        return -1;
    }

    private void addComposites(int n2, UnicodeSet unicodeSet) {
        char c2;
        do {
            int n3;
            if (((c2 = this.maybeYesCompositions.charAt(n2)) & '\u0001') == 0) {
                n3 = this.maybeYesCompositions.charAt(n2 + 1);
                n2 += 2;
            } else {
                n3 = (this.maybeYesCompositions.charAt(n2 + 1) & 0xFFFF003F) << 16 | this.maybeYesCompositions.charAt(n2 + 2);
                n2 += 3;
            }
            int n4 = n3 >> 1;
            if ((n3 & '\u0001') != 0) {
                this.addComposites(this.getCompositionsListForComposite(this.getRawNorm16(n4)), unicodeSet);
            }
            unicodeSet.add(n4);
        } while ((c2 & 0x8000) == 0);
    }

    private void recompose(ReorderingBuffer reorderingBuffer, int n2, boolean bl2) {
        int n3 = n2;
        StringBuilder stringBuilder = reorderingBuffer.getStringBuilder();
        if (n3 == stringBuilder.length()) {
            return;
        }
        int n4 = -1;
        int n5 = -1;
        boolean bl3 = false;
        int n6 = 0;
        while (true) {
            int n7 = stringBuilder.codePointAt(n3);
            n3 += Character.charCount(n7);
            int n8 = this.getNorm16(n7);
            int n9 = Normalizer2Impl.getCCFromYesOrMaybe(n8);
            if (this.isMaybe(n8) && n4 >= 0 && (n6 < n9 || n6 == 0)) {
                int n10;
                int n11;
                if (Normalizer2Impl.isJamoVT(n8)) {
                    if (n7 < 4519 && (n11 = (int)(stringBuilder.charAt(n5) - 4352)) < 19) {
                        char c2;
                        n10 = n3 - 1;
                        char c3 = (char)(44032 + (n11 * 21 + (n7 - 4449)) * 28);
                        if (n3 != stringBuilder.length() && (c2 = (char)(stringBuilder.charAt(n3) - 4519)) < '\u001c') {
                            ++n3;
                            c3 = (char)(c3 + c2);
                        }
                        stringBuilder.setCharAt(n5, c3);
                        stringBuilder.delete(n10, n3);
                        n3 = n10;
                    }
                    if (n3 == stringBuilder.length()) break;
                    n4 = -1;
                    continue;
                }
                int n12 = Normalizer2Impl.combine(this.maybeYesCompositions, n4, n7);
                if (n12 >= 0) {
                    n11 = n12 >> 1;
                    n10 = n3 - Character.charCount(n7);
                    stringBuilder.delete(n10, n3);
                    n3 = n10;
                    if (bl3) {
                        if (n11 > 65535) {
                            stringBuilder.setCharAt(n5, UTF16.getLeadSurrogate(n11));
                            stringBuilder.setCharAt(n5 + 1, UTF16.getTrailSurrogate(n11));
                        } else {
                            stringBuilder.setCharAt(n5, (char)n7);
                            stringBuilder.deleteCharAt(n5 + 1);
                            bl3 = false;
                            --n3;
                        }
                    } else if (n11 > 65535) {
                        bl3 = true;
                        stringBuilder.setCharAt(n5, UTF16.getLeadSurrogate(n11));
                        stringBuilder.insert(n5 + 1, UTF16.getTrailSurrogate(n11));
                        ++n3;
                    } else {
                        stringBuilder.setCharAt(n5, (char)n11);
                    }
                    if (n3 == stringBuilder.length()) break;
                    if ((n12 & 1) != 0) {
                        n4 = this.getCompositionsListForComposite(this.getRawNorm16(n11));
                        continue;
                    }
                    n4 = -1;
                    continue;
                }
            }
            n6 = n9;
            if (n3 == stringBuilder.length()) break;
            if (n9 == 0) {
                n4 = this.getCompositionsListForDecompYes(n8);
                if (n4 < 0) continue;
                if (n7 <= 65535) {
                    bl3 = false;
                    n5 = n3 - 1;
                    continue;
                }
                bl3 = true;
                n5 = n3 - 2;
                continue;
            }
            if (!bl2) continue;
            n4 = -1;
        }
        reorderingBuffer.flush();
    }

    public int composePair(int n2, int n3) {
        int n4;
        int n5 = this.getNorm16(n2);
        if (Normalizer2Impl.isInert(n5)) {
            return -1;
        }
        if (n5 < this.minYesNoMappingsOnly) {
            if (Normalizer2Impl.isJamoL(n5)) {
                if (0 <= (n3 -= 4449) && n3 < 21) {
                    return 44032 + ((n2 - 4352) * 21 + n3) * 28;
                }
                return -1;
            }
            if (this.isHangulLV(n5)) {
                if (0 < (n3 -= 4519) && n3 < 28) {
                    return n2 + n3;
                }
                return -1;
            }
            n4 = 64512 - this.minMaybeYes + n5 >> 1;
            if (n5 > this.minYesNo) {
                n4 += 1 + (this.maybeYesCompositions.charAt(n4) & 0x1F);
            }
        } else {
            if (n5 < this.minMaybeYes || 64512 <= n5) {
                return -1;
            }
            n4 = this.getCompositionsListForMaybe(n5);
        }
        if (n3 < 0 || 0x10FFFF < n3) {
            return -1;
        }
        return Normalizer2Impl.combine(this.maybeYesCompositions, n4, n3) >> 1;
    }

    private boolean hasCompBoundaryBefore(int n2, int n3) {
        return n2 < this.minCompNoMaybeCP || this.norm16HasCompBoundaryBefore(n3);
    }

    private boolean norm16HasCompBoundaryBefore(int n2) {
        return n2 < this.minNoNoCompNoMaybeCC || this.isAlgorithmicNoNo(n2);
    }

    private boolean hasCompBoundaryBefore(CharSequence charSequence, int n2, int n3) {
        return n2 == n3 || this.hasCompBoundaryBefore(Character.codePointAt(charSequence, n2));
    }

    private boolean norm16HasCompBoundaryAfter(int n2, boolean bl2) {
        return (n2 & 1) != 0 && (!bl2 || this.isTrailCC01ForCompBoundaryAfter(n2));
    }

    private boolean hasCompBoundaryAfter(CharSequence charSequence, int n2, int n3, boolean bl2) {
        return n2 == n3 || this.hasCompBoundaryAfter(Character.codePointBefore(charSequence, n3), bl2);
    }

    private boolean isTrailCC01ForCompBoundaryAfter(int n2) {
        return Normalizer2Impl.isInert(n2) || (this.isDecompNoAlgorithmic(n2) ? (n2 & 6) <= 2 : this.extraData.charAt(n2 >> 1) <= '\u01ff');
    }

    private int findPreviousCompBoundary(CharSequence charSequence, int n2, boolean bl2) {
        int n3;
        int n4;
        while (n2 > 0 && !this.norm16HasCompBoundaryAfter(n4 = this.getNorm16(n3 = Character.codePointBefore(charSequence, n2)), bl2)) {
            n2 -= Character.charCount(n3);
            if (!this.hasCompBoundaryBefore(n3, n4)) continue;
            break;
        }
        return n2;
    }

    private int findNextCompBoundary(CharSequence charSequence, int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        while (n2 < n3 && !this.hasCompBoundaryBefore(n5 = Character.codePointAt(charSequence, n2), n4 = this.normTrie.get(n5))) {
            n2 += Character.charCount(n5);
            if (!this.norm16HasCompBoundaryAfter(n4, bl2)) continue;
            break;
        }
        return n2;
    }

    private int findPreviousFCDBoundary(CharSequence charSequence, int n2) {
        int n3;
        int n4;
        while (n2 > 0 && (n4 = Character.codePointBefore(charSequence, n2)) >= this.minDecompNoCP && !this.norm16HasDecompBoundaryAfter(n3 = this.getNorm16(n4))) {
            n2 -= Character.charCount(n4);
            if (!this.norm16HasDecompBoundaryBefore(n3)) continue;
            break;
        }
        return n2;
    }

    private int findNextFCDBoundary(CharSequence charSequence, int n2, int n3) {
        int n4;
        int n5;
        while (n2 < n3 && (n5 = Character.codePointAt(charSequence, n2)) >= this.minLcccCP && !this.norm16HasDecompBoundaryBefore(n4 = this.getNorm16(n5))) {
            n2 += Character.charCount(n5);
            if (!this.norm16HasDecompBoundaryAfter(n4)) continue;
            break;
        }
        return n2;
    }

    private int getPreviousTrailCC(CharSequence charSequence, int n2, int n3) {
        if (n2 == n3) {
            return 0;
        }
        return this.getFCD16(Character.codePointBefore(charSequence, n3));
    }

    private void addToStartSet(MutableCodePointTrie mutableCodePointTrie, int n2, int n3) {
        int n4 = mutableCodePointTrie.get(n3);
        if ((n4 & 0x3FFFFF) == 0 && n2 != 0) {
            mutableCodePointTrie.set(n3, n4 | n2);
        } else {
            UnicodeSet unicodeSet;
            if ((n4 & 0x200000) == 0) {
                int n5 = n4 & 0x1FFFFF;
                n4 = n4 & 0xFFE00000 | 0x200000 | this.canonStartSets.size();
                mutableCodePointTrie.set(n3, n4);
                unicodeSet = new UnicodeSet();
                this.canonStartSets.add(unicodeSet);
                if (n5 != 0) {
                    unicodeSet.add(n5);
                }
            } else {
                unicodeSet = this.canonStartSets.get(n4 & 0x1FFFFF);
            }
            unicodeSet.add(n2);
        }
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return byArray[0] == 4;
        }
    }

    public static final class UTF16Plus {
        public static boolean isLeadSurrogate(int n2) {
            return (n2 & 0xFFFFFC00) == 55296;
        }

        public static boolean isTrailSurrogate(int n2) {
            return (n2 & 0xFFFFFC00) == 56320;
        }

        public static boolean isSurrogate(int n2) {
            return (n2 & 0xFFFFF800) == 55296;
        }

        public static boolean isSurrogateLead(int n2) {
            return (n2 & 0x400) == 0;
        }

        public static boolean equal(CharSequence charSequence, CharSequence charSequence2) {
            if (charSequence == charSequence2) {
                return true;
            }
            int n2 = charSequence.length();
            if (n2 != charSequence2.length()) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (charSequence.charAt(i2) == charSequence2.charAt(i2)) continue;
                return false;
            }
            return true;
        }

        public static boolean equal(CharSequence charSequence, int n2, int n3, CharSequence charSequence2, int n4, int n5) {
            if (n3 - n2 != n5 - n4) {
                return false;
            }
            if (charSequence == charSequence2 && n2 == n4) {
                return true;
            }
            while (n2 < n3) {
                if (charSequence.charAt(n2++) == charSequence2.charAt(n4++)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class ReorderingBuffer
    implements Appendable {
        private final Normalizer2Impl impl;
        private final Appendable app;
        private final StringBuilder str;
        private final boolean appIsStringBuilder;
        private int reorderStart;
        private int lastCC;
        private int codePointStart;
        private int codePointLimit;

        public ReorderingBuffer(Normalizer2Impl normalizer2Impl, Appendable appendable, int n2) {
            this.impl = normalizer2Impl;
            this.app = appendable;
            if (this.app instanceof StringBuilder) {
                this.appIsStringBuilder = true;
                this.str = (StringBuilder)appendable;
                this.str.ensureCapacity(n2);
                this.reorderStart = 0;
                if (this.str.length() == 0) {
                    this.lastCC = 0;
                } else {
                    this.setIterator();
                    this.lastCC = this.previousCC();
                    if (this.lastCC > 1) {
                        while (this.previousCC() > 1) {
                        }
                    }
                    this.reorderStart = this.codePointLimit;
                }
            } else {
                this.appIsStringBuilder = false;
                this.str = new StringBuilder();
                this.reorderStart = 0;
                this.lastCC = 0;
            }
        }

        public boolean isEmpty() {
            return this.str.length() == 0;
        }

        public int length() {
            return this.str.length();
        }

        public int getLastCC() {
            return this.lastCC;
        }

        public StringBuilder getStringBuilder() {
            return this.str;
        }

        public boolean equals(CharSequence charSequence, int n2, int n3) {
            return UTF16Plus.equal(this.str, 0, this.str.length(), charSequence, n2, n3);
        }

        public void append(int n2, int n3) {
            if (this.lastCC <= n3 || n3 == 0) {
                this.str.appendCodePoint(n2);
                this.lastCC = n3;
                if (n3 <= 1) {
                    this.reorderStart = this.str.length();
                }
            } else {
                this.insert(n2, n3);
            }
        }

        public void append(CharSequence charSequence, int n2, int n3, boolean bl2, int n4, int n5) {
            if (n2 == n3) {
                return;
            }
            if (this.lastCC <= n4 || n4 == 0) {
                if (n5 <= 1) {
                    this.reorderStart = this.str.length() + (n3 - n2);
                } else if (n4 <= 1) {
                    this.reorderStart = this.str.length() + 1;
                }
                this.str.append(charSequence, n2, n3);
                this.lastCC = n5;
            } else {
                int n6 = Character.codePointAt(charSequence, n2);
                n2 += Character.charCount(n6);
                this.insert(n6, n4);
                while (n2 < n3) {
                    n4 = (n2 += Character.charCount(n6 = Character.codePointAt(charSequence, n2))) < n3 ? (bl2 ? Normalizer2Impl.getCCFromYesOrMaybe(this.impl.getNorm16(n6)) : this.impl.getCC(this.impl.getNorm16(n6))) : n5;
                    this.append(n6, n4);
                }
            }
        }

        @Override
        public ReorderingBuffer append(char c2) {
            this.str.append(c2);
            this.lastCC = 0;
            this.reorderStart = this.str.length();
            return this;
        }

        public void appendZeroCC(int n2) {
            this.str.appendCodePoint(n2);
            this.lastCC = 0;
            this.reorderStart = this.str.length();
        }

        @Override
        public ReorderingBuffer append(CharSequence charSequence) {
            if (charSequence.length() != 0) {
                this.str.append(charSequence);
                this.lastCC = 0;
                this.reorderStart = this.str.length();
            }
            return this;
        }

        @Override
        public ReorderingBuffer append(CharSequence charSequence, int n2, int n3) {
            if (n2 != n3) {
                this.str.append(charSequence, n2, n3);
                this.lastCC = 0;
                this.reorderStart = this.str.length();
            }
            return this;
        }

        public void flush() {
            if (this.appIsStringBuilder) {
                this.reorderStart = this.str.length();
            } else {
                try {
                    this.app.append(this.str);
                    this.str.setLength(0);
                    this.reorderStart = 0;
                }
                catch (IOException iOException) {
                    throw new ICUUncheckedIOException(iOException);
                }
            }
            this.lastCC = 0;
        }

        public ReorderingBuffer flushAndAppendZeroCC(CharSequence charSequence, int n2, int n3) {
            if (this.appIsStringBuilder) {
                this.str.append(charSequence, n2, n3);
                this.reorderStart = this.str.length();
            } else {
                try {
                    this.app.append(this.str).append(charSequence, n2, n3);
                    this.str.setLength(0);
                    this.reorderStart = 0;
                }
                catch (IOException iOException) {
                    throw new ICUUncheckedIOException(iOException);
                }
            }
            this.lastCC = 0;
            return this;
        }

        public void remove() {
            this.str.setLength(0);
            this.lastCC = 0;
            this.reorderStart = 0;
        }

        public void removeSuffix(int n2) {
            int n3 = this.str.length();
            this.str.delete(n3 - n2, n3);
            this.lastCC = 0;
            this.reorderStart = this.str.length();
        }

        private void insert(int n2, int n3) {
            this.setIterator();
            this.skipPrevious();
            while (this.previousCC() > n3) {
            }
            if (n2 <= 65535) {
                this.str.insert(this.codePointLimit, (char)n2);
                if (n3 <= 1) {
                    this.reorderStart = this.codePointLimit + 1;
                }
            } else {
                this.str.insert(this.codePointLimit, Character.toChars(n2));
                if (n3 <= 1) {
                    this.reorderStart = this.codePointLimit + 2;
                }
            }
        }

        private void setIterator() {
            this.codePointStart = this.str.length();
        }

        private void skipPrevious() {
            this.codePointLimit = this.codePointStart;
            this.codePointStart = this.str.offsetByCodePoints(this.codePointStart, -1);
        }

        private int previousCC() {
            this.codePointLimit = this.codePointStart;
            if (this.reorderStart >= this.codePointStart) {
                return 0;
            }
            int n2 = this.str.codePointBefore(this.codePointStart);
            this.codePointStart -= Character.charCount(n2);
            return this.impl.getCCFromYesOrMaybeCP(n2);
        }
    }

    public static final class Hangul {
        public static final int JAMO_L_BASE = 4352;
        public static final int JAMO_L_END = 4370;
        public static final int JAMO_V_BASE = 4449;
        public static final int JAMO_V_END = 4469;
        public static final int JAMO_T_BASE = 4519;
        public static final int JAMO_T_END = 4546;
        public static final int HANGUL_BASE = 44032;
        public static final int HANGUL_END = 55203;
        public static final int JAMO_L_COUNT = 19;
        public static final int JAMO_V_COUNT = 21;
        public static final int JAMO_T_COUNT = 28;
        public static final int JAMO_L_LIMIT = 4371;
        public static final int JAMO_V_LIMIT = 4470;
        public static final int JAMO_VT_COUNT = 588;
        public static final int HANGUL_COUNT = 11172;
        public static final int HANGUL_LIMIT = 55204;

        public static boolean isHangul(int n2) {
            return 44032 <= n2 && n2 < 55204;
        }

        public static boolean isHangulLV(int n2) {
            return 0 <= (n2 -= 44032) && n2 < 11172 && n2 % 28 == 0;
        }

        public static boolean isJamoL(int n2) {
            return 4352 <= n2 && n2 < 4371;
        }

        public static boolean isJamoV(int n2) {
            return 4449 <= n2 && n2 < 4470;
        }

        public static boolean isJamoT(int n2) {
            int n3 = n2 - 4519;
            return 0 < n3 && n3 < 28;
        }

        public static boolean isJamo(int n2) {
            return 4352 <= n2 && n2 <= 4546 && (n2 <= 4370 || 4449 <= n2 && n2 <= 4469 || 4519 < n2);
        }

        public static int decompose(int n2, Appendable appendable) {
            try {
                int n3 = (n2 -= 44032) % 28;
                appendable.append((char)(4352 + (n2 /= 28) / 21));
                appendable.append((char)(4449 + n2 % 21));
                if (n3 == 0) {
                    return 2;
                }
                appendable.append((char)(4519 + n3));
                return 3;
            }
            catch (IOException iOException) {
                throw new ICUUncheckedIOException(iOException);
            }
        }

        public static void getRawDecomposition(int n2, Appendable appendable) {
            try {
                int n3 = n2;
                int n4 = (n2 -= 44032) % 28;
                if (n4 == 0) {
                    appendable.append((char)(4352 + (n2 /= 28) / 21));
                    appendable.append((char)(4449 + n2 % 21));
                } else {
                    appendable.append((char)(n3 - n4));
                    appendable.append((char)(4519 + n4));
                }
            }
            catch (IOException iOException) {
                throw new ICUUncheckedIOException(iOException);
            }
        }
    }
}

