/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.Collections;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CurrencyDisplayNames;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class CurrencyData {
    public static final CurrencyDisplayInfoProvider provider;

    private CurrencyData() {
    }

    static {
        CurrencyDisplayInfoProvider currencyDisplayInfoProvider = null;
        try {
            Class<?> clazz = Class.forName("macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUCurrencyDisplayInfoProvider");
            currencyDisplayInfoProvider = (CurrencyDisplayInfoProvider)clazz.newInstance();
        }
        catch (Throwable throwable) {
            currencyDisplayInfoProvider = new CurrencyDisplayInfoProvider(){

                @Override
                public CurrencyDisplayInfo getInstance(ULocale uLocale, boolean bl2) {
                    return DefaultInfo.getWithFallback(bl2);
                }

                @Override
                public boolean hasData() {
                    return false;
                }
            };
        }
        provider = currencyDisplayInfoProvider;
    }

    public static class DefaultInfo
    extends CurrencyDisplayInfo {
        private final boolean fallback;
        private static final CurrencyDisplayInfo FALLBACK_INSTANCE = new DefaultInfo(true);
        private static final CurrencyDisplayInfo NO_FALLBACK_INSTANCE = new DefaultInfo(false);

        private DefaultInfo(boolean bl2) {
            this.fallback = bl2;
        }

        public static final CurrencyDisplayInfo getWithFallback(boolean bl2) {
            return bl2 ? FALLBACK_INSTANCE : NO_FALLBACK_INSTANCE;
        }

        @Override
        public String getName(String string) {
            return this.fallback ? string : null;
        }

        @Override
        public String getPluralName(String string, String string2) {
            return this.fallback ? string : null;
        }

        @Override
        public String getSymbol(String string) {
            return this.fallback ? string : null;
        }

        @Override
        public String getNarrowSymbol(String string) {
            return this.fallback ? string : null;
        }

        @Override
        public String getFormalSymbol(String string) {
            return this.fallback ? string : null;
        }

        @Override
        public String getVariantSymbol(String string) {
            return this.fallback ? string : null;
        }

        @Override
        public Map<String, String> symbolMap() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> nameMap() {
            return Collections.emptyMap();
        }

        @Override
        public ULocale getULocale() {
            return ULocale.ROOT;
        }

        @Override
        public Map<String, String> getUnitPatterns() {
            if (this.fallback) {
                return Collections.emptyMap();
            }
            return null;
        }

        @Override
        public CurrencyFormatInfo getFormatInfo(String string) {
            return null;
        }

        @Override
        public CurrencySpacingInfo getSpacingInfo() {
            return this.fallback ? CurrencySpacingInfo.DEFAULT : null;
        }
    }

    public static final class CurrencySpacingInfo {
        private final String[][] symbols = new String[SpacingType.COUNT.ordinal()][SpacingPattern.COUNT.ordinal()];
        public boolean hasBeforeCurrency = false;
        public boolean hasAfterCurrency = false;
        private static final String DEFAULT_CUR_MATCH = "[:letter:]";
        private static final String DEFAULT_CTX_MATCH = "[:digit:]";
        private static final String DEFAULT_INSERT = " ";
        public static final CurrencySpacingInfo DEFAULT = new CurrencySpacingInfo("[:letter:]", "[:digit:]", " ", "[:letter:]", "[:digit:]", " ");

        public CurrencySpacingInfo() {
        }

        public CurrencySpacingInfo(String ... stringArray) {
            assert (stringArray.length == 6);
            int n2 = 0;
            for (int i2 = 0; i2 < SpacingType.COUNT.ordinal(); ++i2) {
                for (int i3 = 0; i3 < SpacingPattern.COUNT.ordinal(); ++i3) {
                    this.symbols[i2][i3] = stringArray[n2];
                    ++n2;
                }
            }
        }

        public void setSymbolIfNull(SpacingType spacingType, SpacingPattern spacingPattern, String string) {
            int n2;
            int n3 = spacingType.ordinal();
            if (this.symbols[n3][n2 = spacingPattern.ordinal()] == null) {
                this.symbols[n3][n2] = string;
            }
        }

        public String[] getBeforeSymbols() {
            return this.symbols[SpacingType.BEFORE.ordinal()];
        }

        public String[] getAfterSymbols() {
            return this.symbols[SpacingType.AFTER.ordinal()];
        }

        public static final class SpacingPattern
        extends Enum<SpacingPattern> {
            public static final /* enum */ SpacingPattern CURRENCY_MATCH = new SpacingPattern(0);
            public static final /* enum */ SpacingPattern SURROUNDING_MATCH = new SpacingPattern(1);
            public static final /* enum */ SpacingPattern INSERT_BETWEEN = new SpacingPattern(2);
            public static final /* enum */ SpacingPattern COUNT = new SpacingPattern();
            private static final /* synthetic */ SpacingPattern[] $VALUES;

            public static SpacingPattern[] values() {
                return (SpacingPattern[])$VALUES.clone();
            }

            public static SpacingPattern valueOf(String string) {
                return Enum.valueOf(SpacingPattern.class, string);
            }

            private SpacingPattern() {
            }

            private SpacingPattern(int n3) {
                assert (n3 == this.ordinal());
            }

            static {
                $VALUES = new SpacingPattern[]{CURRENCY_MATCH, SURROUNDING_MATCH, INSERT_BETWEEN, COUNT};
            }
        }

        public static enum SpacingType {
            BEFORE,
            AFTER,
            COUNT;

        }
    }

    public static final class CurrencyFormatInfo {
        public final String isoCode;
        public final String currencyPattern;
        public final String monetaryDecimalSeparator;
        public final String monetaryGroupingSeparator;

        public CurrencyFormatInfo(String string, String string2, String string3, String string4) {
            this.isoCode = string;
            this.currencyPattern = string2;
            this.monetaryDecimalSeparator = string3;
            this.monetaryGroupingSeparator = string4;
        }
    }

    public static abstract class CurrencyDisplayInfo
    extends CurrencyDisplayNames {
        public abstract Map<String, String> getUnitPatterns();

        public abstract CurrencyFormatInfo getFormatInfo(String var1);

        public abstract CurrencySpacingInfo getSpacingInfo();
    }

    public static interface CurrencyDisplayInfoProvider {
        public CurrencyDisplayInfo getInstance(ULocale var1, boolean var2);

        public boolean hasData();
    }
}

