/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.nio.ByteBuffer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie;

public class CharTrie
extends Trie {
    private char m_initialValue_;
    private char[] m_data_;

    public CharTrie(ByteBuffer byteBuffer, Trie.DataManipulate dataManipulate) {
        super(byteBuffer, dataManipulate);
        if (!this.isCharTrie()) {
            throw new IllegalArgumentException("Data given does not belong to a char trie.");
        }
    }

    public CharTrie(int n2, int n3, Trie.DataManipulate dataManipulate) {
        super(new char[2080], 512, dataManipulate);
        int n4;
        int n5 = 256;
        int n6 = 256;
        if (n3 != n2) {
            n6 += 32;
        }
        this.m_data_ = new char[n6];
        this.m_dataLength_ = n6;
        this.m_initialValue_ = (char)n2;
        for (n4 = 0; n4 < n5; ++n4) {
            this.m_data_[n4] = (char)n2;
        }
        if (n3 != n2) {
            char c2 = (char)(n5 >> 2);
            int n7 = 1760;
            for (n4 = 1728; n4 < n7; ++n4) {
                this.m_index_[n4] = c2;
            }
            n7 = n5 + 32;
            for (n4 = n5; n4 < n7; ++n4) {
                this.m_data_[n4] = (char)n3;
            }
        }
    }

    public final char getCodePointValue(int n2) {
        if (0 <= n2 && n2 < 55296) {
            int n3 = (this.m_index_[n2 >> 5] << 2) + (n2 & 0x1F);
            return this.m_data_[n3];
        }
        int n4 = this.getCodePointOffset(n2);
        return n4 >= 0 ? this.m_data_[n4] : this.m_initialValue_;
    }

    public final char getLeadValue(char c2) {
        return this.m_data_[this.getLeadOffset(c2)];
    }

    public final char getBMPValue(char c2) {
        return this.m_data_[this.getBMPOffset(c2)];
    }

    public final char getSurrogateValue(char c2, char c3) {
        int n2 = this.getSurrogateOffset(c2, c3);
        if (n2 > 0) {
            return this.m_data_[n2];
        }
        return this.m_initialValue_;
    }

    public final char getTrailValue(int n2, char c2) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n3 = this.m_dataManipulate_.getFoldingOffset(n2);
        if (n3 > 0) {
            return this.m_data_[this.getRawOffset(n3, (char)(c2 & 0x3FF))];
        }
        return this.m_initialValue_;
    }

    public final char getLatin1LinearValue(char c2) {
        return this.m_data_[32 + this.m_dataOffset_ + c2];
    }

    @Override
    public boolean equals(Object object) {
        boolean bl2 = super.equals(object);
        if (bl2 && object instanceof CharTrie) {
            CharTrie charTrie = (CharTrie)object;
            return this.m_initialValue_ == charTrie.m_initialValue_;
        }
        return false;
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    protected final void unserialize(ByteBuffer byteBuffer) {
        int n2 = this.m_dataOffset_ + this.m_dataLength_;
        this.m_index_ = ICUBinary.getChars(byteBuffer, n2, 0);
        this.m_data_ = this.m_index_;
        this.m_initialValue_ = this.m_data_[this.m_dataOffset_];
    }

    @Override
    protected final int getSurrogateOffset(char c2, char c3) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n2 = this.m_dataManipulate_.getFoldingOffset(this.getLeadValue(c2));
        if (n2 > 0) {
            return this.getRawOffset(n2, (char)(c3 & 0x3FF));
        }
        return -1;
    }

    @Override
    protected final int getValue(int n2) {
        return this.m_data_[n2];
    }

    @Override
    protected final int getInitialValue() {
        return this.m_initialValue_;
    }
}

