/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.Date;

public class CalendarAstronomer {
    public static final double SIDEREAL_DAY = 23.93446960027;
    public static final double SOLAR_DAY = 24.065709816;
    public static final double SYNODIC_MONTH = 29.530588853;
    public static final double SIDEREAL_MONTH = 27.32166;
    public static final double TROPICAL_YEAR = 365.242191;
    public static final double SIDEREAL_YEAR = 365.25636;
    public static final int SECOND_MS = 1000;
    public static final int MINUTE_MS = 60000;
    public static final int HOUR_MS = 3600000;
    public static final long DAY_MS = 86400000L;
    public static final long JULIAN_EPOCH_MS = -210866760000000L;
    static final long EPOCH_2000_MS = 946598400000L;
    private static final double PI = Math.PI;
    private static final double PI2 = Math.PI * 2;
    private static final double RAD_HOUR = 3.819718634205488;
    private static final double DEG_RAD = Math.PI / 180;
    private static final double RAD_DEG = 57.29577951308232;
    static final double JD_EPOCH = 2447891.5;
    static final double SUN_ETA_G = 4.87650757829735;
    static final double SUN_OMEGA_G = 4.935239984568769;
    static final double SUN_E = 0.016713;
    public static final SolarLongitude WINTER_SOLSTICE = new SolarLongitude(4.71238898038469);
    static final double moonL0 = 5.556284436750021;
    static final double moonP0 = 0.6342598060246725;
    static final double moonN0 = 5.559050068029439;
    static final double moonI = 0.08980357792017056;
    static final double moonE = 0.0549;
    static final double moonA = 384401.0;
    static final double moonT0 = 0.009042550854582622;
    static final double moonPi = 0.016592845198710092;
    public static final MoonAge NEW_MOON = new MoonAge(0.0);
    private long time;
    private static final double INVALID = Double.MIN_VALUE;
    private transient double julianDay = Double.MIN_VALUE;
    private transient double sunLongitude = Double.MIN_VALUE;
    private transient double meanAnomalySun = Double.MIN_VALUE;
    private transient double moonEclipLong = Double.MIN_VALUE;
    private transient Equatorial moonPosition = null;

    public CalendarAstronomer() {
        this(System.currentTimeMillis());
    }

    public CalendarAstronomer(long l2) {
        this.time = l2;
    }

    public void setTime(long l2) {
        this.time = l2;
        this.clearCache();
    }

    public void setJulianDay(double d2) {
        this.time = (long)(d2 * 8.64E7) + -210866760000000L;
        this.clearCache();
        this.julianDay = d2;
    }

    public long getTime() {
        return this.time;
    }

    public Date getDate() {
        return new Date(this.time);
    }

    public double getJulianDay() {
        if (this.julianDay == Double.MIN_VALUE) {
            this.julianDay = (double)(this.time - -210866760000000L) / 8.64E7;
        }
        return this.julianDay;
    }

    public final Equatorial eclipticToEquatorial(double d2, double d3) {
        double d4 = this.eclipticObliquity();
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        double d7 = Math.sin(d2);
        double d8 = Math.cos(d2);
        double d9 = Math.sin(d3);
        double d10 = Math.cos(d3);
        double d11 = Math.tan(d3);
        return new Equatorial(Math.atan2(d7 * d6 - d11 * d5, d8), Math.asin(d9 * d6 + d10 * d5 * d7));
    }

    public double getSunLongitude() {
        if (this.sunLongitude == Double.MIN_VALUE) {
            double[] dArray = this.getSunLongitude(this.getJulianDay());
            this.sunLongitude = dArray[0];
            this.meanAnomalySun = dArray[1];
        }
        return this.sunLongitude;
    }

    double[] getSunLongitude(double d2) {
        double d3 = d2 - 2447891.5;
        double d4 = CalendarAstronomer.norm2PI(0.017202791632524146 * d3);
        double d5 = CalendarAstronomer.norm2PI(d4 + 4.87650757829735 - 4.935239984568769);
        return new double[]{CalendarAstronomer.norm2PI(this.trueAnomaly(d5, 0.016713) + 4.935239984568769), d5};
    }

    public long getSunTime(double d2, boolean bl2) {
        return this.timeOfAngle(new AngleFunc(){

            @Override
            public double eval() {
                return CalendarAstronomer.this.getSunLongitude();
            }
        }, d2, 365.242191, 60000L, bl2);
    }

    public long getSunTime(SolarLongitude solarLongitude, boolean bl2) {
        return this.getSunTime(solarLongitude.value, bl2);
    }

    public Equatorial getMoonPosition() {
        if (this.moonPosition == null) {
            double d2 = this.getSunLongitude();
            double d3 = this.getJulianDay() - 2447891.5;
            double d4 = CalendarAstronomer.norm2PI(0.22997150421858628 * d3 + 5.556284436750021);
            double d5 = CalendarAstronomer.norm2PI(d4 - 0.001944368345221015 * d3 - 0.6342598060246725);
            double d6 = 0.022233749341155764 * Math.sin(2.0 * (d4 - d2) - d5);
            double d7 = 0.003242821750205464 * Math.sin(this.meanAnomalySun);
            double d8 = 0.00645771823237902 * Math.sin(this.meanAnomalySun);
            double d9 = 0.10975677534091541 * Math.sin(d5 += d6 - d7 - d8);
            double d10 = 0.0037350045992678655 * Math.sin(2.0 * d5);
            double d11 = d4 + d6 + d9 - d7 + d10;
            double d12 = 0.011489502465878671 * Math.sin(2.0 * (d11 - d2));
            double d13 = CalendarAstronomer.norm2PI(5.559050068029439 - 9.242199067718253E-4 * d3);
            double d14 = Math.sin((d11 += d12) - (d13 -= 0.0027925268031909274 * Math.sin(this.meanAnomalySun)));
            double d15 = Math.cos(d11 - d13);
            this.moonEclipLong = Math.atan2(d14 * Math.cos(0.08980357792017056), d15) + d13;
            double d16 = Math.asin(d14 * Math.sin(0.08980357792017056));
            this.moonPosition = this.eclipticToEquatorial(this.moonEclipLong, d16);
        }
        return this.moonPosition;
    }

    public double getMoonAge() {
        this.getMoonPosition();
        return CalendarAstronomer.norm2PI(this.moonEclipLong - this.sunLongitude);
    }

    public long getMoonTime(double d2, boolean bl2) {
        return this.timeOfAngle(new AngleFunc(){

            @Override
            public double eval() {
                return CalendarAstronomer.this.getMoonAge();
            }
        }, d2, 29.530588853, 60000L, bl2);
    }

    public long getMoonTime(MoonAge moonAge, boolean bl2) {
        return this.getMoonTime(moonAge.value, bl2);
    }

    private long timeOfAngle(AngleFunc angleFunc, double d2, double d3, long l2, boolean bl2) {
        double d4;
        double d5 = angleFunc.eval();
        double d6 = CalendarAstronomer.norm2PI(d2 - d5);
        double d7 = d4 = (d6 + (bl2 ? 0.0 : Math.PI * -2)) * (d3 * 8.64E7) / (Math.PI * 2);
        long l3 = this.time;
        this.setTime(this.time + (long)d4);
        do {
            double d8 = angleFunc.eval();
            double d9 = Math.abs(d4 / CalendarAstronomer.normPI(d8 - d5));
            d4 = CalendarAstronomer.normPI(d2 - d8) * d9;
            if (Math.abs(d4) > Math.abs(d7)) {
                long l4 = (long)(d3 * 8.64E7 / 8.0);
                this.setTime(l3 + (bl2 ? l4 : -l4));
                return this.timeOfAngle(angleFunc, d2, d3, l2, bl2);
            }
            d7 = d4;
            d5 = d8;
            this.setTime(this.time + (long)d4);
        } while (Math.abs(d4) > (double)l2);
        return this.time;
    }

    private static final double normalize(double d2, double d3) {
        return d2 - d3 * Math.floor(d2 / d3);
    }

    private static final double norm2PI(double d2) {
        return CalendarAstronomer.normalize(d2, Math.PI * 2);
    }

    private static final double normPI(double d2) {
        return CalendarAstronomer.normalize(d2 + Math.PI, Math.PI * 2) - Math.PI;
    }

    private double trueAnomaly(double d2, double d3) {
        double d4;
        double d5 = d2;
        do {
            d4 = d5 - d3 * Math.sin(d5) - d2;
            d5 -= d4 / (1.0 - d3 * Math.cos(d5));
        } while (Math.abs(d4) > 1.0E-5);
        return 2.0 * Math.atan(Math.tan(d5 / 2.0) * Math.sqrt((1.0 + d3) / (1.0 - d3)));
    }

    private double eclipticObliquity() {
        double d2 = 2451545.0;
        double d3 = (this.getJulianDay() - 2451545.0) / 36525.0;
        double d4 = 23.439292 - 0.013004166666666666 * d3 - 1.6666666666666665E-7 * d3 * d3 + 5.027777777777778E-7 * d3 * d3 * d3;
        return d4 * (Math.PI / 180);
    }

    private void clearCache() {
        this.julianDay = Double.MIN_VALUE;
        this.sunLongitude = Double.MIN_VALUE;
        this.meanAnomalySun = Double.MIN_VALUE;
        this.moonEclipLong = Double.MIN_VALUE;
        this.moonPosition = null;
    }

    private static String radToHms(double d2) {
        int n2 = (int)(d2 * 3.819718634205488);
        int n3 = (int)((d2 * 3.819718634205488 - (double)n2) * 60.0);
        int n4 = (int)((d2 * 3.819718634205488 - (double)n2 - (double)n3 / 60.0) * 3600.0);
        return Integer.toString(n2) + "h" + n3 + "m" + n4 + "s";
    }

    private static String radToDms(double d2) {
        int n2 = (int)(d2 * 57.29577951308232);
        int n3 = (int)((d2 * 57.29577951308232 - (double)n2) * 60.0);
        int n4 = (int)((d2 * 57.29577951308232 - (double)n2 - (double)n3 / 60.0) * 3600.0);
        return Integer.toString(n2) + "\u00b0" + n3 + "'" + n4 + "\"";
    }

    public static final class Equatorial {
        public final double ascension;
        public final double declination;

        public Equatorial(double d2, double d3) {
            this.ascension = d2;
            this.declination = d3;
        }

        public String toString() {
            return Double.toString(this.ascension * 57.29577951308232) + "," + this.declination * 57.29577951308232;
        }

        public String toHmsString() {
            return CalendarAstronomer.radToHms(this.ascension) + "," + CalendarAstronomer.radToDms(this.declination);
        }
    }

    public static final class Ecliptic {
        public final double latitude;
        public final double longitude;

        public Ecliptic(double d2, double d3) {
            this.latitude = d2;
            this.longitude = d3;
        }

        public String toString() {
            return Double.toString(this.longitude * 57.29577951308232) + "," + this.latitude * 57.29577951308232;
        }
    }

    private static interface AngleFunc {
        public double eval();
    }

    private static class MoonAge {
        double value;

        MoonAge(double d2) {
            this.value = d2;
        }
    }

    private static class SolarLongitude {
        double value;

        SolarLongitude(double d2) {
            this.value = d2;
        }
    }
}

