/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetMBCS;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.UConverterAlias;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.InvalidFormatException;

public final class CharsetProviderICU
extends CharsetProvider {
    private static List<Charset> icuCharsets = Collections.emptyList();

    @Override
    public final Charset charsetForName(String string) {
        try {
            String string2;
            String string3 = "";
            if (string.endsWith(",swaplfnl")) {
                string3 = ",swaplfnl";
                string = string.substring(0, string.length() - string3.length());
            }
            if ((string2 = CharsetProviderICU.getICUCanonicalName(string)) == null || string2.length() == 0) {
                string2 = string;
            }
            return CharsetProviderICU.getCharset(string2, string3);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public final Charset charsetForName(String string, String string2) {
        return this.charsetForName(string, string2, null);
    }

    public Charset charsetForName(String string, String string2, ClassLoader classLoader) {
        CharsetMBCS charsetMBCS = null;
        try {
            charsetMBCS = new CharsetMBCS(string, string, new String[0], string2, classLoader);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return charsetMBCS;
    }

    @Deprecated
    public static final String getICUCanonicalName(String string) throws UnsupportedCharsetException {
        String string2 = null;
        String string3 = null;
        try {
            if (string != null) {
                string2 = UConverterAlias.getCanonicalName(string, "MIME");
                string3 = string2 != null ? string2 : ((string2 = UConverterAlias.getCanonicalName(string, "IANA")) != null ? string2 : ((string2 = UConverterAlias.getAlias(string, 0)) != null ? string2 : (string.indexOf("x-") == 0 || string.indexOf("X-") == 0 ? ((string2 = UConverterAlias.getAlias(string.substring(2), 0)) != null ? string2 : "") : "")));
            }
            return string3;
        }
        catch (IOException iOException) {
            throw new UnsupportedCharsetException(string);
        }
    }

    private static final Charset getCharset(String string, String string2) throws IOException {
        String[] stringArray = CharsetProviderICU.getAliases(string);
        String string3 = CharsetProviderICU.getJavaCanonicalName(string);
        return CharsetICU.getCharset(string + string2, string3, stringArray);
    }

    @Deprecated
    public static String getJavaCanonicalName(String string) {
        if (string == null) {
            return null;
        }
        try {
            String string2 = null;
            string2 = UConverterAlias.getStandardName(string, "MIME");
            if (string2 == null && (string2 = UConverterAlias.getStandardName(string, "IANA")) == null) {
                String string3;
                int n2 = UConverterAlias.countAliases(string);
                for (int i2 = 0; i2 < n2; ++i2) {
                    string3 = UConverterAlias.getAlias(string, i2);
                    if (string3 == null || string3.indexOf("x-") != 0) continue;
                    string2 = string3;
                    break;
                }
                if (string2 == null || string2.length() == 0) {
                    string3 = UConverterAlias.getStandardName(string, "UTR22");
                    if (string3 == null && string.indexOf(",") != -1) {
                        string3 = UConverterAlias.getAlias(string, 1);
                    }
                    if (string3 == null) {
                        string3 = string;
                    }
                    string2 = "x-" + string3;
                }
            }
            return string2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Deprecated
    private static final String[] getAliases(String string) throws IOException {
        String[] stringArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String[] stringArray2 = new String[50];
        if (string != null) {
            n2 = UConverterAlias.countAliases(string);
            n4 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                String string2 = UConverterAlias.getAlias(string, n3);
                if (string2.indexOf(44) != -1) continue;
                stringArray2[n4++] = string2;
            }
            stringArray = new String[n4];
            while (--n4 >= 0) {
                stringArray[n4] = stringArray2[n4];
            }
        }
        return stringArray;
    }

    private static final synchronized void loadAvailableICUCharsets() {
        if (!icuCharsets.isEmpty()) {
            return;
        }
        LinkedList<Charset> linkedList = new LinkedList<Charset>();
        int n2 = UConverterAlias.countAvailable();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = UConverterAlias.getAvailableName(i2);
            try {
                Charset charset = CharsetProviderICU.getCharset(string, "");
                linkedList.add(charset);
                continue;
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        icuCharsets = Collections.unmodifiableList(linkedList);
    }

    @Override
    public final Iterator<Charset> charsets() {
        CharsetProviderICU.loadAvailableICUCharsets();
        return icuCharsets.iterator();
    }

    @Deprecated
    public static final String[] getAvailableNames() {
        CharsetProviderICU.loadAvailableICUCharsets();
        String[] stringArray = new String[icuCharsets.size()];
        int n2 = 0;
        for (Charset charset : icuCharsets) {
            stringArray[n2++] = charset.name();
        }
        return stringArray;
    }

    @Deprecated
    public static final String[] getAllNames() {
        int n2 = UConverterAlias.countAvailable();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = UConverterAlias.getAvailableName(i2);
        }
        return stringArray;
    }
}

