/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.UnsupportedCharsetException;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetDecoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetEncoderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetMBCS;
import macromedia.jdbc.db2.externals.com.ibm.icu.charset.CharsetProviderICU;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class CharsetHZ
extends CharsetICU {
    private static final int UCNV_TILDE = 126;
    private static final int UCNV_OPEN_BRACE = 123;
    private static final int UCNV_CLOSE_BRACE = 125;
    private static final byte[] SB_ESCAPE = new byte[]{126, 125};
    private static final byte[] DB_ESCAPE = new byte[]{126, 123};
    private static final byte[] TILDE_ESCAPE = new byte[]{126, 126};
    private static final byte[] fromUSubstitution = new byte[]{26};
    private CharsetMBCS gbCharset = (CharsetMBCS)new CharsetProviderICU().charsetForName("GBK");
    private boolean isEmptySegment;

    public CharsetHZ(String string, String string2, String[] stringArray) {
        super(string, string2, stringArray);
        if (this.gbCharset == null) {
            throw new UnsupportedCharsetException("unable to open ICU GBK Charset, required for HZ");
        }
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        this.isEmptySegment = false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoderHZ(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoderHZ(this);
    }

    @Override
    void getUnicodeSetImpl(UnicodeSet unicodeSet, int n2) {
        unicodeSet.add(0, 127);
        this.gbCharset.MBCSGetFilteredUnicodeSetForUnicode(this.gbCharset.sharedData, unicodeSet, n2, 6);
    }

    class CharsetEncoderHZ
    extends CharsetEncoderICU {
        CharsetMBCS.CharsetEncoderMBCS gbEncoder;
        boolean isEscapeAppended;
        boolean isTargetUCharDBCS;

        public CharsetEncoderHZ(CharsetICU charsetICU) {
            super(charsetICU, fromUSubstitution);
            this.isEscapeAppended = false;
            this.isTargetUCharDBCS = false;
            this.gbEncoder = (CharsetMBCS.CharsetEncoderMBCS)CharsetHZ.this.gbCharset.newEncoder();
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.gbEncoder.implReset();
            this.isEscapeAppended = false;
            this.isTargetUCharDBCS = false;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, boolean bl2) {
            int n2 = 0;
            int[] nArray = new int[]{0};
            char c2 = '\u0000';
            boolean bl3 = this.isTargetUCharDBCS;
            if (!charBuffer.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            if (this.fromUChar32 != 0 && byteBuffer.hasRemaining()) {
                CoderResult coderResult = this.handleSurrogates(charBuffer, (char)this.fromUChar32);
                return coderResult != null ? coderResult : CoderResult.unmappableForLength(2);
            }
            while (charBuffer.hasRemaining()) {
                nArray[0] = 65535;
                if (byteBuffer.hasRemaining()) {
                    c2 = charBuffer.get();
                    bl3 = this.isTargetUCharDBCS;
                    if (c2 == '~') {
                        this.concatEscape(charBuffer, byteBuffer, intBuffer, TILDE_ESCAPE);
                        continue;
                    }
                    if (c2 <= '\u007f') {
                        n2 = 1;
                        nArray[0] = c2;
                    } else {
                        n2 = this.gbEncoder.fromUChar32(c2, nArray, super.isFallbackUsed());
                        nArray[0] = n2 == 2 && 41377 <= nArray[0] && nArray[0] <= 65022 && 161 <= (nArray[0] & 0xFF) && (nArray[0] & 0xFF) <= 254 ? nArray[0] - 32896 : 65535;
                    }
                    if (nArray[0] != 65535) {
                        boolean bl4 = this.isTargetUCharDBCS = nArray[0] > 255;
                        if (bl3 != this.isTargetUCharDBCS || !this.isEscapeAppended) {
                            if (!this.isTargetUCharDBCS) {
                                this.concatEscape(charBuffer, byteBuffer, intBuffer, SB_ESCAPE);
                                this.isEscapeAppended = true;
                            } else {
                                this.concatEscape(charBuffer, byteBuffer, intBuffer, DB_ESCAPE);
                                this.isEscapeAppended = true;
                            }
                        }
                        if (this.isTargetUCharDBCS) {
                            if (byteBuffer.hasRemaining()) {
                                byteBuffer.put((byte)(nArray[0] >> 8));
                                if (intBuffer != null) {
                                    intBuffer.put(charBuffer.position() - 1);
                                }
                                if (byteBuffer.hasRemaining()) {
                                    byteBuffer.put((byte)nArray[0]);
                                    if (intBuffer == null) continue;
                                    intBuffer.put(charBuffer.position() - 1);
                                    continue;
                                }
                                this.errorBuffer[this.errorBufferLength++] = (byte)nArray[0];
                                continue;
                            }
                            this.errorBuffer[this.errorBufferLength++] = (byte)(nArray[0] >> 8);
                            this.errorBuffer[this.errorBufferLength++] = (byte)nArray[0];
                            continue;
                        }
                        if (byteBuffer.hasRemaining()) {
                            byteBuffer.put((byte)nArray[0]);
                            if (intBuffer == null) continue;
                            intBuffer.put(charBuffer.position() - 1);
                            continue;
                        }
                        this.errorBuffer[this.errorBufferLength++] = (byte)nArray[0];
                        continue;
                    }
                    if (UTF16.isSurrogate(c2)) {
                        CoderResult coderResult = this.handleSurrogates(charBuffer, c2);
                        return coderResult != null ? coderResult : CoderResult.unmappableForLength(2);
                    }
                    this.fromUChar32 = c2;
                    return CoderResult.unmappableForLength(1);
                }
                return CoderResult.OVERFLOW;
            }
            return CoderResult.UNDERFLOW;
        }

        private CoderResult concatEscape(CharBuffer charBuffer, ByteBuffer byteBuffer, IntBuffer intBuffer, byte[] byArray) {
            CoderResult coderResult = null;
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byte by2 = byArray[i2];
                if (byteBuffer.hasRemaining()) {
                    byteBuffer.put(by2);
                    if (intBuffer == null) continue;
                    intBuffer.put(charBuffer.position() - 1);
                    continue;
                }
                this.errorBuffer[this.errorBufferLength++] = by2;
                coderResult = CoderResult.OVERFLOW;
            }
            return coderResult;
        }
    }

    class CharsetDecoderHZ
    extends CharsetDecoderICU {
        CharsetMBCS.CharsetDecoderMBCS gbDecoder;
        boolean isStateDBCS;

        public CharsetDecoderHZ(CharsetICU charsetICU) {
            super(charsetICU);
            this.isStateDBCS = false;
            this.gbDecoder = (CharsetMBCS.CharsetDecoderMBCS)CharsetHZ.this.gbCharset.newDecoder();
        }

        @Override
        protected void implReset() {
            super.implReset();
            this.gbDecoder.implReset();
            this.isStateDBCS = false;
            CharsetHZ.this.isEmptySegment = false;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, IntBuffer intBuffer, boolean bl2) {
            CoderResult coderResult = CoderResult.UNDERFLOW;
            byte[] byArray = new byte[2];
            int n2 = 0;
            int n3 = 0;
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!charBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            block5: while (byteBuffer.hasRemaining()) {
                if (charBuffer.hasRemaining()) {
                    n3 = byteBuffer.get() & 0xFF;
                    if (this.mode == 126) {
                        this.mode = 0;
                        switch (n3) {
                            case 10: {
                                continue block5;
                            }
                            case 126: {
                                if (intBuffer != null) {
                                    intBuffer.put(byteBuffer.position() - 2);
                                }
                                charBuffer.put((char)n3);
                                continue block5;
                            }
                            case 123: 
                            case 125: {
                                boolean bl3 = this.isStateDBCS = n3 == 123;
                                if (CharsetHZ.this.isEmptySegment) {
                                    CharsetHZ.this.isEmptySegment = false;
                                    this.toUBytesArray[0] = 126;
                                    this.toUBytesArray[1] = (byte)n3;
                                    this.toULength = 2;
                                    return CoderResult.malformedForLength(1);
                                }
                                CharsetHZ.this.isEmptySegment = true;
                                continue block5;
                            }
                        }
                        CharsetHZ.this.isEmptySegment = false;
                        coderResult = CoderResult.malformedForLength(1);
                        this.toUBytesArray[0] = 126;
                        if (this.isStateDBCS ? 33 <= n3 && n3 <= 126 : n3 <= 127) {
                            this.toULength = 1;
                            byteBuffer.position(byteBuffer.position() - 1);
                        } else {
                            this.toUBytesArray[1] = (byte)n3;
                            this.toULength = 2;
                        }
                        return coderResult;
                    }
                    if (this.isStateDBCS) {
                        boolean bl4;
                        if (this.toUnicodeStatus == 0) {
                            if (n3 == 126) {
                                this.mode = 126;
                                continue;
                            }
                            this.toUnicodeStatus = n3 | 0x100;
                            CharsetHZ.this.isEmptySegment = false;
                            continue;
                        }
                        int n4 = this.toUnicodeStatus & 0xFF;
                        n2 = 65535;
                        boolean bl5 = (short)(0xFF & n4 - 33) <= 92;
                        boolean bl6 = bl4 = (short)(0xFF & n3 - 33) <= 93;
                        if (bl5 && bl4) {
                            byArray[0] = (byte)(n4 + 128);
                            byArray[1] = (byte)(n3 + 128);
                            n2 = this.gbDecoder.simpleGetNextUChar(ByteBuffer.wrap(byArray), super.isFallbackUsed());
                            n3 = n4 << 8 | n3;
                        } else if (bl4) {
                            byteBuffer.position(byteBuffer.position() - 1);
                            n3 = n4;
                        } else {
                            n3 = 0x10000 | n4 << 8 | n3;
                        }
                        this.toUnicodeStatus = 0;
                    } else {
                        if (n3 == 126) {
                            this.mode = 126;
                            continue;
                        }
                        if (n3 <= 127) {
                            n2 = n3;
                            CharsetHZ.this.isEmptySegment = false;
                        } else {
                            n2 = 65535;
                            CharsetHZ.this.isEmptySegment = false;
                        }
                    }
                    if (n2 < 65534) {
                        if (intBuffer != null) {
                            intBuffer.put(byteBuffer.position() - 1 - (this.isStateDBCS ? 1 : 0));
                        }
                        charBuffer.put((char)n2);
                        continue;
                    }
                    if (n3 > 255) {
                        this.toUBytesArray[this.toUBytesBegin + 0] = (byte)(n3 >> 8);
                        this.toUBytesArray[this.toUBytesBegin + 1] = (byte)n3;
                        this.toULength = 2;
                    } else {
                        this.toUBytesArray[this.toUBytesBegin + 0] = (byte)n3;
                        this.toULength = 1;
                    }
                    if (n2 == 65534) {
                        return CoderResult.unmappableForLength(this.toULength);
                    }
                    return CoderResult.malformedForLength(this.toULength);
                }
                return CoderResult.OVERFLOW;
            }
            return coderResult;
        }
    }
}

